

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getObjectsWithPermissionsV2Wrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getObjectsWithPermissionsV2Wrapper()
--  |
--  | Description:  This SP is a wrapper aroung sec_getObjectsWithPermissionsV2 which will get list of objects of given entity type
--	|				along with list of permissions that this user has on that entity.
--	|				#permissionIdTable with input permission Id should be passed. So we will
--	|				get the entities that has any of these permission Ids along with the permission Id.
--  |				This wrapper additionally considers the privacy settings on the client and filters clients based on it.
--  |
--  |        Note:	Support yet to be add for iDA objects.
--	|
--  |       Input:  @userId, @entityType, @honorPrivacy, #permissionIdTable (permissionId INT)
--	|
--  |       Output:  (entityId INT, permissionId INT)
--  |
--  |
--  |		Author: sravanan
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getObjectsWithPermissionsV2Wrapper')
BEGIN
	print '>>> Drop Stored Procedure: sec_getObjectsWithPermissionsV2Wrapper <<<'
	drop procedure sec_getObjectsWithPermissionsV2Wrapper
END
IF EXISTS (select * from GxQscripts where name='sec_getObjectsWithPermissionsV2Wrapper')
	delete from GxQscripts where name = 'sec_getObjectsWithPermissionsV2Wrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getObjectsWithPermissionsV2Wrapper')
	delete from GXDBVersions where aliasname = 'sec_getObjectsWithPermissionsV2Wrapper'
GO
print '... Creating Procedure: sec_getObjectsWithPermissionsV2Wrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getObjectsWithPermissionsV2Wrapper
  @userId INT,
  @entityType INT,
  @honorPrivacy INT,
  @shouldSelectOutput INT = 0
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED				-- All queries are readonly. So no lock is needed.
-- We need an external temp table with list of permissions.
-- Else for admin users, we will end up sending all clients * all permissions.
-- Output tables.
IF @shouldSelectOutput = 1			-- Caller has not created output table.
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getObjectsWithPermissionsV2WrapperExtTbl') IS NOT NULL
		DROP TABLE #getObjectsWithPermissionsV2WrapperExtTbl
	CREATE TABLE #getObjectsWithPermissionsV2WrapperExtTbl (entityId INT, permissionId INT)
END
IF @honorPrivacy = 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NULL
		CREATE TABLE #permissionIdTable (permissionId INT)
IF NOT EXISTS(SELECT 1 FROM #permissionIdTable WHERE permissionId = 13)
	BEGIN
		INSERT INTO #permissionIdTable
SELECT 13
	END
END
INSERT INTO #getObjectsWithPermissionsV2WrapperExtTbl
	EXEC sec_getObjectsWithPermissionsV2 @userId, @entityType ,1
IF @honorPrivacy = 1
BEGIN
	-- Remove clientIds which are locked and given user is not owner.
	-- privacy / locked clients should be honored irrespective of what bit (browse/compliance search) - confirmed over email from amey/parag
	--
	DELETE FROM #getObjectsWithPermissionsV2WrapperExtTbl WHERE entityId IN (
SELECT CP.componentNameId FROM #getObjectsWithPermissionsV2WrapperExtTbl OBJ JOIN App_ClientProp CP ON OBJ.entityId = CP.componentNameId AND CP.attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'
AND CP.attrVal = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' AND CP.modified = 0 AND dbo.IsClientOwner(CP.componentNameId,@userId) = 0
		)
	-- Remove clientIds which are belonging to a locked company. Only tenant admin or tenant user can fetch those clients
	DELETE FROM #getObjectsWithPermissionsV2WrapperExtTbl WHERE entityId IN(
SELECT CP.componentNameId FROM #getObjectsWithPermissionsV2WrapperExtTbl OBJ JOIN App_ClientProp CP ON OBJ.entityId = CP.componentNameId  AND CP.attrName = 'Installation Company ID' AND CP.modified=0
JOIN App_CompanyProp COMP ON CONVERT(NVARCHAR, COMP.componentNameId) = CP.attrVal AND COMP.attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND COMP.attrVal = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' AND COMP.cs_attrName = checksum('7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807') AND COMP.modified = 0
AND (EXISTS(SELECT 1 FROM UMUserGroup UU WITH(NOLOCK) INNER JOIN UMGroups UG WITH(NOLOCK) ON UU.groupId=UG.id AND UU.userId=@userId WHERE (UG.groupFlags & 0x40000 <> 0)
			OR dbo.AppGetOrganizationForUser(@userId) <> COMP.componentNameId)))
END
IF @shouldSelectOutput = 1
	SELECT * FROM #getObjectsWithPermissionsV2WrapperExtTbl

IF EXISTS (select * from GxQscripts where name = 'sec_getObjectsWithPermissionsV2Wrapper')
	delete from GxQscripts where name = 'sec_getObjectsWithPermissionsV2Wrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getObjectsWithPermissionsV2Wrapper')
	delete from GXDBVersions where aliasname = 'sec_getObjectsWithPermissionsV2Wrapper'
GO

insert into GXDBVersions values(2, 'sec_getObjectsWithPermissionsV2Wrapper',  '00000000000000000000', 'sec_getObjectsWithPermissionsV2Wrapper', '00000000000000000000')
GO

