

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getObjectsWithPermissionsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getObjectsWithPermissionsV2()
--  |
--  | Description:  This SP will get list of objects of given entity type
--	|				along with list of permissions that this user has on that entity.
--	|				#permissionIdTable with input permission Id should be passed. So we will
--	|				get the entities that has any of these permission Ids along with the permission Id.
--  |
--  |        Note:	Support yet to be add for iDA objects.
--	|
--  |       Input:  @userId, @entityType, #permissionIdTable (permissionId INT)
--	|
--  |       Output:  (entityId INT, permissionId INT)
--  |
--  |
--  |		Author: jswaminathan
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getObjectsWithPermissionsV2')
BEGIN
	print '>>> Drop Stored Procedure: sec_getObjectsWithPermissionsV2 <<<'
	drop procedure sec_getObjectsWithPermissionsV2
END
IF EXISTS (select * from GxQscripts where name='sec_getObjectsWithPermissionsV2')
	delete from GxQscripts where name = 'sec_getObjectsWithPermissionsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getObjectsWithPermissionsV2')
	delete from GXDBVersions where aliasname = 'sec_getObjectsWithPermissionsV2'
GO
print '... Creating Procedure: sec_getObjectsWithPermissionsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getObjectsWithPermissionsV2
  @userID INT,
  @entityTYpe INT,
  @shouldSelectOutput INT = 0
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED				-- All queries are readonly. So no lock is needed.
	-- We need an external temp table with list of permissions.
	-- Else for admin users, we will end up sending all clients * all permissions.
	-- This will be passed. Just creating for testing purposes here.
	--IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
	--	DROP TABLE #permissionIdTable
	--CREATE TABLE #permissionIdTable (permissionId INT)
	-- Output tables.
	IF @shouldSelectOutput = 1			-- Caller has not created output table.
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
			DROP TABLE #getObjectsTable
		CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	END
	DECLARE @dynamicSQLStmt VARCHAR(MAX) = ''
	declare @startTime datetime2(7)
	-- set @startTime = sysdatetime()
	-- Get user groups for this user.
	IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
		DROP TABLE #userGroupId
	CREATE TABLE #userGroupId (userGroupId INT)
	EXEC sec_getMemberUserGroups @userId
	-- select 'User group membership', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
	IF OBJECT_ID ('tempdb.dbo.#userAndGroupId') IS NOT NULL
		DROP TABLE #userAndGroupId
	CREATE TABLE #userAndGroupId
	(
		userOrGroupId INT,
		isUser INT,
		UNIQUE CLUSTERED (isUser, userOrGroupId)					-- Performance tuning
	)
	INSERT INTO #userAndGroupId
		SELECT userGroupId, 0
		FROM #userGroupId
		UNION
		SELECT @userID, 1
	DROP TABLE #userGroupId			-- This is no more required. Let s clear some temp DB space.
	-- Check if all permissions are on commcell itself.
	DECLARE @allPermissionsOnCommcell INT = 0
	IF OBJECT_ID('tempdb.dbo.#commcellLevelPermissions') IS NOT NULL
		DROP TABLE #commcellLevelPermissions
	CREATE TABLE #commcellLevelPermissions (permissionId INT)
	INSERT INTO #commcellLevelPermissions
		SELECT Sec.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN #permissionIdTable P
				ON Sec.permissionId = P.permissionID
		WHERE
			Sec.entityType1 = 1 AND Sec.entityId1 = 2
			AND Sec.permissionId > 0
		UNION
		SELECT RPE.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON Sec.roleID = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionID
		WHERE
			Sec.entityType1 = 1 AND Sec.entityId1 = 2
			AND Sec.roleID > 0
		UNION
		SELECT Sec.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN #permissionIdTable P
				ON Sec.permissionId = P.permissionID
		WHERE
			Sec.entityType1 = @entityTYpe AND Sec.includeAll = 1
			AND Sec.permissionId > 0
		UNION
		SELECT RPE.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON Sec.roleID = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionID
		WHERE
			Sec.entityType1 = @entityTYpe AND Sec.includeAll = 1
			AND Sec.roleID > 0
	-- select 'All permisisons and roles', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
	-- SELECT * FROM #commcellLevelPermissions
	IF EXISTS (SELECT 1 FROM #commcellLevelPermissions)
	BEGIN
		-- Whatever is in CommcellLevelPermissions is applicable for all entities.
		/*INSERT INTO #getObjectsTable (entityId, permissionId)
			SELECT Tbl.id, P.permissionId
			FROM APP_Client Tbl
				INNER JOIN #commcellLevelPermissions P
					ON 1 = 1
			WHERE
				Tbl.id > 1*/
		DECLARE @tableName VARCHAR(1024)
		DECLARE @idCOlName VARCHAR(1024)
		DECLARE @whereClause VARCHAR(1024)
		SELECT @tableName = tableName,
			   @idCOlName = idColName,
			   @whereClause = CASE WHEN whereClause = '' THEN ' 1 = 1 '
								   ELSE whereClause
							  END
		FROM APP_Entity
		WHERE
			entityType = @entityTYpe
		SET @dynamicSQLStmt = 'INSERT INTO #getObjectsTable (entityId, permissionId)' + CHAR(10)
							  + ' SELECT Tbl.' + @idCOlName + ', P.permissionId ' + CHAR(10)
							  + ' FROM ' + @tableName + ' Tbl ' + CHAR(10)
							  + '	INNER JOIN #commcellLevelPermissions P ' + CHAR(10)
							  + '	ON 1 = 1 ' + CHAR(10)
							  + ' WHERE ' + CHAR(10)
							  + @whereClause
		EXEC (@dynamicSQLStmt)
	END
	-- select 'Commcell delegation', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
	-- Now check if required permissions are all present at commcell. If so we can quit.
	IF NOT EXISTS (
					SELECT 1
					FROM #permissionIdTable PInput
						LEFT OUTER JOIN #commcellLevelPermissions CP
							ON PInput.permissionId = CP.permissionId
					WHERE
						CP.permissionId IS NULL
				  )
	BEGIN
					SET @allPermissionsOnCommcell = 1
					IF @shouldSelectOutput = 1
						SELECT DISTINCT *
						FROM #getObjectsTable
					RETURN
	END
	-- select 'All permissions on Commcell check', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
	-- Get permission from parent if this entity type has one.
	-- Need to try performance with a View instead of #temp table.
	IF OBJECT_ID ('tempdb.dbo.#parentChildEntityTable') IS NOT NULL
		DROP TABLE #parentChildEntityTable
	CREATE TABLE #parentChildEntityTable (parentEntityTYpe INT, parentEntityId INT, childEntityType INT, childEntityId INT)
	CREATE CLUSTERED INDEX parentChildEntityTable_Idx ON #parentChildEntityTable (parentEntityType, parentEntityId)
	IF EXISTS (SELECT 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityTYpe)
	BEGIN
		-- Performance issue fix: Insert only those parent child entities on which this user / group has rights on into the parent child temp table.
		-- Than inserting all the parent and child entities of given entity type. (That is a huge list and is a performance killer).
		SET @dynamicSQLStmt = 'INSERT INTO #parentChildEntityTable
									SELECT parentEntityType, parentId, childEntityType, childId
									FROM UMSecurityAssociations Sec (NOLOCK)
											INNER JOIN #userAndGroupId UG
												ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
											INNER JOIN
											('
												+ CHAR(10)
												+ SUBSTRING ((
												SELECT DISTINCT
												'UNION'
												+ CHAR(10)
												+ CAST(associationQuery AS VARCHAR(MAX))
												+ CHAR(10)
												FROM APP_EntityParentAssociation
												WHERE
													childEntityType = @entityType
												FOR XML PATH (''), TYPE
												).value('.', 'NVARCHAR(MAX)'),
												6,
												2147483647) + '
											)Tbl
												ON Sec.entityType1 = Tbl.parentEntityTYpe AND Sec.entityId1 = Tbl.parentId'
		EXEC (@dynamicSQLStmt)
	END
	-- select 'Parent table formation', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
	DECLARE @ownerEntities TABLE (entityId INT PRIMARY KEY)
	INSERT INTO @ownerEntities
		SELECT DISTINCT Sec.entityId
		FROM UMOwners Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
		WHERE
			Sec.entityType = @entityTYpe
	-- select 'Owner entities', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
	-- Get permission individually on each entity and put into output table.
	INSERT INTO #getObjectsTable (entityId, permissionId)
		SELECT Sec.entityId1, Sec.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN #permissionIdTable P
				ON Sec.permissionId = P.permissionId
		WHERE
			Sec.entityType1 = @entityTYpe AND Sec.entityId1 > 0
			AND Sec.permissionId > 0
		UNION
		SELECT Sec.entityId1, RPE.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON Sec.roleId = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionId
		WHERE
			Sec.entityType1 = @entityTYpe AND Sec.entityId1 > 0
			AND Sec.roleID > 0
		UNION
		SELECT PC.childEntityId, P.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN #permissionIdTable P
				ON Sec.permissionId = P.permissionId
			INNER JOIN #parentChildEntityTable PC
				ON Sec.entityType1 = PC.parentEntityTYpe AND (Sec.entityId1 = PC.parentEntityId)
		WHERE
			Sec.permissionId > 0
		UNION
		SELECT PC.childEntityId, P.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN #permissionIdTable P
				ON Sec.permissionId = P.permissionId
			INNER JOIN #parentChildEntityTable PC
				ON Sec.entityType1 = PC.parentEntityTYpe AND (Sec.includeAll = 1)
		WHERE
			Sec.permissionId > 0
		UNION
		SELECT PC.childEntityId, P.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON Sec.roleId = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionId
			INNER JOIN #parentChildEntityTable PC
				ON Sec.entityType1 = PC.parentEntityTYpe AND (Sec.entityId1 = PC.parentEntityId)
		WHERE
			Sec.roleID > 0
		UNION
		SELECT PC.childEntityId, P.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON Sec.roleId = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionId
			INNER JOIN #parentChildEntityTable PC
				ON Sec.entityType1 = PC.parentEntityTYpe AND (Sec.includeALl = 1)
		WHERE
			Sec.roleID > 0
		UNION
		SELECT OE.entityId, RPE.permissionId
		FROM UMOwnerRoles R
			 INNER JOIN @ownerEntities OE
				ON R.entityType = @entityTYpe AND R.entityId = OE.entityID
			 INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON R.roleID = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionId
		UNION
		SELECT OE.entityId, RPE.permissionId
		FROM UMOwnerRoles R
			 INNER JOIN @ownerEntities OE
				ON R.entityType = 1 AND R.entityId = 2
			 INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON R.roleID = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionId
		UNION
		SELECT OE.entityId, RPE.permissionId
		FROM UMOwnerRoles R
			 INNER JOIN APP_ClientGroupAssoc PC
				ON R.entityType = 28 AND R.entityId = PC.clientGroupId
			 INNER JOIN @ownerEntities OE
				ON PC.clientId = OE.entityId
			 INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON R.roleID = RPE.roleID
			INNER JOIN #permissionIdTable P
				ON RPE.permissionId = P.permissionId
	-- select 'All security associations', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
	-- select count(*) from #getObjectsTable
	IF @shouldSelectOutput = 1
		SELECT DISTINCT *							-- The reason for DISTINCT is because there could be common permission between commcell and direct association.
		FROM #getObjectsTable
	-- select 'Final Select', datediff(ms,@startTime,sysdatetime())
	-- set @startTime = sysdatetime()
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getObjectsWithPermissionsV2')
	delete from GxQscripts where name = 'sec_getObjectsWithPermissionsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getObjectsWithPermissionsV2')
	delete from GXDBVersions where aliasname = 'sec_getObjectsWithPermissionsV2'
GO

insert into GXDBVersions values(2, 'sec_getObjectsWithPermissionsV2',  '00000000000000000000', 'sec_getObjectsWithPermissionsV2', '00000000000000000000')
GO

