

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getObjectsWithPermissions.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_getObjectsWithPermissions.sp"
--	|	Description : This stored procedure gets the list of entities of given entity type that this user has rights on. It gets the list
--	|				  of permissions that this user has on those entities.
--	|
--	|	Output table format : Output table should have an entityId column and permissionsList nvarchar column for non ida objects and client.
--	|						  Output table should have clientId, appTypeId, instanceId, backupsetId and subclient and permissionsList nvarchar column
--  |						  for iDA objects except client.
--  |						  Verify to comments section for sample output tables.
--	|	Author: saggarwal & jswaminathan
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getObjectsWithPermissions')
BEGIN
	print '>>> Drop Stored Procedure: sec_getObjectsWithPermissions <<<'
	drop procedure sec_getObjectsWithPermissions
END
IF EXISTS (select * from GxQscripts where name='sec_getObjectsWithPermissions')
	delete from GxQscripts where name = 'sec_getObjectsWithPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getObjectsWithPermissions')
	delete from GXDBVersions where aliasname = 'sec_getObjectsWithPermissions'
GO
print '... Creating Procedure: sec_getObjectsWithPermissions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getObjectsWithPermissions
--Inputs
  @userId INT,
  @entityTypeReq INT,			
  @tableOutput NVARCHAR(MAX)
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
----output table (for non Ida entity types)
--if object_id('tempdb.dbo.#outputTable_WithPermissions') is not null
--	drop table #outputTable_WithPermissions
--create table #outputTable_WithPermissions (entityId int, permissionList nvarchar(max))
----output table (for IDA entity types)
--if object_id('tempdb.dbo.#outputTableIDA_WithPermissions') is not null
--	drop table #outputTableIDA_WithPermissions
--create table #outputTableIDA_WithPermissions (clientId int, appTypeId int, instanceId int, backupsetId int, subclientID int, permissionList nvarchar(max))
declare @entityType int
--for apptype, instance, backupset and subclient we can take entityType as client and do the normal calculations
if @entityTYpeReq in (4, 5, 6, 7)				--use macro
set @entityType = 3
else
	set @entityType = @entityTYpeReq
if object_id('tempdb.dbo.#outputTable_Temp') is not null
	drop table #outputTable_Temp
create table #outputTable_Temp (entityId int, roleID int, permissionId int)
if object_id('tempdb.dbo.#outputTableIDA_Temp') is not null
	drop table #outputTableIDA_Temp
create table #outputTableIDA_Temp (clientId int, appTypeId int, instanceId int, backupsetId int, subclientId int, roleID int, permissionId int)
--list of user groups this user belongs to
if @userID = 0
	return
if object_id('tempdb.dbo.#userAndGroupId') is not null
	drop table #userAndGroupID
create table #userAndGroupID (userOrGroupId int, isUser int)
insert into #userAndGroupID
			  select distinct id, 0
			  from umgroups inner join (select groupid, 0 as isuser from umusergroup inner join umgroups on umusergroup.groupid = umgroups.id where userid = @userid
										union
										select umgroupid, 0 from umdsgroupmaps (nolock) inner join umusergroup (nolock) on umdsgroupmaps.umdsgroupid = umusergroup.groupid and userid = @userid) as ug
			  on umgroups.id = ug.groupid
where groupflags & 0x0001 = 0x0001
			  union
			  select @userid, 1
--list of individual entities associated to these users and groups
insert into #outputTable_Temp (entityId, roleId, permissionId)
	select sa.entityId1, sa.roleId, sa.permissionId
	from UMSecurityAssociations sa inner join #userAndGroupID ug
	on sa.isuser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
	where entityTYpe1 = @entityType and entityTYpe2 = 0				--for client only is considered
insert into #outputTable_Temp (entityId, roleId, permissionId)
	select uo.entityId, uor.roleId, uor.permissionId
	from umowners uo inner join #userAndGroupID ug
	on uo.isUser = ug.isUser and uo.userOrGroupId = ug.userOrGroupId
	inner join umownerroles uor
	on uo.entityType = uor.entityType and uo.entityId = uor.entityId
	where uo.entityType = @entityType
--expand all entities of this type to individual entities
if exists (select 1
		   from UMSecurityAssociations sa inner join #userAndGroupID ug
		   on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
		   where entityType1 = @entityType and includeAll = 1)
begin
	declare @allEntitiesExpansionSQL nvarchar(max) = N''
	--select id from app_client where id <> 1
	set @allEntitiesExpansionSQL = (select 'select ' + idColName + ' as id from ' + tableName + ' where ' + isnull(whereClause, ' 1 = 1 ') from APP_Entity where entityType = @entityType)
	--add exception handling here, there may be some entities not defined in app_entity table but present in umsecurityassociations
	--select entity.id, sa.roleId, sa.permissionId
	--from UMSecurityAssociations sa inner join #userAndGroupID ug
	--on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
	--inner join (select id from app_client where id <> 1) as entity
	--on sa.entityTYpe1 = 3 and sa.includeAll = 1
	set @allEntitiesExpansionSQL = 'select entity.id, sa.roleId, sa.permissionId ' +
								   'from UMSecurityAssociations sa inner join #userAndGroupID ug ' +
								   'on sa.isUser = ug.isUser and sa.userORGroupID = ug.userOrGroupID '+
								   'inner join (' + @allEntitiesExpansionSQL + ') as entity '+
								   'on sa.entityTYpe1 = ' + cast(@entityType as nvarchar(10)) + ' and sa.includeAll = 1'
	insert into #outputTable_Temp
		exec(@allEntitiesExpansionSQL)
end
--expand commcell association to individual entities
if exists (select 1
		   from UMSecurityAssociations sa inner join #userAndGroupID ug
		   on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
where entityType1 = 1 and entityId1 = 2)				--use macro
begin
	--select id from app_client where id <> 1
	set @allEntitiesExpansionSQL = (select 'select ' + idColName + ' as id from ' + tableName + ' where ' + isnull(whereClause, ' 1 = 1 ') from APP_Entity where entityType = @entityType)
	--select entity.id, sa.roleId, sa.permissionId
	--from UMSecurityAssociations sa inner join #userAndGroupID ug
	--on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
	--inner join (select id from app_client where id <> 1) as entity
	--on sa.entityTYpe1 = 3 and sa.includeAll = 1
	set @allEntitiesExpansionSQL = 'select entity.id, sa.roleId, sa.permissionId ' +
								   'from UMSecurityAssociations sa inner join #userAndGroupID ug ' +
								   'on sa.isUser = ug.isUser and sa.userORGroupID = ug.userOrGroupID '+
								   'inner join (' + @allEntitiesExpansionSQL + ') as entity '+
								   'on sa.entityTYpe1 = 1 and sa.entityId1 = 2'
	insert into #outputTable_Temp
		exec(@allEntitiesExpansionSQL)
end
--list of parent - child entities
if object_id('tempdb.dbo.#parententitytable') is not null
        drop table #parententitytable
create table #parententitytable (parententitytype int, parententityid int, childentitytype int, childentityid int)
declare @sqlstmt as nvarchar(max)
set @sqlstmt = 'insert into #parententitytable
					select distinct parentEntityType, parentId, childEntityType, childId
					from ('
							+char(10)
							+substring((select distinct
							'union'
							+char(10)
							+(associationQuery)
							+char(10)
							from App_EntityParentAssociation PE
							where
								PE.childEntityType = @entityType
							for xml path (''), type
							).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
							6,				-- Exclude the first UNION
							2147483647		-- MAX
							)
					+ ')Tbl'
exec (@sqlstmt)
--expand rights on parents to their respective children
insert into #outputTable_Temp
	select pet.childentityid, sa.roleId, sa.permissionId
	from UMSecurityAssociations sa inner join #userAndGroupID ug
	on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
	inner join #parententitytable pet
	on sa.entityType1 = pet.parententitytype and sa.entityId1 = pet.parententityid
--expand rights on "include all" of all parents to all the children
insert into #outputTable_Temp
	select pet.childentityid, sa.roleId, sa.permissionId
	from UMSecurityAssociations sa inner join #userAndGroupID ug
	on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
	inner join #parententitytable pet
	on sa.entityType1 = pet.parententitytype and sa.includeAll = 1
--owners and permissions both defined at parents
insert into #outputTable_Temp
	select pet.childentityid, uor.roleId, uor.permissionId
	from umowners uo inner join #userAndGroupID ug
	on uo.isUser = ug.isUser and uo.userOrGroupId = ug.userOrGroupId
	inner join #parententitytable pet
	on uo.entityTYpe = pet.parententitytype and uo.entityId = pet.parententityid
	inner join umownerroles uor
	on uor.entityType = uo.entityType and uor.entityId = uo.entityId
--owners of children, permissions and roles at parents (this is possible: client owner and client group owner permission)
insert into #outputTable_Temp
	select pet.childEntityId, uor.roleId, uor.permissionId
	from umowners uo inner join #userAndGroupID ug
	on uo.isUser = ug.isUser and uo.userOrGroupId = ug.userOrGroupId
	inner join #parententitytable pet
	on uo.entityType = @entityType and uo.entityId = pet.childentityid
	inner join umownerroles uor
	on uor.entityType = pet.parententitytype and uor.entityId = pet.parententityid
--owners of parents, permissions and roles at children (this is also not possible today)
insert into #outputTable_Temp
	select pet.childEntityId, uor.roleId, uor.permissionId
	from umowners uo inner join #userAndGroupID ug
	on uo.isUser = ug.isUser and uo.userOrGroupId = ug.userOrGroupId
	inner join #parententitytable pet
	on uo.entityType = pet.parententitytype and uo.entityId = pet.parententityid
	inner join umownerroles uor
	on uor.entityType = @entityType and uor.entityId = pet.childentityid
-- owner permissions at commcell level
declare @CommCellRoleId int = ISNULL((select top(1) roleId from umownerroles where entityType = 1 and entityId = 2), 0)
if @CommCellRoleId <> 0
	insert into #outputTable_Temp (entityId, roleId, permissionId)
		select uo.entityId, @CommCellRoleId, 0
		from umowners uo inner join #userAndGroupID ug
		on uo.isUser = ug.isUser and uo.userOrGroupId = ug.userOrGroupId
		where uo.entityType = @entityType
--special handling for iDA entities			--use macro
if @entityTYpeReq in (4, 5, 6, 7)
begin
	--expand client asociations to app types and gather individual associations on app types
if @entityTYpeReq = 4
	begin
		insert into #outputTableIDA_Temp
			select sa.entityId1, sa.entityID2, 0, 0, 0, sa.roleId, sa.permissionId
			from UMSecurityAssociations sa inner join #userAndGroupID ug
			on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
where sa.entityType2 = 4 and sa.entityType3 = 0			--only app types
		--expand clients to apptypes
		insert into #outputTableIDA_Temp
			select ida.clientId, ida.appTypeId, 0, 0, 0, ott.roleId, ott.permissionId
			from #outputTable_Temp ott inner join app_idaname ida
			on ott.entityId = ida.clientID
	end
else if @entityTYpeReq = 5
	begin
		insert into #outputTableIDA_Temp
			select sa.entityId1, sa.entityID2, sa.entityId3, 0, 0, sa.roleId, sa.permissionId
			from UMSecurityAssociations sa inner join #userAndGroupID ug
			on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
where sa.entityType2 = 4 and sa.entityTYpe4 = 0		--app types, instances
		--expand clients and apptypes to instances
		insert into #outputTableIDA_Temp
			select a.clientID, a.appTypeId, a.instance, 0, 0, ott.roleID, ott.permissionId
			from #outputTable_Temp ott inner join app_application a
			on ott.entityId = a.clientId
			union
			select ott.clientId, ott.appTypeId, a.instance, 0, 0, ott.roleId, ott.permissionID
			from #outputTableIDA_Temp ott inner join app_application a
			on ott.clientId = a.clientID and ott.appTypeId = a.appTypeId
			where ott.instanceId = 0
		delete from #outputTableIDA_Temp
		where instanceId = 0
	end
else if @entityTYpeReq = 6
	begin
		insert into #outputTableIDA_Temp
			select sa.entityId1, sa.entityID2, sa.entityId3, sa.entityId4, 0, sa.roleId, sa.permissionId
			from UMSecurityAssociations sa inner join #userAndGroupID ug
			on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
where sa.entityType2 = 4 and sa.entityType5 = 0			--app types, instances, backupset
		--expand clients, apptypes, instances entries to backupsets
		insert into #outputTableIDA_Temp
			select a.clientId, a.appTypeId, a.instance, a.backupSet, 0, ott.roleId, ott.permissionId
			from #outputTable_Temp ott inner join app_application a
			on ott.entityId = a.clientId
			union
			select a.clientId, a.appTypeId, a.instance, a.backupSet, 0, ott.roleId, ott.permissionId
			from #outputTableIDA_Temp ott inner join app_application a
			on ott.clientID = a.clientID and ott.appTypeId = a.appTypeId and (ott.instanceId = 0 or ott.instanceId = a.instance)
			where ott.backupsetId = 0
		delete from #outputTableIDA_Temp
		where backupsetId = 0
	end
else if @entityTYpeReq = 7
	begin
		insert into #outputTableIDA_Temp
			select sa.entityId1, sa.entityID2, sa.entityId3, sa.entityId4, sa.entityId5, sa.roleId, sa.permissionId
			from UMSecurityAssociations sa inner join #userAndGroupID ug
			on sa.isUser = ug.isUser and sa.userOrGroupId = ug.userOrGroupId
where sa.entityType2 = 4					--app types, instance, backupset and subclient
		--expand clients, apptypes, instances, backupsets into subclient entries
		insert into #outputTableIDA_Temp
			select a.clientId, a.appTypeId, a.instance, a.backupSet, a.id, ott.roleId, ott.permissionId
			from #outputTable_Temp ott inner join app_application a
			on ott.entityId = a.clientId
			union
			select a.clientId, a.appTypeId, a.instance, a.backupset, a.id, ott.roleId, ott.permissionId
			from #outputTableIDA_Temp ott inner join app_application a
			on ott.clientId = a.clientId and ott.appTypeId = a.appTypeId and (ott.instanceId = 0 or ott.instanceId = a.instance) and (ott.backupsetId = 0 or ott.backupsetId = a.backupSet)
			where ott.subclientId = 0
		delete from #outputTableIDA_Temp
		where subclientId = 0
	end
end
--we are done with reading from security association tables. Now let us remove the non mapped permissions and disabled roles
declare @permissionForEntity table (permissionID int)
insert into @permissionForEntity
	select permissionId
	from UMPermissionEntityTypeMap
	where entityType in (0, @entityType)
delete ott
from #outputTable_Temp ott inner join umroles r
on ott.roleId = r.id
where ott.roleID <> 0 and r.disabled <> 0
delete ott
from #outputTable_Temp ott left outer join @permissionForEntity pfe
on ott.permissionId = pfe.permissionID
where pfe.permissionID is null and ott.permissionId <> 0
delete ott
from #outputTable_Temp ott
where roleID <> 0 and roleId not in (select roleID
									from UMRolesWithPermissionsExpanded rpe inner join @permissionForEntity pfe
									on rpe.permissionId = pfe.permissionID)
delete ott
from #outputTableIDA_Temp ott inner join umroles r
on ott.roleId = r.id
where ott.roleID <> 0 and r.disabled <> 0
delete ott
from #outputTableIDA_Temp ott left outer join @permissionForEntity pfe
on ott.permissionId = pfe.permissionID
where pfe.permissionID is null and ott.permissionId <> 0
delete ott
from #outputTableIDA_Temp ott
where roleID <> 0 and roleId not in (select roleID
									from UMRolesWithPermissionsExpanded rpe inner join @permissionForEntity pfe
									on rpe.permissionId = pfe.permissionID)
declare @outputStatementSQL nvarchar(1024) = N''
if @entityTYpeReq not in (4, 5, 6, 7)				--use macro
	set @outputStatementSQL =
	'insert into ' + @tableOutput
	+ ' select distinct ott.entityId, stuff((select '','' + cast(itt.permissionId as nvarchar(10)) '
						 + ' from (select permissionID from #outputTable_temp itt where itt.entityId = ott.entityId and itt.permissionId <> 0 '
						 +	' union '
						 +	' select rpe.permissionId from UMRolesWithPermissionsExpanded rpe inner join #outputTable_Temp itt on itt.roleID = rpe.roleID where itt.entityId = ott.entityId and itt.roleID <> 0) itt '
						 + ' for xml path ('''')), 1, 1, '''') '
	+ ' from #outputTable_Temp ott '
else
	set @outputStatementSQL =
	'insert into ' + @tableOutput
	+ ' select distinct ott.clientId, ott.appTypeID, ott.instanceId, ott.backupsetId, ott.subclientId, stuff((select '','' + cast(itt.permissionId as nvarchar(10)) '
																								 + ' from (select permissionID from #outputTableIDA_Temp itt where itt.clientId = ott.clientID and itt.appTypeId = ott.appTypeId and itt.instanceId = ott.instanceId and itt.backupsetid = ott.backupsetID and itt.subclientId = ott.subclientId and itt.permissionId <> 0 '
																								 +	' union '
																								 +	' select rpe.permissionId from UMRolesWithPermissionsExpanded rpe inner join #outputTableIDA_Temp itt on itt.roleID = rpe.roleID where itt.clientId = ott.clientID and itt.appTypeId = ott.appTypeId and itt.instanceId = ott.instanceId and itt.backupsetid = ott.backupsetID and itt.subclientId = ott.subclientId and itt.roleID <> 0) itt '
																								 + ' for xml path ('''')), 1, 1, '''') '
	+ ' from #outputTableIDA_Temp ott'
exec (@outputStatementSQL)
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getObjectsWithPermissions')
	delete from GxQscripts where name = 'sec_getObjectsWithPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getObjectsWithPermissions')
	delete from GXDBVersions where aliasname = 'sec_getObjectsWithPermissions'
GO

insert into GXDBVersions values(2, 'sec_getObjectsWithPermissions',  '00000000000000000000', 'sec_getObjectsWithPermissions', '00000000000000000000')
GO

