

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getNonIdaObjectsForThisUserWrapperV2.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_getNonIdaObjectsForThisUserWrapperV2.sp"
--	|	Description:
--	|	For a given user fetches the list of entity Ids of the requested entity type and permissions
--	|	If permission Id is not set to 0, then will get the list of all associated entities with given permissions on it
--	|	Author: Logesh
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getNonIdaObjectsForThisUserWrapperV2 <<<'

IF EXISTS (select * from sysobjects where name='sec_getNonIdaObjectsForThisUserWrapperV2')
	drop procedure sec_getNonIdaObjectsForThisUserWrapperV2
IF EXISTS (select * from GxQscripts where name='sec_getNonIdaObjectsForThisUserWrapperV2')
	delete from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserWrapperV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNonIdaObjectsForThisUserWrapperV2')
	delete from GXDBVersions where aliasname = 'sec_getNonIdaObjectsForThisUserWrapperV2'
GO
print '... Creating Procedure: sec_getNonIdaObjectsForThisUserWrapperV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getNonIdaObjectsForThisUserWrapperV2
--Inputs
  @userId INT,
  @entityTypeReq INT,			
  @permissionIds NVARCHAR(MAX)
AS
  DECLARE @entityId INT
SET NOCOUNT ON
-- Output entity Ids table.
IF object_id('tempdb.dbo.#getNonIdaObjectsOutputTable') IS NOT NULL
	DROP TABLE #getNonIdaObjectsOutputTable
CREATE TABLE #getNonIdaObjectsOutputTable
(
	entityId INT
)
IF @permissionIds = ''
BEGIN
	GOTO SELECT_EXIT
END
IF object_id('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NOT NULL
	DROP TABLE #getNonIdaObjects_InputPermissionsTbl
CREATE TABLE #getNonIdaObjects_InputPermissionsTbl
(
	permissionId INT
)
INSERT INTO #getNonIdaObjects_InputPermissionsTbl
SELECT _id
FROM dbo.SplitIDs(@permissionIds)
EXEC sec_getNonIdaObjectsForThisUser @userId,@entityTypeReq,-1,'#getNonIdaObjectsOutputTable'
SELECT_EXIT:
SELECT entityId FROM #getNonIdaObjectsOutputTable
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjectsOutputTable') IS NOT NULL
    DROP TABLE #getNonIdaObjectsOutputTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserWrapperV2')
	delete from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserWrapperV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNonIdaObjectsForThisUserWrapperV2')
	delete from GXDBVersions where aliasname = 'sec_getNonIdaObjectsForThisUserWrapperV2'
GO

insert into GXDBVersions values(2, 'sec_getNonIdaObjectsForThisUserWrapperV2',  '00000000000000000000', 'sec_getNonIdaObjectsForThisUserWrapperV2', '00000000000000000000')
GO

