

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getNonIdaObjectsForThisUserV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_getNonIdaObjectsForThisUserV2.sp"
--	|	Description: Fetches list of Non Ida entities, with capability bit mask that user has rights on.
--	|	Inputs: 1. userId, 2. entity type(CvEntities.x)
--	|	Outputs: 1. capability bit mask that user has on Commcell (old-cache logic). This will be stored against commcell row in cache table.
--	|			 2. temp table with entity Id and capabilities bit mask.
--	|	Note: Well known external temp table #nonIdaObjectsV2_OutputTbl should be created before calling this SP.
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getNonIdaObjectsForThisUserV2')
BEGIN
	print '>>> Drop Stored Procedure: sec_getNonIdaObjectsForThisUserV2 <<<'
	drop procedure sec_getNonIdaObjectsForThisUserV2
END
IF EXISTS (select * from GxQscripts where name='sec_getNonIdaObjectsForThisUserV2')
	delete from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNonIdaObjectsForThisUserV2')
	delete from GXDBVersions where aliasname = 'sec_getNonIdaObjectsForThisUserV2'
GO
print '... Creating Procedure: sec_getNonIdaObjectsForThisUserV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getNonIdaObjectsForThisUserV2
--Inputs
  @userId INT, 
  @entityTypeReq INT,			
  @capsOnCommcellThisUserHas BIGINT OUTPUT
AS
	-- Sample well known external temp table to be created before calling this SP.
	/*IF OBJECT_ID('tempdb.dbo.#nonIdaObjectsV2_OutputTbl') IS NOT NULL
		DROP TABLE #nonIdaObjectsV2_OutputTbl
	CREATE TABLE #nonIdaObjectsV2_OutputTbl
	(
		entityId INT PRIMARY KEY,
		capabilities BIGINT
	)*/
	IF OBJECT_ID('tempdb.dbo.#nonIdaObjectsV2_OutputTbl') IS NULL
	BEGIN
		RAISERROR('Error. Output table for nonIdaObjectsV2_OutputTbl not yet created',
				16,
				1
				 )
		RETURN
	END
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	-- Useful variables.
	DECLARE @allCapsBitMask BIGINT = (SELECT SUM(CAST(POWER(2.0,id-1)AS BIGINT)) FROM UMPermissions WHERE id < 65)
	DECLARE	@inheritedPermissions BIGINT = 0
DECLARE	@viewBitMask BIGINT = POWER(2, 31 - 1)
	DECLARE @entityTableName NVARCHAR(128) = ''
	DECLARE @idColName NVARCHAR(128) = ''
	DECLARE @whereColName NVARCHAR(128) = ''
	DECLARE @dynamicSQL NVARCHAR(MAX) = ''
	DECLARE @inheritedPermissionsStr VARCHAR(20)
	-- Form user/user group table
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
			DROP TABLE #getMemberUserGroupsHelperOutputTbl
		CREATE TABLE #getMemberUserGroupsHelperOutputTbl
		(
			isUser INT,
			userOrGroupId INT,
			UNIQUE CLUSTERED (isUser, userOrGroupId)					-- Performance tuning
		)
		EXEC sec_getMemberUserGroupsHelper @userId
	END
	-- Get all valid entity types that needs to be processed. (Like parents, etc.).
	BEGIN
		DECLARE @entityTypesTbl TABLE
		(
			entityType INT PRIMARY KEY
		)
		INSERT INTO @entityTypesTbl
			SELECT DISTINCT parentEntityType
			FROM App_EntityParentAssociation
			WHERE
				childEntityType = @entityTypeReq
		INSERT INTO @entityTypesTbl
			VALUES (@entityTypeReq),
					(1)			-- Commcell is default parent of all entities.
	END
	-- Read security associations that this user / group has on the above entity types along with role / permission and capability bit mask.
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tempAssoc ') IS NOT NULL
			DROP TABLE #tempAssoc
		CREATE TABLE #tempAssoc
		(
			entityType INT,
			entityId INT,
			includeAll INT,
			roleId INT,
			permissionId INT,
			capabilities BIGINT
			-- Note: this is "as-is" bit mask. Does not convert permission > 64 into View
			-- as commcell and other entities have different ways of processing it.
		)
		CREATE CLUSTERED INDEX tempAssocIdx_entityType_entityId ON #tempAssoc(entityType, entityId);
		INSERT INTO #tempAssoc
			SELECT	Sec.entityType1,
					Sec.entityId1,
					Sec.includeAll,
					Sec.roleId,
					0,
					R.capabilitiesBitMask
			FROM UMSecurityAssociations Sec
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON UG.isUser = Sec.isUser AND UG.userOrGroupId = Sec.userOrGroupId
				INNER JOIN UMRolesWithPermissionsExpanded RPE
					ON Sec.roleId = RPE.roleId
				INNER JOIN UMPermissionEntityTypeMap UPE
					ON RPE.permissionId = UPE.permissionID
					AND UPE.entityType IN (0, @entityTypeReq)
				INNER JOIN UMRoles R
					ON Sec.roleID = R.id
					AND R.disabled = 0
				INNER JOIN @entityTypesTbl E
					ON Sec.entityType1 = E.entityType
			UNION
			SELECT	Sec.entityType1,
					Sec.entityId1,
					Sec.includeAll,
					0,
					Sec.permissionId,
					CASE WHEN Sec.permissionId < 64 THEN POWER(2.0,Sec.permissionId - 1) ELSE 0 END
			FROM UMSecurityAssociations Sec
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON UG.isUser = Sec.isUser AND UG.userOrGroupId = Sec.userOrGroupId
				INNER JOIN UMPermissionEntityTypeMap UPE
					ON Sec.permissionId = UPE.permissionId
					AND UPE.entityType IN (0, @entityTypeReq)
				INNER JOIN @entityTypesTbl E
					ON Sec.entityType1 = E.entityType
	END
	-- If master user, return right away. Old cache logic used to just return one row with all capabilities bit mask in this case.
IF EXISTS (SELECT TOP 1 1 FROM #tempAssoc WHERE entityType = 1 AND entityId = 2 AND capabilities = @allCapsBitMask)
	BEGIN
		SET @capsOnCommcellThisUserHas = @allCapsBitMask
		GOTO PROC_EXIT
	END
	-- Process commcell associations, according to old cache table logic.
IF EXISTS (SELECT TOP 1 1 FROM #tempAssoc WHERE entityType = 1 AND entityId = 2)
	BEGIN
		-- Generic permission < 65 can be treated as that respective bit mask on commcell. (set in output commcell capability variable)
		-- Generic permission > 64 can be treated as View on commcell. (set in output commcell capability variable)
		-- Mapped permission < 65 has to be inherited as that respetive bit mask onto all the entity Ids. (set into inherited permissions variable for now).
		-- Mapped permission > 64 has to be inherited as View onto all the entity Ids. (set into inherited permissions variable for now).
		SELECT
				@capsOnCommcellThisUserHas = @capsOnCommcellThisUserHas | (CASE WHEN UPE.entityType = 0 AND TA.permissionId < 65 THEN TA.capabilities
																				WHEN UPE.entityType = 0 AND TA.permissionId > 64 THEN @viewBitMask
																				ELSE 0
																		   END),
				@inheritedPermissions = @inheritedPermissions | (CASE WHEN UPE.entityType = @entityTypeReq AND TA.permissionId < 65 THEN TA.capabilities
																	  WHEN UPE.entityType = @entityTypeReq AND TA.permissionId > 64 THEN @viewBitMask
																	  ELSE 0
																END)
		FROM #tempAssoc TA
			INNER JOIN UMPermissionEntityTypeMap UPE
				ON TA.permissionId = UPE.permissionId
		WHERE
TA.entityType = 1 AND TA.entityId = 2 AND TA.permissionId > 0
		SELECT
				@capsOnCommcellThisUserHas = @capsOnCommcellThisUserHas | (CASE WHEN UPE.entityType = 0 AND RPE.permissionId < 65 THEN CAST(POWER(2.0, RPE.permissionId - 1) AS BIGINT)
																				WHEN UPE.entityType = 0 AND RPE.permissionId > 64 THEN @viewBitMask
																				ELSE 0
																		   END),
				@inheritedPermissions = @inheritedPermissions | (CASE WHEN UPE.entityType = @entityTypeReq AND RPE.permissionId < 65 THEN CAST(POWER(2.0, RPE.permissionId - 1) AS BIGINT)
																	  WHEN UPE.entityType = @entityTypeReq AND RPE.permissionId > 64 THEN @viewBitMask
																	  ELSE 0
																END)
		FROM #tempAssoc TA
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON TA.roleId = RPE.roleId
			INNER JOIN UMPermissionEntityTypeMap UPE
				ON RPE.permissionId = UPE.permissionId
		WHERE
TA.entityType = 1 AND TA.entityId = 2 AND TA.roleId > 0
	END
	-- We have filled 0 in capabilities column if permission Ids > 64 (or role contains valid permissions but > 64).
	-- Now that commcell is processed, let's set all those entries to view bit mask.
	UPDATE #tempAssoc
	SET capabilities = @viewBitMask
	WHERE
		entityType <> 1 AND capabilities = 0
	-- Process include all of direct associations and set a bit mask in inherited permissions variable.
	-- Down later, it will be applied on all entity Ids.
	IF EXISTS (SELECT TOP 1 1 FROM #tempAssoc WHERE entityType = @entityTypeReq AND includeAll = 1)
	BEGIN
		SELECT @inheritedPermissions = @inheritedPermissions | capabilities
		FROM #tempAssoc
		WHERE
			entityType = @entityTypeReq AND includeAll = 1 AND capabilities <> 0
	END
	-- Parent entities expansion.
	IF EXISTS (SELECT TOP 1 1 FROM #tempAssoc WHERE entityType NOT IN (1, @entityTypeReq))
	BEGIN
		/*
			INSERT INTO #tempAssoc
				SELECT Tbl.childEntityType, Tbl.childId, 0, Parent.roleId, Parent.permissionId, Parent.capabilities
				FROM (
						-- Association query.
						SELECT DISTINCT 158 AS parentEntityType, componentNameId AS parentId, 17 AS childEntityType, attrVal AS childId
						FROM APP_PlanProp (NOLOCK)
						WHERE attrName = 'Storage policy'					-- Adding a OR does not work here since when expanding parent child in dynamic query, it is considering all the attrVals not only those with this attrName causing SQL error.
						UNION												-- It is because of a wrong index on App_PlanProp table, seems to be. We can make that table change later on SP14 since need to analyze it more deep.
						SELECT DISTINCT 158 AS parentEntityType, componentNameId AS parentId, 17 AS childEntityType, attrVal AS childId
						FROM APP_PlanProp (NOLOCK)
						WHERE attrName = 'Log Storage policy'
					 )Tbl
					INNER JOIN #tempAssoc Parent
						ON Parent.entityType = Tbl.parentEntityType AND Parent.entityId = Tbl.parentId
		*/
		SET @dynamicSQL = 'INSERT INTO #tempAssoc'
                                    + CHAR(10)
                                    + SUBSTRING
                                        (
                                            (
                                                SELECT 'UNION'
                                                    + CHAR(10)
                                                    + 'SELECT Tbl.childEntityType, Tbl.childId, 0, Parent.roleId, Parent.permissionId, Parent.capabilities '
                                                    + CHAR(10)
                                                    + 'FROM ('
                                                    + CHAR(10)
                                                    + CAST(associationQuery AS VARCHAR(MAX))
                                                    + CHAR(10)
                                                    + ')Tbl'
                                                    + CHAR(10)
                                                    + ' INNER JOIN #tempAssoc Parent
															ON Parent.entityType = Tbl.parentEntityType AND Parent.entityId = Tbl.parentId '
                                                    + CHAR(10)
                                                FROM App_EntityParentAssociation PE
                                                WHERE
                                                    childEntityType = @entityTypeReq
													AND parentEntityType IN (SELECT DISTINCT entityType FROM #tempAssoc)
                                                FOR XML PATH (''), TYPE
                                            ).value('.','NVARCHAR(MAX)'),               -- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
                                            6,              -- Exclude the first UNION
                                            2147483647      -- MAX
                                        )
         EXEC (@dynamicSQL)
	END
	DECLARE @companyIdOfUser INT = 0
    SET @companyIdOfUser = dbo.AppGetCompanyForUserOrUserGroup(@userId, 1)
IF OBJECT_ID('tempdb.dbo.#validCompaniesOfCompanyUser') IS NOT NULL
    DROP TABLE #validCompaniesOfCompanyUser
CREATE TABLE #validCompaniesOfCompanyUser
    (
        companyId INT NOT NULL
        primary key (companyId)
    )
DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
IF @doNotUseCompanyEntitiesTableForFiltering = 1
BEGIN
	SET @companyIdOfUser = 0
END
IF @companyIdOfUser <> 0
BEGIN
    declare @parentCompanyId int = @companyIdOfUser
        ;with parentCompany as
        (
            select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            union all
            select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select childCompanyId
        from parentCompany
    declare @childCompanyId int = @companyIdOfUser
        ;with childCompany as
        (
            select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
            union all
            select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select parentCompanyId
        from childCompany
    INSERT INTO #validCompaniesOfCompanyUser values (@companyIdOfUser) , (0)   -- Company Id 0 For MSP entities
END
	IF @companyIdOfUser <> 0
	BEGIN
		-- Insert into final output table.
		INSERT INTO #nonIdaObjectsV2_OutputTbl
			SELECT T1.entityId,
				   SUM(DISTINCT T2.value)
			FROM #tempAssoc T1
			LEFT JOIN App_CompanyEntities App
				On App.entityType = @entityTypeReq AND App.entityId = T1.entityId
			LEFT JOIN #validCompaniesOfCompanyUser C
				On C.companyId = App.companyId
				CROSS APPLY dbo.bitwiseOrV1(T1.capabilities) T2
			WHERE
				T1.entityType = @entityTypeReq AND T1.entityId > 0
				AND (App.entityId is NULL Or C.companyId = App.companyId)
			GROUP BY T1.entityId
	END
	ELSE
	BEGIN
		-- Insert into final output table.
		INSERT INTO #nonIdaObjectsV2_OutputTbl
			SELECT entityId,
				   SUM(DISTINCT T2.value)
			FROM #tempAssoc T1
				CROSS APPLY dbo.bitwiseOrV1(T1.capabilities) T2
			WHERE
				entityType = @entityTypeReq AND entityId > 0
			GROUP BY entityId
	END
	-- Process inherited permissions from commcell.
	IF @inheritedPermissions <> 0
	BEGIN
		-- Update the capabilities of each entity available with this bit mask.
		UPDATE #nonIdaObjectsV2_OutputTbl
		SET capabilities = capabilities | @inheritedPermissions
		-- For those remaining entities, get them from that entity table and set this bit mask.
		SET @inheritedPermissionsStr = CAST(@inheritedPermissions AS VARCHAR(20))
		SELECT	@entityTableName = tableName,
				@idColName = idColName,
				@whereColName = whereClause
		FROM APP_Entity
		WHERE
			entityType = @entityTypeReq
		/*
			INSERT INTO #nonIdaObjectsV2_OutputTbl
				SELECT Entity.libraryid, @inheritedPermissionsStr
				FROM MMLibrary Entity
					LEFT JOIN #nonIdaObjectsV2_OutputTbl O
						ON Entity.libraryId = O.entityId
				WHERE
					O.entityId IS NULL
					AND libraryId > 0
		*/
		IF @companyIdOfUser <> 0
		BEGIN
			IF PATINDEX('%flags%', @whereColName) <> 0 AND PATINDEX('%.flags%', @whereColName) = 0
            BEGIN
                -- Sometimes whereColName has columns such flags which may be ambiguous with the table it is joining to, so better add table name in where clause.
                SET @whereColName = REPLACE(@whereColName, 'flags', @entityTableName + '.' + 'flags')
            END
			SET @dynamicSQL = 'INSERT INTO #nonIdaObjectsV2_OutputTbl' + CHAR(10) +
								'SELECT Entity.' + @idColName + ',' + @inheritedPermissionsStr + CHAR(10) +
								'FROM ' + @entityTableName + ' Entity' + CHAR(10) +
									'LEFT OUTER JOIN #nonIdaObjectsV2_OutputTbl O' + CHAR(10) +
										'ON Entity.' + @idColName + ' = O.entityId' + CHAR(10) +
									' LEFT JOIN App_CompanyEntities App ' +
										' On App.entityType = '+ CAST (@entityTypeReq AS VARCHAR(10))  +' AND App.entityId = Entity.' + @idColName +
									' LEFT JOIN #validCompaniesOfCompanyUser C ' +
                                             				' ON App.companyId = C.companyId ' +
									' WHERE (App.entityId is NULL Or C.companyId = App.companyId) AND ' + CHAR(10) +
									'O.entityId IS NULL ' + CHAR(10) +
									CASE WHEN @whereColName <> '' AND @whereColName IS NOT NULL THEN ' AND ' + @whereColName ELSE '' END
		END
		ELSE
		BEGIN
			SET @dynamicSQL = 'INSERT INTO #nonIdaObjectsV2_OutputTbl' + CHAR(10) +
                                'SELECT Entity.' + @idColName + ',' + @inheritedPermissionsStr + CHAR(10) +
                                'FROM ' + @entityTableName + ' Entity' + CHAR(10) +
                                    'LEFT OUTER JOIN #nonIdaObjectsV2_OutputTbl O' + CHAR(10) +
                                        'ON Entity.' + @idColName + ' = O.entityId' + CHAR(10) +
                                'WHERE' + CHAR(10) +
                                    'O.entityId IS NULL ' + CHAR(10) +
                                    CASE WHEN @whereColName <> '' AND @whereColName IS NOT NULL THEN ' AND ' + @whereColName ELSE '' END
		END
		EXEC (@dynamicSQL)
	END
	PROC_EXIT:
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserV2')
	delete from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNonIdaObjectsForThisUserV2')
	delete from GXDBVersions where aliasname = 'sec_getNonIdaObjectsForThisUserV2'
GO

insert into GXDBVersions values(2, 'sec_getNonIdaObjectsForThisUserV2',  '00000000000000000000', 'sec_getNonIdaObjectsForThisUserV2', '00000000000000000000')
GO

