

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getNonIdaObjectsForThisUserOld.sp] ---------- 

--  +-----------------------------------------------------------------------------------------------------------------------------------+
--  |   Procedure : "sec_getNonIdaObjectsForThisUserOld.sp"
--  |   Description:
--  |   For a given user fetches the list of entity Ids of the requested entity type
--  |   If permission Id is set to 0, then will get the list of all associated entities
--  |   (does not care about permission, this case is called when we just want to get the list of entities that user can view)
--  |   If permission Id is not set to 0, then will get the list of all associated entities with given permission on it
--  |   If there are multiple permission Ids pass it in #getNonIdaObjects_InputPermissionsTbl.
--  |   Will get entities on which user has any of those permissions.
--  |   When honorParentAssociations is set to 0, it will honor done only on the entity level directly. Ignores commcell and parent entity
--  |   associations.
--  |   Author: saggarwal & jswaminathan
--  +-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getNonIdaObjectsForThisUserOld')
BEGIN
	print '>>> Drop Stored Procedure: sec_getNonIdaObjectsForThisUserOld <<<'
	drop procedure sec_getNonIdaObjectsForThisUserOld
END
IF EXISTS (select * from GxQscripts where name='sec_getNonIdaObjectsForThisUserOld')
	delete from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserOld'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNonIdaObjectsForThisUserOld')
	delete from GXDBVersions where aliasname = 'sec_getNonIdaObjectsForThisUserOld'
GO
print '... Creating Procedure: sec_getNonIdaObjectsForThisUserOld'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getNonIdaObjectsForThisUserOld
--Inputs
  @userId INT,
  @entityTypeReq INT,           
  @permissionId INT,
  @tableOutput NVARCHAR(MAX) = '',
  @includeNotMappedPermission INT = 0,
  @honorParentAssociations INT = 1
AS
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET NOCOUNT ON
    IF @userId = 0
    BEGIN
        RAISERROR ('Invalid userId passed.',16,1)
        RETURN
    END
    DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
    -- User group table framing.
    BEGIN
        IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
            DROP TABLE #getMemberUserGroupsHelperOutputTbl
        CREATE TABLE #getMemberUserGroupsHelperOutputTbl
        (
            isUser INT,
            userOrGroupId INT,
            UNIQUE CLUSTERED (isUser, userOrGroupId)
        )
        EXEC sec_getMemberUserGroupsHelper @userID
    END
    -- Read metadata for this entity.
    BEGIN
        DECLARE @idColName VARCHAR(128) = ''
                ,@tableName VARCHAR(128) = ''
                ,@whereClause VARCHAR(512) = ''
                ,@entityFlags INT = 0
        SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause, @entityFlags = flags
        FROM APP_Entity
        WHERE
            entityType = @entityTypeReq
        IF @whereClause = ''
            SET @whereClause = '1=1'
    END
    -- Comma separated list of entity types to use in WHERE clause when querying security association table.
    -- This is just a list of entity types so would have very few entries. (As of now, max 4 for entity type = 13: 1,13,15,61).
    BEGIN
        DECLARE @entityTypesString VARCHAR(128) = CAST(@entityTypeReq AS VARCHAR(10))
                ,@parentSameAsChildEntityType BIT = 0
        IF @honorParentAssociations = 1
        BEGIN
            IF @entityFlags & 4 = 0         -- SKIP_COMMCELL_SECURITY_CHECK
                SET @entityTypesString = @entityTypesString + ',' + '1'         -- COMMCELL
            SELECT @entityTypesString += (',' + CAST(parentEntityType AS VARCHAR(128)))
                   ,@parentSameAsChildEntityType = (CASE WHEN parentEntityType = @entityTypeReq THEN 1 ELSE @parentSameAsChildEntityType END)
            FROM App_EntityParentAssociation EPA
            WHERE
                childEntityType = @entityTypeReq
        END
    END
    -- List of roles and permissions that are applicable.
    BEGIN
        IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_tempRolesAndPermissions') IS NOT NULL
            DROP TABLE #getNonIdaObjects_tempRolesAndPermissions
        CREATE TABLE #getNonIdaObjects_tempRolesAndPermissions
        (
            roleId INT,
            permissionId INT,
            UNIQUE CLUSTERED (roleId, permissionId)
        )
        IF @permissionId = 0
        BEGIN
            -- Having entityTypes in WHERE clause instead of JOIN on a table of entity types reduces reads from ~55500 to ~370.
            -- Filtering entity types in WHERE clause and JOIN on user-user groups table gives ~16488 rows in one index seek on security associations table,
            -- with isUser,userOrGroupId,entityType1 in seek predicate and roleId in output.
            -- If we JOIN on user-user groups table and entity types table, it first results ~27516 rows then filters entities giving ~16488 rows.
            -- Inputs: userId = 88(dave), entityTypeReq = 13, FC SP9 staged DB
            SET @dynamicSQLStr = '
            INSERT INTO #getNonIdaObjects_tempRolesAndPermissions
                SELECT DISTINCT T.roleID, 0
                FROM
                    (
                        SELECT DISTINCT Sec.roleID
                        FROM UMSecurityAssociations Sec
                             INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                                ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                        WHERE
                            Sec.entityType1 IN (' + @entityTypesString + ')
                    )T
                    INNER JOIN UMRolesWithPermissionsExpanded RPE
                        ON RPE.roleID = T.roleID
                    INNER JOIN UMPermissionEntityTypeMap UPE
                        ON RPE.permissionId = UPE.permissionId
                    INNER JOIN UMRoles R
                        ON R.id = T.roleID
                WHERE
                    R.disabled = 0
                    AND UPE.entityType IN (0,' + CAST(@entityTypeReq AS VARCHAR(128)) + ')'
            EXEC (@dynamicSQLStr)
            INSERT INTO #getNonIdaObjects_tempRolesAndPermissions
                SELECT DISTINCT 0, permissionID         -- We can just get permissions from this table. It will be less.
                FROM UMPermissionEntityTypeMap
                WHERE
                    entityType IN (0,@entityTypeReq)
        END
        ELSE IF @permissionId > 0
        BEGIN
            SET @dynamicSQLStr = '
            INSERT INTO #getNonIdaObjects_tempRolesAndPermissions
                SELECT DISTINCT T.roleID, 0
                FROM
                    (
                        SELECT DISTINCT Sec.roleID
                        FROM UMSecurityAssociations Sec
                             INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                                ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                        WHERE
                            Sec.entityType1 IN (' + @entityTypesString + ')
                    )T
                    INNER JOIN UMRolesWithPermissionsExpanded RPE
                        ON RPE.roleID = T.roleID
                    INNER JOIN UMRoles R
                        ON R.id = T.roleID
                WHERE
                    R.disabled = 0
                    AND RPE.permissionId = ' + CAST(@permissionId AS VARCHAR(10))
            EXEC (@dynamicSQLStr)
            INSERT INTO #getNonIdaObjects_tempRolesAndPermissions
                VALUES (0, @permissionId)
        END
        ELSE IF @permissionID = -1          -- This is a new support. Passing multiple permission Ids in the input via #getNonIdaObjects_InputPermissionsTbl, many devs asked for this.
        BEGIN
            IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NULL
            BEGIN
                RAISERROR ('#getNonIdaObjects_InputPermissionsTbl not passed as input to sec_getNonIdaObjectsForThisUser.',16,1)
                RETURN
            END
            SET @dynamicSQLStr = '
            INSERT INTO #getNonIdaObjects_tempRolesAndPermissions
                SELECT DISTINCT T.roleID, 0
                FROM
                    (
                        SELECT DISTINCT Sec.roleID
                        FROM UMSecurityAssociations Sec
                             INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                                ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                        WHERE
                            Sec.entityType1 IN (' + @entityTypesString + ')
                    )T
                    INNER JOIN UMRolesWithPermissionsExpanded RPE
                        ON RPE.roleID = T.roleID
                    INNER JOIN #getNonIdaObjects_InputPermissionsTbl UPE
                        ON RPE.permissionId = UPE.permissionId
                    INNER JOIN UMRoles R
                        ON R.id = T.roleID
                WHERE
                    R.disabled = 0'
            EXEC (@dynamicSQLStr)
            INSERT INTO #getNonIdaObjects_tempRolesAndPermissions
                SELECT 0, permissionId
                FROM #getNonIdaObjects_InputPermissionsTbl
        END
    END
    IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_TempTable') IS NOT NULL
        DROP TABLE #getNonIdaObjects_TempTable
    CREATE TABLE #getNonIdaObjects_TempTable
    (
        entityType INT,
        entityId INT,
        includeAll INT DEFAULT 0
    )
    CREATE CLUSTERED INDEX getNonIdaObjects_TempTable_Idx ON #getNonIdaObjects_TempTable (entityType,entityId,includeALl)           -- Not necessarily UNIQUE because same entity can come direct and from parent.
    SET @dynamicSQLStr = '
    INSERT INTO #getNonIdaObjects_TempTable
        SELECT DISTINCT Sec.entityType1, Sec.entityId1, Sec.includeAll
        FROM UMSecurityAssociations Sec
             INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
             INNER JOIN #getNonIdaObjects_tempRolesAndPermissions RP
                ON Sec.roleId = RP.roleID AND Sec.permissionId = RP.permissionID
        WHERE
            Sec.entityType1 IN (' + @entityTypesString + ')'
    EXEC (@dynamicSQLStr)
    DECLARE @allAssociations BIT = 0
    SELECT TOP 1 @allAssociations = 1
    FROM #getNonIdaObjects_TempTable
    WHERE
        entityType = 1 AND entityId = 2
        OR (entityType = @entityTypeReq AND includeAll = 1)
    -- Expand parent child association.
    IF (@allAssociations <> 1)
        AND
            -- We need this check to be placed here. Whether user actually has rights on any parent entity or not. Else we would be causing extra reads by joining it on parent child table everytime.
            (
                EXISTS
                (
                    SELECT TOP 1 entityType
                    FROM #getNonIdaObjects_TempTable
                    WHERE
                        entityType NOT IN (1,@entityTypeReq)    -- There are some other entity types present on the table. Obviously they are parents. So expand them.
                )
                OR
                (@parentSameAsChildEntityType = 1)              -- For entities like user group, they themselves are parent. (Commvault group holds AD groups). In those cases too we need to expand parent child relation.
                                                                -- Here we do not need a check on the table whether it contains entries or not. If they are not there, then table itself is empty so joining will not be an issue.
            )
    BEGIN
            -- If includeAll parent is selected, then we can get all children from associationQuery. Else we need to JOIN with input table.
            -- This way of doing the query brought down the time from ~2seconds to ~200ms when includeAll parent is included.
            -- Inputs: userId = 1696(Robert Abate), entityTypeReq = 13, FC SP9 staged DB. This user has includeAll "user group" results in ~30000 rows.
            SET @dynamicSQLStr = 'INSERT INTO #getNonIdaObjects_TempTable (entityType, entityID)'
                                    + CHAR(10)
                                    + SUBSTRING
                                        (
                                            (
                                                SELECT 'UNION'
                                                    + CHAR(10)
                                                    + 'SELECT Tbl.childEntityType, Tbl.childId '
                                                    + CHAR(10)
                                                    + 'FROM ('
                                                    + CHAR(10)
                                                    + CAST(associationQuery AS VARCHAR(MAX))
                                                    + CHAR(10)
                                                    + ')Tbl'
                                                    + CHAR(10)
                                                    + CASE WHEN EXISTS (SELECT TOP 1 entityType FROM #getNonIdaObjects_TempTable WHERE entityType = PE.parentEntityType AND includeALl = 1) THEN ' '
                                                           ELSE ' INNER JOIN #getNonIdaObjects_TempTable Sec
                                                                    ON Sec.entityType = Tbl.parentEntityType AND (Sec.entityId = Tbl.parentId)'
                                                      END
                                                    + CHAR(10)
                                                FROM App_EntityParentAssociation PE
                                                WHERE
                                                    childEntityType = @entityTypeReq
                                                FOR XML PATH (''), TYPE
                                            ).value('.','NVARCHAR(MAX)'),               -- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
                                            6,              -- Exclude the first UNION
                                            2147483647      -- MAX
                                        )
                EXEC (@dynamicSQLStr)
                -- Requirement (MR 233017): When any user gets associated with any rights on a plan, he should be able to View the alerts associated to it.
                -- If we handle this in with Parent Child Association approach, all permissions from plan (Edit, Delete) also will inherit to alerts -> this should not happen.
                -- If we add an entry into Security Associations table for each association done on the plan, it is too much bookmarking and maintanence issues.
                -- So manually handling this in all the necessary stored procs. Specifically this code is written only if permission Id = 0(just for Viewing).
IF @entityTypeReq = 64 AND @permissionId = 0
                BEGIN
                    INSERT INTO #getNonIdaObjects_TempTable (entityType, entityID)
SELECT DISTINCT 64, SIDS._ID
                        FROM UMSecurityAssociations Sec(NOLOCK)
                            INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
                                ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
                            INNER JOIN App_PlanProp PP (NOLOCK)
ON Sec.entityType1 = 158 AND Sec.entityId1 = PP.componentNameId
AND PP.attrName = 'Alert' AND PP.modified = 0
                            CROSS APPLY dbo.splitIds(PP.attrVal) SIDS                       -- Alerts are stored as comma separated list in plan properties table.
                END
    END
	DECLARE @companyIdOfUser INT = 0
	SET @companyIdOfUser = dbo.AppGetCompanyForUserOrUserGroup(@userId, 1)
IF OBJECT_ID('tempdb.dbo.#validCompaniesOfCompanyUser') IS NOT NULL
    DROP TABLE #validCompaniesOfCompanyUser
CREATE TABLE #validCompaniesOfCompanyUser
    (
        companyId INT NOT NULL
        primary key (companyId)
    )
DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
IF @doNotUseCompanyEntitiesTableForFiltering = 1
BEGIN
	SET @companyIdOfUser = 0
END
IF @companyIdOfUser <> 0
BEGIN
    declare @parentCompanyId int = @companyIdOfUser
        ;with parentCompany as
        (
            select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            union all
            select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select childCompanyId
        from parentCompany
    declare @childCompanyId int = @companyIdOfUser
        ;with childCompany as
        (
            select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
            union all
            select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select parentCompanyId
        from childCompany
    INSERT INTO #validCompaniesOfCompanyUser values (@companyIdOfUser) , (0)   -- Company Id 0 For MSP entities
END
    IF @tableOutput <> ''           -- Let's push into output table at the last.
    BEGIN
        SET @dynamicSQLStr = 'INSERT INTO '+ @tableOutput
        --if all association is set get from APP_ENtity and quit, else return whatever we have in temp table
        IF (@allAssociations = 1) AND (@idColName <> '') AND (@tableName <> '') AND @whereClause <> ''
        BEGIN
			IF @companyIdOfUser <> 0
			BEGIN
				IF PATINDEX('%flags%', @whereClause) <> 0 AND PATINDEX('%.flags%', @whereClause) = 0
				BEGIN
					-- Sometimes whereclause has columns such flags which may be ambiguous with the table it is joining to, so better add table table in clause.
					SET @whereClause = REPLACE(@whereClause, 'flags', @tableName + '.' + 'flags')
				END
				-- Filter the entities belonging to valid companies.
				-- Analysis: Filtering these records by doing join on App_CompanyEntities table has better
				-- results than inserting these records in a temp table and then filtering out invalid entities to get
				-- valid results then eventually inserting into output table.
				SET @dynamicSQLStr += ' SELECT '+ @idColName +' FROM '+ @tableName +
										' LEFT JOIN App_CompanyEntities App
											ON App.entityType = ' +  CAST (@entityTypeReq AS VARCHAR(10)) + ' AND App.entityId = ' + @idColName +
											' LEFT JOIN #validCompaniesOfCompanyUser C
											ON App.companyId = C.companyId' +
										' WHERE (App.entityId is NULL Or C.companyId = App.companyId) AND '+ @whereClause
			END
			ELSE
			BEGIN
				SET @dynamicSQLStr += ' SELECT '+ @idColName +' FROM '+ @tableName +' WHERE '+ @whereClause
			END
			EXEC (@dynamicSQLStr)
        END
        ELSE
        BEGIN
			IF @companyIdOfUser <> 0
			BEGIN
				-- Filter the entities belonging to valid companies.
				-- Analysis: Filtering these records by doing join on App_CompanyEntities table has better
				-- results than inserting these records in a temp table and then filtering out invalid entities to get
				-- valid results then eventually inserting into output table. Also this has better results than
				-- performing join on App_CompanyEntities table everytime records are inserted in #getNonIdaObjects_TempTable table.
               	 		SET @dynamicSQLStr += ' SELECT DISTINCT objectTable.entityId FROM #getNonIdaObjects_TempTable objectTable
						LEFT JOIN App_CompanyEntities App
						On App.entityType = objectTable.entityType AND App.entityId = objectTable.entityId
						LEFT JOIN #validCompaniesOfCompanyUser validCompany
						ON App.companyId = validCompany.companyId
						WHERE (App.entityId is NULL Or App.companyId = validCompany.companyId) AND objectTable.entityType = ' + CAST (@entityTypeReq AS VARCHAR(10))
			END
			ELSE
			BEGIN
                		SET @dynamicSQLStr += ' SELECT DISTINCT entityId FROM #getNonIdaObjects_TempTable WHERE entityType = ' + CAST (@entityTypeReq AS VARCHAR(10))
			END
            EXEC (@dynamicSQLStr)
        END
    END
    DROP TABLE #getMemberUserGroupsHelperOutputTbl
    DROP TABLE #getNonIdaObjects_tempRolesAndPermissions
    DROP TABLE #getNonIdaObjects_TempTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserOld')
	delete from GxQscripts where name = 'sec_getNonIdaObjectsForThisUserOld'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNonIdaObjectsForThisUserOld')
	delete from GXDBVersions where aliasname = 'sec_getNonIdaObjectsForThisUserOld'
GO

insert into GXDBVersions values(2, 'sec_getNonIdaObjectsForThisUserOld',  '00000000000000000000', 'sec_getNonIdaObjectsForThisUserOld', '00000000000000000000')
GO

