

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getNameServersForThisUserWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getNameServersForThisUserWrapper()
--  |
--  | Description:  Fetches a list of name servers this callerId can see / edit
--	|
--  |
--  |       Input:  callerId, forModification
--	|
--	|		forModification if set to 1, only those name servers whom the caller can edit will be fetched
--  |		forModification if set to 0, all the name servers whom the caller is associated will be fetched
--	|
--  |      Output:  List of name servers
--  |      Return:  xxx
--  |
--  |		THINGS TO DO FURTHER: Handling of restricted view enabled users
--  |
--  |   Author
--  |   ---------
--	|	saggarwal & jswaminathan
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getNameServersForThisUserWrapper <<<'

IF EXISTS (select * from sysobjects where name='sec_getNameServersForThisUserWrapper')
	drop procedure sec_getNameServersForThisUserWrapper
IF EXISTS (select * from GxQscripts where name='sec_getNameServersForThisUserWrapper')
	delete from GxQscripts where name = 'sec_getNameServersForThisUserWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNameServersForThisUserWrapper')
	delete from GXDBVersions where aliasname = 'sec_getNameServersForThisUserWrapper'
GO
print '... Creating Procedure: sec_getNameServersForThisUserWrapper'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getNameServersForThisUserWrapper
  @callerId INT, 
  @forModification INT = 0,
  @forViewUserOrGroupInAD INT=0
AS
  DECLARE @nameServersId INTEGER
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#sec_getNameServersForThisUserWrapperTbl') IS NOT NULL
	DROP TABLE #sec_getNameServersForThisUserWrapperTbl
CREATE TABLE #sec_getNameServersForThisUserWrapperTbl
(
	nameServersId INT
)
EXEC sec_getNameServersForThisUser '#sec_getNameServersForThisUserWrapperTbl',@callerId,@forModification,@forViewUserOrGroupInAD
SELECT nameServersId FROM #sec_getNameServersForThisUserWrapperTbl
IF OBJECT_ID('tempdb.dbo.#sec_getNameServersForThisUserWrapperTbl') IS NOT NULL
	DROP TABLE #sec_getNameServersForThisUserWrapperTbl
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getNameServersForThisUserWrapper')
	delete from GxQscripts where name = 'sec_getNameServersForThisUserWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNameServersForThisUserWrapper')
	delete from GXDBVersions where aliasname = 'sec_getNameServersForThisUserWrapper'
GO

insert into GXDBVersions values(2, 'sec_getNameServersForThisUserWrapper',  '00000000000000000000', 'sec_getNameServersForThisUserWrapper', '00000000000000000000')
GO

