

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getNameServersForThisUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_getNameServersForThisUser()
--  |
--  | Description:  Fetches a list of name servers this callerId can see / edit
--	|
--  |
--  |       Input:  callerId, forModification
--	|				forModification=0 ( only to view AD server)
--	|				for modification=1 ( to modify AD server)
--	|				for viewUSer=2  ( to view users and user group in AD server)
--	|		forModification if set to 1, only those name servers whom the caller can edit will be fetched
--  |		forModification if set to 0, all the name servers whom the caller is associated will be fetched
--	|
--  |      Output:  List of name servers
--  |      Return:  xxx
--  |
--  |		THINGS TO DO FURTHER: Handling of restricted view enabled users
--  |
--  |   Author
--  |   ---------
--	|	saggarwal & jswaminathan
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getNameServersForThisUser')
BEGIN
	print '>>> Drop Stored Procedure: sec_getNameServersForThisUser <<<'
	drop procedure sec_getNameServersForThisUser
END
IF EXISTS (select * from GxQscripts where name='sec_getNameServersForThisUser')
	delete from GxQscripts where name = 'sec_getNameServersForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNameServersForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getNameServersForThisUser'
GO
print '... Creating Procedure: sec_getNameServersForThisUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getNameServersForThisUser
  @tableOutput NVARCHAR(MAX),
  @callerId INT, 
  @forModification INT,
  @forViewUserOrGroupInAD INT=0
AS
IF @callerId = 0
	return
DECLARE @entityType AS INT
SET @entityType = 61				--CvEntities::EntityType_PROVIDER_ENTITY(61)
--Few questions need to check out :
--1. How to handle resticted users
--2. If my user is part of a name server, but has no association to it, can he see it ?
IF OBJECT_ID('tempdb.dbo.#getNameServersForThisUserTable') IS NOT NULL
	DROP TABLE #getNameServersForThisUserTable
CREATE TABLE #getNameServersForThisUserTable
(
	nameServersId INT
)
IF @forModification = 0				--get all associated name servers
	EXEC sec_getNonIdaObjectsForThisUser @callerId, @entityType, 0, '#getNameServersForThisUserTable'
ELSE								--get all associated name servers with permission - add / edit / delete name servers
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NOT NULL
		DROP TABLE #getNonIdaObjects_InputPermissionsTbl
	CREATE TABLE #getNonIdaObjects_InputPermissionsTbl
	(
		permissionId INT
	)
	INSERT INTO #getNonIdaObjects_InputPermissionsTbl
VALUES (250),(251)
	EXEC sec_getNonIdaObjectsForThisUser @callerId, @entityType, -1, '#getNameServersForThisUserTable'		-- Get those domains on which user has at least one permission. It is for list loading. When deleting / editing they are checking for specific permission.
END
-- If the request is only view, then user can see
-- 1. name server of which he is part of
-- 2. All name servers whose children he can see (Like if he can see a AD user, then he can see the AD domain too though he does not have explicit rights directly on it.)
IF @forModification = 0 AND @forViewUserOrGroupInAD=0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_OutputTablee') IS NOT NULL
		DROP TABLE #getNonIdaObjects_OutputTable
	CREATE TABLE #getNonIdaObjects_OutputTable
	(
		entityId INT
	)
	-- Get all users who he has direct rights on, and get their providers
SET @entityType = 13				-- CvEntities::EntityType_USER_ENTITY (13)
	EXEC sec_getNonIdaObjectsForThisUser @userId = @callerID,
										@entityTypeReq = @entityType,
										@permissionId = 0,
										@tableOutput = '#getNonIdaObjects_OutputTable',			-- We need to pass this table name as parameter to the SP. This is needed as part of removing unnecessary temp table usage in get non ida objects SP.
										@honorParentAssociations = 0					-- We can get only direct associations. If it is coming from parents like nameserver / commcell it is already included in the previous call.
	INSERT INTO #getNameServersForThisUserTable
		SELECT U.umdsProviderId
		FROM UMUsers U
			 INNER JOIN #getNonIdaObjects_OutputTable Sec
				ON U.id = Sec.entityId
		WHERE
			U.umdsProviderId <> 0
	TRUNCATE TABLE #getNonIdaObjects_OutputTable
	-- Get all user groups who he has direct rights on, and get their providers
SET @entityType = 15				-- CvEntities::EntityType_USER_GROUP_ENTITY (15)
	EXEC sec_getNonIdaObjectsForThisUser @userId = @callerID,
										@entityTypeReq = @entityType,
										@permissionId = 0,
										@tableOutput = '#getNonIdaObjects_OutputTable',
										@honorParentAssociations = 0				-- We can get only direct associations. If it is coming from parents like nameserver / commcell it is already included in the previous call.
	INSERT INTO #getNameServersForThisUserTable
		SELECT G.umdsProviderId
		FROM UMGroups G
			 INNER JOIN #getNonIdaObjects_OutputTable Sec
				ON G.id = Sec.entityId
		WHERE
			G.umdsProviderId <> 0
		UNION
		SELECT G.umdsProviderId										-- Local groups contain AD groups. So get providers of those AD groups too.
		FROM UMGroups G
			INNER JOIN UMDSGroupMaps GM
				ON G.id = GM.umdsGroupId
			INNER JOIN #getNonIdaObjects_OutputTable Sec
				ON GM.umgroupId = Sec.entityId
		UNION
		SELECT U.umdsProviderId									-- Local groups contain AD users. So get providers of those AD users too.
		FROM UMUserGroup UG
			INNER JOIN #getNonIdaObjects_OutputTable Sec
				ON UG.groupId = Sec.entityId
			INNER JOIN UMGroups G
				ON UG.groupId = G.id
				AND G.umdsProviderID = 0
			INNER JOIN UMUsers U
				ON U.id = UG.userID
		WHERE
			U.umdsProviderId <> 0
	-- Get name server to which callerId belongs to.
END
IF @forViewUserOrGroupInAD=0 OR  NOT EXISTS (SELECT 1 FROM GxGlobalParam (NOLOCK) WHERE name = 'CanSeePeerNameServerMembers' AND value = '0' AND modified = 0)
	BEGIN
	INSERT INTO #getNameServersForThisUserTable
		SELECT umdsProviderID
		FROM UMUsers
		WHERE
			id = @callerId
			AND umdsProviderID <> 0
		UNION
		SELECT ownerCompany from UMDSProviders Prov JOIN UMUSers U ON umdsproviderId=Prov.id and U.id=@callerId and ownerCompany<>0
END
DECLARE @outputstatement NVARCHAR(MAX)
SET @outputstatement = 'INSERT INTO ' + @tableoutput +
					   ' SELECT DISTINCT nameServersId FROM #getNameServersForThisUserTable'
EXEC (@outputstatement)
IF OBJECT_ID('tempdb.dbo.#getNameServersForThisUserTable') IS NOT NULL
	DROP TABLE #getNameServersForThisUserTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getNameServersForThisUser')
	delete from GxQscripts where name = 'sec_getNameServersForThisUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNameServersForThisUser')
	delete from GXDBVersions where aliasname = 'sec_getNameServersForThisUser'
GO

insert into GXDBVersions values(2, 'sec_getNameServersForThisUser',  '00000000000000000000', 'sec_getNameServersForThisUser', '00000000000000000000')
GO

