

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getNameServerDetails.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_getNameServerDetails()
--  | Description:  Takes domainName as input and return domain list along with baseDN as output. ORder by is important here.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getNameServerDetails.sp,v $ $Id: sec_getNameServerDetails.sp,v 1.1.2.2 2019/07/24 13:17:22 saggarwal Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getNameServerDetails')
BEGIN
	print '>>> Drop Stored Procedure: sec_getNameServerDetails <<<'
	drop procedure sec_getNameServerDetails
END
IF EXISTS (select * from GxQscripts where name='sec_getNameServerDetails')
	delete from GxQscripts where name = 'sec_getNameServerDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNameServerDetails')
	delete from GXDBVersions where aliasname = 'sec_getNameServerDetails'
GO
print '... Creating Procedure: sec_getNameServerDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getNameServerDetails
  @i_domainName VARCHAR(1024),
  @i_providerId INT =0
AS
  DECLARE @providerId INT
  DECLARE @FQDN NVARCHAR(1024)
  DECLARE @login NVARCHAR(1024)
  DECLARE @password NVARCHAR(1024)
  DECLARE @serviceType INT
  DECLARE @useSecureLdap int
  DECLARE @port int
  DECLARE @baseDN NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
if(@i_providerId=0)
BEGIN
	SELECT UMDSProviders.id,CASE WHEN   dnsRootStatus =1  THEN  dnsRoot ELSE  hostNAme END,
		   login,password,serviceType,useSecureLdap,port, ISNULL(attributeString,'') as baseDN
	FROM UMDSProviders
	LEFT OUTER JOIN UMDSProviderProp ON  serviceType=14 and attrNAme = 'Dynamic Provider Type'  and componentNameId=UMDSProviders.id and UMDSProviderProp.modified=0
	LEFT OUTER JOIN UMProviderTypeAttributeMap ON attrVal=providerTypeId and attributeId=10 and attributeString<>'baseDN'
	WHERE domainName=@i_domainName and enabled<>0
	order by baseDN desc
END
ELSE
BEGIN
	SELECT UMDSProviders.id,CASE WHEN   dnsRootStatus =1  THEN  dnsRoot ELSE  hostNAme END,
		   login,password,serviceType,useSecureLdap,port, ISNULL(attributeString,'') as baseDN
	FROM UMDSProviders
	LEFT OUTER JOIN UMDSProviderProp ON  serviceType=14 and attrNAme = 'Dynamic Provider Type' and componentNameId=UMDSProviders.id and UMDSProviderProp.modified=0
	LEFT OUTER JOIN UMProviderTypeAttributeMap ON attrVal=providerTypeId and attributeId=10 and attributeString<>'baseDN'
	WHERE UMDSProviders.id=@i_providerId and enabled<>0
	order by baseDN desc
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'sec_getNameServerDetails')
	delete from GxQscripts where name = 'sec_getNameServerDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getNameServerDetails')
	delete from GXDBVersions where aliasname = 'sec_getNameServerDetails'
GO

insert into GXDBVersions values(2, 'sec_getNameServerDetails',  '00010001000200020000', 'sec_getNameServerDetails', '00010001000200020000')
GO

