

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getMyDataApplications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getMyDataApplications')
BEGIN
	print '>>> Drop Stored Procedure: sec_getMyDataApplications <<<'
	drop procedure sec_getMyDataApplications
END
IF EXISTS (select * from GxQscripts where name='sec_getMyDataApplications')
	delete from GxQscripts where name = 'sec_getMyDataApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMyDataApplications')
	delete from GXDBVersions where aliasname = 'sec_getMyDataApplications'
GO
print '... Creating Procedure: sec_getMyDataApplications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getMyDataApplications
  @userId INTEGER,
  @myDataApplications XML OUTPUT,
  @CvFeaturesList bigint=-1,
  @CloudCapabilities int=-1,
  @cvFeatureCapabilities int=-1
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isVMExist BIT=0;
DECLARE @isDriveExist BIT;
DECLARE @sharePointExist BIT=0;
DECLARE @oneDriveExist BIT=0;
DECLARE @mailExist BIT=0;
DECLARE @computerExist BIT=0;
DECLARE @sharesExist BIT;
DECLARE @isSyncAllowed BIT=0;
DECLARE @isCustomPropertyEnabled BIT;
DECLARE @isDeleteClientAuthWorkflowEnabled BIT=0;
DECLARE @out_xml XML
DECLARE @GUID VARCHAR(255)
DECLARE @userMailBoxXML XML
DECLARE @userDelegatedMailBoxXML XML
DECLARE @clientCount INT
DECLARE @syncCount INT=0
DECLARE @excludeStatusMaskForSync INT = (cast(0x00002 AS INT) | cast(0x00004 AS INT) | cast(0x00010 AS INT) | cast(0x00020 AS INT))
DECLARE @edgeClientsWithCapabilities TABLE (
	clientId INT
	,clientStatus INT
	,capabilities BIGINT
	,userAssociationType INT
	)
DECLARE @clientId INT
DECLARE @t_userCaps TABLE (caps BIGINT)
DECLARE @i_userCaps BIGINT
DECLARE @mailboxExists INT=0
DECLARE @capUploadBrowse bigint= ( CONVERT(BIGINT,POWER(2.0, 5 -1)) | CONVERT(BIGINT,POWER(2.0, 13 -1)) );
DECLARE	@SYNCREQUEST INT = 16
DECLARE	@SYNC_HIDECAPABILITY			INT = 7
DECLARE @COLLABORATIVESHARE_DISABLE_CAPABILITY	INT = 14	-- 14th bit on CvFeatureList in GxGlobalParam is being used to disable Collaborative share button.
DECLARE @CVLEGALAPP_SHOW_CAPABILITY		INT = 15			-- 15th bit on CvFeatureList in GxGlobalParam is being used to show CVLEGAL app in web console.
DECLARE @COLLABORATIVESHARE_HIDE_CAPABILITY	INT = 14		-- If this is set do not show request collaborative share button in shares page
CREATE TABLE #clientList (
	cId INT PRIMARY KEY
	,STATUS INT NOT NULL
	)
DECLARE @allowLaptopClassicSecurity int = 0
SELECT @allowLaptopClassicSecurity=value FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = N'AllowLaptopClassicSecurity' AND value = '1'
IF ( @allowLaptopClassicSecurity = 1)
BEGIN
	SELECT TOP 1 @isVMExist  = 1
FROM #tempAppGetApplicationSecurityObjects um
       INNER JOIN App_ClientProp prop ON
            (prop.componentNameId = um.clientId
		OR
				(
um.commCellId=2 AND um.clientGroupId=0 AND um.clientId=0 AND um.appTypeId=0 AND um.instanceId=0 AND um.backupsetId=0 AND um.subClientId=0 AND um.mediaAgentId=0 AND um.libraryId=0 AND um.archGroupId=0 AND um.vtContainerId=0 AND um.vtPolicyId=0 AND um.vtShelfId=0 AND um.reviewSetId=0 AND um.querySetId=0 AND um.downloadSetId=0 AND um.ermId=0 AND um.legalHoldId=0 AND um.tagId=0 AND um.cdPolicyId=0 AND um.complianceReportId=0 AND um.taskId=0 AND um.workflowId=0 AND um.logMonitoringPolicyId=0 AND um.arrayId=0 AND um.cloudId=0 AND um.userGroupId=0 AND um.providerId=0 AND um.entityId1=0 AND um.entityId2=0 AND um.entityId3=0 AND um.entityId4=0 AND um.entityId5=0									AND um.entityId6=0 AND um.entityId7=0 AND um.entityId8=0 AND um.entityId9=0
				))
              AND prop.attrName = N'Virtual Server Discovered Clients'
              AND prop.modified = 0
              AND prop.attrVal = '1'
       INNER JOIN APP_ClientProp prop2 ON
			prop.componentNameId=prop2.componentNameId
			AND prop2.attrName='Last Backup JobID' AND prop2.modified=0
END
IF(@isVMExist  = 0)
BEGIN
	SELECT TOP 1 @isVMExist  = 1
	FROM UMOwnerCredentials um
       INNER JOIN App_ClientProp prop ON
              prop.componentNameId = um.clientId
              AND prop.attrName = N'Virtual Server Discovered Clients'
              AND prop.modified = 0
              AND prop.attrVal = '1'
        INNER JOIN APP_ClientProp prop2 ON
			prop.componentNameId=prop2.componentNameId
			AND prop2.attrName='Last Backup JobID' AND prop2.modified=0
	WHERE um.userId = @userId
END
IF EXISTS (
		SELECT TOP 1 AAP.id
		FROM APP_BackupSetProp ABP
		INNER JOIN App_Application AAP ON ABP.componentNameId = AAP.backupset
		WHERE 1 = 1
			AND ABP.attrName = 'Edge Drive User Id'
			AND ABP.attrVal = CAST(@userId AS NVARCHAR(256))
			AND ABP.modified = 0
		)
BEGIN
	SET @isDriveExist = 1
END
ELSE
BEGIN
	INSERT INTO @edgeClientsWithCapabilities
	EXEC AppGetEdgeCapabilties @userId
		,NULL
	SET @clientId = ISNULL((
				SELECT TOP 1 EC.clientId
				FROM @edgeClientsWithCapabilities EC
				INNER JOIN App_EdgeDriveAssociation EDA ON EDA.clientId = EC.clientId
					AND EDA.entityType = 3
					AND EDA.entityId > 1
				WHERE capabilities & @capUploadBrowse = @capUploadBrowse -- Client with upload and browse capability
					--AND (@clientToUse = 0 OR EC.clientId = @clientToUse)
ORDER BY (EC.clientStatus & 0x40000000) DESC, EC.userAssociationType DESC
				), 0)
	IF (@clientId > 0)
	BEGIN
		SET @isDriveExist = 1
	END
	ELSE
		SET @isDriveExist = 0
END
IF EXISTS (SELECT TOP 1 1 FROM APP_IDAName i INNER join GetAppTypesForAppGroup(55,0) A on i.appTypeId = A.appTypeId)
BEGIN
IF EXISTS (SELECT TOP 1 1
				FROM APP_Client C
				INNER JOIN APP_IDAName i
				ON i.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(55,0)) AND c.id = i.clientId
INNER JOIN #tempAppGetApplicationSecurityObjects sec ON
				(sec.clientId=c.id)
				 OR
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
					 AND releaseId>15)
	SET @sharePointExist=1
END
IF EXISTS (SELECT TOP 1 1 FROM APP_IDAName i INNER join GetAppTypesForAppGroup(135,0) A on i.appTypeId = A.appTypeId)
BEGIN
IF EXISTS (SELECT TOP 1 1 FROM APP_Client C
					INNER JOIN APP_IDAName i
					ON c.id in  ( SELECT DISTINCT APP.clientId FROM APP_Application APP
									INNER JOIN APP_ClientProp CL on APP.clientId = CL.componentNameId
									INNER JOIN APP_InstanceProp INST on APP.instance = INST.componentNameId
									WHERE CL.attrName = 'Office 365 Pseudo Client' and CL.attrVal = 1  and INST.attrName = 'Cloud Apps Instance Type' and INST.attrVal = 7
									and CL.modified = 0 and INST.modified = 0)
				    AND c.id = i.clientId
INNER JOIN #tempAppGetApplicationSecurityObjects sec ON
				(sec.clientId=c.id)
				 OR
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
					 AND releaseId>15)
	SET @oneDriveExist=1
END
IF ( @allowLaptopClassicSecurity = 1)
BEGIN
IF EXISTS (SELECT TOP 1 1
				FROM APP_Client C
				INNER JOIN APP_IDAName i
				ON (i.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0))) AND c.id = i.clientId
INNER JOIN #tempAppGetApplicationSecurityObjects sec ON
				(sec.clientId=c.id)
				 OR
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
					)
				INSERT INTO #clientList (cId ,STATUS)
				SELECT DISTINCT c.id, c.status
				FROM APP_Client C
				INNER JOIN APP_IDAName i
				ON (i.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0))) AND c.id = i.clientId
				INNER JOIN #tempAppGetApplicationSecurityObjects sec ON
				(sec.clientId=c.id)
				 OR
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
	SET @computerExist = 1
END
IF(@computerExist = 0)
BEGIN
	INSERT INTO #clientList (cId ,STATUS)
	SELECT DISTINCT um.clientId,C.STATUS
	FROM UMOwnerCredentials um
	JOIN APP_IDAName ida ON ida.clientId = um.clientId
	AND (
		 ida.appTypeId IN (
			SELECT appTypeId
			FROM GetAppTypesForAppGroup(35, 0)
			)
		AND ida.appTypeId <> 13
		)
	JOIN APP_Client C ON C.id = um.clientId
	WHERE um.userId = @userId
	SET @clientCount= @@ROWCOUNT
	IF(@clientCount > 0)
	BEGIN
		SET @computerExist = 1
	END
	ELSE
	BEGIN
		DECLARE @o_userHasInstallCapability INT
		EXECUTE sec_userHasCapability @userId, 0, @o_userHasInstallCapability OUTPUT, 0, 1, '65' -- Install client permission
		IF (@o_userHasInstallCapability = 1)
		BEGIN
			SET @computerExist = 1
		END
		ELSE
			SET @computerExist = 0
	END
END
IF (@CvFeaturesList & POWER(2, @SYNCREQUEST - 1) <> 0)
			AND (@CloudCapabilities & POWER(2, @SYNC_HIDECAPABILITY - 1) <> POWER(2, @SYNC_HIDECAPABILITY - 1))
BEGIN
	SELECT @syncCount = count(*) FROM #clientList WHERE (status & 4096 = 4096) AND (status & @excludeStatusMaskForSync = 0)
	IF (@syncCount > 1)
	BEGIN
		SET @isSyncAllowed = 1
	END
END
SELECT @GUID = userGuid
FROM UMUsers
WHERE id = @userId
EXEC [dbo].LaptopMailboxExists @GUID
	,@userid
	,@mailboxExists OUTPUT
SET @mailExist = @mailboxExists
-- CHECK IF CUSTOM PROPERTIES APP IS ENABLED
IF ((@cvFeatureCapabilities & POWER(2, @CVLEGALAPP_SHOW_CAPABILITY - 1) = POWER(2, @CVLEGALAPP_SHOW_CAPABILITY - 1))
				AND EXISTS(SELECT 1 from GXGlobalParam WHERE name = 'CvLegalAppShareId'))
	BEGIN
		CREATE TABLE #propertyList (propertyId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @userId, 166, 31, '#propertyList'
		IF ((SELECT COUNT(1) FROM #propertyList) > 0)
			SET @isCustomPropertyEnabled = 1
		DROP TABLE #propertyList
	END
-- CHECK IF SHARES APP IS ENABLED
IF ((@CvFeaturesList & POWER(2, @COLLABORATIVESHARE_DISABLE_CAPABILITY - 1) <> POWER(2, @COLLABORATIVESHARE_DISABLE_CAPABILITY - 1))
	AND (@cvFeatureCapabilities & POWER(2, @COLLABORATIVESHARE_HIDE_CAPABILITY - 1) <> POWER(2, @COLLABORATIVESHARE_HIDE_CAPABILITY - 1))
	AND EXISTS(select TOP 1 1 from WF_Deploy WD WITH(NOLOCK)
			JOIN WF_Definition WF WITH(NOLOCK) ON WF.WorkflowId = WD.WorkflowId
			WHERE Name = 'Create Collaborative Shares'))
	SET @sharesExist = 1
ELSE
BEGIN
	EXEC AppSharingDoesUserHaveSharedFolder @userId, @sharesExist OUTPUT
END
IF EXISTS (
			SELECT TOP 1 1 FROM WF_Definition wf
			INNER JOIN WF_Deploy deploy ON wf.WorkflowId = deploy.WorkflowId
			WHERE wf.Name = 'DeleteClientAuthorization' AND wf.flags & 0x01 = 0 --0x01 = DISABLE
			)
BEGIN
	SET @isDeleteClientAuthWorkflowEnabled = 1
END
SET @out_xml = (
		SELECT @isVMExist AS '@IsVMEnabled'
			,@isDriveExist AS '@IsDriveEnabled'
			,@sharePointExist AS '@IsSharePointEnabled'
			,@oneDriveExist AS '@IsOneDriveEnabled'
			,@mailExist AS '@IsEmailEnabled'
			,@computerExist AS '@IsComputersEnabled'
			,@sharesExist AS '@IsSharesEnabled'
			,@isSyncAllowed AS '@IsSyncAllowed'
			,@isCustomPropertyEnabled AS '@IsCustomPropertyEnabled'
			,@isDeleteClientAuthWorkflowEnabled AS '@IsDeleteClientAuthWorkflowEnabled'
		FOR XML PATH('myDataApplications')
		)
SELECT @myDataApplications = @out_xml


IF EXISTS (select * from GxQscripts where name = 'sec_getMyDataApplications')
	delete from GxQscripts where name = 'sec_getMyDataApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMyDataApplications')
	delete from GXDBVersions where aliasname = 'sec_getMyDataApplications'
GO

insert into GXDBVersions values(2, 'sec_getMyDataApplications',  '00000000000000000000', 'sec_getMyDataApplications', '00000000000000000000')
GO

