

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getMemberUserGroupsHelper.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_getMemberUserGroupsHelper.sp"
--	|	Description: Fetches list of user groups that user is member of. Gets in isUser, userORGroupId format to be used internally by Sec SPs.
--	|	Author: jswaminathan
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getMemberUserGroupsHelper <<<'

IF EXISTS (select * from sysobjects where name='sec_getMemberUserGroupsHelper')
	drop procedure sec_getMemberUserGroupsHelper
IF EXISTS (select * from GxQscripts where name='sec_getMemberUserGroupsHelper')
	delete from GxQscripts where name = 'sec_getMemberUserGroupsHelper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMemberUserGroupsHelper')
	delete from GXDBVersions where aliasname = 'sec_getMemberUserGroupsHelper'
GO
print '... Creating Procedure: sec_getMemberUserGroupsHelper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getMemberUserGroupsHelper
--Inputs
  @userId INT
AS
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- Caller should mandatorily pass output table. Else raise exception.
	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NULL
	BEGIN
		RAISERROR('Error. Output table for sec_getMemberUserGroupsHelper not yet created',
				16,
				1
				 )
		RETURN
	END
	-- #userGroupId Table should be passed externally.
	INSERT INTO #getMemberUserGroupsHelperOutputTbl
		SELECT 0, id
		FROM UMGroups G
				INNER JOIN UMUserGroup UG
				ON G.id = UG.groupId
		WHERE UG.userID = @userID AND G.groupFlags & 1 = 1					--GF_GROUP_ENABLED
		UNION
		SELECT 1, @userId
		UNION
		SELECT 0, G.id
		FROM UMGroups G
				INNER JOIN UMDSGroupMaps GM
				ON G.id = GM.umgroupId
				INNER JOIN UMUserGroup UG
				ON UG.groupId = GM.umDSgroupId
		WHERE UG.userId = @userId AND G.groupFlags & 1 = 1				--GF_GROUP_ENABLED
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getMemberUserGroupsHelper')
	delete from GxQscripts where name = 'sec_getMemberUserGroupsHelper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMemberUserGroupsHelper')
	delete from GXDBVersions where aliasname = 'sec_getMemberUserGroupsHelper'
GO

insert into GXDBVersions values(2, 'sec_getMemberUserGroupsHelper',  '00000000000000000000', 'sec_getMemberUserGroupsHelper', '00000000000000000000')
GO

