

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getMemberUserGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------
--
--	SP: sec_getMemberUserGroups
--
--	Description: Gets list of user groups for given user.
--				 #userGroupId (userGroupId) table should be passed externally.
--
--
--
--	Author:	jswaminathan
-- ------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getMemberUserGroups <<<'

IF EXISTS (select * from sysobjects where name='sec_getMemberUserGroups')
	drop procedure sec_getMemberUserGroups
IF EXISTS (select * from GxQscripts where name='sec_getMemberUserGroups')
	delete from GxQscripts where name = 'sec_getMemberUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMemberUserGroups')
	delete from GXDBVersions where aliasname = 'sec_getMemberUserGroups'
GO
print '... Creating Procedure: sec_getMemberUserGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getMemberUserGroups
  @userId INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- #userGroupId Table should be passed externally.
DECLARE @isExternalUser INT = 0
SELECT @isExternalUser = 1
FROM UMUsers
WHERE id = @userID AND umDSproviderId > 0
INSERT INTO #userGroupId
	SELECT id
	FROM UMGroups G
			INNER JOIN UMUserGroup UG
			ON G.id = UG.groupId
	WHERE UG.userID = @userID AND G.groupFlags & 1 = 1					--GF_GROUP_ENABLED
IF @isExternalUser = 1
	INSERT INTO #userGroupId
		SELECT DISTINCT G.id
		FROM UMGroups G
				INNER JOIN UMDSGroupMaps GM
				ON G.id = GM.umgroupId
				INNER JOIN UMUserGroup UG
				ON UG.groupId = GM.umDSgroupId
		WHERE UG.userId = @userId AND G.groupFlags & 1 = 1				--GF_GROUP_ENABLED
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getMemberUserGroups')
	delete from GxQscripts where name = 'sec_getMemberUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getMemberUserGroups')
	delete from GXDBVersions where aliasname = 'sec_getMemberUserGroups'
GO

insert into GXDBVersions values(2, 'sec_getMemberUserGroups',  '00000000000000000000', 'sec_getMemberUserGroups', '00000000000000000000')
GO

