

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getLoginForEmail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Imtiaz Mohammad
--	Date:   07/20/2013
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   sec_getLoginForEmail.sp - Given an email, returns the number of logins with that email-id. If only 1, returns the login too.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getLoginForEmail')
BEGIN
	print '>>> Drop Stored Procedure: sec_getLoginForEmail <<<'
	drop procedure sec_getLoginForEmail
END
IF EXISTS (select * from GxQscripts where name='sec_getLoginForEmail')
	delete from GxQscripts where name = 'sec_getLoginForEmail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLoginForEmail')
	delete from GXDBVersions where aliasname = 'sec_getLoginForEmail'
GO
print '... Creating Procedure: sec_getLoginForEmail'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getLoginForEmail
  @i_email nvarchar(255) = ''
AS
  DECLARE @o_n integer;
  DECLARE @o_usrLogin nvarchar(255);
  DECLARE @o_usrId integer;
  DECLARE @o_isOrganizationUser integer;
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET ANSI_NULLS ON
	SET NOCOUNT ON
	DECLARE @providerId INT = 0
	DECLARE @serviceType INT = 0
	SET @o_usrLogin = ''
	SET @o_usrId = 0
SET @o_n = (SELECT COUNT(*) FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%' and flags & 0x8000 = 0 )
	set @o_isOrganizationUser = 0
	IF (@o_n = 1)
	BEGIN
		declare @umdsProviderID int = 0
SELECT @o_usrLogin = ISNULL(login, ''), @o_usrId = ISNULL(id, 0), @umdsProviderID = ISNULL(umdsProviderID, 0) FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%' and flags & 0x8000 = 0
		if @umdsProviderID > 0
select @o_isOrganizationUser = case when serviceType = 5 then 1 else 0 end
			from umdsproviders
			where id = @umdsProviderID
	END
	else if (exists( select id from UMUsers where login = @i_email and flags <> 0 ) and @o_n = 0)
	begin
		--New addition for supporting Email as a proper username.
		--We now allow an Email, say 'abc@commvault.com' to exist either as username or as an email for distinct user, not both
		--At this juncture, we know that there is no active user with email as one provided in the input. We will now check for username as the input email.
		 select @o_usrId = ISNULL(id, 0), @o_usrLogin = ISNULL(login, '') , @o_n = (case when id is null then 0 else 1 end)
		 from 	UMUsers where login = @i_email and flags <> 0
	end
	else if(exists( select U.id from UMUsers U join UMDSProviders P
						on U.umDSproviderId = P.id
						where U.login like Concat('%\', @i_email)
							and U.flags <> 0
							AND (P.serviceType = 5 OR P.serviceType = 2)
							AND P.enabled= 1 ) and @o_n = 0)
	begin
		select @o_usrId = ISNULL(U.id, 0), @o_usrLogin = ISNULL(U.login, '') , @o_n = (case when U.id is null then 0 else 1 end) from UMUsers U join UMDSProviders P
						on U.umDSproviderId = P.id
						where U.login like Concat('%\', @i_email)
							and U.flags <> 0
							AND (P.serviceType = 5 OR P.serviceType = 2)
							AND P.enabled= 1
		--select @o_usrId = ISNULL(id, 0), @o_usrLogin = ISNULL(login, '') , @o_n = (case when id is null then 0 else 1 end)
		-- from 	UMUsers where login = @i_email and flags <> 0
	end
		else if ( EXISTS( SELECT GUID FROM APP_GUID WHERE NAME = @i_email AND STATUS = 64 ) AND  @o_n = 0)
	begin
		declare @guid nvarchar(1024)
		select @guid = guid from APP_GUID WHERE name = @i_email and status = 64 --CV_APPGUID_STATUSBIT_LN_INETADDRESS
		select @o_usrLogin=name from APP_GUID where guid = @guid and status = 1 --CV_APPGUID_STATUSBIT_DISPLAYNAME
		Select @o_usrId = id from UMUsers where name = @guid
		SET @o_n = (case when @guid is null then 0 else 1 end )
	end
	--if 2 users have same email id and if they are linked together, send back details of cloud user
	IF (@o_n=2)
	BEGIN
	    DECLARE @localUserId INT = 0
		DECLARE @cloudUserId INT = 0
		DECLARE @linkedcloudUserId INT = 0
SELECT @o_n = COUNT(*) FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%' and flags & 0x4000 = 0
		IF (@o_n = 1)
		BEGIN
SELECT @localUserId=id, @providerId=umDSProviderId FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%' and flags & 0x4000 = 0x4000
SELECT @cloudUserId=id FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%' and flags & 0x4000 = 0
			IF @providerId > 0
				SELECT @serviceType = serviceType FROM UMDSProviders WITH (NOLOCK) WHERE id = @providerId
			--verify if they are linked
			--if linked, send local user details if local user is an external user, else send cloud user details
IF EXISTS (SELECT 1 FROM UMUsersProp WITH (NOLOCK) WHERE componentNameId = @localUserId AND attrName = 'Linked CommvaultId' AND attrVal = cast(@cloudUserId as nvarchar(10)))
			BEGIN
IF @serviceType = 0 OR @serviceType =  5 --organization user
SELECT @o_usrLogin = ISNULL(login, ''), @o_usrId = ISNULL(id, 0), @umdsProviderID = ISNULL(umdsProviderID, 0) FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%' and flags & 0X010 <> 0
				ELSE
SELECT @o_usrLogin = ISNULL(login, ''), @o_usrId = ISNULL(id, 0), @umdsProviderID = ISNULL(umdsProviderID, 0) FROM UMUsers WITH (NOLOCK) WHERE email = @i_email and login not like '%Deleted,%' and flags & 0x4000 <> 0
			END
			ELSE
					SET @o_n=2  --users are not linked, so set o_n=2 which gives multiple users error
		END
	END
	SELECT @o_n, @o_usrLogin,@o_usrId, @o_isOrganizationUser
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getLoginForEmail')
	delete from GxQscripts where name = 'sec_getLoginForEmail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLoginForEmail')
	delete from GXDBVersions where aliasname = 'sec_getLoginForEmail'
GO

insert into GXDBVersions values(2, 'sec_getLoginForEmail',  '00000000000000000000', 'sec_getLoginForEmail', '00000000000000000000')
GO

