

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getLibraryForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getLibraryForUser.sp,v $ $Id: sec_getLibraryForUser.sp,v 1.2.36.3 2020/01/07 05:44:20 prasanthm Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getLibraryForUser')
BEGIN
	print '>>> Drop Stored Procedure: sec_getLibraryForUser <<<'
	drop procedure sec_getLibraryForUser
END
IF EXISTS (select * from GxQscripts where name='sec_getLibraryForUser')
	delete from GxQscripts where name = 'sec_getLibraryForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLibraryForUser')
	delete from GXDBVersions where aliasname = 'sec_getLibraryForUser'
GO
print '... Creating Procedure: sec_getLibraryForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getLibraryForUser
  @i_userId integer = 0
AS
  DECLARE @LibraryId integer
  DECLARE @Capabilities bigint
----------------------------------------------
--------------- Security Check ---------------
----------------------------------------------
DECLARE @userId	INTEGER = @i_userId
DECLARE @secObjTypeLib	INTEGER = 2049		-- 2049
DECLARE @secObjTypeMA	INTEGER = 2048	-- 2048
DECLARE @secObjCapLibMgr		BIGINT = power(2, 8-1)
DECLARE @secObjCapLibAdmin	BIGINT = power(2, 11-1)
DECLARE @secObjCapMAMgr		BIGINT = power(2, 10-1)
DECLARE @csCapabilities bigint = 0
DECLARE @tblLibrary table (LibraryId int, capabilities bigint)
IF object_id('tempdb.dbo.#tblSecObj_Lib') is not null DROP TABLE #tblSecObj_Lib
IF object_id('tempdb.dbo.#tblSecObj_MA') is not null DROP TABLE #tblSecObj_MA
create table  #tblSecObj_Lib ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #tblSecObj_MA ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, @secObjTypeLib, 0, '#tblSecObj_Lib'
--Only care about visibility, no capability check is needed here!
IF EXISTS (SELECT * FROM #tblSecObj_Lib sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
BEGIN
	-- User group associated with CS
SELECT @csCapabilities = capabilities FROM #tblSecObj_Lib sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
END
-- Get all libraries associated specifically to user group
INSERT INTO @tblLibrary SELECT LibraryId, capabilities from #tblSecObj_Lib WHERE LibraryId > 0
----------------------------------------------
IF EXISTS (SELECT * FROM MMConfigs WITH (NOLOCK) WHERE NAME = 'MMS2_CONFIG_CHECK_USER_MA_RIGHT' AND value = 1)
BEGIN
	EXEC sec_getUserObjects @userId, @secObjTypeMA, 0, '#tblSecObj_MA'
	--Must be able to manage media agent
	DELETE FROM #tblSecObj_MA WHERE (capabilities & @secObjCapMAMgr) = 0
IF EXISTS (SELECT * FROM #tblSecObj_MA sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	BEGIN
		-- User group associated with CS
SELECT @csCapabilities = (capabilities | @csCapabilities | @secObjCapLibMgr | @secObjCapLibAdmin) FROM #tblSecObj_MA sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	END
	ELSE
	BEGIN
		-- Get libraries associated through media agents
		INSERT INTO @tblLibrary
		SELECT DISTINCT A.LibraryId, 0
		FROM MMLibraryController A with (nolock), #tblSecObj_MA B
		WHERE A.ClientId = B.MediaAgentId
		AND A.LibraryId NOT IN (SELECT LibraryId FROM @tblLibrary)
		-- Update Capabilities for libraries assoicated directly
		UPDATE A
		SET A.capabilities = CASE WHEN A.capabilities > 0 THEN A.capabilities | @secObjCapLibMgr | @secObjCapLibAdmin
								ELSE A.capabilities | C.capabilities | @secObjCapLibMgr | @secObjCapLibAdmin
								END
		FROM @tblLibrary A, MMLibraryController B with (nolock), #tblSecObj_MA C
		WHERE A.LibraryId = B.LibraryId
		AND B.ClientId = C.MediaAgentId
	END
END
IF @csCapabilities > 0
BEGIN
	-- Update capabilities for ALL libraries
	UPDATE @tblLibrary
	SET capabilities = capabilities | @csCapabilities
	INSERT INTO @tblLibrary
	SELECT LibraryId, @csCapabilities
	FROM MMLibrary WITH (NOLOCK)
	WHERE LibraryId > 0
	AND LibraryId NOT IN (SELECT LibraryId FROM @tblLibrary)
END
IF object_id('tempdb.dbo.#tblSecObj_Lib') is not null DROP TABLE #tblSecObj_Lib
IF object_id('tempdb.dbo.#tblSecObj_MA') is not null DROP TABLE #tblSecObj_MA
SELECT * FROM @tblLibrary
ORDER BY LibraryId
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getLibraryForUser')
	delete from GxQscripts where name = 'sec_getLibraryForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLibraryForUser')
	delete from GXDBVersions where aliasname = 'sec_getLibraryForUser'
GO

insert into GXDBVersions values(2, 'sec_getLibraryForUser',  '00010002003600030000', 'sec_getLibraryForUser', '00010002003600030000')
GO

