

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getLaptopUsersForAdminDLO.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_getUsers"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getLaptopUsersForAdminDLO')
BEGIN
	print '>>> Drop Stored Procedure: sec_getLaptopUsersForAdminDLO <<<'
	drop procedure sec_getLaptopUsersForAdminDLO
END
IF EXISTS (select * from GxQscripts where name='sec_getLaptopUsersForAdminDLO')
	delete from GxQscripts where name = 'sec_getLaptopUsersForAdminDLO'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLaptopUsersForAdminDLO')
	delete from GXDBVersions where aliasname = 'sec_getLaptopUsersForAdminDLO'
GO
print '... Creating Procedure: sec_getLaptopUsersForAdminDLO'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getLaptopUsersForAdminDLO
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isDLOApp int = 1
DECLARE @getlatopUsers int = 1
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_xmlText XML
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N''
DECLARE @canGetUser INT = 0
DECLARE @level int = 30
DECLARE @allEntity int = 0
DECLARE @userId int = 0
DECLARE @callerId int = 0
DECLARE @localeId int = 0
DECLARE @forModification int = 0
DECLARE @providerId int = 0
DECLARE @userGroupId int = 0
DECLARE @i_startRowNum INT = 0
DECLARE @i_endRowNum INT = 0
DECLARE @i_limit INT = 0
DECLARE @totalUsers int = 0
DECLARE @searchStr nvarchar(50) = ''
DECLARE @planId INT = 0
DECLARE @LockedAttemptsLimit INT = 0
DECLARE @LockDuration INT = 0
DECLARE @currentTimeUnix INT = 0
IF OBJECT_ID('tempdb.dbo.#userList') IS NOT NULL
	DROP TABLE #userList
CREATE TABLE #userList
(
	userId INT PRIMARY KEY
);
SET @localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
                        FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/processinginstructioninfo/locale') R(ref)), 0)
SET @callerId = ISNULL (( SELECT ref.value('@userId', 'INT')
						FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/processinginstructioninfo/user') R(ref)), 0)
SET @providerId = ISNULL (( SELECT ref.value('@providerId', 'INT')
						FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/parent') R(ref)), 0)
SET @userGroupId = ISNULL (( SELECT ref.value('@userGroupId', 'INT')
						FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/parent') R(ref)), 0)
SET @userGroupId = ISNULL (( SELECT ref.value('@groupId', 'INT')
						FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/parent') R(ref)), @userGroupId)
SET @planId = ISNULL (( SELECT ref.value('@planId', 'INT')
						FROM @xmlText.nodes ('/App_GetUserPropertiesRequest/plan') R(ref)), @planId)
SET @i_startRowNum = ISNULL (( SELECT ref.value('@offset', 'INT')
                    FROM  @xmlText.nodes ('App_GetUserPropertiesRequest/pageConfig') R(ref)), 0)
 SET @i_limit = ISNULL (( SELECT ref.value('@limit', 'INT')
                    FROM  @xmlText.nodes ('App_GetUserPropertiesRequest/pageConfig') R(ref)), 0)
SET @LockedAttemptsLimit = ISNULL(( SELECT CAST(VALUE as int)
								FROM GXGlobalParam where name = 'FailedLoginAttemptLimit' and ISNUMERIC(value) = 1), 0)
SET @LockDuration = ISNULL(( SELECT CAST(VALUE as int)
								FROM GXGlobalParam where name = 'AccountLockDuration' and ISNUMERIC(value) = 1), 0)
SET @currentTimeUnix = ISNULL(dbo.GetUnixTime(GetUTCdate()), 0)
INSERT INTO #userList
SELECT ref.value('@userId', 'INT')
FROM @xmlText.nodes ('App_GetUserPropertiesRequest/users') R(ref)
IF @i_limit <> 0
BEGIN
    SET @i_startRowNum = @i_startRowNum + 1 -- This is done as GUI doesnt want to send 1 as the start :)
    SET @i_endRowNum = @i_startRowNum + @i_limit
END
-- Sort options
DECLARE @sortField VARCHAR(MAX) = ISNULL (( SELECT ref.value('@sortField', 'VARCHAR(MAX)')
                                            FROM  @xmlText.nodes ('App_GetUserPropertiesRequest/pageConfig') R(ref)), 'Id')
DECLARE @sortDirection INT = ISNULL (( SELECT ref.value('@sortDirection', 'INT')
                                            FROM  @xmlText.nodes ('App_GetUserPropertiesRequest/pageConfig') R(ref)), 2)
-- To get around nested case statements for dynamic order by clause.
IF @sortDirection = 1
    SET @sortField = @sortField + 'DESC'
-- Honor these sort tables only if sent in request.
DECLARE @isSortFieldSpecified BIT = 1
IF @xmlText.exist('App_GetUserPropertiesRequest/pageConfig') = 0
	SET @isSortFieldSpecified = 0
IF NOT EXISTS (SELECT 1 FROM UMUsers (NOLOCK) where id = @callerId)
BEGIN
	--generate error resp
	SET @errorCode = -1
	SET @errorString = 'Invalid Caller'
	SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('response'), ROOT('App_GenericResponse'))
	GOTO PROC_EXIT
END
SET @forModification = ISNULL (( SELECT ref.value('@forModification', 'INT')
						FROM @xmlText.nodes ('App_GetUserPropertiesRequest') R(ref)), 0)
SET @userId = ISNULL(@xmlText.value('(/App_GetUserPropertiesRequest/user/@userId)[1]', 'int'), 0)
SET @searchStr = ISNULL (( SELECT ref.value('@filter', 'NVARCHAR(50)')
						FROM @xmlText.nodes ('App_GetUserPropertiesRequest') R(ref)), '') --This is used to search for users. Use this filter on user name, login and email
DECLARE @userName NVARCHAR(MAX)
IF NOT EXISTS(SELECT 1 FROM #userList)
BEGIN
	IF @userId IS NULL OR @userId <= 0
	BEGIN
		SET @userName = @xmlText.value('(/App_GetUserPropertiesRequest/user/@userName)[1]', 'NVARCHAR(MAX)')
		IF @userName IS NOT NULL
		BEGIN
			SET @userId = ISNULL((SELECT id FROM UMUsers where login = @userName), 0)
		IF 	@userId <= 0
			BEGIN
				--generate error resp
				SET @errorCode = -1
				SET @errorString = 'Invalid userName'
				SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
								FOR XML PATH('response'), ROOT('App_GenericResponse'))
				GOTO PROC_EXIT
			END
		END
	END
	IF @userId IS NULL
		SET @userId = 0
	IF  @userId IS NULL OR	@userId = 0
		SET @allEntity = 1
END
ELSE
BEGIN
	-- Delete invalid users
	DELETE inputList
	FROM #userList inputList
	LEFT JOIN UMUsers U
	ON inputList.userId = u.id
WHERE u.id IS NULL OR (u.flags & (0x001 )<=0 )
END
SET @level = ISNULL(@xmlText.value('(/App_GetUserPropertiesRequest/@level)[1]', 'int'), 30)
-- Table to hold records before sorting
-- This table holds all the properties needed at level 1 and 10.
IF OBJECT_ID('tempdb.dbo.#UsersTemp') IS NOT NULL
	DROP TABLE #UsersTemp
CREATE TABLE #UsersTemp
(
	userId int primary key,		-- This will be used for sorting as per pageConfig property as well. Though this is marked as primary key, the sort order will be dictated by Users table::id column.
    name nvarchar(255),			-- This will be used for sorting as per pageConfig property as well.
    login nvarchar(255),		-- This will be used for sorting as per pageConfig property as well.
    email nvarchar(255),		-- This will be used for sorting as per pageConfig property as well.
    umdsProviderId int,
    enabled INT,				-- This will be used for sorting as per pageConfig property as well.
	userGuid VARCHAR(128),
	description NVARCHAR(MAX),
	lastLoginTime INT DEFAULT 0,
	companyName VARCHAR(MAX) DEFAULT '',
	isAccountLocked int DEFAULT 0,
	lockStartTime int DEFAULT 0,
	lockEndTime int DEFAULT 0,
	isLaptopUser INT DEFAULT 0
);
-- This table will hold the user Ids in the sorted format as specified by pageConfig property.
IF OBJECT_ID('tempdb.dbo.#Users') IS NOT NULL
	DROP TABLE #Users
CREATE TABLE #Users
(
	id int primary key,
	userId int
)
IF OBJECT_ID('tempdb.dbo.#UsersSec_getUsersNewTbl')  IS NOT NULL
	DROP TABLE #UsersSec_getUsersNewTbl
CREATE TABLE  #UsersSec_getUsersNewTbl  ( userId int primary key);
-- This table will be used only at level > 10.
 if OBJECT_ID('tempdb.dbo.#UsersProperties') is not null drop table #UsersProperties
      CREATE TABLE #UsersProperties  (
        id int DEFAULT 0,
		name nvarchar(255) DEFAULT '',
		userGuid nvarchar(256),
		login nvarchar(255),
		description [nvarchar](max) DEFAULT '',
		email [nvarchar](255) DEFAULT '',
		enableUser int DEFAULT 0,
		lastLogInTime int DEFAULT 0,
        companyName varchar(max) DEFAULT '',
		enforceFSQuota int DEFAULT 0 ,
		quotaLimitInGB bigint DEFAULT 0,
		inheritGroupQuotaSettings int DEFAULT 0,
		agePasswordDays int DEFAULT 0,
		associatedUserGroupsXML XML DEFAULT '',
		securityAssociations XML DEFAULT '',
		associatedExternalUserGroupsXML XML DEFAULT '',
		userSecurityXML XML DEFAULT '',
		additionalSettingsXML XML DEFAULT '',
		commvaultId nvarchar(255),
		enforceEdgeDriveQuota int DEFAULT 0 ,
		edgeDriveQuotaLimitInGB bigint DEFAULT 0,
		inheritGroupEdgeDriveQuotaSettings int DEFAULT 0,
		apiQuotaLimit int DEFAULT 0,
		apiQuotaTimeFrame int DEFAULT 0,
		isAccountLocked int DEFAULT 0,
		lockStartTime int DEFAULT 0,
		lockEndTime int DEFAULT 0
    )
	IF OBJECT_ID('tempdb.dbo.#LaptopUsers') is not null drop table #LaptopUsers
		CREATE TABLE #LaptopUsers(
			userId INT
		)
DECLARE @includeUsersFlags int = -1;
DECLARE @excludeUsersFlags int = 0;
SET @includeUsersFlags = ( CAST (0x001 AS INT) )
SET @excludeUsersFlags = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
IF @allEntity <> 1  AND NOT EXISTS (SELECT id FROM UMUsers where id = @userId AND (flags & (0x001 )>0 ) ) AND NOT EXISTS(SELECT 1 FROM #userList)
BEGIN
	--generate error resp
SET @errorCode = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('response'), ROOT('App_GenericResponse'))
	GOTO PROC_EXIT
END
IF @allEntity=1 OR EXISTS(SELECT 1 FROM #userList)
BEGIN
	DECLARE @flag INT = ISNULL(@xmlText.value('(/App_GetUserPropertiesRequest/@flag)[1]', 'INT'), 0)		-- By default get all.
	EXEC sec_getUsersForThisUser '#UsersSec_getUsersNewTbl', @callerId, @forModification, @flag				-- No need to pass exclude / include flags here. It is already filtered in the Security SP.
	IF EXISTS(SELECT 1 FROM #userList)
	BEGIN
		DELETE sec
		FROM #UsersSec_getUsersNewTbl sec
		LEFT JOIN #userList inputuser
		ON sec.userId = inputuser.userId
		WHERE inputuser.userId IS NULL
	END
END
ELSE
BEGIN
	DECLARE @isallowed INT = 0
	IF(@callerId =  @userId) -- user can see himself
		SET @isallowed = 1
	ELSE
	BEGIN -- check permission on userId
		DECLARE @permissionId INT
		IF(@forModification = 0)
			SET @permissionId = 0			-- Any permission is fine. He can see user.
		ELSE
SET @permissionId =  101
EXEC sec_checkPermissionOnEntity @callerId,@permissionId ,@isallowed output,13,@userId
	END
	IF(@isallowed = 1)
		INSERT #UsersSec_getUsersNewTbl VALUES (@userId)
END
DECLARE @providerTable table (id int)
--filter is set for provider id
IF(@providerId <> 0)
BEGIN
	INSERT INTO @providerTable
	SELECT @providerId
		-- build the CTE
			;WITH tblChild AS
		(
			SELECT id
				FROM UMDSProviders WHERE ownerCompany = @providerId
			UNION ALL
			SELECT UMDSProviders.id FROM UMDSProviders  JOIN tblChild  ON UMDSProviders.ownerCompany = tblChild.Id
		)
		INSERT INTO @providerTable SELECT id FROM tblChild --union select @providerId
		OPTION(MAXRECURSION 32767)
END
IF @allEntity<>1
BEGIN
	IF NOT EXISTS(SELECT 1 FROM #userList)
	BEGIN
		INSERT INTO #userList
		VALUES(@userId)
	END
END
INSERT INTO #LaptopUsers
SELECT DISTINCT UMO.userOrGroupId 'userid'
FROM UMOwners UMO
INNER JOIN App_client C ON UMO.entityId = C.id AND C.status & 4096 = 4096 AND UMO.isUser <> 0
INNER JOIN #UsersSec_getUsersNewTbl secUser ON UMO.userOrGroupId = secUser.userId
WHERE entityType = 3
UNION
SELECT DISTINCT UG.userId 'userid'
FROM UMOwners UM
INNER JOIN UMUserGroup UG ON UM.userOrGroupId = UG.groupId
INNER JOIN App_client C ON UM.entityId = C.id AND C.status & 4096 = 4096 AND UM.isUser = 0
INNER JOIN #UsersSec_getUsersNewTbl secUser ON UG.userId = secUser.userId
WHERE entityType = 3
UNION
SELECT DISTINCT UG.userId 'userid'
FROM UMOwners UM
INNER JOIN UMDSGroupMaps UGM ON UM.userOrGroupId = UGM.umgroupId
INNER JOIN UMDSUserGroup UG ON UGM.umDSgroupId = UG.groupId
INNER JOIN App_client C ON UM.entityId = C.id AND C.status & 4096 = 4096 AND UM.isUser = 0
INNER JOIN #UsersSec_getUsersNewTbl secUser ON UG.userId = secUser.userId
WHERE entityType = 3
IF @allEntity<>1 --@getlatopUsers is ignored. when you want to get properties of any user, user id will be provided.
BEGIN
	IF NOT EXISTS (SELECT 1 FROM #UsersSec_getUsersNewTbl sec INNER JOIN #userList req ON sec.userId = req.userId)
	BEGIN
			--generate error resp
SET @errorCode = (3288 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3288 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorString'
							FOR XML PATH('response'), ROOT('App_GenericResponse'))
			GOTO PROC_EXIT
	END
	INSERT INTO #UsersTemp (userId, name, login, email, umdsProviderId, enabled, userGUID, description, lastLoginTime, companyName, isAccountLocked, lockStartTime, lockEndTime, isLaptopUser)
		SELECT U.id, name, login, email, umDSproviderId, enabled, userGuid, description, lastLogInTime, UP.attrVal,
				CASE WHEN UP2.attrVal IS NOT NULL THEN 1 ELSE 0 END, ISNULL(UP2.modified, 0), ISNULL((@LockDuration + UP2.modified), 0),
				CASE WHEN laptopUser.userId is NOT NULL THEN 1 else 0 END
		FROM UMUsers U
			INNER JOIN #userList req ON U.id = req.userId
			LEFT JOIN UMUsersProp UP
				ON U.id = UP.componentNameId AND UP.attrName = 'Company Name' AND UP.modified = 0
			LEFT JOIN UMUsersProp UP2
ON U.id = UP2.componentNameId AND UP2.attrName = 'Failed login attempts' AND UP2.cs_attrName = CHECKSUM(N'Failed login attempts') AND ISNUMERIC(UP2.attrVal) = 1 AND UP2.attrVal > 0 AND UP2.attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - UP2.modified < @LockDuration
			LEFT JOIN #LaptopUsers laptopUser
				ON U.id = laptopUser.userId
		WHERE
			(@providerId = 0 OR umdsProviderID in (select id from @providerTable))
END
ELSE IF @allEntity = 1
BEGIN
		if(@getlatopUsers=1)
		BEGIN
			INSERT INTO #UsersTemp (userId, name, login, email, umdsProviderId, enabled, userGUID, description, lastLoginTime, companyName, isAccountLocked, lockStartTime, lockEndTime, isLaptopUser)
			SELECT 	U.id,
				U.name,
				U.login,
				U.email,
				u.umDSproviderId,
				u.enabled,
				u.userGuid,
				u.description,
				u.lastLogInTime,
				up.attrVal,
				CASE WHEN UP2.attrVal IS NOT NULL THEN 1 ELSE 0 END,
				ISNULL(UP2.modified, 0),
				ISNULL((@LockDuration + UP2.modified), 0),
				1
			FROM UMUsers U
			INNER JOIN #LaptopUsers lapTopUser ON U.id=lapTopUser.userId
			LEFT JOIN UMUsersProp UP
				ON U.id = UP.componentNameId AND UP.attrName = 'Company Name' AND UP.modified = 0
			LEFT JOIN UMUsersProp UP2
			-- Do not add check for modified=0 here as the modified value itself needs to be shown
ON U.id = UP2.componentNameId AND UP2.attrName = 'Failed login attempts' AND UP2.cs_attrName = CHECKSUM(N'Failed login attempts') AND ISNUMERIC(UP2.attrVal) = 1 AND UP2.attrVal > 0 AND UP2.attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - UP2.modified < @LockDuration
			INNER JOIN #UsersSec_getUsersNewTbl Sec
				ON U.id = Sec.userId
			WHERE
				(@providerId = 0 OR umdsProviderID  in (select id from @providerTable))
				AND (@userGroupId = 0 OR u.id in (SELECT userid FROM UMUserGroup WHERE groupId=@userGroupId))
				AND (@searchStr='' OR (name like ('%' + @searchStr + '%') OR email like ('%' + @searchStr + '%') OR login like ('%' + @searchStr  + '%')))
		END
		ELSE
		BEGIN
			INSERT INTO #UsersTemp (userId, name, login, email, umdsProviderId, enabled, userGUID, description, lastLoginTime, companyName, isAccountLocked, lockStartTime, lockEndTime, isLaptopUser)
				SELECT 	U.id,
					U.name,
					U.login,
					U.email,
					u.umDSproviderId,
					u.enabled,
					U.userGUId,
					U.description,
					U.lastloginTime,
					UP.attrVal,
					CASE WHEN UP2.attrVal IS NOT NULL THEN 1 ELSE 0 END,
					ISNULL(UP2.modified, 0),
					ISNULL((@LockDuration + UP2.modified), 0),
					CASE WHEN laptopUser.userId is NOT NULL THEN 1 else 0 END
				FROM UMUsers U
					INNER JOIN #UsersSec_getUsersNewTbl sec
						ON U.id = sec.userId
					LEFT JOIN UMUsersProp UP
						ON U.id = UP.componentNameId AND UP.attrName = 'Company Name' AND UP.modified = 0
					LEFT JOIN UMUsersProp UP2
					-- Do not add check for modified=0 here as the modified value itself needs to be shown
ON U.id = UP2.componentNameId AND UP2.attrName = 'Failed login attempts' AND UP2.cs_attrName = CHECKSUM(N'Failed login attempts') AND ISNUMERIC(UP2.attrVal) = 1 AND UP2.attrVal > 0 AND UP2.attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - UP2.modified < @LockDuration
					LEFT JOIN #LaptopUsers laptopUser
						ON U.id = laptopUser.userId
				WHERE
					(@providerId = 0 OR umdsProviderID  in (select id from @providerTable))
					AND (@userGroupId = 0 OR u.id in (SELECT userid FROM UMUserGroup WHERE groupId=@userGroupId))
					AND (@searchStr='' OR (name like ('%' + @searchStr + '%') OR email like ('%' + @searchStr + '%') OR login like ('%' + @searchStr  + '%')))
		END
END
 if OBJECT_ID('tempdb.dbo.#UsersAdminDLOProperties') is not null drop table #UsersAdminDLOProperties
CREATE TABLE  #UsersAdminDLOProperties  (
userId int primary key,
spaceConsumed bigint default 0,
numDevices int default 0,
profileId int ,
profileName nvarchar(255),
planId int,
planName nvarchar(255),
serviceType int default 0,
DomainId int,
domainName nvarchar(255),
inviteSent int,
inviteTime int,
companyId int,
companyName nvarchar(4000) );
IF(@isDLOApp=1 AND @level >= 10)
BEGIN
		INSERT INTO #UsersAdminDLOProperties (userid, numDevices)
		SELECT U.userid,
			(SELECT COUNT(clientid)
			FROM dbo.sec_getClientOwnersExpandUG o
				INNER JOIN app_client  WITH(NOLOCK) on APP_Client.id=o.clientId and status & 0x1000 = 0x1000
				WHERE o.userid = U.userId)
		FROM	#UsersTemp U
		--plan
		--check for user level first
		UPDATE #UsersAdminDLOProperties set planId = p.id, planName = p.name
		FROM #UsersAdminDLOProperties
INNER JOIN UMUsersProp prop  WITH (NOLOCK) on prop.componentNameId =  #UsersAdminDLOProperties.userId AND attrName ='Associated Plan' AND prop.modified = 0 AND prop.cs_attrName = CHECKSUM(N'Associated Plan')
		INNER JOIN App_Plan p  WITH (NOLOCK) on p.id= attrVal  AND p.modified = 0 AND (@planId = 0 OR p.id = @planId )
		--if plan is not set at the user level, check for group level
		UPDATE #UsersAdminDLOProperties set planId = p.id, planName = p.name
		FROM #UsersAdminDLOProperties
		INNER join UMUserGroup ug on ug.userId=#UsersAdminDLOProperties.userId
INNER JOIN UMGroupsProp prop  WITH (NOLOCK) on prop.componentNameId =  ug.groupId AND attrName ='Associated Plan' AND prop.modified = 0  AND prop.cs_attrName = CHECKSUM(N'Associated Plan')
		INNER JOIN App_Plan p  WITH (NOLOCK) on p.id= attrVal  AND p.modified = 0 AND (@planId = 0 OR p.id = @planId )
LEFT OUTER JOIN UMUsersProp UUP  WITH (NOLOCK) on UUP.componentNameId =  ug.userId AND UUP.attrName ='Associated Plan' AND UUP.modified = 0 AND UUP.cs_attrName = CHECKSUM(N'Associated Plan')
		WHERE #UsersAdminDLOProperties.planId is null AND UUP.id IS NULL
		--Domain
		update #UsersAdminDLOProperties set DomainId = p.id, domainName = p.domainName, serviceType=p.serviceType
		from #UsersAdminDLOProperties
		INNER JOIN #UsersTemp u  on u.userId =  #UsersAdminDLOProperties.userId  AND u.umdsProviderId >0
		INNER JOIN UMDSProviders p  WITH (NOLOCK) on p.Id= u.umdsProviderId
		--invite
		UPDATE #UsersAdminDLOProperties set inviteSent = prop.attrVal, inviteTime=prop.created
		FROM #UsersAdminDLOProperties
		INNER JOIN UMUsersProp prop  WITH (NOLOCK) on prop.componentNameId =  #UsersAdminDLOProperties.userId AND attrName ='Invitation sent' AND prop.modified = 0 AND prop.cs_attrName = CHECKSUM(N'Invitation sent')
		--Response is framed using #UsersTemp table so make sure it also having the users with the given plan id only
		IF(@planId > 0)
		BEGIN
			DELETE FROM #UsersAdminDLOProperties WHERE planId IS NULL
			DELETE FROM #UsersTemp WHERE userId not in (select userId from #UsersAdminDLOProperties)
		END
		--company
		UPDATE #UsersAdminDLOProperties set companyId = p.id, companyName = p.hostName
		FROM #UsersAdminDLOProperties
		INNER JOIN #UsersTemp u  on u.userId =  #UsersAdminDLOProperties.userId  AND u.umdsProviderId >0
INNER JOIN UMDSProviders p  WITH (NOLOCK) on p.Id= u.umdsProviderId and  P.serviceType = 5
		UPDATE #UsersAdminDLOProperties set companyId = p1.id, companyName = p1.hostName
		FROM #UsersAdminDLOProperties
		INNER JOIN #UsersTemp u  ON u.userId =  #UsersAdminDLOProperties.userId  AND u.umdsProviderId >0
INNER JOIN UMDSProviders p  WITH (NOLOCK) ON p.Id= u.umdsProviderId AND  P.serviceType in (2,12) AND p.ownerCompany > 0
		INNER JOIN UMDSProviders p1 ON p.ownerCompany = p1.id
END
IF @allEntity = 1
BEGIN
	SET @totalUsers = ISNULL((SELECT count(1) from #UsersTemp),0)--Now populate this as the users are filter out by plan id by now.
END
--Sort the rows here
IF (@isSortFieldSpecified = 1) OR (@level NOT IN (1,10))		-- Do not frame this table, if sort field is not specified. We need to frame this when level > 10 though, as it is subsequently used in the code.
BEGIN
	INSERT INTO #Users
		SELECT 	ROW_NUMBER() OVER (ORDER BY
                                    CASE @sortField WHEN 'login' THEN login END,
                                    CASE @sortField WHEN 'loginDESC' THEN login END DESC,
                                    CASE @sortField WHEN 'name' THEN name END,
                                    CASE @sortField WHEN 'nameDESC' THEN name END DESC,
                                    CASE @sortField WHEN 'email' THEN email END,
                                    CASE @sortField WHEN 'emailDESC' THEN email END DESC,
                                    CASE @sortField WHEN 'planName' THEN planName END,
                                    CASE @sortField WHEN 'planNameDESC' THEN planName END DESC,
                                    CASE @sortField WHEN 'DomainName' THEN DomainName END,
                                    CASE @sortField WHEN 'DomainNameDESC' THEN DomainName END DESC,
									CASE @sortField WHEN 'enabled' THEN enabled END,
                                    CASE @sortField WHEN 'enabledDESC' THEN enabled END DESC,
									CASE @sortField WHEN 'laptopCount' THEN numDevices END,
                                    CASE @sortField WHEN 'laptopCountDESC' THEN numDevices END DESC,
									CASE @sortField WHEN 'locked' THEN isAccountLocked END,
                                    CASE @sortField WHEN 'lockedDESC' THEN isAccountLocked END DESC,
									CASE @sortField WHEN 'companyName' THEN d.companyName END,
                                    CASE @sortField WHEN 'companyNameDESC' THEN d.companyName END DESC),
				U.userid
			FROM #UsersTemp U
			LEFT OUTER JOIN #UsersAdminDLOProperties d
			ON u.userid = d.userid
		IF (@i_startRowNUM >= 0 AND @i_endRowNum >0)
        BEGIN
            DELETE #Users
            WHERE (id < @i_startRowNUM OR id >= @i_endRowNum)
        END
END
IF OBJECT_ID('tempdb.dbo.#UserSecurityAssocTbl') IS NOT NULL
	DROP TABLE #UserSecurityAssocTbl
CREATE TABLE #UserSecurityAssocTbl
(
	userId int primary key,
	securityAssocXML XML,				-- Security done from user level on other entities. (User properties -> Associations tab)
	userSecurityXML XML					-- Security done on the user entity as such. (Righy click user -> Security tab)
)
IF @level NOT IN (1,10)			-- For 1 and 10, the Users Temp table itself has all the data. No need to frame User Properties for that.
BEGIN
	IF OBJECT_ID('tempdb.dbo.#UsergroupsSec_getUsersNewTbl') IS NOT NULL
		DROP TABLE #UsergroupsSec_getUsersNewTbl
	CREATE TABLE #UsergroupsSec_getUsersNewTbl
	(
		userGroupId INT PRIMARY KEY
	)
	IF @level < 40				-- When @level < 40, we do not need associatedUserGroups, SecurityAssociations and UserSecurity.
	BEGIN
		INSERT INTO #UserSecurityAssocTbl (userId)
			SELECT userID
			FROM #users
	END
	ELSE
	BEGIN
		EXEC sec_getUserGroupsForThisUser '#UsergroupsSec_getUsersNewTbl', @callerID
		DECLARE @secAssocXML XML
		DECLARE @userSecurityXML XML
		DECLARE @userIdTemp INTEGER
		DECLARE getSecAssocCursor CURSOR FOR
			 SELECT userId
			 FROM #Users
		OPEN getSecAssocCursor
		FETCH NEXT FROM getSecAssocCursor INTO @userIdTemp
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @secAssocXML = NULL
			SET @userSecurityXML = NULL
			EXEC sec_getSecurityForUserAndUserGroup @userIdTemp, 0, @callerId, @secAssocXML OUTPUT			-- from user: SecurityAssociations
			IF @level >= 50
				EXEC sec_getsecurityforentity @callerId, @userSecurityXML OUTPUT, 13, @userIdTemp				-- on user: UserSecurity
			INSERT INTO #userSecurityAssocTbl
				VALUES (@userIdTemp, @secAssocXML, @userSecurityXML)
			FETCH NEXT FROM getSecAssocCursor INTO @userIdTemp
		END
		CLOSE getSecAssocCursor
		DEALLOCATE getSecAssocCursor
	END
	IF dbo.isExternalLocalGroupSingleList() = 0		--will remove this code once this key is made default
		insert into #UsersProperties
		SELECT u.id
										,u.name
										,u.userGuid
										,u.login
										,u.description
										,u.email
										,u.enabled
										,u.lastLogInTime
										,(SELECT TOP 1 attrVal FROM UMUsersProp WHERE componentNameId= userSec.userId  AND attrName ='Company Name' AND modified = 0 AND cs_attrName = CHECKSUM(N'Company Name'))
										,ISNULL((select attrVal from UMUsersProp  with (nolock)  where componentNameId = userSec.userId and attrName like 'Enforce quota' and modified = 0 AND cs_attrName = CHECKSUM(N'Enforce quota')), 0)
										,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName like 'Quota size' and modified = 0 AND cs_attrName = CHECKSUM(N'Quota size')), 100)
										,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName like 'UMDS user inherits quota'  and modified = 0 AND cs_attrName = CHECKSUM(N'UMDS user inherits quota')), 1)
										, policy
										, CASE WHEN @level >= 40 THEN
										(		SELECT  UMGroups.id  as '@userGroupId',
														UMGroups.name   as '@userGroupName'
												FROM UMUserGroup, UMGroups , #UsergroupsSec_getUsersNewTbl Sec
												WHERE UMUserGroup.groupId = UMGroups.id  and UMUserGroup.userId = userSec.userId and Sec.userGroupId = UMGroups.id and umdsProviderId=0
												for XML PATH('associatedUserGroups'), TYPE
											) END
										, CASE WHEN @level >= 40 THEN
												(SELECT (SELECT securityAssocXML.query('App_SecurityAssociationForUserOrGroupList/associations') FOR XML PATH(''),TYPE),
													(SELECT securityAssocXML.query('App_SecurityAssociationForUserOrGroupList/inheritedAssociations') FOR XML PATH(''),TYPE)
												FOR XML PATH ('securityAssociations'), TYPE)
											END
										, CASE WHEN @level >= 40 THEN
										(SELECT	UMGroups.id as '@groupId',
													UMGroups.name   as '@externalGroupName',
													umdsProviderId   as '@providerId',
													domainName as '@providerDomainName'
												FROM UMUserGroup, UMGroups , UMDSProviders   , #UsergroupsSec_getUsersNewTbl Sec
												WHERE UMUserGroup.groupId = UMGroups.id  and UMUserGroup.userId = userSec.userId and Sec.userGroupId = UMGroups.id and umdsProviderId<>0 and  UMgroups.umdsProviderId=UMDSProviders.id
												for XML PATH('associatedExternalUserGroups'), TYPE
											) END
										,CASE WHEN @level >= 50 THEN (SELECT userSecurityXML AS 'userSecurity' FOR XML PATH (''), TYPE) END,
										(SELECT
																		CR.keyName as '@keyName',
																		CR.type as '@type',
																		(CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
																		CR.relativepath as '@relativepath',
																		--CR.deleted as '@deleted',
																		CR.enabled as '@enabled',
																		ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
																		NULL as '@isInheritedFromClientGroup',
																		(SELECT
																		CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
																		CASE CR.sourceEntityType WHEN 15 THEN CR.sourceId ELSE NULL END AS '@userGroupId',
													CASE CR.sourceEntityType WHEN 15 THEN (SELECT name FROM UMGroups WITH(NOLOCK) WHERE id = CR.sourceId) ELSE NULL END AS '@userGroupName',
													CASE CR.sourceEntityType WHEN 61 THEN CR.sourceId ELSE NULL END AS '@providerId',
													CASE CR.sourceEntityType WHEN 61 THEN (SELECT domainName FROM UMDSProviders WITH(NOLOCK) WHERE id = CR.sourceId) ELSE NULL END AS '@providerDomainName',
													CASE CR.sourceEntityType WHEN 189 THEN CR.sourceId ELSE NULL END AS '@companyId',
												    CASE CR.sourceEntityType WHEN 189 THEN (SELECT domainName FROM UMDSProviders WITH(NOLOCK) WHERE id = CR.sourceId) ELSE NULL END AS '@companyName'
																		FOR XML PATH('sourceEntity'),TYPE)
																		FROM APP_AdvanceSettings as CR WITH(NOLOCK)
																		LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx WITH(NOLOCK)
																		ON CR.id = AdvEx.keyId
																		WHERE CR.entityId = u.id AND CR.entityType = 13 --USER_ENTITY
																		and CR.deleted = 0
																		FOR XML PATH('additionalSettings'),TYPE)
,(SELECT email FROM UMUsers  WHERE id=(SELECT attrVal FROM UMUsersProp  WHERE componentNameId = userSec.userId and attrName = 'Linked CommvaultId'  and modified = 0 AND cs_attrName = CHECKSUM(N'Linked CommvaultId')))
,ISNULL((select attrVal from UMUsersProp  with (nolock)  where componentNameId = u.id and attrName = 'Enforce Edge Drive Quota' and modified = 0 AND cs_attrName = CHECKSUM(N'Enforce Edge Drive Quota')), 0)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = u.id and attrName = 'Edge Drive Quota Size' and modified = 0 AND cs_attrName = CHECKSUM(N'Edge Drive Quota Size')), 100)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'UMDS User Inherits Edge Drive Quota' and modified = 0 AND cs_attrName = CHECKSUM(N'UMDS User Inherits Edge Drive Quota')), 1)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'API Quota Limit' and modified = 0 AND cs_attrName = CHECKSUM(N'API Quota Limit')), 0)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'API Quota Time Frame' and modified = 0 AND cs_attrName = CHECKSUM(N'API Quota Time Frame')), 0)
,ISNULL((select 1 from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'Failed login attempts' and attrVal > 0 AND attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - modified < @LockDuration AND cs_attrName = CHECKSUM(N'Failed login attempts')), 0)
,ISNULL((select modified from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'Failed login attempts' and cs_attrName = CHECKSUM(N'Failed login attempts') and ISNUMERIC(attrVal) = 1 and attrVal > 0 AND attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - modified < @LockDuration), 0)
,ISNULL((@LockDuration + (select modified from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'Failed login attempts' and cs_attrName = CHECKSUM(N'Failed login attempts') and ISNUMERIC(attrVal) = 1 and attrVal > 0 AND attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - modified < @LockDuration)), 0)
								FROM #userSecurityAssocTbl userSec inner join umusers u ON u.id = userSec.userId
	ELSE
		insert into #UsersProperties
		SELECT u.id
										,u.name
										,u.userGuid
										,u.login
										,u.description
										,email
										,enabled
										,lastLogInTime
										,(SELECT TOP 1 attrVal FROM UMUsersProp WHERE componentNameId= u.id  AND attrName ='Company Name' AND modified = 0 AND cs_attrName = CHECKSUM(N'Company Name'))
										,ISNULL((select attrVal from UMUsersProp  with (nolock)  where componentNameId = u.id and attrName = 'Enforce quota' and modified = 0 AND cs_attrName = CHECKSUM(N'Enforce quota')), 0)
										,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = u.id and attrName = 'Quota size' and modified = 0 AND cs_attrName = CHECKSUM(N'Quota size')), 100)
										,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId =u.id and attrName = 'UMDS user inherits quota'  and modified = 0 AND cs_attrName = CHECKSUM(N'UMDS user inherits quota')), 1)
										, policy
										, CASE WHEN @level >= 40 THEN
										(		SELECT UMGroups.id AS '@userGroupId',
													CASE WHEN UMGroups.umdsProviderId <= 0 THEN UMGroups.name
													ELSE P.domainName + '\' + UMGroups.name
													END
												AS '@userGroupName'
												FROM UMUserGroup INNER JOIN UMGroups ON UMUserGroup.groupId = UMGroups.id
												INNER JOIN #UsergroupsSec_getUsersNewTbl Sec ON Sec.userGroupId = UMGroups.id
												LEFT OUTER JOIN UMDSProviders P ON P.id = UMGroups.umdsProviderID
												WHERE UMUserGroup.userId = u.id
												FOR XML PATH('associatedUserGroups'), TYPE
											) END
										, CASE WHEN @level >= 40 THEN
												(SELECT (SELECT securityAssocXML.query('App_SecurityAssociationForUserOrGroupList/associations') FOR XML PATH(''),TYPE),
													(SELECT securityAssocXML.query('App_SecurityAssociationForUserOrGroupList/inheritedAssociations') FOR XML PATH(''),TYPE)
												FOR XML PATH ('securityAssociations'), TYPE) END
										, ''
										,CASE WHEN @level >= 50 THEN (SELECT userSecurityXML AS 'userSecurity' FOR XML PATH (''), TYPE) END,
										(SELECT
																	CR.keyName as '@keyName',
																	CR.type as '@type',
																	(CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
																	CR.relativepath as '@relativepath',
																	--CR.deleted as '@deleted',
																	CR.enabled as '@enabled',
																	ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
																	NULL as '@isInheritedFromClientGroup',
																	(SELECT
																	CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
																	CASE CR.sourceEntityType WHEN 15 THEN CR.sourceId ELSE NULL END AS '@userGroupId',
																	CASE CR.sourceEntityType WHEN 61 THEN CR.sourceId ELSE NULL END AS '@providerId'
																	FOR XML PATH('sourceEntity'),TYPE)
																	FROM APP_AdvanceSettings as CR WITH(NOLOCK)
																	LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx WITH(NOLOCK)
																	ON CR.id = AdvEx.keyId
																	WHERE CR.entityId = u.id AND CR.entityType = 13 --USER_ENTITY
																	and CR.deleted = 0
																	FOR XML PATH('additionalSettings'),TYPE)
,(SELECT email FROM UMUsers WITH (NOLOCK) WHERE id=(SELECT attrVal FROM UMUsersProp  WITH (NOLOCK) WHERE componentNameId = userSec.userId and attrName = 'Linked CommvaultId'  and modified = 0 AND cs_attrName = CHECKSUM(N'Linked CommvaultId')))
,ISNULL((select attrVal from UMUsersProp  with (nolock)  where componentNameId = u.id and attrName = 'Enforce Edge Drive Quota' and modified = 0 AND cs_attrName = CHECKSUM(N'Enforce Edge Drive Quota')), 0)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId = u.id and attrName = 'Edge Drive Quota Size' and modified = 0 AND cs_attrName = CHECKSUM(N'Edge Drive Quota Size')), 100)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId =u.id and attrName = 'UMDS User Inherits Edge Drive Quota' and modified = 0 AND cs_attrName = CHECKSUM(N'UMDS User Inherits Edge Drive Quota')), 1)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId =u.id and attrName = 'API Quota Limit' and modified = 0 AND cs_attrName = CHECKSUM(N'API Quota Limit')), 0)
,ISNULL((select attrVal from UMUsersProp  with (nolock) where componentNameId =u.id and attrName = 'API Quota Time Frame' and modified = 0 AND cs_attrName = CHECKSUM(N'API Quota Time Frame')), 0)
,ISNULL((select 1 from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'Failed login attempts' and attrVal > 0 AND attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - modified < @LockDuration AND cs_attrName = CHECKSUM(N'Failed login attempts')), 0)
,ISNULL((select modified from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'Failed login attempts' and cs_attrName = CHECKSUM(N'Failed login attempts') and ISNUMERIC(attrVal) = 1 and attrVal > 0 AND attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - modified < @LockDuration), 0)
,ISNULL((@LockDuration + (select modified from UMUsersProp  with (nolock) where componentNameId = userSec.userId and attrName = 'Failed login attempts' and cs_attrName = CHECKSUM(N'Failed login attempts') and ISNUMERIC(attrVal) = 1 and attrVal > 0 AND attrVal >= @LockedAttemptsLimit AND @currentTimeUnix - modified < @LockDuration)), 0)
								FROM #userSecurityAssocTbl userSec inner join umusers u ON u.id = userSec.userId
END
DECLARE @showLockedInfo BIT = 0
SET @showLockedInfo = ISNULL((SELECT 1 FROM GXGlobalParam where name = 'AccountLockDuration'), 0)
IF @level = 1
BEGIN
	IF (@isSortFieldSpecified = 0)		-- No need to join on Users "sorted" table.
	BEGIN
		SET @o_xmlText = (SELECT @totalUsers as '@totalRecordsWithoutPaging',(SELECT	tempUMUsers.isLaptopUser as '@isLaptopUser',(SELECT tempUMUsers.userid AS '@userId', tempUMUsers.userGuid as '@userGUID', tempUMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
								FROM #UsersTemp tempUMUsers
								FOR XML PATH('users'),type)
								FOR XML PATH('App_GetUserPropertiesResponse'), type
							 )
	END
	ELSE
	BEGIN
		SET @o_xmlText = (SELECT @totalUsers as '@totalRecordsWithoutPaging',(SELECT	tempUMUsers.isLaptopUser as '@isLaptopUser',(SELECT tempUMUsers.userid AS '@userId', tempUMUsers.userGuid as '@userGUID', tempUMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
								FROM #UsersTemp tempUMUsers
									INNER JOIN #Users U
										ON tempUMUsers.userId = U.userId
								ORDER BY U.id				-- This id column already sorted the users based on the sort condition. So just get it in that order.
								FOR XML PATH('users'),type)
								FOR XML PATH('App_GetUserPropertiesResponse'), type
							 )
	END
END
ELSE IF @level = 10
BEGIN
	IF (@isSortFieldSpecified = 0)		-- No need to join on Users "sorted" table.
	BEGIN
		SET @o_xmlText = (SELECT @totalUsers as '@totalRecordsWithoutPaging',  (SELECT TempUMUsers.description AS '@description'
							,TempUMUsers.name AS '@fullName'
							,TempUMUsers.enabled AS '@enableUser'
							,TempUMUsers.email AS '@email'
							,TempUMUsers.lastLogInTime AS '@lastLogIntime'
							,TempUMUsers.companyName AS '@companyName'
							,TempUMUsers.isLaptopUser as '@isLaptopUser'
							,DLO.spaceConsumed as '@spaceConsumed'
							--account lock info
							, CASE WHEN @showLockedInfo = 1 THEN TempUMUsers.isAccountLocked END AS '@isAccountLocked'
							, CASE WHEN @showLockedInfo = 1  AND TempUMUsers.isAccountLocked = 1 THEN TempUMUsers.lockStartTime END AS '@lockStartTime'
							, CASE WHEN @showLockedInfo = 1  AND TempUMUsers.isAccountLocked = 1 THEN TempUMUsers.lockEndTime END AS '@lockEndTime'
							--number of devices
							,DLO.numDevices as '@numDevices'
							,DLO.serviceType as '@serviceType'
							--invite
							,DLO.inviteSent as '@inviteSent'
							,DLO.inviteTime as '@inviteTime'
                            --profile name profile
							,(SELECT DLO.profileId as '@profileId', DLO.profileName as '@profileName' FOR XML PATH('profile'), TYPE)
							--plan
							,(SELECT DLO.planId as '@planId', DLO.planName as '@planName' FOR XML PATH('plan'), TYPE)
							--Domain
							,(SELECT DLO.domainId as '@providerId', DLO.domainName as '@providerDomainName' FOR XML PATH('provider'), TYPE)
							,(SELECT TempUMUsers.userid AS '@userId', TempUMUsers.userGuid as '@userGUID', TempUMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
							--company
							,(SELECT DLO.companyId as '@providerId', DLO.companyName as '@providerDomainName' FOR XML PATH('company'), TYPE)
					FROM #UsersTemp TempUMUsers
						LEFT JOIN #UsersAdminDLOProperties DLO
							ON TempUMUsers.userId = DLO.userId
					FOR XML PATH('users'),type)
					FOR XML PATH('App_GetUserPropertiesResponse'), type
				 )
	END
	ELSE
	BEGIN
		SET @o_xmlText = (SELECT @totalUsers as '@totalRecordsWithoutPaging',  (SELECT TempUMUsers.description AS '@description'
							,TempUMUsers.name AS '@fullName'
							,TempUMUsers.enabled AS '@enableUser'
							,TempUMUsers.email AS '@email'
							,TempUMUsers.lastLogInTime AS '@lastLogIntime'
							,TempUMUsers.companyName AS '@companyName'
							,TempUMUsers.isLaptopUser as '@isLaptopUser'
							,DLO.spaceConsumed as '@spaceConsumed'
							--account lock info
							, CASE WHEN @showLockedInfo = 1 THEN TempUMUsers.isAccountLocked END AS '@isAccountLocked'
							, CASE WHEN @showLockedInfo = 1  AND TempUMUsers.isAccountLocked = 1 THEN TempUMUsers.lockStartTime END AS '@lockStartTime'
							, CASE WHEN @showLockedInfo = 1  AND TempUMUsers.isAccountLocked = 1 THEN TempUMUsers.lockEndTime END AS '@lockEndTime'
							--number of devices
							,DLO.numDevices as '@numDevices'
							,DLO.serviceType as '@serviceType'
							--invite
							,DLO.inviteSent as '@inviteSent'
							,DLO.inviteTime as '@inviteTime'
                            --profile name profile
							,(SELECT DLO.profileId as '@profileId', DLO.profileName as '@profileName' FOR XML PATH('profile'), TYPE)
							--plan
							,(SELECT DLO.planId as '@planId', DLO.planName as '@planName' FOR XML PATH('plan'), TYPE)
							--Domain
							,(SELECT DLO.domainId as '@providerId', DLO.domainName as '@providerDomainName' FOR XML PATH('provider'), TYPE)
							,(SELECT TempUMUsers.userid AS '@userId', TempUMUsers.userGuid as '@userGUID', TempUMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
							--company
							,(SELECT DLO.companyId as '@providerId', DLO.companyName as '@providerDomainName' FOR XML PATH('company'), TYPE)
					FROM #UsersTemp TempUMUsers
						LEFT JOIN #UsersAdminDLOProperties DLO
							ON TempUMUsers.userId = DLO.userId
						INNER JOIN #Users U
							ON TempUMUsers.userId = U.userId
						ORDER BY U.id			-- This id column already sorted the users based on the sort condition. So just get it in that order.
					FOR XML PATH('users'),type)
					FOR XML PATH('App_GetUserPropertiesResponse'), type
				 )
	END
END
ELSE			-- When level not in 1,10 query on UserProperties table which has already taken sort into account.
SET @o_xmlText = (SELECT @totalUsers as '@totalRecordsWithoutPaging', (	SELECT tempUMUsers.description AS '@description'
								, tempUMUsers.name AS '@fullName'
								, tempUMUsers.email AS '@email'
								,tempUMUsers.lastLogInTime AS '@lastLogIntime'
								, tempUMUsers.enableUser AS '@enableUser'
								--account lock info
								, CASE WHEN @showLockedInfo = 1 THEN tempUMUsers.isAccountLocked END AS '@isAccountLocked'
								, CASE WHEN @showLockedInfo = 1  AND tempUMUsers.isAccountLocked = 1 THEN tempUMUsers.lockStartTime END AS '@lockStartTime'
								, CASE WHEN @showLockedInfo = 1  AND tempUMUsers.isAccountLocked = 1 THEN tempUMUsers.lockEndTime END AS '@lockEndTime'
								,(select spaceConsumed from #UsersAdminDLOProperties where userId=tempUMUsers.id) as '@spaceConsumed'
								, TempUMUsers.companyName AS '@companyName'
								,tempUMUsers.enforceFSQuota as '@enforceFSQuota'
								,tempUMUsers.quotaLimitInGB as '@quotaLimitInGB'
								,tempUMUsers.inheritGroupQuotaSettings as '@inheritGroupQuotaSettings'
								, tempUMUsers.agePasswordDays AS '@agePasswordDays'
								,(CASE WHEN lapTopUsers.userId is NOT NULL THEN 1 else 0 END) AS '@isLaptopUser'
								--number of devices
							,(SELECT numDevices from #UsersAdminDLOProperties WHERE userId=tempUMUsers.id) as '@numDevices'
							,(SELECT serviceType from #UsersAdminDLOProperties WHERE userId=tempUMUsers.id) as '@serviceType'
                            --invite
							,(SELECT inviteSent from #UsersAdminDLOProperties WHERE userId=tempUMUsers.id) as '@inviteSent'
							,(SELECT inviteTime from #UsersAdminDLOProperties WHERE userId=tempUMUsers.id) as '@inviteTime'
							--profile name profile
							,(SELECT p.profileId as '@profileId', p.profileName as '@profileName' from #UsersAdminDLOProperties p WHERE userId=tempUMUsers.id  FOR XML PATH('profile'), TYPE)
							--plan
							,(SELECT p.planId as '@planId', p.planName as '@planName' from #UsersAdminDLOProperties p WHERE userId=tempUMUsers.id  FOR XML PATH('plan'), TYPE)
															--Domain
							,(SELECT p.domainId as '@providerId', p.domainName as '@providerDomainName' from #UsersAdminDLOProperties p WHERE userId=tempUMUsers.id  FOR XML PATH('provider'), TYPE)
							--company
							,(SELECT p.companyId as '@providerId', p.companyName as '@providerDomainName' from #UsersAdminDLOProperties p WHERE userId=tempUMUsers.id  FOR XML PATH('company'), TYPE)
								, (SELECT tempUMUsers.id AS '@userId', tempUMUsers.userGuid as '@userGUID', tempUMUsers.login AS '@userName' FOR XML PATH('userEntity'), TYPE)
								, TempUMUsers.associatedUserGroupsXML.query('.')
								, TempUMUsers.securityAssociations.query('.')
								, TempUMUsers.associatedExternalUserGroupsXML.query('.')
								, TempUMUsers.userSecurityXML.query('.')
					FROM #UsersProperties tempUMUsers
						LEFT JOIN #LaptopUsers lapTopUsers ON lapTopUsers.userId = tempUMUsers.id
					FOR XML PATH('users'),type)
					 FOR XML PATH('App_GetUserPropertiesResponse'), type
				 )
PROC_EXIT:
IF @o_xmlText is NULL
	SET @o_xmlText = '<App_GetUserPropertiesResponse/>'
IF OBJECT_ID('tempdb.dbo.#userList') IS NOT NULL
	DROP TABLE #userList
IF OBJECT_ID('tempdb.dbo.#LaptopUsers') IS NOT NULL
	DROP TABLE #LaptopUsers
SELECT @o_xmlText o_xmlText
SET @xmlText = @o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getLaptopUsersForAdminDLO')
	delete from GxQscripts where name = 'sec_getLaptopUsersForAdminDLO'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getLaptopUsersForAdminDLO')
	delete from GXDBVersions where aliasname = 'sec_getLaptopUsersForAdminDLO'
GO

insert into GXDBVersions values(2, 'sec_getLaptopUsersForAdminDLO',  '00000000000000000000', 'sec_getLaptopUsersForAdminDLO', '00000000000000000000')
GO

