

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getInheritedSecurityForUserOrGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	--associationType =1 specifies classis security
--					=2  specifies owner associations
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getInheritedSecurityForUserOrGroup')
BEGIN
	print '>>> Drop Stored Procedure: sec_getInheritedSecurityForUserOrGroup <<<'
	drop procedure sec_getInheritedSecurityForUserOrGroup
END
IF EXISTS (select * from GxQscripts where name='sec_getInheritedSecurityForUserOrGroup')
	delete from GxQscripts where name = 'sec_getInheritedSecurityForUserOrGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getInheritedSecurityForUserOrGroup')
	delete from GXDBVersions where aliasname = 'sec_getInheritedSecurityForUserOrGroup'
GO
print '... Creating Procedure: sec_getInheritedSecurityForUserOrGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getInheritedSecurityForUserOrGroup
  @userId INT,
  @xmlOut XML OUTPUT,
  @entityType INT,
  @userOrGroupId INT,
  @isReturn INT =0,
  @returnHiddenPermission INT =0
AS
  DECLARE @o_xml XML
BEGIN
      DECLARE @viewAllEntity INTEGER =0
	  DECLARE @userGroupTbl TABLE(groupId integer)
	  DECLARE @isUser INTEGER=0
EXEC sec_checkPermissionOnEntity @userId,0 ,@viewAllEntity OUTPUT,1,2
IF(@entityType=13)
	  BEGIN
		SET @isUSer=1
		INSERT INTO @userGroupTbl
		SELECT id
		FROM UMGroups JOIN(SELECT umgroupId  as groupId
						FROM UMDSGroupMaps UGMAP
							JOIN UMUserGroup UG
							ON UG.groupId=UGMAP.umDSgroupId and userId=@userOrGroupId
						UNION ALL
						SELECT groupId
						FROM UMUserGroup
						where userId=@userOrGroupId
					)AS Map on Map.groupId=id
	  END
IF(@entityType =62)
	  BEGIN
	  INSERT INTO @userGroupTbl
		SELECT umgroupId
		FROM UMDSGroupMaps UGMAP
		where umdsGroupId=@userOrGroupId
	  END
      --1. Get all parents of entityIds passed.
      IF(@viewAllEntity=0 and exists( SELECT 1 FROM @userGroupTbl ))
      BEGIN
		--Now this is specific to usergroup, and provider entity only. So instead of looping over list of parent entityIds lets get list of user group .
		  IF OBJECT_ID ('tempdb.dbo.#sec_inheritedVisibleUserGroups') IS NOT NULL
					DROP TABLE #sec_inheritedVisibleUserGroups
			CREATE TABLE #sec_inheritedVisibleUserGroups (userGRoupId INT)
				EXEC sec_getUserGroupsForThisUser '#sec_inheritedVisibleUserGroups', @userId
			DELETE  tbl
			FROM @userGroupTbl tbl
			WHERE groupId not in (SELECT userGRoupId FROM #sec_inheritedVisibleUserGroups)
	  END
      IF OBJECT_ID('tempdb.dbo.#inheritedCap') IS NOT NULL
		DROP TABLE #inheritedCap
	  CREATE TABLE #inheritedCap ( userOrGroupId INTEGER,isUser INTEGER,roleId INTEGER DEFAULT 0, permissionId INTEGER DEFAULT 0,
									entitytype1 integer,entityId1 integer,
									entityType2 integer default 0, entityId2 integer default 0,
									entityType3 integer default 0, entityId3 integer default 0,
									entityType4 integer default 0, entityId4 integer default 0,
									entityType5 integer default 0, entityId5 integer default 0,
									permissionsXML NVARCHAR(MAX) default'',
									categoryPermissionXML NVARCHAR(MAX) default '',
									roleName nvarchar(max) default '',
									isOwner integer default 0,
									includeAll integer default 0,
									userGroupId integer default 0,
									userGroupName nvarchar(max)	default N'',
									externalGroupId integer default 0,
									externalGroupName nvarchar(max) default N'',
									userId integer default 0,
									userName nvarchar(max) default N'',
									_type_ integer default 0,
									genericEntityAssociated XML default '',
									isCreator INT DEFAULT 0,
									associationType INT DEFAULT 1
									)
	 INSERT INTO #inheritedCap (userOrGroupId,isUser,roleId,permissionId,entitytype1 ,entityId1 ,entityType2  , entityId2 ,entityType3 , entityId3 ,entityType4 , entityId4 ,entityType5 , entityId5 ,includeAll,isCreator)
	 SELECT userOrGroupId,isUser,roleId,permissionId,entitytype1 ,entityId1 ,entityType2  , entityId2 ,entityType3 , entityId3 ,entityType4 , entityId4 ,entityType5 , entityId5 ,includeAll,isCreator
	  FROM UMSecurityAssociations Sec JOIN @userGroupTbl ON isUSer=0 and userORGRoupId=groupId
	 --We should not send role that are hidden back to GUI
	DELETE Tbl
	FROM #inheritedCap Tbl INNER JOIN UMROles Roles
	ON Tbl.roleId = Roles.id
WHERE Tbl.roleId <> 0 AND Roles.flags & 4 <> 0  AND Roles.flags& 32=0
	IF(@returnHiddenPermission=0)
	BEGIN
		UPDATE Perm
		SET Perm.permissionId=0
		FROM #inheritedCap Perm INNER JOIN UMPermissions
			ON Perm.permissionId = UMPermissions.id
AND flags&2<>0
	END
	INSERT INTO #inheritedCap (userORGroupId,isUser,categoryPermissionXML, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, isCreator)
    SELECT userOrGroupId,isUser,
			(
             SELECT( SELECT Perm.permissionid AS '@permissionId',
					UMPermissions.permissionName AS '@permissionName',
					UMPermissions.categoryId as '@categoryId',
122 AS '@_type_'
			 FROM #inheritedCap Perm INNER JOIN UMPermissions
			 ON Perm.permissionId = UMPermissions.id and UMPermissions.id<>0
			 WHERE Perm.entityType1 = Entity.entityType1 AND Perm.entityID1 = Entity.entityId1
				  AND Perm.entityType2 = Entity.entityType2 AND Perm.entityID2 = Entity.entityId2
				  AND Perm.entityType3 = Entity.entityType3 AND Perm.entityID3 = Entity.entityId3
				  AND perm.entityType4 = Entity.entityType4 AND Perm.entityID4 = Entity.entityId4
				  AND Perm.entityType5 = Entity.entityType5 AND Perm.entityID5 = Entity.entityId5
				  AND Perm.permissionId <> 0 AND Perm.isCreator = Entity.isCreator
				  AND Perm.isUser = Entity.isUser AND Perm.userOrGroupId = Entity.userOrGroupID
			 FOR XML PATH ('categoriesPermissionList'),TYPE)
			FOR XML PATH('categoryPermission')),
             Entity.entityType1,
             Entity.entityId1,
             Entity.entityType2,
             Entity.entityId2,
             Entity.entityType3,
             Entity.entityID3,
             Entity.entityTYpe4,
             Entity.entityId4,
             Entity.entityType5,
             Entity.entityId5,
             Entity.includeAll,
             Entity.isCreator
    FROM (SELECT DISTINCT userORGroupId,isUSer,entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeALl, isCreator FROM #inheritedCap WHERE permissionId <> 0) Entity
	DELETE FROM #inheritedCap WHERE permissionId <> 0		-- they are already framed up as custom role in the above statement. Dont populate again, it creates duplicate entries in UI.
IF EXISTS(SELECT 1 FROM    #inheritedCap JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0)
		BEGIN
			DECLARE @customRoleXmlIn XML = (SELECT 20 AS '@listPropertyLevel',
										 (SELECT roleId AS '@roleId'
FROM #inheritedCap JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0
										  FOR XML PATH ('roleEntity'),TYPE)
									FOR XML PATH('Security_GetRolesPropertiesRequest'))
 			EXEC sec_getRoleDetailList @customRoleXmlIn OUTPUT, 1, 0
			UPDATE TBL
			SET categoryPermissionXML = CAST(roleXML AS NVARCHAR(MAX)),roleId=0
			FROM #inheritedCap Tbl JOIN ( SELECT R.value('(role/@roleId)[1]','INT') as roleId,R.query('categoryPermission') as roleXML
										 FROM @customRoleXmlIn.nodes('Security_GetRolesPropertiesResponse/roleProperties') AS Input(R)  ) Role
								 ON Role.roleId=Tbl.roleId
		END
INSERT INTO #inheritedCap (userOrGroupId,isUser,entitytype1,entityId1,isOwner,associationType)
SELECT O.userOrGroupId, O.isUser,entityType,entityId,1,2 FROM UMOwners O JOIN @userGroupTbl tbl ON isUSer=0 and userORGRoupId=groupId
UNION
SELECT O.userOrGroupId, O.isUser,entityType,entityId,1,2 FROM UMOwners O WHERE isUser=@isUser and userORGroupId=@userOrGroupId
 --Lets do security check smartly. If more than 50 entities associated of same entity type than lets call sec_getnonIda object for entity else in cursor sec_checkPermissionOnEntity
 DECLARE @tempEntityTypeTbl TABLE (entityType1 integer,entityType2 integer, entityType3 integer, entityType4 integer,entityType5 integer)
 INSERT INTO @tempEntityTypeTbl
 SELECT entityType1,entitytype2,entityType3,entityType4,entityType5 FROM #inheritedCap group by entityType1,entitytype2,entityType3,entityType4,entityType5  HAVING count(*)>50
	--Now see caller user has view rights on associated entity or not. this has to be cursor for now.
	DECLARE @tempEntityType AS INT
	DECLARE @tempEntityType1 AS INT
	DECLARE @tempEntityId1 AS INT
	DECLARE @tempEntityType2 AS INT
	DECLARE @tempEntityId2 AS INT
	DECLARE @tempEntityType3 AS INT
	DECLARE @tempEntityId3 AS INT
	DECLARE @tempEntityType4 AS INT
	DECLARE @tempEntityId4 AS INT
	DECLARE @tempEntityType5 AS INT
	DECLARE @tempEntityId5 AS INT
	DECLARE @tempRoleId AS INT
	IF(@viewAllEntity=0  and exists (Select 1 from #inheritedCap))
	BEGIN
		DECLARE tempCursor CURSOR STATIC FOR
		SELECT DISTINCT entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5
		FROM #inheritedCap
		WHERE dbo.getEntityLevelFromEntityHierarchy(entityType1,entitytype2,entityType3,entityType4,entityType5) not in (SELECT dbo.getEntityLevelFromEntityHierarchy(entityType1,entitytype2,entityType3,entityType4,entityType5) from @tempEntityTypeTbl)
		OPEN tempCursor
		FETCH NEXT FROM tempCursor INTO @tempEntityType1, @tempEntityId1, @tempEntityType2, @tempEntityId2, @tempEntityType3, @tempEntityId3, @tempEntityType4, @tempEntityId4, @tempEntityType5, @tempEntityId5
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE @canView AS INT
			SET @canView = 0
			--If caller can see this entity and it is not present in inputConsolidatedTable then he has purposefully deleted it
			EXEC dbo.sec_checkPermissionOnEntity @userId, 0, @canView OUTPUT, @tempEntityType1, @tempEntityId1, @tempEntityType2, @tempEntityId2, @tempEntityType3, @tempEntityId3, @tempEntityType4, @tempEntityId4, @tempEntityType5, @tempEntityId5, 0, 1
			IF @canView = 0
			BEGIN
				DELETE FROM #inheritedCap
				WHERE entityType1 = @tempEntityType1 AND entityId1 = @tempEntityId1 AND
					  entityType2 = @tempEntityType2 AND entityId2 = @tempEntityId2 AND
					  entityType3 = @tempEntityType3 AND entityId3 = @tempEntityId3 AND
					  entityType4 = @tempEntityType4 AND entityId4 = @tempEntityId4 AND
					  entityType5 = @tempEntityType5 AND entityId5 = @tempEntityId5
			END
			FETCH NEXT FROM tempCursor INTO @tempEntityType1, @tempEntityId1, @tempEntityType2, @tempEntityId2, @tempEntityType3, @tempEntityId3, @tempEntityType4, @tempEntityId4, @tempEntityType5, @tempEntityId5
		END
		CLOSE tempCursor
		DEALLOCATE tempCursor
	END
	IF(@viewAllEntity=0  and exists (Select 1 from @tempEntityTypeTbl))
	BEGIN
				IF OBJECT_ID('tempdb.dbo.#entityVisibleNonIda') IS NOT NULL
					DROP TABLE #entityVisibleNonIda
				CREATE TABLE #entityVisibleNonIda (entityId INT)
			IF OBJECT_ID('tempdb.dbo.#entityVisibleIda') IS NOT NULL
				DROP TABLE #entityVisibleIda
			CREATE TABLE #entityVisibleIda (clientId INT, appTypeId INT, instanceID INT, backupsetId INT, subclientId INT)
			DECLARE tempcursor CURSOR FOR
				SELECT DISTINCT dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityTYpe4, entityType5)
				FROM @tempEntityTypeTbl
			OPEN tempcursor
			FETCH NEXT FROM tempcursor INTO @tempentitytype
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DELETE FROM #entityVisibleNonIda
				DELETE FROM #entityVisibleIda
IF (@tempentitytype NOT IN (3, 4, 5, 6, 7))
				BEGIN
					EXEC sec_getNonIdaObjectsForThisUser @userId, @tempentitytype, 0, '#entityVisibleNonIda'
					DELETE tbl
					FROM #inheritedCap tbl LEFT OUTER JOIN #entityVisibleNonIda sec
					ON tbl.entityType1 = @tempentitytype AND tbl.entityId1 = sec.entityId
					WHERE tbl.entityType1 = @tempentityType AND sec.entityId IS NULL AND includeAll = 0
				END
				ELSE
				BEGIN
					EXEC sec_getIdaObjectsForUser @userId, @tempentitytype, 0, 0, '#entityVisibleIda'
					--Note that sec_getIdaObjectsForUser.sp will always "expand" the results and give. If you are asking for list of "backupset", then it will get you only backupset rows.
					--No client or appType or instance rows with backupsetId as 0 will be returned. So all we have to do is just do a ID mapping between tempTable and entityVisibleIda
					DELETE tbl
					FROM #inheritedCap Tbl LEFT OUTER JOIN #entityVisibleIda Sec
ON (tbl.entityType1 = 3 AND tbl.entityID1 = Sec.clientID)
AND (@tempEntityType < 4 OR (tbl.entityType2 = 4 AND tbl.entityId2 = Sec.appTypeId))
AND (@tempEntityType < 5 OR (tbl.entityType3 = 5 AND tbl.entityId3 = Sec.instanceId))
AND (@tempEntityType < 6 OR (tbl.entityType4 = 6 AND tbl.entityId4 = Sec.backupsetid))
AND (@tempEntityType < 7 OR (tbl.entityType5 = 7 AND tbl.entityId5 = Sec.subclientId))
					WHERE dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityTYpe4, entityType5) = @tempentitytype AND Sec.clientId IS NULL AND includeAll = 0
				END
				FETCH NEXT FROM tempcursor INTO @tempentitytype
			END
			CLOSE tempcursor
			DEALLOCATE tempcursor
	END
 	  UPDATE Tbl
SET  userGroupId = UMGroups.id, userGroupName = UMGroups.name, _type_ = 15
	 FROM #inheritedCap TBL  JOIN UMGroups ON Tbl.isUser=0 and Tbl.userOrGroupId=UMGroups.id
	  WHERE UMGroups.umdsProviderId=0
	UPDATE Tbl
SET externalGroupId = G.id, externalGroupName = p.domainName + '\' + G.name, _type_ = 62
	FROM #inheritedCap TBL  JOIN UMGroups G ON Tbl.isUser = 0 and Tbl.userOrGroupId = G.id
	INNER JOIN UMDSProviders P ON P.id = G.umdsProviderID
	WHERE G.umdsProviderId<>0
	UPDATE Tbl
SET userId=userOrGroupId, userName = U.login, _type_=13
	FROM #inheritedCap TBL  INNER JOIN UMUsers U
	ON Tbl.userOrGroupID = U.id
	WHERE isUser=1
	UPDATE #inheritedCap
	SET roleName = R.name
	FROM UMRoles R
	WHERE R.id = #inheritedCap.roleID AND #inheritedCap.roleID > 0
	EXEC EntityIdToNameConverterDynamic '#inheritedCap', 'entity'
	SET @xmlOut =
	ISNULL((SELECT
				(SELECT
					(SELECT
						(SELECT Entity.genericEntityAssociated.query('.')
						 FROM #inheritedCap Entity
						 WHERE Entity.roleId = RP.roleId AND Entity.permissionsXML = RP.permissionsXML AND Entity.isCreator = RP.isCreator and Entity.userGroupId=RP.usergroupId and Entity.externalGroupId=RP.externalGroupId and Entity.associationType=RP.associationType and Entity.userId=RP.userId and Entity._type_=RP._type_
						 AND Entity.roleName = RP.roleName AND Entity.userName = Rp.userName AND Entity.userGroupName = RP.userGroupName AND Entity.externalGroupname = RP.externalGroupname AND Entity.categoryPermissionXML = RP.categoryPermissionXML
						 FOR XML PATH (''), TYPE)
					FOR XML PATH ('entities'), TYPE),
					(SELECT ISNULL(isCreator,0) AS '@isCreatorAssociation',
							ISNULL(associationType,1) AS '@type',
							CASE WHEN RP.roleId <> 0 THEN
								 (SELECT RP.roleId AS '@roleId',
										 RP.roleName AS '@roleName',
120 AS '@_type_'
									FOR XML PATH ('role'), TYPE)
								WHEN RP.permissionsXML IS NOT NULL AND RP.permissionsXML <> N'' THEN
								(SELECT CAST(RP.permissionsXML AS XML)
								 FOR XML PATH (''), TYPE)
								ELSE
								(SELECT CAST(RP.categorypermissionXML AS XML)
								 FOR XML PATH (''), TYPE)
							END
					FOR XML PATH ('properties'), TYPE)
				FOR XML PATH ('association'), TYPE),
				( SELECT userGroupId as '@userGroupId',
						 userGroupName AS '@userGroupName',
							 externalGroupId as '@groupId',
							 externalGroupName AS '@externalGroupName',
							 userId as '@userId',
							 userName AS '@userName',
							 _type_   as'@_type_'
						FOR XML PATH('parentEntity'),TYPE)
				FROM (SELECT DISTINCT roleId, roleName, userGroupId, userGroupName, externalGroupId, externalGroupName, userId, userName, _type_, permissionsXML, categoryPermissionXML, isCreator, associationType FROM #inheritedCap) RP
			FOR XML PATH ('inheritedAssociations')), '<inheritedAssociations/>')
		IF(@isReturn<>0)
			SELECT @xmlOut
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getInheritedSecurityForUserOrGroup')
	delete from GxQscripts where name = 'sec_getInheritedSecurityForUserOrGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getInheritedSecurityForUserOrGroup')
	delete from GXDBVersions where aliasname = 'sec_getInheritedSecurityForUserOrGroup'
GO

insert into GXDBVersions values(2, 'sec_getInheritedSecurityForUserOrGroup',  '00000000000000000000', 'sec_getInheritedSecurityForUserOrGroup', '00000000000000000000')
GO

