

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getInheritedSecurityForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getInheritedSecurityForEntity <<<'

IF EXISTS (select * from sysobjects where name='sec_getInheritedSecurityForEntity')
	drop procedure sec_getInheritedSecurityForEntity
IF EXISTS (select * from GxQscripts where name='sec_getInheritedSecurityForEntity')
	delete from GxQscripts where name = 'sec_getInheritedSecurityForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getInheritedSecurityForEntity')
	delete from GXDBVersions where aliasname = 'sec_getInheritedSecurityForEntity'
GO
print '... Creating Procedure: sec_getInheritedSecurityForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getInheritedSecurityForEntity
  @userId INT,
  @xmlOut XML OUTPUT,
  @xmlOwnerOut XML OUTPUT,
  @entityType1 INT,
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0,
  @isReturn INT =0,
  @returnHiddenPermission INT =0,
  @getAssociationTypeFilter INT=39,
  @skipIdToNameConversion INT = 0
AS
  DECLARE @o_xml XML
  DECLARE @o_ownerXML XML
BEGIN
	DECLARE @entityTypeReq INT = dbo.getEntityLevelFromEntityHierarchy(@entityType1, @entityType2, @entityType3, @entityTYpe4, @entityType5)
	IF OBJECT_ID ('tempdb.dbo.#inheritedSecurityAssociations') IS NOT NULL
		DROP TABLE #inheritedSecurityAssociations
	CREATE TABLE #inheritedSecurityAssociations
	(
		isUser INT,
		userOrGroupId INT,
		roleId INT,
		permissionId INT DEFAULT 0,
		entityType1 INT,
		entityId1 INT,
		entityType2 INT DEFAULT 0,
		entityId2 INT DEFAULT 0,
		entityType3 INT DEFAULT 0,
		entityId3 INT DEFAULT 0,
		entityType4 INT DEFAULT 0,
		entityId4 INT DEFAULT 0,
		entityType5 INT DEFAULT 0,
		entityId5 INT DEFAULT 0,
		includeAll INT DEFAULT 0,
		isCreator INT DEFAULT 0,
		customRoleXML XML,
		genericEntityAssociated NVARCHAR(MAX),
		userName VARCHAR(MAX),
		userGroupName VARCHAR(MAX)
	)
	CREATE CLUSTERED INDEX inheritedSecurityAssociations_isUser_userOrGroupId ON #inheritedSecurityAssociations (isUser, userOrGroupId);
	CREATE NONCLUSTERED INDEX inheritedSecurityAssociations_roleId ON #inheritedSecurityAssociations (roleId);
	IF OBJECT_ID('tempdb.dbo.#inheritedOwnerPermissions') IS NOT NULL
		DROP TABLE #inheritedOwnerPermissions
	CREATE TABLE #inheritedOwnerPermissions
	(
		entityType INT,
		entityId INT,
		permissionId INT,
		genericEntityAssociated XML
	)
	CREATE CLUSTERED INDEX inheritedOwnerPermissions_entityType_entityId ON #inheritedOwnerPermissions (entityType, entityId);
	IF OBJECT_ID('tempdb.dbo.#sec_parentEntityTable') IS NOT NULL
			DROP TABLE #sec_parentEntityTable
	CREATE TABLE #sec_parentEntityTable
	(
		parentEntityType INT,
		parentEntityId INT,
		entityType2 INT DEFAULT 0,				-- Will be filled for apptype, instance, backupset and subclient entities.
		entityId2 INT DEFAULT 0,
		entityType3 INT DEFAULT 0,
		entityId3 INT DEFAULT 0,
		entityType4 INT DEFAULT 0,
		entityId4 INT DEFAULT 0,
		entityType5 INT DEFAULT 0,
		entityId5 INT DEFAULT 0,
		includeAll INT DEFAULT 0
	)
    CREATE CLUSTERED INDEX parentEntityTable_parentEntityType_parentEntityId ON #sec_parentEntityTable (parentEntityType, parentEntityId);
	-- Get all parents of entityIds passed.
	BEGIN
		IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType1)
		BEGIN
			DECLARE @associationsQuery NVARCHAR(MAX) = ''
			--Get all parent entities and their entity types of this entity.
			SELECT @associationsQuery = 'INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityId)' +
										CHAR(10) +
								SUBSTRING
									(
										(
											SELECT DISTINCT 'UNION'
															+ CHAR(10)			-- New line character
															+ 'SELECT parentEntityType, parentId'
															+ CHAR(10)
															+ 'FROM ('
															+ CHAR(10)
															+ CAST(associationQuery AS VARCHAR(MAX))
															+ CHAR(10)
															+ ')Tbl'
															+ CHAR(10)
															+ 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10))
															+ CHAR(10)
											FROM App_EntityParentAssociation
											WHERE
												childEntityType = @entityType1
											FOR XML PATH (''), TYPE
										).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
										6,				-- Exclude the first UNION
										2147483647		-- MAX
									)
			EXEC (@associationsQuery)
		END
	END
	-- Filter out the parent entities that cannot be seen by caller.
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#entityVisibleNonIda') IS NOT NULL
			DROP TABLE #entityVisibleNonIda
		CREATE TABLE #entityVisibleNonIda
		(
			entityId INT PRIMARY KEY
		)
		DECLARE @tempentitytype INT = 0
		DECLARE tempcursor CURSOR FOR
			SELECT DISTINCT parentEntityType
			FROM #sec_parentEntityTable
		OPEN tempCursor
		FETCH NEXT FROM tempcursor INTO @tempentitytype
		WHILE @@FETCH_STATUS=0
		BEGIN
			TRUNCATE TABLE #entityVisibleNonIda
			EXEC sec_getNonIdaObjectsForThisUser @userId, @tempentitytype, 0, '#entityVisibleNonIda'
			DELETE Tbl
			FROM #sec_parentEntityTable Tbl
				 LEFT OUTER JOIN #entityVisibleNonIda Sec
					ON Tbl.parententityId = Sec.entityId
			WHERE
				Tbl.parentEntityType = @tempEntityType
				AND Sec.entityID IS NULL
			FETCH NEXT FROM tempCursor INTO @tempEntityType
		END
		CLOSE tempCursor
		DEALLOCATE tempCursor
		-- To insert commcell entity, let us call sec_CheckPermissionOnEntity
		DECLARE @canSeeCommcell INT = 0
		EXEC sec_checkPermissionOnEntity @userId, '0', @canSeeCommcell OUTPUT, 1, 2
		IF @canSeeCommcell = 1
			INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityID)
				SELECT 1, 2
	END
	-- Inherited owner permissions.
IF (@getAssociationTypeFilter & 32 <> 0)
	BEGIN
		IF(@entitytype2 = 0)
		BEGIN
			INSERT INTO #inheritedOwnerPermissions (permissionId, entityType, entityId)
				SELECT RPE.permissionId, entityType, entityId
				FROM UMOwnerRoles ORoles
						INNER JOIN #sec_parentEntityTable
							ON parentEntityType = entityType AND parentEntityId = entityID
						INNER JOIN UMRolesWithPermissionsExpanded RPE
							ON ORoles.roleId = RPE.roleId
			-- Hardcoding the application table names for nwo since owner feature is applicable only for clients.
			UPDATE #inheritedOwnerPermissions
			SET genericEntityAssociated = (
											SELECT id AS '@clientGroupId',
												   name AS '@clientGroupName',
												   28 AS '@_type_'			-- CLIENT_GROUP_ENTITY
											FROM APP_ClientGroup
											WHERE
												id = entityId
											FOR XML PATH ('parents'), TYPE
								   )
			WHERE
				entityType = 28
			UPDATE #inheritedOwnerPermissions
			SET genericEntityAssociated = (
											SELECT id AS '@commCellId',
												   aliasname AS '@commCellName',
												   1 AS '@_type_'			-- COMMCELL_ENTITY
											FROM APP_Commcell
											WHERE
												id = entityId
											FOR XML PATH ('parents'), TYPE
								   )
			WHERE
				entityType = 1
			SELECT @xmlOwnerOut =   (
										SELECT
												(
													SELECT entity.genericEntityAssociated.query('.')
													FROM #inheritedOwnerPermissions entity
													WHERE
														entity.permissionId = parent.permissionId
													FOR XML PATH(''),TYPE
												),
												(
													SELECT P.id AS '@permissionId',
														   P.permissionName AS '@permissionName',
										    			   122 AS '@_type_'				-- PERMISSION_ENTITY
													FROM UMPermissions P
													WHERE
														id = parent.PermissionId
													FOR XML PATH('permission'),TYPE
												)
										FROM (SELECT DISTINCT permissionId FROM #inheritedOwnerPermissions) parent
										FOR XML PATH ('inheritedOwners'), TYPE
									)
		END
	END
	-- Inherited classic security associations.
IF(@getAssociationTypeFilter & 8<>0)
	BEGIN
		-- Include all of this entity type and parent entity type also need to be inherited.
		INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityId, includeALl)
			VALUES (@entityType1, 0, 1)
		INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityId, includeALl)
			SELECT DISTINCT parentEntityType, 0, 1
			FROM #sec_parentEntityTable
			WHERE
				parentEntityType <> @entityType1			-- User group will have itself as its parent.
		-- Special case for iDA entities.
		-- For appType, instance, backupset and subclient we need to consider till client, appType, instance and backupset rows respectively.
		-- So inserting the corresponding entries into #sec_parentEntityTable.
		-- We cannot put it above because we do not want security check to happen for these parents. We can see client even if we do not have explicit rights on client but see appType.
		IF @entityTypeReq IN (4,5,6,7)			-- APPTYPE_ENTITY, INSTANCE_ENTITY, BACKUPSET_ENTITY, SUBCLIENT_ENTITY
		BEGIN
			IF @entityTypeReq >= 4				-- For apptype we need to consider client rows
				INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityId)
					VALUES (@entityType1, @entityId1)
			IF @entityTypeReq >= 5				-- For instance we need to consider client, appType rows
				INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityId, entityType2, entityId2)
					VALUES (@entityType1, @entityId1, @entityType2, @entityId2)
			IF @entityTypeReq >= 6				-- For backuset we need to consider client, appType, instance rows
				INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityId, entityType2, entityId2, entityType3, entityId3)
					VALUES (@entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3)
			IF @entityTypeReq = 7				-- For subclient we need to consider client, appType, instance, backupset rows
				INSERT INTO #sec_parentEntityTable (parentEntityType, parentEntityId, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4)
					VALUES (@entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4)
		END
		-- Get visible users and groups.
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible') IS NOT NULL
				DROP TABLE #usersAndGroupsVisible
			CREATE TABLE #usersAndGroupsVisible
			(
				isUser INT,
				userOrGroupId INT,
				UNIQUE CLUSTERED (isUser, userOrGroupId)
			)
			IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
					DROP TABLE #VisibleUsersAndUserGroups
			CREATE TABLE #VisibleUsersAndUserGroups (userOrGroupId INT)
			EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups', @userId
			INSERT INTO #usersAndGroupsVisible
					SELECT 1, userOrGroupId
					FROM #VisibleUsersAndUserGroups
			TRUNCATE TABLE #VisibleUsersAndUserGroups
			EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups', @userId
			INSERT INTO #usersAndGroupsVisible
					SELECT 0, userOrGroupId
					FROM #VisibleUsersAndUserGroups
			TRUNCATE TABLE #VisibleUsersAndUserGroups
		END
		IF @entityTypeReq NOT IN (3,4,5,6,7)			-- CLIENT_ENTITY, APPTYPE_ENTITY, INSTANCE_ENTITY, BACKUPSET_ENTITY, SUBCLIENT_ENTITY
		BEGIN
			-- We can JOIN on #sec_parentEntityTable.parentEntityType = entityType1 and #sec_parentEntityTable.parentEntityId = entityId1
			-- For iDA entities we need to JOIN on all 4 parents.
			INSERT INTO #inheritedSecurityAssociations (userOrGroupId, isUser, roleId, permissionId, entityType1, entityId1, includeAll, isCreator)
				SELECT Sec.userOrGroupId, Sec.isUser, Sec.roleId, Sec.permissionId, Sec.entityType1, Sec.entityId1, Sec.includeAll, Sec.isCreator
				FROM UMSecurityAssociations Sec
						INNER JOIN #usersAndGroupsVisible UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGRoupId
						INNER JOIN #sec_parentEntityTable Parent
							ON Sec.EntityType1 = Parent.parentEntityType AND Sec.entityId1 = Parent.ParentEntityId AND Sec.includeALl = Parent.includeAll
						INNER JOIN
										(
											SELECT DISTINCT RPE.roleId AS roleId, 0 AS permissionId
											FROM UMRolesWithPermissionsExpanded RPE
												 INNER JOIN UMPermissionEntityTypeMap PE
													ON RPE.permissionId = PE.permissionID
											WHERE
												PE.entityType IN (0, @entityTypeReq)
											UNION ALL
											SELECT 0 AS roleId, PE.permissionId AS permissionID
											FROM UMPermissionEntityTypeMap PE
											WHERE
												PE.entityType IN (0, @entityTypeReq)
										)R
							ON Sec.roleID = R.roleID AND Sec.permissionId = R.permissionId
		END
		ELSE
		BEGIN
			INSERT INTO #inheritedSecurityAssociations (userOrGroupId, isUser, roleId, permissionId, entityType1, entityId1, includeAll, isCreator, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5)
				SELECT Sec.userOrGroupId, Sec.isUser, Sec.roleId, Sec.permissionId, Sec.entityType1, Sec.entityId1, Sec.includeAll, Sec.isCreator, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityId3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityId5
				FROM UMSecurityAssociations Sec
						INNER JOIN #usersAndGroupsVisible UG
							ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGRoupId
						INNER JOIN #sec_parentEntityTable Parent
							ON (Sec.entityType1 = Parent.parentEntityType AND Sec.entityId1 = Parent.parentEntityId)
							   AND (Sec.entityType2 = Parent.entityType2 AND Sec.entityId2 = Parent.entityId2)
							   AND (Sec.entityType3 = Parent.entityType3 AND Sec.entityId3 = Parent.entityId3)
							   AND (Sec.entityType4 = Parent.entityType4 AND Sec.entityId4 = Parent.entityId4)
							   AND (Sec.entityType5 = 0 AND Sec.entityID5 = 0)
							   AND Sec.includeAll = Parent.includeAll
						INNER JOIN
										(
											SELECT DISTINCT RPE.roleId AS roleId, 0 AS permissionId
											FROM UMRolesWithPermissionsExpanded RPE
												 INNER JOIN UMPermissionEntityTypeMap PE
													ON RPE.permissionId = PE.permissionID
											WHERE
												PE.entityType IN (0, @entityTypeReq)
											UNION ALL
											SELECT 0 AS roleId, PE.permissionId AS permissionID
											FROM UMPermissionEntityTypeMap PE
											WHERE
												PE.entityType IN (0, @entityTypeReq)
										)R
							ON Sec.roleID = R.roleID AND Sec.permissionId = R.permissionId
		END
IF EXISTS(SELECT 1 FROM    #inheritedSecurityAssociations JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0)
		BEGIN
			DECLARE @customRoleXmlIn XML = (SELECT 20 AS '@listPropertyLevel',
										 (SELECT roleId AS '@roleId'
FROM #inheritedSecurityAssociations JOIN UMRoles R ON R.id=roleId and R.flags& 32<>0
										  FOR XML PATH ('roleEntity'),TYPE)
									FOR XML PATH('Security_GetRolesPropertiesRequest'), TYPE)
 			EXEC sec_getRoleDetailList @customRoleXmlIn OUTPUT, 1, 0
			UPDATE TBL
			SET customRoleXML = roleXML,roleId=0
			FROM #inheritedSecurityAssociations Tbl JOIN ( SELECT R.value('(role/@roleId)[1]','INT') as roleId,R.query('categoryPermission') as roleXML
										 FROM @customRoleXmlIn.nodes('Security_GetRolesPropertiesResponse/roleProperties') AS Input(R)  ) Role
								 ON Role.roleId=Tbl.roleId
		END
		DELETE Tbl
		FROM #inheritedSecurityAssociations Tbl INNER JOIN UMROles Roles
		ON Tbl.roleId = Roles.id
WHERE Tbl.roleId <> 0 AND Roles.flags & 4 <> 0
	END
	IF(@returnHiddenPermission=0)
	BEGIN
		UPDATE Perm
		SET Perm.permissionId=0
		FROM #inheritedSecurityAssociations Perm INNER JOIN UMPermissions
				ON Perm.permissionId = UMPermissions.id
AND flags&0x002<>0
	END
	IF @skipIdToNameConversion = 0
		EXEC EntityIdToNameConverterDynamic '#inheritedSecurityAssociations','parentEntity'
	ELSE
		UPDATE #inheritedSecurityAssociations
		SET genericEntityAssociated = CAST(dbo.getGenericXMLFromEntityType(entitytype1, entityid1,entitytype2,entityId2,entitytype3,entityId3,entitytype4,entityId4,entitytype5,entityId5,0,includeALL,'parentEntity')	AS NVARCHAR(MAX))	-- This would just fill ids.
		SET @xmlOut = (SELECT
							(SELECT
								(SELECT
									(SELECT CASE WHEN isUser = 1 THEN userORgroupId END as'@userId',
											CASE WHEN isUser = 0 THEN userOrGroupId END as '@userGroupId',
											CASE WHEN isUser = 1 THEN U.login END AS '@userName',
											CASE WHEN isUser = 0 THEN
												CASE WHEN G.umdsProviderId = 0 THEN G.name ELSE P.domainName + '\' + G.name END
											END AS '@userGroupName',
											CASE WHEN isUser = 1 THEN 13 ELSE 15 END as '@_type_'
									  FOR XML PATH('userOrGroup'),TYPE),
									(SELECT isCreator as '@isCreatorAssociation'	,
										(SELECT		roleId  as'@roleId',
													name as'@roleName',
120 AS '@_type_'
										 FROM UMRoles where id=roleId
										 FOR XML PATH('role'),TYPE)
									FOR XML PATH('properties'),TYPE)
						      FOR XML PATH('association'),TYPE),
						    (SELECT CAST(genericEntityAssociated AS XML)
							 FOR XML PATH(''),TYPE)
						 FROM #inheritedSecurityAssociations outside
							  LEFT JOIN UMUsers U
								ON outside.isUser = 1 AND outside.userOrGroupId = U.id
							  LEFT JOIN UMGroups G
								ON outside.isUser = 0 AND outside.userOrGroupId = G.id
							  LEFT JOIN UMDSProviders P
								ON G.umdsProviderId = P.id
						 WHERE roleId<>0
						 FOR XML PATH ('inheritedAssociations'),TYPE),
						(SELECT
							(SELECT
								(SELECT CASE WHEN isUser = 1 THEN userORgroupId END as'@userId',
											CASE WHEN isUser = 0 THEN userOrGroupId END as '@userGroupId',
											CASE WHEN isUser = 1 THEN U.login END AS '@userName',
											CASE WHEN isUser = 0 THEN
												CASE WHEN G.umdsProviderId = 0 THEN G.name ELSE P.domainName + '\' + G.name END
											END AS '@userGroupName',
											CASE WHEN isUser = 1 THEN 13 ELSE 15 END as '@_type_'
									FOR XML PATH('userOrGroup'),TYPE),
								(SELECT isCreator as '@isCreatorAssociation',
									(SELECT(SELECT permissionId  as'@permissionId',
												permissionName as '@permissionName',
122 as '@_type_'
									  FROM #inheritedSecurityAssociations inside JOIN UMPermissions ON permissionId=id and permissionID<>0
									  WHERE inside.genericEntityAssociated = outside.genericEntityAssociated
											 and inside.isUser = outside.isUser and inside.userOrGroupId = outside.userOrGroupId
											 and inside.isCreator = outside.isCreator
									FOR XML PATH ('categoriesPermissionList'),TYPE)
									FOR XML PATH('categoryPermission'),TYPE)
								FOR XML PATH('properties'),TYPE)
							FOR XML PATH('association'),TYPE),
							(SELECT CAST(genericEntityAssociated AS XML)
							FOR XML PATH(''),TYPE)
						FROM #inheritedSecurityAssociations Outside
							  LEFT JOIN UMUsers U
								ON Outside.isUser = 1 AND Outside.userOrGroupId = U.id
							  LEFT JOIN UMGroups G
								ON Outside.isUser = 0 AND Outside.userOrGroupId = G.id
							  LEFT JOIN UMDSProviders P
								ON G.umdsProviderId = P.id
						WHERE permissionId<>0
						GROUP BY isUser, userOrGroupId, U.login, G.umdsProviderId, P.domainName, G.name, isCreator, genericEntityAssociated
					FOR XML PATH('inheritedAssociations'),TYPE),
					(SELECT
							(SELECT
								(SELECT CASE WHEN isUser = 1 THEN userORgroupId END as'@userId',
											CASE WHEN isUser = 0 THEN userOrGroupId END as '@userGroupId',
											CASE WHEN isUser = 1 THEN U.login END AS '@userName',
											CASE WHEN isUser = 0 THEN
												CASE WHEN G.umdsProviderId = 0 THEN G.name ELSE P.domainName + '\' + G.name END
											END AS '@userGroupName',
											CASE WHEN isUser = 1 THEN 13 ELSE 15 END as '@_type_'
									FOR XML PATH('userOrGroup'),TYPE),
								(SELECT isCreator as '@isCreatorAssociation',
									(SELECT customRoleXml.query('.')  FOR XML PATH(''),TYPE)
								FOR XML PATH('properties'),TYPE)
							FOR XML PATH('association'),TYPE),
							(SELECT CAST(genericEntityAssociated AS XML)
							FOR XML PATH(''),TYPE)
						 FROM #inheritedSecurityAssociations outside
							  LEFT JOIN UMUsers U
								ON outside.isUser = 1 AND outside.userOrGroupId = U.id
							  LEFT JOIN UMGroups G
								ON outside.isUser = 0 AND outside.userOrGroupId = G.id
							  LEFT JOIN UMDSProviders P
								ON G.umdsProviderId = P.id
						WHERE customRoleXml.exist('categoryPermission')<>0
					FOR XML PATH('inheritedAssociations'),TYPE)
				FOR XML PATH(''))
		IF(@isReturn<>0)
			SELECT @xmlOut,@xmlOwnerOut
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getInheritedSecurityForEntity')
	delete from GxQscripts where name = 'sec_getInheritedSecurityForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getInheritedSecurityForEntity')
	delete from GXDBVersions where aliasname = 'sec_getInheritedSecurityForEntity'
GO

insert into GXDBVersions values(2, 'sec_getInheritedSecurityForEntity',  '00000000000000000000', 'sec_getInheritedSecurityForEntity', '00000000000000000000')
GO

