

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getIdaObjectsForUserV2.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_getIdaObjectsForUserV2.sp"
--	|	Description: Fetches list of clients, with capability bit mask that user has rights on.
--	|	Author: jswaminathan
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getIdaObjectsForUserV2')
BEGIN
	print '>>> Drop Stored Procedure: sec_getIdaObjectsForUserV2 <<<'
	drop procedure sec_getIdaObjectsForUserV2
END
IF EXISTS (select * from GxQscripts where name='sec_getIdaObjectsForUserV2')
	delete from GxQscripts where name = 'sec_getIdaObjectsForUserV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getIdaObjectsForUserV2')
	delete from GXDBVersions where aliasname = 'sec_getIdaObjectsForUserV2'
GO
print '... Creating Procedure: sec_getIdaObjectsForUserV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getIdaObjectsForUserV2
--Inputs
  @userId INT, 
  @entityTypeReq INT			
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @dynamicSQLStr VARCHAR(MAX) = ''
	-- Input
	--DECLARE @userID INT = 1
	--DECLARE @entityTypeReq INT = 3
	-- Caller should mandatorily pass output table. Else raise exception.
	IF OBJECT_ID('tempdb.dbo.#getIdaObjectsForUserV2OutputTbl') IS NULL
	BEGIN
		RAISERROR('Error. Output table for sec_getIdaObjectsForUserV2 not yet created',
				16,
				1
				 )
		RETURN
	END
	-- Framing user/user group table
	-- Calling helper SP to do this.
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
			DROP TABLE #getMemberUserGroupsHelperOutputTbl
		CREATE TABLE #getMemberUserGroupsHelperOutputTbl
		(
			isUser INT,
			userOrGroupId INT,
			UNIQUE CLUSTERED (isUser, userOrGroupId)					-- Performance tuning
		)
		EXEC sec_getMemberUserGroupsHelper @userId
	END
	DECLARE @companyIdOfUser INT = 0
	SET @companyIdOfUser = dbo.AppGetCompanyForUserOrUserGroup(@userId, 1)
IF OBJECT_ID('tempdb.dbo.#validCompaniesOfCompanyUser') IS NOT NULL
    DROP TABLE #validCompaniesOfCompanyUser
CREATE TABLE #validCompaniesOfCompanyUser
    (
        companyId INT NOT NULL
        primary key (companyId)
    )
DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
IF @doNotUseCompanyEntitiesTableForFiltering = 1
BEGIN
	SET @companyIdOfUser = 0
END
IF @companyIdOfUser <> 0
BEGIN
    declare @parentCompanyId int = @companyIdOfUser
        ;with parentCompany as
        (
            select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            union all
            select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select childCompanyId
        from parentCompany
    declare @childCompanyId int = @companyIdOfUser
        ;with childCompany as
        (
            select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
            union all
            select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select parentCompanyId
        from childCompany
    INSERT INTO #validCompaniesOfCompanyUser values (@companyIdOfUser) , (0)   -- Company Id 0 For MSP entities
END
	-- Master users will have all permissions on all clients. So just quit right here with all clients.
	-- Drilling down further (esp. with company inheritance changes from SP13+) is a performance killer for these users.
	DECLARE @masterGroupId INT = dbo.getMasterGroupId()
	IF EXISTS (SELECT 1 FROM #getMemberUserGroupsHelperOutputTbl WHERE isUser = 0 AND userOrGroupId = @masterGroupId)
	BEGIN
		DECLARE @allCapabilitiesBitMask BIGINT = ISNULL((SELECT SUM(CAST(POWER(2.0,id-1)AS BIGINT)) FROM UMPermissions (NOLOCK) WHERE id < 65), 0)
		INSERT INTO #getIdaObjectsForUserV2OutputTbl
            	SELECT id, 0,0,0,0, @allCapabilitiesBitMask
            	FROM APP_Client (NOLOCK)
            	WHERE
                	id > 1
		DROP TABLE #getMemberUserGroupsHelperOutputTbl
		RETURN
	END
	IF OBJECT_ID('tempdb.dbo.#tempOutputTable') IS NOT NULL
		DROP TABLE #tempOutputTable
	CREATE TABLE #tempOutputTable
	(
		entityType INT,
		entityId INT,
		includeAll INT DEFAULT 0,
		appTypeId INT DEFAULT 0,
		instanceId INT DEFAULT 0,
		backupsetID INT DEFAULT 0,
		subclientID INT DEFAULT 0,
		roleId INT,
		permissionId INT,
		capabilities BIGINT
	)
	CREATE CLUSTERED INDEX tempOutputTable_idx1 ON #tempOutputTable(entityType, capabilities)			-- This index is needed for the groupBy statement which uses bitwiseOrV1
																										-- Do not include entityId in the index. It delays the SP by almost 100 seconds !!!
	CREATE NONCLUSTERED INDEX tempOutputTable_idx2 ON #tempOutputTable (entityType) INCLUDE (entityId, roleId, permissionId)
	-- OWner processing
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#ownerEntities') IS NOT NULL
			DROP TABLE #ownerEntities
		CREATE TABLE #ownerEntities
		(
			clientID INT PRIMARY KEY
		)
		INSERT INTO #ownerEntities
			SELECT DISTINCT UMOwners.entityId
			FROM UMOwners
				 INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON UMOwners.isUser = UG.isUser AND UMOwners.userOrGroupId = UG.userOrGroupId
			WHERE
				entityType = 3
		-- Commcell owner role.
		BEGIN
			DECLARE @commcellOwnerRole INT = 0,
					@commcellOwnerRoleCapabilities BIGINT = 0
			SELECT @commcellOwnerRole = roleId				-- Get commcell owner role as variable since this is applicable on all owner clients.
			FROM UMOwnerRoles								-- No need to join on UMOwnerRoles and @ownerEntities again for this.
			WHERE
				entityType = 1 AND entityId = 2
			IF (@commcellOwnerRole <> 0) AND (@commcellOwnerRole IS NOT NULL)
			BEGIN
				SELECT @commcellOwnerRoleCapabilities = capabilitiesBitMask
				FROM UMRoles
				WHERE
					id = @commcellOwnerRole
			END
		END
	END
	-- Collect details about parents for client entity. It is not only client group !!!
	BEGIN
		DECLARE @entityTypeString VARCHAR(128) = '1,3'
		SELECT @entityTypeString = @entityTypeString + ',' + CAST(parentEntityType AS VARCHAR(10))
		FROM App_EntityParentAssociation
		WHERE
			childEntityType = @entityTypeReq
	END
	-- Get applicable roles/permissions for this user, this entity. This will avoid UMRolesWithPermissionsExpanded/UMPermissionEntityTypeMap JOIN on all queries.
	-- Get permissions too in capability bit mask format. So we can do one GROUP BY.
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tempUMRoles') IS NOT NULL
			DROP TABLE #tempUMRoles
		CREATE TABLE #tempUMRoles
		(
			roleID INT,
			permissionId INT,
			capabilities BIGINT DEFAULT 0,
			UNIQUE CLUSTERED (roleId, permissionId)
		)
		SET @dynamicSQLStr = '
		-- This way of getting roles and permissions is faster and has less reads than reading twice for roles and permissions.
		INSERT INTO #tempUMRoles
			SELECT DISTINCT Sec.roleId,
							Sec.permissionID,
							RolesAndPermissions.capabilities
			FROM UMSecurityAssociations Sec
				 INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				 INNER JOIN
					(
						 SELECT R.id AS roleId, 0 AS permissionId, R.capabilitiesBitMask AS capabilities
						 FROM UMRoles R
							 INNER JOIN UMRolesWithPermissionsExpanded RPE
								ON R.id = RPE.roleID
							 INNER JOIN UMPermissionEntityTypeMap PE
								ON PE.permissionId = RPE.permissionId
						 WHERE
							PE.entityType IN (0,' + CAST(@entityTypeReq AS VARCHAR(10)) + ')
							AND R.disabled = 0
						 UNION
						 SELECT 0 AS roleId, permissionId AS permissionId, CASE WHEN permissionId < 64 THEN POWER(2.0,permissionId-1) ELSE 0 END AS capabilities			-- Get permission ID too in bit mask format.
						 FROM UMPermissionEntityTypeMap
						 WHERE
							entityType IN (0,' + CAST(@entityTypeReq AS VARCHAR(10)) + ')
					) RolesAndPermissions
					ON Sec.roleID = RolesAndPermissions.roleId AND Sec.permissionId = RolesAndPermissions.permissionId
			WHERE
				entityType1 IN (' + @entityTypeString + ')'
		-- Executing by dynamic SQL reduces the read count from 19000 to 3500, as compared to putting @entityTypesToExpand in a table variable / temp table and doing a JOIN
		EXEC (@dynamicSQLStr)
	END
	-- Read from security table
	BEGIN
		-- Having a single INSERT statement with multiple SELECT statements joined by a UNION query is faster and gives lesser reads (~250000) as compared to
		-- inserting multiple times into the table (~400000). When we have multiple insert statements, each statement alters the clustered index thereby causing a delay and increasing read count.
		SET @dynamicSQLStr = '
		INSERT INTO #tempOutputTable
			-- Direct client owners.
			SELECT 3,
					Owner.clientId,
					0,0,0,0,0,
					Sec.roleID,
					0,
					R.capabilitiesBitMask
			FROM UMOwnerRoles Sec (NOLOCK)
				INNER JOIN #ownerEntities Owner
					ON (Sec.entityType = 3 AND Sec.entityId = Owner.clientId)
				INNER JOIN UMRoles R (NOLOCK)
					ON R.id = Sec.roleID
			UNION
			-- Client group owner roles.
			SELECT 3,
					Owner.clientId,
					0,0,0,0,0,
					Sec.roleID,
					0,
					R.capabilitiesBitMask
			FROM #ownerEntities Owner
				INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK)
					ON Owner.clientID = CGA.clientId
				INNER JOIN UMOwnerRoles Sec (NOLOCK)
					ON Sec.entityId = CGA.clientGroupId
				INNER JOIN UMRoles R (NOLOCK)
					ON R.id = Sec.roleID
			WHERE
				Sec.entityType = 28
			UNION '
			+ CHAR(10)
			-- Commcell owner role. Honor it only if it is there.
			+ CASE WHEN (@commcellOwnerRole <> 0) AND (@commcellOwnerRole IS NOT NULL)	THEN '
			SELECT 3,
			Owner.clientId,
			0,0,0,0,0,'
			+ CHAR(10)
			+ CAST(@commcellOwnerRole AS VARCHAR(10)) + ','
			+ CHAR(10) + '
			0,'
			+ CHAR(10)
			+ CAST(@commcellOwnerRoleCapabilities AS VARCHAR(32))
			+ CHAR(10)
			+ '
			FROM #ownerEntities Owner
			UNION '
				ELSE ''
			END
			+ CHAR(10)
			+ '
			-- Classic security associations
			SELECT Sec.entityType1,
					Sec.entityId1,
					Sec.includeAll,
					Sec.entityId2,
					Sec.entityId3,
					Sec.entityId4,
					Sec.entityId5,
					Sec.roleId,
					Sec.permissionId,
					R.capabilities
			FROM UMSecurityAssociations Sec (NOLOCK)
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN #tempUMRoles R
					ON Sec.roleID = R.roleID AND Sec.permissionId = R.permissionId
			WHERE
				entityType1 IN (1,' + CAST(@entityTypeReq AS VARCHAR(10)) + ')				-- This is direct association / commcell.
AND entityId2 <> 1030'							-- We need to exclude subclient policies in this client list.
			+ CHAR(10)
			+ (SELECT '
			UNION'
            + CHAR(10)
			-- Reading individual times for individual parent type (like once for company, once for client group) gives a better performance.
			-- If we combine all parent entity types together in a single UNION we end up losing the advantage of index of parent entity table.
			-- App_ClientGroupAssoc table has ~70000 rows. When querying security table for only client group entities, it filters and gets only those entries
			-- to which this given user / group has association. If we combine both client group and company together in a single UNION and query security table,
			-- it reads all the 70000 rows in APp_ClientGroupAssoc even if user is associated to few client groups.
            + '
			-- Direct parent associations
			SELECT 3, Tbl.childId, 0,0,0,0,0, Sec.roleId, Sec.permissionId, R.capabilities
			FROM UMSecurityAssociations Sec (NOLOCK)
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN #tempUMRoles R
					ON Sec.roleID = R.roleID AND Sec.permissionId = R.permissionId
				INNER JOIN
							( '
							+ CHAR(10)
							+ CAST(associationQuery AS VARCHAR(MAX))
							+ CHAR(10)
							+ '
							) Tbl
					ON Sec.entityId1 = Tbl.parentId
			WHERE
				Sec.entityType1 = ' + CAST(PE.parentEntityType AS VARCHAR(10))
			+ CHAR(10)
			+ '
			-- Include all parent associations (Including it in the above query with a OR in ON delays the code.)
			UNION
			SELECT 3, Tbl.childId, 0,0,0,0,0, Sec.roleId, Sec.permissionId, R.capabilities
			FROM UMSecurityAssociations Sec (NOLOCK)
				INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
					ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
				INNER JOIN #tempUMRoles R
					ON Sec.roleID = R.roleID AND Sec.permissionId = R.permissionId
				INNER JOIN
							( '
							+ CHAR(10)
							+ CAST(associationQuery AS VARCHAR(MAX))
							+ CHAR(10)
							+ '
							) Tbl
					ON Sec.includeAll = 1
			WHERE
				Sec.entityType1 = ' + CAST(PE.parentEntityType AS VARCHAR(10))
			+ CHAR(10)
            FROM App_EntityParentAssociation PE	(NOLOCK)	-- match to SELECT clause
            WHERE
                childEntityType = @entityTypeReq
            FOR XML PATH (''), TYPE
            ).value('.','NVARCHAR(MAX)')               -- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
		EXEC (@dynamicSQLStr)
	END
	-- VSA Subclients expansion.
	-- We already have list of clients,appType,instance,backupset and subclient. Now just expand the "VSA hypervisor entities" out of them into their respective VM clients.
	-- If you have rights on entire hypervisor client, then you have rights on all the VMs backed up using that hypervisor client.
	-- If you have rights on only one hypervisor subclient, then you have rights on just the VMs backed up using that hypervisor subclient.
	-- This code piece takes care of expanding these details.
	BEGIN
		INSERT INTO #tempOutputTable (entityType, entityId, roleId, permissionId, capabilities)
SELECT 3, CP.componentNameId, OT.roleId, OT.permissionId, OT.capabilities
			FROM #tempOutputTable OT
				INNER JOIN APP_Application A
					ON OT.entityId = A.clientID
					AND (OT.appTypeId = 0 OR OT.appTypeId = A.appTypeId)
					AND (OT.instanceID = 0 OR OT.instanceID = A.instance)
					AND (OT.backupsetID = 0 OR OT.backupsetID = A.backupSet)
					AND (OT.subclientID = 0 OR OT.subclientID = A.id)
				INNER JOIN APP_ClientProp CP
ON CP.attrName = 'Last Backup Subclient'
					AND CAST(CP.attrVal AS INT) = A.id
					AND CP.modified = 0
			WHERE
A.appTypeId = 106
	END
	-- Roll up capabilities into capabilitiesBitMask.
	DECLARE @commcellCapBitMask BIGINT = 0
	DECLARE @commcellRowExist BIT = 0
	SELECT @commcellRowExist = 1,
		   @commcellCapBitMask |= capabilities
	FROM #tempOutputTable T
	WHERE
entityType = 1 OR (entityType = 3 AND includeAll = 1)
	IF @companyIdOfUser <> 0
	BEGIN
		INSERT INTO #getIdaObjectsForUserV2OutputTbl
		SELECT T1.entityId,
			   T1.appTypeId,
			   T1.instanceId,
			   T1.backupsetId,
			   T1.subclientId,
			   SUM(DISTINCT T2.value)
		FROM #tempOutputTable T1
		LEFT JOIN App_CompanyEntities App
On App.entityType = 3 AND App.entityId = T1.entityId
		LEFT JOIN #validCompaniesOfCompanyUser C
		On C.companyId = App.companyId
			CROSS APPLY dbo.bitwiseOrV1(T1.capabilities) T2
		WHERE
			(App.entityId is NULL Or C.companyId = App.companyId) AND
			T1.entityType = 3 AND includeAll = 0					-- Explicit client entries
		GROUP BY T1.entityId, appTypeId, instanceId, backupsetId, subclientId
	END
	ELSE
	BEGIN
		INSERT INTO #getIdaObjectsForUserV2OutputTbl
        	SELECT T1.entityId,
               		T1.appTypeId,
               		T1.instanceId,
               		T1.backupsetId,
               		T1.subclientId,
               		SUM(DISTINCT T2.value)
        		FROM #tempOutputTable T1
            			CROSS APPLY dbo.bitwiseOrV1(T1.capabilities) T2
        		WHERE
            		entityType = 3 AND includeAll = 0                   -- Explicit client entries
        		GROUP BY entityId, appTypeId, instanceId, backupsetId, subclientId
	END
	IF @commcellRowExist = 1
	BEGIN
		IF @commcellCapBitMask <> 0
		BEGIN
			UPDATE #getIdaObjectsForUserV2OutputTbl
			SET capabilities = capabilities | @commcellCapBitMask
		END
		IF @companyIdOfUser <> 0
		BEGIN
			INSERT INTO #getIdaObjectsForUserV2OutputTbl
			SELECT C.id,0,0,0,0,@commcellCapBitMask
			FROM APP_Client C
			LEFT JOIN App_CompanyEntities App
On App.entityType = 3 AND App.entityId = C.id
			LEFT JOIN #validCompaniesOfCompanyUser Comp
			On Comp.companyId = App.companyId
			WHERE NOT EXISTS (SELECT 1 FROM #getIdaObjectsForUserV2OutputTbl WHERE clientId = C.id)
				AND C.id <> 1 AND (App.entityId is NULL Or Comp.companyId = App.companyId)
		END
		ELSE
		BEGIN
			INSERT INTO #getIdaObjectsForUserV2OutputTbl
            		SELECT C.id,0,0,0,0,@commcellCapBitMask
            		FROM APP_Client C
            		WHERE NOT EXISTS (SELECT 1 FROM #getIdaObjectsForUserV2OutputTbl WHERE clientId = C.id)
                		AND C.id <> 1
		END
	END
	DROP TABLE #getMemberUserGroupsHelperOutputTbl
	DROP TABLE #tempUMRoles
	DROP TABLE #tempOutputTable
	--SELECT *
	--FROM #getIdaObjectsForUserV2OutputTbl
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getIdaObjectsForUserV2')
	delete from GxQscripts where name = 'sec_getIdaObjectsForUserV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getIdaObjectsForUserV2')
	delete from GXDBVersions where aliasname = 'sec_getIdaObjectsForUserV2'
GO

insert into GXDBVersions values(2, 'sec_getIdaObjectsForUserV2',  '00000000000000000000', 'sec_getIdaObjectsForUserV2', '00000000000000000000')
GO

