

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getIdaObjectsForUser.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_getIdaObjectsForThisUser.sp"
--	|	Description:
--	|   The previous contents of this file is moved to sec_getIdaObjectsForUserOld.sp
--	|	For a given user fetches the list of entity Ids of the requested entity type
--	|	If permission Id is set to 0, then will get the list of all associated entities
--	|	(does not care about permission, this case is called when we just want to get the list of entities that user can view)
--	|	If permission Id is not set to 0, then will get the list of all associated entities with given permission on it
--	|	If inherit from children is set to 1, then if the permission is present at any child level, will get that also
--	|	Author: saggarwal & jswaminathan
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getIdaObjectsForUser')
BEGIN
	print '>>> Drop Stored Procedure: sec_getIdaObjectsForUser <<<'
	drop procedure sec_getIdaObjectsForUser
END
IF EXISTS (select * from GxQscripts where name='sec_getIdaObjectsForUser')
	delete from GxQscripts where name = 'sec_getIdaObjectsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getIdaObjectsForUser')
	delete from GXDBVersions where aliasname = 'sec_getIdaObjectsForUser'
GO
print '... Creating Procedure: sec_getIdaObjectsForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getIdaObjectsForUser
--Inputs
  @userId INT, 
  @entityTypeReq INT,			
  @permissionId INT,			
  @inheritFromChildren INT,
  @tableOutput NVARCHAR(MAX),
  @includeNotMappedPermission INT =0,
  @permissionList NVARCHAR(MAX)='',
  @isAndOperation INT=0
AS
BEGIN TRY
		exec dbo.sec_getIdaObjectsForUserOld @userId,@entityTypeReq,@permissionId,@inheritFromChildren,@tableOutput,@includeNotMappedPermission,@permissionList,@isAndOperation
END try
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	THROW;
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getIdaObjectsForUser')
	delete from GxQscripts where name = 'sec_getIdaObjectsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getIdaObjectsForUser')
	delete from GXDBVersions where aliasname = 'sec_getIdaObjectsForUser'
GO

insert into GXDBVersions values(2, 'sec_getIdaObjectsForUser',  '00000000000000000000', 'sec_getIdaObjectsForUser', '00000000000000000000')
GO

