

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getFailedLoginCountXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_getFailedLoginCountXML"
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getFailedLoginCountXML <<<'

IF EXISTS (select * from sysobjects where name='sec_getFailedLoginCountXML')
	drop procedure sec_getFailedLoginCountXML
IF EXISTS (select * from GxQscripts where name='sec_getFailedLoginCountXML')
	delete from GxQscripts where name = 'sec_getFailedLoginCountXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getFailedLoginCountXML')
	delete from GXDBVersions where aliasname = 'sec_getFailedLoginCountXML'
GO
print '... Creating Procedure: sec_getFailedLoginCountXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getFailedLoginCountXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @userId INT = ISNULL((SELECT ref.value('@userId', 'INT') FROM @i_xmlText.nodes ('App_GetUserFailedLoginAttemptsReq') R(ref)),
                      ISNULL((SELECT id FROM UMUsers WHERE userGuid = (SELECT ref.value('@userGUID', 'VARCHAR(64)')  FROM @i_xmlText.nodes ('App_GetUserFailedLoginAttemptsReq') R(ref))),
                             (SELECT id FROM UMUsers WHERE login    = (SELECT ref.value('@userName', 'VARCHAR(510)') FROM @i_xmlText.nodes ('App_GetUserFailedLoginAttemptsReq') R(ref)))))
DECLARE @loginAttempts INT
DECLARE @modifiedTime  INT
-- -- SP BODY BEGIN : sec_getFailedLoginCount.spb ----------------------------------------------------------------------------------------------------------------------------------
Select @loginAttempts=cast(attrVal as int), @modifiedTime=modified FROM UMUSERSPROP with(nolock) where attrName = 'Failed login attempts' AND componentNameId = @userID AND ISNUMERIC(attrVal) = 1
-- -- SP BODY END : sec_getFailedLoginCount.spb ------------------------------------------------------------------------------------------------------------------------------------
SET @o_xmlText =
(
	SELECT  ISNULL(@loginAttempts, 0)  AS '@loginAttempts',
		    ISNULL(@modifiedTime,  0)  AS '@modifiedTime',
			id						   AS '@userId',
                        userGuid AS '@userGUID',
                        [login]  AS '@userName'
				FROM    UMUsers U
				WHERE   U.id = @userId
	FOR XML PATH('App_GetUserFailedLoginAttemptsResp'), TYPE
)
SELECT @o_xmlText AS [o_xmlText]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getFailedLoginCountXML')
	delete from GxQscripts where name = 'sec_getFailedLoginCountXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getFailedLoginCountXML')
	delete from GXDBVersions where aliasname = 'sec_getFailedLoginCountXML'
GO

insert into GXDBVersions values(2, 'sec_getFailedLoginCountXML',  '00000000000000000000', 'sec_getFailedLoginCountXML', '00000000000000000000')
GO

