

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getEntityTypeAndNameFromEntityTypeHierarchy.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-
--
--  Returns a combination of [entityType]-[entityName] based on the given entity type by querying
--  the corresponding entity table based on entityType (this info will be fetched from APP_Entity)
--  Mainly used for generating error messages in security layer
--  Authors: saggarwal and jswaminathan
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getEntityTypeAndNameFromEntityTypeHierarchy')
BEGIN
	print '>>> Drop Stored Procedure: sec_getEntityTypeAndNameFromEntityTypeHierarchy <<<'
	drop procedure sec_getEntityTypeAndNameFromEntityTypeHierarchy
END
IF EXISTS (select * from GxQscripts where name='sec_getEntityTypeAndNameFromEntityTypeHierarchy')
	delete from GxQscripts where name = 'sec_getEntityTypeAndNameFromEntityTypeHierarchy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getEntityTypeAndNameFromEntityTypeHierarchy')
	delete from GXDBVersions where aliasname = 'sec_getEntityTypeAndNameFromEntityTypeHierarchy'
GO
print '... Creating Procedure: sec_getEntityTypeAndNameFromEntityTypeHierarchy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getEntityTypeAndNameFromEntityTypeHierarchy
  @entityString NVARCHAR(MAX) OUTPUT,
  @localeId INT,
  @entityType1 INT, 
  @entityID1 INT, 
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0,
  @shouldSelectOutput INT = 0
AS
	--Inputs
	--DECLARE @entityType1 INT = 3
	--DECLARE @entityID1 INT = 2
	--DECLARE @entityType2 INT = 4
	--DECLARE @entityId2 INT = 33
	--DECLARE @entityType3 INT = 5
	--DECLARE @entityId3 INT = 1
	--DECLARE @entityType4 INT = 6
	--DECLARE @entityId4 INT = 3
	--DECLARE @entityType5 INT = 7
	--DECLARE @entityId5 INT = 2
  DECLARE @outputString NVARCHAR(MAX) = ''
	DECLARE @sqlString NVARCHAR(MAX) = ''
	SET @entityString  = ''
	DECLARE @entityTypeName NVARCHAR (MAX) = ''
	DECLARE @entityName NVARCHAR(MAX) = ''
	DECLARE @paramDef NVARCHAR(MAX)
	SET @paramDef = N'@entityName1 NVARCHAR(MAX) OUTPUT'
	--SELECT name FROM APP_CLient WHERE id = @entityId1
	DECLARE @tableName VARCHAR(1024) = ''
			,@entityNameColName VARCHAR(1024) = ''
			,@idColName VARCHAR(1024) = ''
	SELECT @tableName = tableName							-- App_Client
		   ,@entityNameColName = entityNameColName			-- name		(App_Client::name)
		   ,@idColName = idColName							-- id		(App_Client::id)
		   ,@entityTypeName = CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END
	FROM APP_Entity (NOLOCK)
	WHERE entityType = @entityType1
	IF @tableName IS NOT NULL AND @tableName <> '' AND @entityNameColName IS NOT NULL AND @entityNameColName <> '' AND @idColName IS NOT NULL AND @idColName <> ''
	BEGIN				-- Some entities like AppStudio does not have a table to look into. Avoid a SQL exception due to mis constructed dynamic SQL in those cases.
		SELECT @sqlString = 'SELECT TOP 1 @entityName1 = ' + @entityNameColName + ' FROM ' + @tableName + ' (NOLOCK) WHERE ' + @idColName + ' = ' + CAST(@entityId1 AS NVARCHAR(MAX))
		EXEC sp_executesql @sqlString, @paramDef, @entityName1 = @entityName OUTPUT
		SELECT @entityString = @entityString + '[' + @entityTypeName + ']' + '-' + '[' + @entityName + ']'
	END
	ELSE
	BEGIN
		SELECT @entityString = '[' + @entityTypeName + ']'
	END
	IF @entityType2 <> 0
	BEGIN
		SELECT @entityTypeName = CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END,
			   @sqlString = 'SELECT TOP 1 @entityName1 = ' + entityNameColName + ' FROM ' + tableName + ' (NOLOCK) WHERE ' + idColName + ' = ' + CAST(@entityId2 AS NVARCHAR(MAX))
		FROM APP_Entity
		WHERE entityType = @entityType2
		EXEC sp_executesql @sqlString, @paramDef, @entityName1 = @entityName OUTPUT
		SELECT @entityString = @entityString + '[' + @entityTypeName + ']' + '-' + '[' + @entityName + ']'
	END
	IF @entityType3 <> 0
	BEGIN
		SELECT @entityTypeName = CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END,
			   @sqlString = 'SELECT TOP 1 @entityName1 = ' + entityNameColName + ' FROM ' + tableName + ' (NOLOCK) WHERE ' + idColName + ' = ' + CAST(@entityId3 AS NVARCHAR(MAX))
		FROM APP_Entity
		WHERE entityType = @entityType3
		EXEC sp_executesql @sqlString, @paramDef, @entityName1 = @entityName OUTPUT
		SELECT @entityString = @entityString + '[' + @entityTypeName + ']' + '-' + '[' + @entityName + ']'
	END
	IF @entityType4 <> 0
	BEGIN
		SELECT @entityTypeName = CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END,
		       @sqlString = 'SELECT TOP 1 @entityName1 = ' + entityNameColName + ' FROM ' + tableName + ' (NOLOCK) WHERE ' + idColName + ' = ' + CAST(@entityId4 AS NVARCHAR(MAX))
		FROM APP_Entity
		WHERE entityType = @entityType4
		EXEC sp_executesql @sqlString, @paramDef, @entityName1 = @entityName OUTPUT
		SELECT @entityString = @entityString + '[' + @entityTypeName + ']' + '-' + '[' + @entityName + ']'
	END
	IF @entityType5 <> 0
	BEGIN
		SELECT @entityTypeName = CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END,
		       @sqlString = 'SELECT TOP 1 @entityName1 = ' + entityNameColName + ' FROM ' + tableName + ' (NOLOCK) WHERE ' + idColName + ' = ' + CAST(@entityId5 AS NVARCHAR(MAX))
		FROM APP_Entity
		WHERE entityType = @entityType5
		EXEC sp_executesql @sqlString, @paramDef, @entityName1 = @entityName OUTPUT
		SELECT @entityString = @entityString + '[' + @entityTypeName + ']' + '-' + '[' + @entityName + ']'
	END
	IF @shouldSelectOutput <> 0
		SELECT @entityString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getEntityTypeAndNameFromEntityTypeHierarchy')
	delete from GxQscripts where name = 'sec_getEntityTypeAndNameFromEntityTypeHierarchy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getEntityTypeAndNameFromEntityTypeHierarchy')
	delete from GXDBVersions where aliasname = 'sec_getEntityTypeAndNameFromEntityTypeHierarchy'
GO

insert into GXDBVersions values(2, 'sec_getEntityTypeAndNameFromEntityTypeHierarchy',  '00000000000000000000', 'sec_getEntityTypeAndNameFromEntityTypeHierarchy', '00000000000000000000')
GO

