

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getDM2UserAndGroupListSharingCap.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_getDM2UserAndGroupListSharingCap()
--  | Description:  SP to return Sharing information for DM2 Entities
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getDM2UserAndGroupListSharingCap.sp,v $ $Id: sec_getDM2UserAndGroupListSharingCap.sp,v 1.7.34.4 2018/03/22 03:07:08 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getDM2UserAndGroupListSharingCap <<<'

IF EXISTS (select * from sysobjects where name='sec_getDM2UserAndGroupListSharingCap')
	drop procedure sec_getDM2UserAndGroupListSharingCap
IF EXISTS (select * from GxQscripts where name='sec_getDM2UserAndGroupListSharingCap')
	delete from GxQscripts where name = 'sec_getDM2UserAndGroupListSharingCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getDM2UserAndGroupListSharingCap')
	delete from GXDBVersions where aliasname = 'sec_getDM2UserAndGroupListSharingCap'
GO
print '... Creating Procedure: sec_getDM2UserAndGroupListSharingCap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getDM2UserAndGroupListSharingCap
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer = 0,
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @entityType INT = 0
	DECLARE @entityId   INT = 0
	DECLARE @userGuid   VARCHAR(36)
	DECLARE @localeId     INT = 0
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET	@userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetUserAndGroupListForSharingReq') R(ref)), '')
	SET @entityType = ISNULL(( SELECT ref.value('@entityType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetUserAndGroupListForSharingReq') R ( ref ) ), 0)
	SET @entityId = ISNULL(( SELECT ref.value('@entityId', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetUserAndGroupListForSharingReq') R ( ref ) ), 0)
	SET @localeId = ISNULL(( SELECT ref.value('@localeId', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetUserAndGroupListForSharingReq') R ( ref ) ), 0)
	-- Get the user id from the guid
	IF ( @userGUID IS NOT NULL  AND @userGUID <> '' )
	BEGIN
		SET @userId = ( SELECT id FROM UMUsers WHERE userGuid = @userGUID )
	END
	IF ( @userId = 0 OR @userId IS null )
	BEGIN
			SET @o_errorCode = -1
			SET	@o_errorString = 'User not found or not mentioned'
			GOTO EXIT_ERROR
	END
DECLARE @outputTable TABLE
(
    userId INT DEFAULT 0,
    userName NVARCHAR(MAX) DEFAULT '',
	userGuid nvarchar(512) DEFAULT '',
    userGroupId INT DEFAULT 0,
    userGroupName NVARCHAR(MAX) DEFAULT '',
    externalGroupId INT DEFAULT 0,
    externalGroupName NVARCHAR(MAX) DEFAULT '',
    providerId INT DEFAULT 0,
    providerName NVARCHAR(MAX) DEFAULT ''  ,
	capabilityBitMask bigint
)
IF(dbo.isNewSecurity()=0)
BEGIN
	INSERT INTO @outputTable
	SELECT id , login, userGuid '@userGuid',0,'',0,'',0,'' , UUG.capabilities
	FROM UMUsers UU INNER JOIN UMUserandGroupEntityAssociation UUG ON UU.id = UUG.userId
	WHERE  UUG.ownerUserId = @userId
		AND UUG.entityType = @entityType
		AND ( UUG.objectId = @entityId OR UUG.objectId = -10 )
	UNION
	SELECT  0,'','',id , name,0,'',0,'' , UUG.capabilities
	FROM UMGroups UG INNER JOIN UMUserandGroupEntityAssociation UUG ON UG.id = UUG.groupId AND UUG.providerId = 0
	WHERE  UUG.ownerUserId = @userId
	AND UUG.entityType = @entityType
	AND ( UUG.objectId = @entityId OR UUG.objectId = -10 )
    UNION
	SELECT 0,'','',0,'',UG.id , UP.domainName + '\' + UG.name , umdsProviderId  ,'',UUG.capabilities
	FROM UMDSgroups UG INNER JOIN UMDSProviders UP ON UG.umdsProviderId = UP.id
							INNER JOIN UMUserandGroupEntityAssociation UUG ON UUG.groupId = UG.id AND UUG.providerId = UG.umdsProviderId
	WHERE  UUG.ownerUserId = @userId
					AND UUG.entityType = @entityType
					AND ( UUG.objectId = @entityId OR UUG.objectId = -10 )
END
ELSE
BEGIN
	DECLARE @getNewProtcolXMl XML
	DECLARE @CventityType INTEGER=dbo.sec_ObjectTypeToEntitytype(@entitytype)
	EXEC sec_getSecurityForEntity @userId,@getNewProtcolXMl  OUTPUT,@CventityType,@entityId
	INSERT INTO @outputTable(userId , userName,userGroupId, userGroupName,externalGroupId,externalGroupName, providerId,providerName,capabilityBitMask)
	SELECT userId,userName,userGroupId,userGroupName,externalGroupId,CASE WHEN externalGroupName <>'' AND providerName <>''
																		  THEN providerName +'\'+externalGroupName
																		  ELSE '' END,
			providerId,providerName,SUM(POWER(2.0,perm-1))
	FROM
    ( SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0) as userId,
               ISNULL(UG.value('(@userName)[1]', 'NVARCHAR(MAX)'), N'') as userName,
               ISNULL(UG.value('(@userGroupId)[1]', 'INT'), 0) as userGroupId,
               ISNULL(UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)'), N'') as userGroupName,
               ISNULL(UG.value('(@groupId)[1]', 'INT'), 0) as externalGroupId,
               ISNULL(UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)'), N'') as externalGroupName,
               ISNULL(UG.value('(@providerId)[1]', 'INT'), 0) as providerId,
               ISNULL(UG.value('(@providerDomainName)[1]', 'NVARCHAR(MAX)'), N'') as providerName  ,
                ISNULL(P.value('(@permissionId)[1]', 'INT'), 0) as perm
        FROM @getNewProtcolXMl.nodes('associations/userOrGroup') AS Input(UG)
        CROSS APPLY
        Input.UG.nodes('../properties/categoryPermission/categoriesPermissionList') AS Permissions(P) ) T
		WHERE perm <64
		GROUP BY userId,userName,userGroupId,userGroupName,externalGroupId,externalGroupName,providerId,providerName
  UPDATE TBL
  SET TBL.userGuid =u.userGUID
  FROM UMUSers u JOIN @outputTable TBL ON TBL.userId<>0 and TBL.userId=id
  UPDATE Tbl
  SET Tbl.userGroupId = 0, Tbl.userGroupName = N'', Tbl.externalGroupId = G.id, Tbl.externalGroupName = P.domainName + '\' + G.name, Tbl.providerId = G.umdsProviderID, Tbl.providerName = P.domainName
  FROM @outputTable Tbl INNER JOIN UMGroups G ON Tbl.userGroupId = G.id
						INNER JOIN UMDSProviders P ON P.id = G.umdsProviderID
  WHERE Tbl.userGroupId <> 0 AND G.umdsProviderId > 0
END
	-- Fetch the user list
		SET @o_xmlText =
		(
		-- Get the list of users, usergroups and external groups with their sharing rights
		SELECT (SELECT
				(
				SELECT userId '@userId', userName '@userName', userGuid '@userGuid' , capabilityBitMask '@capabilities'
				FROM @outputTable
				WHERE userId<>0
				FOR XML PATH('userDetailsAndCapabilities'), TYPE
				),
				(
				SELECT userGroupId '@groupId', userGroupName '@groupName' , capabilityBitMask '@capabilities'
				FROM @outputTable
				WHERE userGroupId<>0
				FOR XML PATH('userGroupDetailsAndCapabilities'), TYPE
				),
				(
				SELECT externalGroupId '@groupId', providerId '@providerId' , externalGroupName as '@groupName', capabilityBitMask '@capabilities'
				FROM @outputTable
				WHERE externalGroupId<>0
				FOR XML PATH('externalGroupDetailsAndCapabilities'), TYPE
				)
				FOR XML PATH('shareUserAndGroupCapabilityList'), TYPE
			),
			-- Get the list of supported capabilities for the entity type, here the locale also needs to be passed
			(
				SELECT UC.id '@capabilityId',dbo.sec_getLocalizedPermission(UC.id,@localeId)  '@capabilityName'
				FROM UMDM2EntityCapability DMC INNER JOIN UMPermissions UC ON DMC.capabilityId = UC.id
				WHERE DMC.entityType = @entityType
				FOR XML PATH('capabilities'), TYPE
			)
			FOR XML PATH(''), ROOT('DM2ContentIndexing_GetUserAndGroupListForSharingResp')
		)
		SELECT @o_xmlText
EXIT_ERROR:
	if(@o_errorCode <> 0)
	BEGIN
		SELECT	@o_errorCode			as 'errList/@errorCode',
				@o_errorString			as 'errList/@errLogMessage'
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GenericResp')
    END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getDM2UserAndGroupListSharingCap')
	delete from GxQscripts where name = 'sec_getDM2UserAndGroupListSharingCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getDM2UserAndGroupListSharingCap')
	delete from GXDBVersions where aliasname = 'sec_getDM2UserAndGroupListSharingCap'
GO

insert into GXDBVersions values(2, 'sec_getDM2UserAndGroupListSharingCap',  '00010007003400040000', 'sec_getDM2UserAndGroupListSharingCap', '00010007003400040000')
GO

