

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getCreatorNameAndIdForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_getCreatorNameAndIdForEntity
--  |
--  | Description:  getting creator userId / userGroupID for any entity
--  |
--  |
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getCreatorNameAndIdForEntity <<<'

IF EXISTS (select * from sysobjects where name='sec_getCreatorNameAndIdForEntity')
	drop procedure sec_getCreatorNameAndIdForEntity
IF EXISTS (select * from GxQscripts where name='sec_getCreatorNameAndIdForEntity')
	delete from GxQscripts where name = 'sec_getCreatorNameAndIdForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreatorNameAndIdForEntity')
	delete from GXDBVersions where aliasname = 'sec_getCreatorNameAndIdForEntity'
GO
print '... Creating Procedure: sec_getCreatorNameAndIdForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getCreatorNameAndIdForEntity
  @creatorUserId INT OUTPUT,
  @creatorName VARCHAR(1024) OUTPUT,
  @isUser INT OUTPUT,
  @returnCursor INT,
  @entityType1 INT,							
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0
AS
  DECLARE @creatorUserIdOutputSelect INT = 0
  DECLARE @creatorUserGroupIdOutputSelect INT = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT TOP 1 @creatorUserId = userOrGroupId ,
			 @isUser = isUser
FROM UMSecurityAssociations WITH(NOLOCK)
WHERE entityType1 = @entityType1 AND entityId1 = @entityId1
								AND entityType2 = @entityType2 AND entityId2 = @entityId2
								AND entityType3 = @entityType3 AND entityId3 = @entityId3
								AND entityType4 = @entityType4 AND entityId4 = @entityId4
								AND entityType5 = @entityType5 AND entityId5 = @entityId5
								AND isCreator = 1
IF(@isUser=1)
BEGIN
	SET @creatorName =(SELECT login FROM UMUSERS WHERE id=@creatorUserId)
END
ELSE
BEGIN
	 SET @creatorName = (SELECT  CASE WHEN G.umdsProviderID = 0 THEN G.name ELSE P.domainName + '\' + G.name END
                           FROM UMGroups G WITH(NOLOCK) LEFT OUTER JOIN UMDSProviders P WITH (NOLOCK)
                           ON G.umdsProviderID = P.id
                           WHERE G.id = @creatorUserId)
END
IF @returnCursor <> 0
	SELECT @creatorUserId, @creatorName,@isUser
EXIT_PROC:
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getCreatorNameAndIdForEntity')
	delete from GxQscripts where name = 'sec_getCreatorNameAndIdForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreatorNameAndIdForEntity')
	delete from GXDBVersions where aliasname = 'sec_getCreatorNameAndIdForEntity'
GO

insert into GXDBVersions values(2, 'sec_getCreatorNameAndIdForEntity',  '00000000000000000000', 'sec_getCreatorNameAndIdForEntity', '00000000000000000000')
GO

