

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getCreateUpdateUserEmailSettings.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCreateCompanyEmailSetting
--  | Description:  This will get email related settings for create user or password is modified for the user
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getCreateUpdateUserEmailSettings.sp,v $ $Id: sec_getCreateUpdateUserEmailSettings.sp,v 1.1.2.8 2020/04/30 22:28:35 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getCreateUpdateUserEmailSettings')
BEGIN
	print '>>> Drop Stored Procedure: sec_getCreateUpdateUserEmailSettings <<<'
	drop procedure sec_getCreateUpdateUserEmailSettings
END
IF EXISTS (select * from GxQscripts where name='sec_getCreateUpdateUserEmailSettings')
	delete from GxQscripts where name = 'sec_getCreateUpdateUserEmailSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreateUpdateUserEmailSettings')
	delete from GXDBVersions where aliasname = 'sec_getCreateUpdateUserEmailSettings'
GO
print '... Creating Procedure: sec_getCreateUpdateUserEmailSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getCreateUpdateUserEmailSettings
  @i_operationType INTEGER,
  @i_pwdOperationType INTEGER,
  @i_haveToSendEmail INTEGER,
  @i_userId INTEGER,
  @i_pwd NVARCHAR(400),
  @i_localeId INT
AS
  DECLARE @sendEmail INTEGER
  DECLARE @userEmailSettings XML
  DECLARE @EmailBody NVARCHAR(MAX)
  DECLARE @EmailSub NVARCHAR(MAX)
  DECLARE @errorCode INT
DECLARE @WebConsoleURL NVARCHAR(MAX)
DECLARE @adminEmail NVARCHAR(510)
DECLARE @adminConsoleURL NVARCHAR(MAX)
DECLARE @EmailTitle nvarchar(255) = ''
DECLARE @templateTypeId int
DECLARE @companyName NVARCHAR(255) = ''
DECLARE @EmailFooter nvarchar(500) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
--Decide if email has to be sent
IF(@i_haveToSendEmail = 1)
	SET @sendEmail = 1
ELSE
BEGIN
	IF(@i_operationType = 1)--OperationType_ADD
	BEGIN
		SET @sendEmail = ISNULL((SELECT value FROM GXGlobalParam WHERE name ='SendEmailForUserCreation'  AND modified=0) , 0)--SEND_EMAIL_FOR_USER_CREATION, SendEmailForUserCreation
	END
	ELSE IF(@i_operationType = 3) --OperationType_MODIFY
	BEGIN
		IF(@i_pwdOperationType = 2 )--App::PasswordOperationType_CHANGE_PWD
		BEGIN
			SET @sendEmail = ISNULL((SELECT value FROM GXGlobalParam WHERE name ='SendEmailForUserPasswordModification'  AND modified=0) , 0)--SEND_EMAIL_FOR_USER_PASSWORD_MODIFICATION, SendEmailForUserPasswordModification
		END
	END
END
IF(@sendEmail =1)
BEGIN
	SET @companyName = (SELECT dbo.AppGetOrganizationNameForUser(@i_userId))
	SELECT @templateTypeId=typeId from App_EmailTemplateType where name='INVITE_USER'
	DECLARE @email nvarchar(255)
	DECLARE @name nvarchar(255)
	DECLARE @login nvarchar(255)
	DECLARE @serviceType int
	DECLARE @adminName NVARCHAR(510)
SELECT @adminEmail=email, @adminName=name FROM umusers WHERE flags & 0x040  <> 0
	SELECT @email=email, @name=name, @login=u.login, @serviceType=serviceType FROM umusers u INNER JOIN UMDSProviders p ON p.id=U.umdsproviderId WHERE u.id=@i_userId
	if(@name is null OR @name ='')
		SET @name = @login
	IF object_id('tempdb.dbo.#tempGXGlobalParamObjects') IS NOT Null DROP TABLE #tempGXGlobalParamObjects
	CREATE TABLE #tempGXGlobalParamObjects(name nvarchar(max), val nvarchar(max))
	DECLARE @strEmailTemplate   NVARCHAR(MAX) = '<!doctype html><html><head/><body><div style="width: 600px;padding: 0;margin: 0 auto;text-align: center;text-align:-moz-center; text-align:-webkit-center;border:0;"><table border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff" width="600" style="color: #666;background: #ffffff;width: 600px;border:0;"><tbody><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.5em;line-height: 1.25em;text-align: left;padding: 0;margin:0;"><p style="font-family: Helvetica, Arial, sans-serif;font-size: 1.5em; margin: 0;padding:0;text-transform: uppercase;font-weight: bold;">commvault</p><hr width="100%" noshade="noshade" size="1" color="#666666" style="height: 1px;" /></td></tr><tr><td>&nbsp;</td></tr><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.85em;line-height: 1.25em;text-align: left;padding: 0;margin:0;"><p style="margin: 0;padding:0;">$MESSAGE_TITLE</p></td></tr><tr><td>&nbsp;</td></tr><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-size: 1em;line-height: 1.2em;text-align: left;font-family: Helvetica, Arial, sans-serif;"><p>$MESSAGE_CONTENT<hr width="100%" noshade="noshade" size="1" color="#666666" style="height: 1px;" /><span style="font-size:75%;"><br >$PROBLEM</span></p></td></tr></tbody></table></div></body></html>'
	SET @strEmailTemplate = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'WebserverEmailMessageTemplate' AND modified = 0), @strEmailTemplate)
	--Form create user email
	IF(@i_operationType = 1)--OperationType_ADD
	BEGIN
		--Create a reset password link, this is change in email template
		DECLARE @passwordLink NVARCHAR(max) = ''
		DECLARE @sessionid VARCHAR(255)
		DECLARE @qsdkSessionId  VARCHAR(255)
		DECLARE @sessionTable TABLE (errorCode       int, guidOut         VARCHAR(255))
DECLARE @timeoutInMins int = ISNULL((SELECT CAST(value as int) from GXGlobalParam WITH (NOLOCK) WHERE name = 'ChangePasswordLinkExpirationTimeInMinutes'), 4320)--72 hours
		DECLARE @timeoutInHoursMins nvarchar(50)=''
IF(@serviceType = 1 OR @serviceType= 5)
		BEGIN
			SET @timeoutInHoursMins = (SELECT dbo.AppGetTimeOutFormatedString(@timeoutInMins, @i_localeId))
		END
		INSERT INTO @sessionTable
		EXEC QSDK_CreateSession @sessionid,@i_userId, '',16, @timeoutInMins-- EC_API
		IF((SELECT errorCode FROM @sessionTable) <> 0)
		BEGIN
SET @errorCode = (3344 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_END
		END
		SET @qsdkSessionId = (SELECT guidOut FROM @sessionTable)
		DECLARE @encryptedSessionId nvarchar(max)
		EXEC dbo.pswEncryptionManaged @qsdkSessionId , @encryptedSessionId OUTPUT
		--for backward compatibility set the password
		DECLARE @DecrptPwd NVARCHAR(400)
		EXEC miscProc2 @i_pwd,@DecrptPwd  OUTPUT
		INSERT INTO #tempGXGlobalParamObjects
		SELECT name, value from GXGlobalParam where name in ('WebConsoleURL', 'EmailTemplateForUserCreation', 'EmailSubjectForUserCreation') AND modified=0 --EMAIL_TEMPLATE_FOR_USER_CREATION,EMAIL_SUBJECT_FOR_USER_CREATION
		SELECT @WebConsoleURL=val FROM #tempGXGlobalParamObjects WHERE name='WebConsoleURL'
		SELECT @EmailBody=val FROM #tempGXGlobalParamObjects WHERE name='EmailTemplateForUserCreation'
		SET @adminConsoleURL = (SELECT SUBSTRING(@webConsoleURL, 1, (CHARINDEX('webconsole', @webConsoleURL) - 1)) + 'adminconsole')
		SET @passwordLink = (SELECT SUBSTRING(@webConsoleURL, 1, (CHARINDEX('/webconsole', @webConsoleURL) - 1)) + '/webconsole')
		SET @passwordLink = @passwordLink + '/login/resetPassword.jsp?app=1&tk=' + @encryptedSessionId;
		SELECT @userEmailSettings = (SELECT @templateTypeId as '@templateTypeId'
		, (SELECT 'RECIPIENT_NAME' as '@name', @name as '@value' for xml path('tokenValues'), type)
		, (SELECT 'COMPANY_NAME' as '@name', @companyName as '@value' for xml path('tokenValues'), type)
		, (SELECT 'ADMINCONSOLE_URL' as '@name', @adminConsoleURL as '@value' for xml path('tokenValues'), type)
		, (SELECT 'USERNAME' as '@name', @email as '@value' for xml path('tokenValues'), type)
, CASE WHEN @serviceType = 1 OR @serviceType= 5 THEN (SELECT 'PASSWORD' as '@name', @DecrptPwd as '@value' for xml path('tokenValues'), type) END
, CASE WHEN @serviceType = 1 OR @serviceType= 5 THEN (SELECT 'CHANGE_PASSWORD_LINK' as '@name', @passwordLink as '@value' for xml path('tokenValues'), type) END
, CASE WHEN @serviceType = 1 OR @serviceType= 5 THEN (SELECT 'CHANGE_PASSWORD_LINK_EXPIRATION' as '@name', @timeoutInHoursMins as '@value' for xml path('tokenValues'), type) END
		, (SELECT 'ADMINISTRATOR_EMAIL' as '@name', @adminEmail as '@value' for xml path('tokenValues'), type)
		, (SELECT 'ADMINISTRATOR_NAME' as '@name', @adminName as '@value' for xml path('tokenValues'), type)
		,(SELECT @email as '@val' for xml path('toEmails'), type)
		FOR XML PATH('Api_SendEmailTemplateMailRequest'))
		--for backward compatibility
		if(@EmailBody is null)
		BEGIN
SET @EmailBody = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3457 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)--(3380 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @EmailBody = REPLACE(@EmailBody,  '[^1%s]', @name)
			SET @EmailBody = REPLACE(@EmailBody,  '[^2%s]', '<a style="color: #00a3d4; font-family: Verdana, Helvetica, sans-serif;" href="{@LINK}">Admin Console</a>')
			SET @EmailBody = REPLACE(@EmailBody,  '{@LINK}', @adminConsoleURL)
			SET @EmailBody = REPLACE(@EmailBody,  '[^3%s]', @email)
			SET @EmailBody = REPLACE(@EmailBody,  '[^4%s]', @DecrptPwd)
			SET @EmailBody = REPLACE(@EmailBody,  '[^5%s]', @adminEmail)
SET @EmailFooter = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(2773 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)
			SET @EmailFooter =  REPLACE(@EmailFooter, '^2%s', '</a>')
			SET @EmailFooter =  REPLACE(@EmailFooter, '^3%s', ' ')--'<br/>')
			SET @EmailFooter =  REPLACE(@EmailFooter, '^1%s', '<a href="mailto:{@MAILTO}" style="color: #3366ff;">')
			SET @EmailFooter =  REPLACE(@EmailFooter, '{@MAILTO}', @adminEmail)
SET @EmailTitle =  (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3459 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)
		END
		ELSE
		BEGIN
			SET @EmailBody = REPLACE(@EmailBody,  '$NAME', @name)
			SET @EmailBody = REPLACE(@EmailBody,  '$URL', '<a style="color: #00a3d4; font-family: Verdana, Helvetica, sans-serif;" href="{@LINK}">Admin Console</a>')
			SET @EmailBody = REPLACE(@EmailBody,  '{@LINK}', @adminConsoleURL)
			SET @EmailBody = REPLACE(@EmailBody,  '$EMAIL', @email)
			SET @EmailBody = REPLACE(@EmailBody,  '$PASSWORD', @DecrptPwd)
			SET @EmailBody = REPLACE(@EmailBody,  '$ADMIN_EMAIL', @adminEmail)
		END
		SET @EmailBody = REPLACE(@strEmailTemplate,  '$MESSAGE_CONTENT', @EmailBody)
		SET @EmailBody = REPLACE(@EmailBody,  '$MESSAGE_TITLE', @EmailTitle)
		SET @EmailBody = REPLACE(@EmailBody,  '$PROBLEM', @EmailFooter)
		SELECT @EmailSub=val FROM #tempGXGlobalParamObjects WHERE name='CompanyCreateEmailSub'
		IF(@EmailSub is null)
		BEGIN
SET @EmailSub = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3458 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)--(3381 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		END
	END
	--Form update user password email
	ELSE IF(@i_operationType = 3 AND @i_pwdOperationType = 2)--OperationType_MODIFY, App::PasswordOperationType_CHANGE_PWD
	BEGIN
		INSERT INTO #tempGXGlobalParamObjects
		SELECT name, value from GXGlobalParam where name in ('WebConsoleURL', 'EmailSubjectForUserPasswordModification', 'EmailTemplateForUserPasswordModification') AND modified=0 --EMAIL_TEMPLATE_FOR_USER_CREATION,EMAIL_SUBJECT_FOR_USER_CREATION
		SELECT @WebConsoleURL=val FROM #tempGXGlobalParamObjects WHERE name='WebConsoleURL'
		SELECT @EmailBody=val FROM #tempGXGlobalParamObjects WHERE name='EmailTemplateForUserPasswordModification'
		SET @adminConsoleURL = (SELECT SUBSTRING(@webConsoleURL, 1, (CHARINDEX('webconsole', @webConsoleURL) - 1)) + 'adminconsole')
		SELECT @userEmailSettings = (
		SELECT @templateTypeId as '@templateTypeId'
		, (SELECT 'RECEIPIENT_NAME' as '@name', @name as '@value' for xml path('tokenValues'), type)
		, (SELECT 'ADMINISTRATOR_EMAIL' as '@name', @adminEmail as '@value' for xml path('tokenValues'), type)
		, (SELECT 'ADMINISTRATOR_NAME' as '@name', @adminName as '@value' for xml path('tokenValues'), type)
		,(SELECT @email as '@val' for xml path('toEmails'), type)
		FOR XML PATH('Api_SendEmailTemplateMailRequest'))
		--Backward compatibility
		if(@EmailBody is null)
		BEGIN
SET @EmailBody = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3460 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)--(3382 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @EmailBody = REPLACE(@EmailBody,  '[^1%s]', @name)
			SET @EmailBody = REPLACE(@EmailBody,  '[^2%s]', @adminEmail)
SET @EmailFooter = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(2773 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)
			SET @EmailFooter =  REPLACE(@EmailFooter, '^2%s', '</a>')
			SET @EmailFooter =  REPLACE(@EmailFooter, '^3%s', ' ')--'<br/>')
			SET @EmailFooter =  REPLACE(@EmailFooter, '^1%s', '<a href="mailto:{@MAILTO}" style="color: #3366ff;">')
			SET @EmailFooter =  REPLACE(@EmailFooter, '{@MAILTO}', @adminEmail)
SET @EmailTitle =  (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3459 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)
		END
		ELSE
		BEGIN
			SET @EmailBody = REPLACE(@EmailBody,  '$NAME', @name)
			SET @EmailBody = REPLACE(@EmailBody,  '$ADMIN_EMAIL', @adminEmail)
		END
		SET @EmailBody = REPLACE(@strEmailTemplate,  '$MESSAGE_CONTENT', @EmailBody)
		SET @EmailBody = REPLACE(@EmailBody,  '$MESSAGE_TITLE', @EmailTitle)
		SET @EmailBody = REPLACE(@EmailBody,  '$PROBLEM', @EmailFooter)
		SELECT @EmailSub=val FROM #tempGXGlobalParamObjects WHERE name='EmailSubjectForUserPasswordModification'
		IF(@EmailSub is null)
		BEGIN
SET @EmailSub = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3005 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)--(3006 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		END
	END
END
IF object_id('tempdb.dbo.#tempGXGlobalParamObjects') IS NOT Null DROP TABLE #tempGXGlobalParamObjects
PROC_END:
SELECT  @sendEmail,@userEmailSettings,  @EmailBody, @EmailSub, @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getCreateUpdateUserEmailSettings')
	delete from GxQscripts where name = 'sec_getCreateUpdateUserEmailSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreateUpdateUserEmailSettings')
	delete from GXDBVersions where aliasname = 'sec_getCreateUpdateUserEmailSettings'
GO

insert into GXDBVersions values(2, 'sec_getCreateUpdateUserEmailSettings',  '00010001000200080000', 'sec_getCreateUpdateUserEmailSettings', '00010001000200080000')
GO

