

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getCreateAsUserId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--           Stored procedure to get the create as user id for given entity
--           on a given entity.
--
--           If CreateAs is an user group, will get the hidden CreateAs user of
--			 that user group. If he does not exist yet, will create one
--           user for that user group.
--
--           Authors: saggarwal and jswaminathan
-- ----------------------------------------------------------------------*/
--gets the create as user id for given entity
--if CreateAs is an user group, will get the hidden CreateAs user of that user group. If he does not exist yet, will create one
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getCreateAsUserId')
BEGIN
	print '>>> Drop Stored Procedure: sec_getCreateAsUserId <<<'
	drop procedure sec_getCreateAsUserId
END
IF EXISTS (select * from GxQscripts where name='sec_getCreateAsUserId')
	delete from GxQscripts where name = 'sec_getCreateAsUserId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreateAsUserId')
	delete from GXDBVersions where aliasname = 'sec_getCreateAsUserId'
GO
print '... Creating Procedure: sec_getCreateAsUserId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getCreateAsUserId
-- Input arguments
  @entityType INT,
  @entityId INT,
  @createAsUserID INT OUTPUT,
  @returnCursor INT = 0,
  @shouldUpdateUserCredentials INT = 0,
  @userGroupId INT = 0  
--used for schedules which doesnot have entity info and where owner is not set in UMSecurityAssociaions
AS
  DECLARE @outputVariable int 
DECLARE @createAsUserGroupId INT
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @createAsUserID = 0
SET @createAsUserGroupID = 0
IF @entityType = 0 and @entityId = 0 and @userGroupId <> 0
	SET @createAsUserGroupID = @userGroupId
ELSE
	SELECT TOP 1 @createAsUserId = CASE WHEN isUser = 1 THEN userOrGroupId ELSE 0 END,
				 @createAsUserGroupId = CASE WHEN isUser = 0 THEN userOrGroupId ELSE 0 END
	FROM UMSecurityAssociations (NOLOCK)
	WHERE
		entityType1 = @entityType AND entityId1 = @entityId
		AND isCreator = 1
IF @createAsUserId = 0
BEGIN
	IF @createAsUserGroupID > 0
	BEGIN
SET @createAsUserId = ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp (NOLOCK) WHERE componentNameId = @createAsUserGroupId AND attrName = N'Create As User' AND modified = 0), 0)
		-- The system created user Id got removed for some user groups (via StaleCredsCheck for existing customers).
		-- So check once in Users table too if the user is present. If not present there, create one and update the Group table with this new user Id.
		-- This SP gets called during SCG refresh. So during next run, it will insert the new user and correct the DB.
		IF ((@createAsUserId = 0) OR NOT EXISTS (SELECT 1 FROM UMUsers (NOLOCK) WHERE id = @createAsUserID AND enabled = 1))
		BEGIN
			DECLARE @umdsproviderId INT
					,@createAsLoginName NVARCHAR(600)
			-- When user group becomes creator, we create a hidden user. This hidden user needs to have same name as user group. So that on UI it is self explanatory that the
			-- user group owns this entity. Having some complex name like "CreateAs" looks weird and confusing on the UI.
			-- Issue hit us now, because Master group is owner of default schedules created by Admin (SP14). If the owner name is shown as some weird name like CreateAs1, it is confusing.
			-- Showing Master is meaningful.
			SELECT @createAsLoginName = CASE WHEN G.umdsProviderID > 0 THEN P.domainName + '\' + G.name ELSE G.name END
				   ,@umdsProviderId = G.umdsProviderId
			FROM UMGroups G (NOLOCK)
				INNER JOIN UMDSProviders P (NOLOCK)
					ON G.umdsProviderID = P.id
			WHERE
				G.id = @createAsUserGroupID
			--We are not using CreateUserRequest XML message. Instead we are directly inserting into DB. Because CreateUserRequest XML protocol does not allow us to add a local user as a member of external user groups.
			--Even for external groups we will add a local user as a hidden createAs user. There is no harm since this user is going to be hidden anyways.
			IF NOT EXISTS (SELECT 1 FROM UMUsers WHERE login = @createAsLoginName)
				INSERT INTO UMUsers (name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified, pVer, pager, lastLogInTime, credSetTime, umDSproviderId, userGuid, origUserGuid, origCCId)
SELECT @createAsLoginName, N'Create As for user group' + CAST(@createAsUserGroupId AS NVARCHAR(10)), @createAsLoginName, '9' + CAST(NEWID() AS VARCHAR(512)), '', dbo.getunixtime(getutcdate()), 0, 0, 1, 0x800, 0, 50, NULL, 0, 0, @umdsproviderId, NEWID(), '', 2
			ELSE
			BEGIN
				SET @createAsLoginName = @createAsLoginName +' Group'
				IF NOT EXISTS (SELECT 1 FROM UMUsers WHERE login = @createAsLoginName)			-- Very rarely would people name the user as "GroupA group". Still check once for safety.
					INSERT INTO UMUsers (name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified, pVer, pager, lastLogInTime, credSetTime, umDSproviderId, userGuid, origUserGuid, origCCId)
SELECT  @createAsLoginName, N'Create As for user group' + CAST(@createAsUserGroupId AS NVARCHAR(10)), @createAsLoginName, '9' + CAST(NEWID() AS VARCHAR(512)), '', dbo.getunixtime(getutcdate()), 0, 0, 1, 0x800, 0, 50, NULL, 0, 0, @umdsproviderId, NEWID(), '', 2
			END
			SET @createAsUserID = (SELECT id FROM UMUsers WHERE login = @createAsLoginName)
			IF NOT EXISTS (SELECT 1 FROM UMUserGroup WHERE userID = @createAsUserID AND groupId = @createAsUserGroupID)
				INSERT INTO UMUserGroup (userID, groupID, flag)
					SELECT @createASUserId, @createAsUserGroupId, 0		--no need to put in UMDSUserGroup
IF NOT EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @createAsUserGroupId AND attrName = N'Create As User' AND modified = 0)
				INSERT INTO UMGroupsProp (componentNameId, attrName, attrVal, attrType, created, modified)
SELECT @createAsUserGroupId, N'Create As User', CAST(@createAsUserId AS NVARCHAR(10)), 7, dbo.getunixtime(getutcdate()), 0
			ELSE
				UPDATE UMGroupsProp
				SET attrVal = CAST(@createAsUserId AS NVARCHAR(10))
WHERE componentNameId = @createAsUserGroupId AND attrName = N'Create As User' AND modified = 0
		END
	END
END
IF @shouldUpdateUserCredentials = 1 AND @createAsUserId <> 0
	EXEC sec_updateUserCredentials @createAsUserId, 1
IF @returnCursor = 1
	SELECT @createAsUserID
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getCreateAsUserId')
	delete from GxQscripts where name = 'sec_getCreateAsUserId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreateAsUserId')
	delete from GXDBVersions where aliasname = 'sec_getCreateAsUserId'
GO

insert into GXDBVersions values(2, 'sec_getCreateAsUserId',  '00000000000000000000', 'sec_getCreateAsUserId', '00000000000000000000')
GO

