

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getCreateAsUserGroups.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------+
--	| 			Procedure : "sec_getCreateAsUserGroups"
--	|
--	|			Standalone protocol to get list of user groups that can be displayed in Create As window.
--	|			Gets list of user groups that user is member of, in case if logged in user is non-admin.
--	|			Gets all user groups in case logged in user is admin (who has all permissions on commcell).
--	|
--	|			Author: jswaminathan & saggarwal
-- 	+------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getCreateAsUserGroups <<<'

IF EXISTS (select * from sysobjects where name='sec_getCreateAsUserGroups')
	drop procedure sec_getCreateAsUserGroups
IF EXISTS (select * from GxQscripts where name='sec_getCreateAsUserGroups')
	delete from GxQscripts where name = 'sec_getCreateAsUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreateAsUserGroups')
	delete from GXDBVersions where aliasname = 'sec_getCreateAsUserGroups'
GO
print '... Creating Procedure: sec_getCreateAsUserGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getCreateAsUserGroups
  @inputXMLReq XML 
AS
/*set @inputXMLReq = '<App_GetCreateAsUserGroupsReq>
	<processinginstructioninfo>
		<user userId="1" userName="admin"/>
	</processinginstructioninfo>
</App_GetCreateAsUserGroupsReq>'*/
--output
  DECLARE @outputXMLReq XML
/*set @outputXMLReq = '<App_GetCreateAsUserGroupsResp>
	<userGroup userGroupId="1" userGroupName="master" _type_="15"/>
	<userGroup userGroupId="3" userGroupName="View All" _type_="15"/>
	<userGroup userGroupId="4" userGroupName="commvault-nj\Dev-Server" _type_="15"/>
</App_GetCreateAsUserGroupsResp>'*/
DECLARE @userId INT
SET @userId = ISNULL((SELECT ref.value('@userId', 'INT')
			  FROM @inputXMLReq.nodes('App_GetCreateAsUserGroupsReq/processinginstructioninfo/user') r (ref)), 0)
DECLARE @isUserAdmin INT
EXEC sec_checkUserHasAllPermissionsOnEntity @userId, 1, 2, @isUserAdmin OUTPUT
IF OBJECT_ID('tempdb.dbo.#createAsUserGroupsSecurity') IS NOT NULL
	DROP TABLE #createAsUserGroupsSecurity
CREATE TABLE #createAsUserGroupsSecurity (userGroupId int)
exec sec_getUserGroupsForThisUser '#createAsUserGroupsSecurity', @userId
--we should not return hidden user groups, CV_Restricted_Visibility, Outlook Common Addins, etc.
--they will be filtered in #createAsUserGroupSecurity table. No need to duplicate that logic here.
IF @isUserAdmin = 1
BEGIN
	SET @outputXMLReq = (SELECT
							(SELECT G.id AS '@userGroupId',
									CASE WHEN G.umdsProviderId <> 0 THEN P.domainName + '\' + G.name ELSE G.name END AS '@userGroupName',
15 AS '@_type_'			--use macro
							 FROM UMGroups G LEFT OUTER JOIN UMDSProviders P
							 ON G.umdsProviderId = P.id INNER JOIN #createAsUserGroupsSecurity Sec
							 ON Sec.userGroupId = G.id
							 WHERE G.groupFlags & 1 <> 0			--get only enabled groups
							 FOR XML PATH ('userGroup'), TYPE)
						FOR XML PATH (''), ROOT ('App_GetCreateAsUserGroupsResp'))
END
ELSE
BEGIN
	SET @outputXMLReq = ISNULL(
						(SELECT
							(SELECT G.id AS '@userGroupId',
									CASE WHEN G.umdsProviderId <> 0 THEN P.domainName + '\' + G.name ELSE G.name END AS '@userGroupName',
15 AS '@_type_'			--use macro
							 FROM UMGroups G LEFT OUTER JOIN UMDSProviders P
							 ON G.umdsProviderId = P.id INNER JOIN (SELECT groupId AS userGroupId FROM UMUserGroup WHERE userId = @userId
																	UNION
																	SELECT GM.umGroupId AS userGroupId FROM UMDSGroupMaps GM INNER JOIN UMUserGroup UG ON UG.groupId = GM.umdsGroupId AND UG.userId = @userId) MG
							 ON G.id = MG.userGroupId INNER JOIN #createAsUserGroupsSecurity Sec
							 ON Sec.userGroupId = G.id
							 WHERE G.groupFlags & 1 <> 0
							 FOR XML PATH ('userGroup'), TYPE)
						 FOR XML PATH (''), ROOT('App_GetCreateAsUserGroupsResp')),
					   '<App_GetCreateAsUserGroupsResp/>')
END
IF OBJECT_ID('tempdb.dbo.#createAsUserGroupsSecurity') IS NOT NULL
	DROP TABLE #createAsUserGroupsSecurity
SELECT @outputXMLReq
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getCreateAsUserGroups')
	delete from GxQscripts where name = 'sec_getCreateAsUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCreateAsUserGroups')
	delete from GXDBVersions where aliasname = 'sec_getCreateAsUserGroups'
GO

insert into GXDBVersions values(2, 'sec_getCreateAsUserGroups',  '00000000000000000000', 'sec_getCreateAsUserGroups', '00000000000000000000')
GO

