

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getCompanyViewUserDetails.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--  +===================================================================================+
--  |       Name: sec_getCompanyViewUserDetails.sp
--  |       Description: This SP returns the company user which has view role assigned
--  |					for the given company.
--  |                    Output: Company user's Id, name, GUID, host name of original token.
--  |
--  |       Author: sghatbale
--  +===================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getCompanyViewUserDetails')
BEGIN
	print '>>> Drop Stored Procedure: sec_getCompanyViewUserDetails <<<'
	drop procedure sec_getCompanyViewUserDetails
END
IF EXISTS (select * from GxQscripts where name='sec_getCompanyViewUserDetails')
	delete from GxQscripts where name = 'sec_getCompanyViewUserDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCompanyViewUserDetails')
	delete from GXDBVersions where aliasname = 'sec_getCompanyViewUserDetails'
GO
print '... Creating Procedure: sec_getCompanyViewUserDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getCompanyViewUserDetails
  @originalSessionGUID VARCHAR(MAX),
  @companyId INT,
  @localeId INT = 0
AS
  DECLARE @companyUserId INT = 0
  DECLARE @companyUserLogin NVARCHAR(MAX) = ''
  DECLARE @companyUserGUID NVARCHAR(1024) = ''
  DECLARE @companyUserEmail NVARCHAR(MAX) = ''
  DECLARE @originalTokenHostName NVARCHAR(MAX) = ''
  DECLARE @errorCode INT
  DECLARE @errorString VARCHAR(1024) 
SET @errorCode = 0
SET @errorString = ''
BEGIN TRY
	DECLARE @originalUserId INT = 0, @companyUserEnabled INT = 0
	SELECT @originalUserId = userId
		  ,@originalTokenHostName = hostName
	FROM UMQSDKSessions (NOLOCK)
	WHERE
		GUID = @originalSessionGUID
	IF @originalUserId = 0
	BEGIN
SET @errorCode = (2741 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @errorCode AND localeId = @localeId)
		GOTO PROC_EXIT
	END
	DECLARE @userHasRights INT = 0
	-- Check for explicit rights.
EXEC sec_checkPermissionOnEntity @originalUserId, '0', @userHasRights OUTPUT, 61, @companyId
	IF @userHasRights = 0
	BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO PROC_EXIT
	END
	-- Get company view user for this company.
	SELECT @companyUserId = id
		,@companyUserLogin = login
		,@companyUserGUID = userGUID
		,@companyUserEmail = email
		,@companyUserEnabled = enabled
		FROM UMUsers WITH (NOLOCK)
		WHERE
			umdsProviderId = @companyId
AND flags & 0x20000 = 0x20000
	IF @companyUserId = 0 OR @companyUserId IS NULL       -- If this is the first time this user is filtering to this company, then the hidden user account is to be created.
	BEGIN
		DECLARE @companyName VARCHAR(MAX),
				@companyUserName VARCHAR(MAX),
				@nowTime INT = dbo.getUnixTime(GETUTCDATE())
		SELECT @companyName = domainName
		FROM UMDSProviders (NOLOCK)
		WHERE
			id = @companyID
		SET @companyUserLogin = @companyName + '\Company_View_User_For_Impersonation'
		SET @companyUserName = 'View User'
		SET @companyUserEmail = ''
		IF NOT EXISTS (SELECT 1 FROM UMUsers WITH(NOLOCK) WHERE login = @companyUserLogin)
			INSERT INTO UMUsers (name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified, pVer, pager,
								lastLoginTime, credSetTime, umdsProviderId, userGUID, origUserGUID, origCCID, salt)
					VALUES(@companyUserName     -- name
						,'Company view user for company:'+CAST(@companyID AS VARCHAR(10))     -- description
						,@companyUserLogin          -- login
						,'9' + CAST(NEWID() AS VARCHAR(512))    -- password
						,@companyUserEmail  -- email
						,@nowTime   -- datePasswordSet
						,0      -- dateExpires
						,0      -- policy
						,1      -- enabled          (When reseller user logs in, we internally login as this user. So he needs to be enabled for logging in. GetUserInfo checks on enabled = 1.)
,CAST(0x20000 AS INT) | CAST(0x004 AS INT) | CAST(0x2000 AS INT) -- 40964    -- flags
						,0      -- modified
						,50     -- pVer
						,NULL   -- pager
						,0      -- lastLoginTime
						,0      -- credSetTime
						,@companyId     -- umdsProviderId
						,NEWID()        -- userGUID
						,''             -- origUserGUID
						,2              -- origCCID
						,''             -- salt
						)
		ELSE            -- Mostly this case will not be hit. If by any chance, there is already another user with the same name, (say a stale entry which was not properly deleted when his original user deleted)
			UPDATE UMUsers                  -- just reuse that Id.
SET flags = flags | (CAST(0x20000 AS INT) | CAST(0x004 AS INT) | CAST(0x2000 AS INT))    -- 40964
			WHERE
				login = @companyUserLogin
		SELECT @companyUserId = id
			   ,@companyUserGUID = userGUID
		FROM UMUsers (NOLOCK)
		WHERE
			login = @companyUserLogin
	END
	ELSE IF @companyUserEnabled = 0		-- Until SP22, when deactivating company, this user got disabled. So enable him.
	BEGIN
		UPDATE UMUsers
		SET enabled = 1
		WHERE
			id = @companyUserId
	END
	-- Associate the view role with this hidden impersonation user on the company.
DECLARE @viewRoleID INT = ISNULL((SELECT TOP 1 id FROM UMRoles (NOLOCK) WHERE (name = 'View') AND (flags & 1 | 2 <> 0)), 0)
	IF @viewRoleID <> 0
	BEGIN
		IF NOT EXISTS (SELECT 1
			FROM UMSecurityAssociations (NOLOCK)
			WHERE roleId = @viewRoleID
				AND isUser = 1
				AND userOrGroupId = @companyUserID
AND entityType1 = 61
				AND entityId1 = @companyId)
		BEGIN
			INSERT INTO UMSecurityAssociations (isUser, userOrGroupId, roleId, entityType1, entityId1, authorId)
				   VALUES (1,
				   @companyUserId,
				   @viewRoleID,
61,
				   @companyId,
				   @originalUserId)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode = ERROR_NUMBER()
	set @errorString = 'Failed to get company view user for company ' +ERROR_MESSAGE()
END CATCH
PROC_EXIT:
    SELECT @companyUserId as companyUserId,
           @companyUserLogin as companyUserLogin,
           @companyUserGUID as companyUserGUID,
           @companyUserEmail as companyUserEmail,
           @originalTokenHostName as originalTokenHostName,
           @errorCode as errorCode,
           @errorString as errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getCompanyViewUserDetails')
	delete from GxQscripts where name = 'sec_getCompanyViewUserDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCompanyViewUserDetails')
	delete from GXDBVersions where aliasname = 'sec_getCompanyViewUserDetails'
GO

insert into GXDBVersions values(2, 'sec_getCompanyViewUserDetails',  '00000000000000000000', 'sec_getCompanyViewUserDetails', '00000000000000000000')
GO

