

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getCompaniesAssociatedWithEntity.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_getCompaniesAssociatedWithEntity()
--  | Description:  Get companies associated with given entity type and entity Id
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_getCompaniesAssociatedWithEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_getCompaniesAssociatedWithEntity <<<'
	drop procedure sec_getCompaniesAssociatedWithEntity
END
IF EXISTS (select * from GxQscripts where name='sec_getCompaniesAssociatedWithEntity')
	delete from GxQscripts where name = 'sec_getCompaniesAssociatedWithEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCompaniesAssociatedWithEntity')
	delete from GXDBVersions where aliasname = 'sec_getCompaniesAssociatedWithEntity'
GO
print '... Creating Procedure: sec_getCompaniesAssociatedWithEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_getCompaniesAssociatedWithEntity
  @i_userId INTEGER,
  @i_entityType INTEGER,
  @i_entityId INTEGER,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @errorCode    integer
DECLARE @errorString	nvarchar(1024)
BEGIN TRY
	SET @errorCode = 0
	SET @errorString = ''
	DECLARE @associatedCompanies TABLE
	(
		id INT,
		domainName nvarchar(255)
		PRIMARY KEY (id)
	)
	DECLARE @roleId INT = 0
IF @i_entityType <> 158
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Entity type ' + cast (@i_entityType AS varchar(10) ) + ' is not supported'
		GOTO SCRIPT_EXIT
	END
SET @roleId = CASE  WHEN @i_entityType = 158
THEN ISNULL((SELECT id FROM UMRoles WITH (NOLOCK) WHERE name = 'Plan Subscription Role' and flags & 64 <> 0) ,0)
						ELSE 0
						END
	-- Get the list of providers to which user has access
	IF OBJECT_ID('tempdb.dbo.#umdsproviderslist') IS NOT NULL
        DROP TABLE #umdsproviderslist
	CREATE TABLE #umdsproviderslist (nameserversId INT PRIMARY KEY)
    	EXEC sec_getNameServersForThisUser '#umdsproviderslist', @i_userId, 0
	INSERT INTO @associatedCompanies
	SELECT DISTINCT P.id, P.domainName
	FROM UMSecurityAssociations US WITH (NOLOCK)
	INNER JOIN UMGroups UG WITH (NOLOCK)
		ON US.isUser = 0
			AND US.userOrGroupId = UG.id
AND UG.groupFlags  &  0x10000 = 0x10000
	INNER JOIN UMDSproviders P WITH (NOLOCK)
		ON P.id = UG.umdsProviderId
AND P.serviceType = 5
	INNER JOIN #umdsproviderslist UDP
                    ON UDP.nameserversId=P.id
	WHERE entityType1 = @i_entityType
			AND entityId1 = @i_entityId
			AND US.roleId = @roleId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET @o_xmlText =(
					SELECT
					(
						SELECT id as '@providerId',
								domainName as '@providerDomainName'
							FROM @associatedCompanies
							FOR XML PATH('companies'), TYPE
					),
					(
						SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('error'),TYPE
					)
					FOR XML PATH('Api_CompaniesAssociatedWithEntityResponse')
			 )
select @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getCompaniesAssociatedWithEntity')
	delete from GxQscripts where name = 'sec_getCompaniesAssociatedWithEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getCompaniesAssociatedWithEntity')
	delete from GXDBVersions where aliasname = 'sec_getCompaniesAssociatedWithEntity'
GO

insert into GXDBVersions values(2, 'sec_getCompaniesAssociatedWithEntity',  '00000000000000000000', 'sec_getCompaniesAssociatedWithEntity', '00000000000000000000')
GO

