

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getAuxiliaryApplications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getAuxiliaryApplications <<<'

IF EXISTS (select * from sysobjects where name='sec_getAuxiliaryApplications')
	drop procedure sec_getAuxiliaryApplications
IF EXISTS (select * from GxQscripts where name='sec_getAuxiliaryApplications')
	delete from GxQscripts where name = 'sec_getAuxiliaryApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAuxiliaryApplications')
	delete from GXDBVersions where aliasname = 'sec_getAuxiliaryApplications'
GO
print '... Creating Procedure: sec_getAuxiliaryApplications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getAuxiliaryApplications
  @userId integer,
  @applications integer,
  @outXML XML output
AS
IF OBJECT_ID('tempdb.dbo.#tempAppGetApplicationSecurityObjects') IS NOT Null DROP TABLE #tempAppGetApplicationSecurityObjects
create table  #tempAppGetApplicationSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 0, 0, '#tempAppGetApplicationSecurityObjects'
DECLARE				@CvFeaturesList bigint=0
DECLARE				@CloudCapabilities int=0
DECLARE @cvFeatureCapabilities int = 0
DECLARE @DefaultCvFeaturesList	INT = 1077968911
SET @CvFeaturesList = ISNULL((SELECT TOP 1 value FROM GXGlobalParam WHERE modified = 0 AND name = N'CvFeaturesList'), @DefaultCvFeaturesList)
--local user
IF OBJECT_ID ('tempdb.dbo.#usersProps') IS NOT NULL
	DROP TABLE #usersProps
CREATE TABLE #usersProps (componentNameId     integer, attrName        nvarchar (1024), attrVal         nvarchar(MAX) )
INSERT INTO #usersProps (componentNameId, attrName , attrVal)
SELECT componentNameId, attrname,    CAST(attrVal AS INT) attrVal
FROM UMUsersProp WITH(NOLOCK) WHERE componentNameId = @userId and modified = 0 and attrName IN(N'Cloud Capabilities',N'cvFeature Capabilities') 	AND ISNUMERIC(attrVal) = 1
--local groups
UNION ALL
SELECT componentNameId, attrname, 	CAST(attrVal AS INT) attrVal
FROM UMGroupsProp ug WITH(NOLOCK)
INNER JOIN  UMUserGroup umgroups WITH(NOLOCK) ON ug.componentNameId=umgroups.groupId and @userId=@userid
			WHERE  ug.modified = 0  AND ug.attrName IN(N'Cloud Capabilities',N'cvFeature Capabilities') 	AND ISNUMERIC(attrVal) = 1
--Ad groups
UNION ALL
SELECT componentNameId,  attrname, CAST(attrVal AS INT) attrVal
FROM UMGroupsProp ug WITH(NOLOCK)
INNER JOIN  UMDSGroupMaps maps WITH(NOLOCK) ON ug.componentNameId=maps.umgroupId
INNER JOIN UMUserGroup umdsgroup WITH(NOLOCK) ON umdsgroup.groupId = maps.umDSgroupId AND umdsgroup.userId=@userid
		WHERE  ug.modified = 0  AND ug.attrName IN(N'Cloud Capabilities',N'cvFeature Capabilities') 	AND ISNUMERIC(attrVal) = 1
SELECT	@CloudCapabilities = (@CloudCapabilities | ISNULL(attrVal,0))
	FROM #usersProps WHERE attrName='Cloud Capabilities'
SELECT	@cvFeatureCapabilities = (@cvFeatureCapabilities | ISNULL(attrVal,0))
	FROM #usersProps WHERE attrName='cvFeature Capabilities'
-- CHECK FOR NULL VALUE AS ABOVE QUERY CAN RETURN NULL VALUE
IF @cvFeatureCapabilities IS NULL
	SET @cvFeatureCapabilities = 0
IF @CloudCapabilities IS NULL
	SET @CloudCapabilities = 0
drop table #usersProps
declare @myDataApps_xml XML
declare @analyticsApps_xml XML
if @applications & 1 = 1
BEGIN
	exec sec_getMyDataApplications @userId, @myDataApps_xml output,@CvFeaturesList, @CloudCapabilities, @cvFeatureCapabilities
	exec sec_getAnalyticsApplications @userId, @analyticsApps_xml output
END
if @applications & 1073741823 = 1073741823
	BEGIN
		set @outXML = (select @myDataApps_xml, @analyticsApps_xml for XML PATH('auxiliaryAppLicenses'))
	END
else
	BEGIN
		set @outXML = (select @myDataApps_xml, @analyticsApps_xml FOR XML PATH(''), ROOT('DM2ContentIndexing_AuxiliaryApplicationResponse'))
	END
-- AEB: inprove web console login, do not need to output result set
--select @outXML
DROP TABLE #tempAppGetApplicationSecurityObjects
GO


IF EXISTS (select * from GxQscripts where name = 'sec_getAuxiliaryApplications')
	delete from GxQscripts where name = 'sec_getAuxiliaryApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAuxiliaryApplications')
	delete from GXDBVersions where aliasname = 'sec_getAuxiliaryApplications'
GO

insert into GXDBVersions values(2, 'sec_getAuxiliaryApplications',  '00000000000000000000', 'sec_getAuxiliaryApplications', '00000000000000000000')
GO

