

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getAnalyticsApplications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getAnalyticsApplications <<<'

IF EXISTS (select * from sysobjects where name='sec_getAnalyticsApplications')
	drop procedure sec_getAnalyticsApplications
IF EXISTS (select * from GxQscripts where name='sec_getAnalyticsApplications')
	delete from GxQscripts where name = 'sec_getAnalyticsApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAnalyticsApplications')
	delete from GXDBVersions where aliasname = 'sec_getAnalyticsApplications'
GO
print '... Creating Procedure: sec_getAnalyticsApplications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getAnalyticsApplications
  @userId integer,
  @analyticsApplications XML output
AS
declare @isFileAnalytics	bit = 0
declare @isEmailAnalytics	bit = 0
declare @isWebAnalytics		bit = 0
declare @isDataConnector	bit = 0
declare @isEventOrganizer	bit = 0
declare @out_xml			XML
declare @isUserAdmin int=0
if object_id('tempdb.dbo.#tblAnalyticsAppPermissions') is not null
begin
	drop table #tblAnalyticsAppPermissions
end
--
-- we will call sec_getAnalyticsApp that will evaluate permissions and insert data into this table
--
create table #tblAnalyticsAppPermissions (isFileAnalytics INT, isEmailAnalytics INT, isDataConnector INT, isWebAnalytics INT)
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF( @isUserAdmin = 1)
BEGIN
	SET @isEventOrganizer	 = 1
	INSERT INTO #tblAnalyticsAppPermissions
	SELECT 1 as isFileAnalytics, 1 as isEmailAnalytics, 1 as isDataConnector, 1 as isWebAnalytics
	GOTO PROC_EXIT
END
--
-- In UI, "Analytics" option in landing page is decided based on certain conditions that are computed in
-- in stored procedure sec_getAnalyticsApp, so we invoke it with @CheckAllPermissions flag = 0
-- so that we can determine if user has at-least any of the following permissions present:
-- File Analytics, Email Analytics, Data Connector, Web Analytics
--
exec sec_getAnalyticsApp @userId, @CheckAllPermissions = 0
--
DECLARE @o_userHasCapability INT
EXECUTE sec_userHasCapability @userId, 0, @o_userHasCapability OUTPUT, 0, 1, '138' -- CAT_EVENTS_ORGANIZER
IF(@o_userHasCapability=1)
BEGIN
	SET @isEventOrganizer = 1
END
PROC_EXIT:
SET @out_xml = (select isFileAnalytics as '@IsFileAnalytics'
				, isEmailAnalytics as '@IsEmailAnalytics'
				, isDataConnector as '@IsDataConnector'
				, isWebAnalytics as '@IsWebAnalytics'
				, @isEventOrganizer as '@IsEventOrganizer'
				FROM #tblAnalyticsAppPermissions
	   FOR XML PATH('analyticsApplications'))
SELECT @analyticsApplications = @out_xml
 if object_id('tempdb.dbo.#tblAnalyticsAppPermissions') is not null
begin
	drop table #tblAnalyticsAppPermissions
end
GO


IF EXISTS (select * from GxQscripts where name = 'sec_getAnalyticsApplications')
	delete from GxQscripts where name = 'sec_getAnalyticsApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAnalyticsApplications')
	delete from GXDBVersions where aliasname = 'sec_getAnalyticsApplications'
GO

insert into GXDBVersions values(2, 'sec_getAnalyticsApplications',  '00000000000000000000', 'sec_getAnalyticsApplications', '00000000000000000000')
GO

