

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getAnalyticsApp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getAnalyticsApp <<<'

IF EXISTS (select * from sysobjects where name='sec_getAnalyticsApp')
	drop procedure sec_getAnalyticsApp
IF EXISTS (select * from GxQscripts where name='sec_getAnalyticsApp')
	delete from GxQscripts where name = 'sec_getAnalyticsApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAnalyticsApp')
	delete from GXDBVersions where aliasname = 'sec_getAnalyticsApp'
GO
print '... Creating Procedure: sec_getAnalyticsApp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getAnalyticsApp
  @userId integer,
  @CheckAllPermissions integer = 1
AS
DECLARE @isFileAnalytics	BIT = 0
DECLARE @isEmailAnalytics	BIT = 0
DECLARE @isWebAnalytics		BIT = 0
DECLARE @isDataConnector	BIT = 0
DECLARE @tblLocal			BIT = 0
DECLARE @l_isUserAdmin INT=0
--
if object_id('tempdb.dbo.#tblAnalyticsAppPermissions') is null
begin
	-- define this temp table here for intellisense to function correctly
	create table #tblAnalyticsAppPermissions (isFileAnalytics INT, isEmailAnalytics INT, isWebAnalytics INT, isDataConnector INT)
	SET	@tblLocal = 1
end
if @CheckAllPermissions is null
begin
	-- By default this SP will check all permissions and return appropriate flags.
	-- But if caller module wants to exit when at-least one permission found,
	-- then we exit right at that point
	--
	SET @CheckAllPermissions = 1
end
EXEC sec_isUserAdmin @userId, @l_isUserAdmin OUTPUT
IF( @l_isUserAdmin = 1)
BEGIN
	SET @isFileAnalytics	 = 1
	SET @isEmailAnalytics	 = 1
	SET @isWebAnalytics		 = 1
	SET @isDataConnector	 = 1
END
ELSE
BEGIN
	DECLARE @l_permissionId INT = 0,
			@l_entityTypeId		INT = 0,
			@l_isFileAnalytics	INT = 0,
			@l_isEmailAnalytics	INT = 0,
			@l_isDataConnector	INT = 0
	/***************************************************************************************************
		Code to check if web analytics or data connector to be enabled
		- Create temp table #permissionIdTable and #getObjectsTable to be used for sec_getObjectsWithPermissionsV2 SP.
- Invoke sec_getObjectsWithPermissionsV2 SP with Entity - 3 and Permission - 136,137
		- Output returns all client, so delete output list that doesnt belong to DM2Cloud.PseudoclientId
			- If output have any _WEB permission entity
				Enable @isWebAnalytics=1
			- If output have any _SEA permission entity
				Enable @isDataConnectory=1
		- IF(@isDataConnector = 0)
- check if any datasource have been shared with permission = 201 and entity = 132,
				Enable @isDataConnector=1
		- drop temp tables
	***************************************************************************************************/
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	CREATE TABLE #permissionIdTable (permissionId INT)
	--Contains objects tables to be used by SP.
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	--
	-- create index for faster queries on temp table
	--
	CREATE INDEX idxTmpGetAnalyticsTable ON #getObjectsTable(entityId)
	CREATE INDEX idxTmpGetAnalyticsPermissions ON #getObjectsTable(permissionId)
	--
	INSERT INTO #permissionIdTable
SELECT 136 /*CAT_ANALYTICS_WEB*/ UNION
SELECT 137 /*CAT_ANALYTICS_SEA*/
EXEC sec_getObjectsWithPermissionsV2 @userId, 3  /*CLIENT_ENTITY */ ,0
	IF EXISTS( SELECT TOP 1 1 FROM #getObjectsTable)
	BEGIN
		--
		-- Whether we are checking web analytics or data connector permission, we do not want to consider psuedo client rows always, so delete them
		--
		DELETE FROM #getObjectsTable WHERE entityId NOT IN (SELECT DISTINCT DC.pseudoClientId FROM DM2Cloud AS DC WHERE DC.CloudType IN ( 1,4,5) )
IF EXISTS( SELECT TOP 1 1 FROM #getObjectsTable WHERE permissionId = 136 /*CAT_ANALYTICS_WEB*/)
		BEGIN
			SET @isWebAnalytics = 1
			if @CheckAllPermissions = 0 goto PROC_EXIT
		END
IF EXISTS( SELECT TOP 1 1 FROM #getObjectsTable WHERE permissionId = 137 /*CAT_ANALYTICS_SEA*/ )
		BEGIN
			SET @isDataConnector = 1
			if @CheckAllPermissions = 0 goto PROC_EXIT
		END
	END
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	IF(@isDataConnector  = 0)
	BEGIN
SET @l_permissionId  = 201 /*CAT_DATACUBE_VIEW*/
SET @l_entityTypeId = 132 /*SEA_DATASOURCE_ENTITY*/
		EXEC sec_checkPermissionOnEntityType @userId,
											@l_entityTypeId,
											@l_isDataConnector OUTPUT,
											@permissionId = @l_permissionId,
											@AndOperation = 0
		IF(@l_isDataConnector > 0)
		BEGIN
			SET @isDataConnector = 1
			if @CheckAllPermissions = 0 goto PROC_EXIT
		END
	END
	/***************************************************************************************************
		Code to check if File and Email have to be enabled
- If @i_user have Client entity with 13 permission
			- And
- Enable FileAnalytics, when user have 134 permission on any Client entity
- Enable EmailAnalytics, when user have 135 permission on any Client entity
	***************************************************************************************************/
	DECLARE @l_clientPermission INT = 0
	SET @l_permissionId  = 0
SET @l_entityTypeId = 3  /*CLIENT_ENTITY*/
	--check for client permission with browse
SET @l_permissionId = 13 /*EV_BROWSE*/
	EXEC sec_checkPermissionOnEntityType @userId,
										@l_entityTypeId,
										@l_clientPermission OUTPUT,
										@permissionId = @l_permissionId,
										@AndOperation = 0
	if(@l_clientPermission = 1)	--now check for File/Email
	BEGIN
		--check for file
SET @l_permissionId  = 134 /*CAT_ANALYTICS_FILE*/
		EXEC sec_checkPermissionOnEntityType @userId,
											@l_entityTypeId,
											@l_isFileAnalytics OUTPUT,
											@permissionId = @l_permissionId,
											@AndOperation = 0
		IF(@l_isFileAnalytics > 0)
		BEGIN
			SET @isFileAnalytics = 1
			if @CheckAllPermissions = 0 goto PROC_EXIT
		END
		--check for Email
SET @l_permissionId  = 135 /*CAT_ANALYTICS_EMAIL*/
		EXEC sec_checkPermissionOnEntityType @userId,
											@l_entityTypeId,
											@l_isEmailAnalytics OUTPUT,
											@permissionId = @l_permissionId,
											@AndOperation = 0
		IF(@l_isEmailAnalytics > 0)
		BEGIN
			SET @isEmailAnalytics = 1
			if @CheckAllPermissions = 0 goto PROC_EXIT
		END
	END
END
PROC_EXIT:
IF @CheckAllPermissions = 1
BEGIN
--
-- NOTE: if additional fields are returned, then stored procedure sec_getAnalyticsApplications need to be modified accordingly as this values are captured into temp table
--
SELECT @isFileAnalytics AS IsFileAnalytics, @isEmailAnalytics AS IsEmailAnalytics, @isDataConnector AS IsDataConnector, @isWebAnalytics AS IsWebAnalytics
END
ELSE
BEGIN
	INSERT INTO #tblAnalyticsAppPermissions
	SELECT @isFileAnalytics AS IsFileAnalytics, @isEmailAnalytics AS IsEmailAnalytics, @isDataConnector AS IsDataConnector, @isWebAnalytics AS IsWebAnalytics
END
-- clean up as needed
if @tblLocal = 1
BEGIN
	--
	-- if we created this, then we drop it
	-- but if caller created it, caller's session will drop it
	--
	DROP TABLE #tblAnalyticsAppPermissions
END
GO


IF EXISTS (select * from GxQscripts where name = 'sec_getAnalyticsApp')
	delete from GxQscripts where name = 'sec_getAnalyticsApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAnalyticsApp')
	delete from GXDBVersions where aliasname = 'sec_getAnalyticsApp'
GO

insert into GXDBVersions values(2, 'sec_getAnalyticsApp',  '00000000000000000000', 'sec_getAnalyticsApp', '00000000000000000000')
GO

