

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getAllUserObjects.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_getAllUserObjects.sp,v $ $Id: sec_getAllUserObjects.sp,v 1.5.294.1 2017/02/10 21:53:36 sjohnson Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_getAllUserObjects()
--  |
--  | Description:  Fetches a flattened list of objects the all user has
--	|			    rights to and puts into passed in table
--  |
--  |       Input:  outputTableArg
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_getAllUserObjects <<<'

IF EXISTS (select * from sysobjects where name='sec_getAllUserObjects')
	drop procedure sec_getAllUserObjects
IF EXISTS (select * from GxQscripts where name='sec_getAllUserObjects')
	delete from GxQscripts where name = 'sec_getAllUserObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAllUserObjects')
	delete from GXDBVersions where aliasname = 'sec_getAllUserObjects'
GO
print '... Creating Procedure: sec_getAllUserObjects'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_getAllUserObjects
  @outputTableArg varchar(100)	
AS
IF object_id('tempdb.dbo.#viewScheduleUserTmp') is not null
					DROP TABLE #viewScheduleUserTmp
create table  #viewScheduleUserTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
DECLARE @userId as int
DECLARE @rowCount as int
DECLARE @sqlStr as nvarchar(1024)
DECLARE	GetSecurityUserCursor CURSOR FOR
SELECT id FROM UMUsers
OPEN GetSecurityUserCursor
FETCH GetSecurityUserCursor INTO @userId
WHILE	@@FETCH_STATUS = 0
BEGIN
	EXEC sec_getUserObjects @userId, 0, 0, '#viewScheduleUserTmp'
	set @rowCount = (SELECT count(*) from #viewScheduleUserTmp)
	if (@rowCount > 0)
	set @sqlStr = 'insert into ' +  @outputTableArg + ' SELECT ' +  CAST(@userId as nvarchar(256)) + ', capabilities, flag, commCellId, clientGroupId, clientId, appTypeId , instanceId, backupsetId, subClientId, mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId from #viewScheduleUserTmp'
	else
	set @sqlStr = 'insert into ' +  @outputTableArg + ' VALUES( ' + CAST(@userId as nvarchar(256)) + ' , 0, 0, 0, 0, 0, 0 , 0, 0, 0 , 0, 0,0, 0,0, 0)'
	EXEC (@sqlStr)
	delete #viewScheduleUserTmp
	FETCH GetSecurityUserCursor INTO @userId
END
CLOSE GetSecurityUserCursor
DEALLOCATE GetSecurityUserCursor
drop table #viewScheduleUserTmp
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getAllUserObjects')
	delete from GxQscripts where name = 'sec_getAllUserObjects'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAllUserObjects')
	delete from GXDBVersions where aliasname = 'sec_getAllUserObjects'
GO

insert into GXDBVersions values(2, 'sec_getAllUserObjects',  '00010005029400010000', 'sec_getAllUserObjects', '00010005029400010000')
GO

