

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_getAllCreatedUsersAndGroups.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_getAllCreatedUsersAndGroups"
--	|			This procedure is used to get list of all created users and groups
--	|			Author: jswaminathan & saggarwal
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_getAllCreatedUsersAndGroups')
BEGIN
	print '>>> Drop Stored Procedure: sec_getAllCreatedUsersAndGroups <<<'
	drop procedure sec_getAllCreatedUsersAndGroups
END
IF EXISTS (select * from GxQscripts where name='sec_getAllCreatedUsersAndGroups')
	delete from GxQscripts where name = 'sec_getAllCreatedUsersAndGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAllCreatedUsersAndGroups')
	delete from GXDBVersions where aliasname = 'sec_getAllCreatedUsersAndGroups'
GO
print '... Creating Procedure: sec_getAllCreatedUsersAndGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_getAllCreatedUsersAndGroups
  @xmlinput XML 
AS
--inputs:
/*set @xmlinput = '<Api_GetAllCreatedUsersAndGroupsRequest>
	<processinginstructioninfo>
		<user userId="1" userName="admin"/>
	</processinginstructioninfo>
	<parent _type_="61" providerId="2" providerDomainName="commvault-nj"/> <!-- optional -->
</Api_GetAllCreatedUsersAndGroupsRequest>'*/
declare @userID int
set @userID = isnull((select @xmlinput.value('(Api_GetAllCreatedUsersAndGroupsRequest/processinginstructioninfo/user/@userId)[1]', 'int')), 0)
declare @flags int
set @flags = isnull((select @xmlinput.value('(Api_GetAllCreatedUsersAndGroupsRequest/@flags)[1]', 'int')), (1 | 2))
if object_id('tempdb.dbo.#outputTable') is not null
	drop table #outputTable
create table #outputTable
(
	_type_ int,
	entityID int,
	entityName nvarchar(1024),
	fullName nvarchar(1024),
	email nvarchar(1024),
	description nvarchar(max),			--to support larger unicode desc
	providerId int,
	providerName nvarchar(1024),
	umEntityGUID  varchar(255)
)
if object_id('tempdb.dbo.#entityTable') is not null
	drop table #entityTable
create table #entityTable
(
	entityId int
)
declare @allentities int = 1
declare @parentNameServerId int = 0
if ((@xmlinput.exist('Api_GetAllCreatedUsersAndGroupsRequest/parent/@_type_') = 1) and (@xmlinput.value('(Api_GetAllCreatedUsersAndGroupsRequest/parent/@_type_)[1]', 'int') = 61))	--use macro
begin
	set @allentities = 0
	set @parentNameServerId = @xmlinput.value('(Api_GetAllCreatedUsersAndGroupsRequest/parent/@providerId)[1]', 'int')
end
if (@flags & 1) <> 0
begin
	--1. get the list of users
	exec sec_getUsersForThisUser '#entityTable', @userID
	insert into #outputTable (_type_, entityId, entityName, fullName, email, description, providerId, providerName,umEntityGUID)
select 13, ET.entityId, U.login, U.name, U.email, U.description, 0, N'',userGuid					--use macro
		from #entityTable ET inner join UMUsers U
		on ET.entityId = U.id and (@allentities = 1 OR U.umDSproviderId = @parentNameServerId)
	delete from #entityTable
end
if (@flags & 2) <> 0
begin
	--2. get the list of user groups
	exec sec_getUserGroupsForThisUser '#entityTable', @userID
	insert into #outputTable (_type_, entityId, entityName, fullName, email, description, providerId, providerName,umEntityGUID)
select 15,		--use macro
			   G.id,
			   case when G.umdsProviderId = 0 then G.name else P.domainName + '\' + G.name end,
			   '',
			   G.email,
			   G.description,
			   G.umdsProviderID,
			   P.domainName,
			   G.guid
		from #entityTable ET inner join UMGroups G
		on ET.entityId = G.id and (@allentities = 1 OR G.umDSproviderId = @parentNameServerId)
		left outer join UMDSProviders P
		on G.umdsProviderId = P.id
	delete from #entityTable
end
set @xmlinput = (select
					(select
(select case when _type_ = 13 then
							(select fullName as '@fullName',
									description as '@description',
									email as '@email',
								(select _type_ as '@_type_',
									   entityId as '@userId',
									   entityName as '@userName',
									   umEntityGUID as '@userGUID'
								for xml path ('associatedUserOrUserGroup'), type
								)
							for xml path('users'), type
							)
						end
						),
(select case when _type_ = 15 then
							(select fullName as '@fullName',
									description as '@description',
									email as '@email',
									umEntityGUID as '@guid',
								(select _type_ as '@_type_',
										entityId as '@userGroupId',
										entityName as '@userGroupName',
										 umEntityGUID as '@GUID'
								for xml path ('associatedUserOrUserGroup'), type
								)
							for xml path('userGroups'), type
							)
						end
						)
					from #outputTable
					for xml path (''), type)
				for xml path ('Api_GetAllCreatedUsersAndGroupsResponse'))
if @xmlinput is null
	set @xmlinput = '<Api_GetAllCreatedUsersAndGroupsResponse/>'
select @xmlinput
GO

IF EXISTS (select * from GxQscripts where name = 'sec_getAllCreatedUsersAndGroups')
	delete from GxQscripts where name = 'sec_getAllCreatedUsersAndGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_getAllCreatedUsersAndGroups')
	delete from GXDBVersions where aliasname = 'sec_getAllCreatedUsersAndGroups'
GO

insert into GXDBVersions values(2, 'sec_getAllCreatedUsersAndGroups',  '00000000000000000000', 'sec_getAllCreatedUsersAndGroups', '00000000000000000000')
GO

