

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_generateErrorMessage.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_generateErrorMessage"
--	|	This Procedure is to return localized error message
--	|  Authors : Seema & Jagadeesh
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_generateErrorMessage')
BEGIN
	print '>>> Drop Stored Procedure: sec_generateErrorMessage <<<'
	drop procedure sec_generateErrorMessage
END
IF EXISTS (select * from GxQscripts where name='sec_generateErrorMessage')
	delete from GxQscripts where name = 'sec_generateErrorMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_generateErrorMessage')
	delete from GXDBVersions where aliasname = 'sec_generateErrorMessage'
GO
print '... Creating Procedure: sec_generateErrorMessage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_generateErrorMessage
  @userId integer,
  @permissionsIdList varchar(4000),
  @entityType integer,
  @entityId integer,
  @errorString nvarchar(4000) OUTPUT,
  @localeId integer=0,
  @isReturn integer=0,
  @errorCode integer=0,
  @andOperation integer=0
AS
  DECLARE @errorMessage nvarchar(4000)
	DECLARE @columnName nvarchar(512)
	DECLARE @columnId nvarchar(512)
	DECLARE @tableName nvarchar(512)
	DECLARE @sqlStmt nvarchar(max)
	DECLARE @param nvarchar(max)
	DECLARE @entityName nvarchar(max)
	DECLARE @pemrissionEnglishName nvarchar(2048)
	DECLARE @permissionsMessageId bigint
	DECLARE @entityTypeName nvarchar(1024)
	DECLARE @entitytypeNameMessageId bigint
	DECLARE @permissionIdTbl TABLE(permissionId INTEGER)
	INSERT INTO @permissionIdTbl
	SELECT _ID
	FROM dbo.SplitIds(@permissionsIdList)
	--permissions name
	DECLARE @permissionString varchar(MAX)=''
	SELECT @permissionString=CASE WHEN @permissionString=''
								THEN permissionName
								ELSE @permissionString +','+permissionName
								END
								FROM
								(SELECT CASE WHEN messageId<>0 THEN
														  (SELECT TOP 1 message  from EvLocaleMsgs WITH(nolock)
															WHERE EvLocaleMsgs.messageId=UMPermissions.MessageId and LocaleId=@localeId)
										ELSE permissionName
										END as permissionName
								FROM UMPermissions JOIN @permissionIdTbl ON id=permissionId) as Tbl
	--entity  & type name
	if(@entityType <>0 AND @errorCode=0)
	BEGIN
		SELECT @columnName=entityNameColName,@columnId=idColName,@tableName=tableName,@entityTypeName=entityTypeName,@entitytypeNameMessageId=entitytypeNameMessageId
		FROM App_Entity with (NOLOCK)
		WHERE entityType=@entityType
		SET @param = '@entityId integer, @entityName nvarchar(4000) OUTPUT';
		IF @tableName IS NOT NULL AND @tableName <> '' AND @columnName IS NOT NULL AND @columnName <> '' AND @columnId IS NOT NULL AND @columnId <> ''
		BEGIN			-- Some entities like AppStudio does not have a table to look into. Avoid a SQL exception due to mis constructed dynamic SQL in those cases.
			SET @sqlStmt ='SELECT top 1 @entityName=  ' + @columnName +' FROM '+@tableName+' with(NOLOCK) WHERE '+@columnId+' = @entityId'
			EXECUTE sp_executesql @sqlStmt,@param,@entityId,@entityName OUTPUT
		END
		ELSE
			SET @entityName = ''
		--entityType
		IF(@entitytypeNameMessageId<>0)
			SELECT @entityTypeName= message
			FROM EvLocaleMsgs WITH (NOLOCK)
			WHERE MessageID=@entitytypeNameMessageId and LocaleID=@localeId
		IF(@errorCode=0)
		BEGIN
		       IF(@andOperation=0 AND  (SELECT COUNT(permissionId) FROM @permissionIdTbl)>1)
SET @errorString= (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId=(2934 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@localeId)
			ELSE
SET @errorString= (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', (SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WITH (NOLOCK) WHERE id = @userId))
			SET @errorString = REPLACE(@errorString, '^2%s', @permissionString)
			SET @errorString = REPLACE(@errorString, '^3%s', @entityName)
			SET @errorString = REPLACE(@errorString, '^4%s', @entityTypeName)
		END
	END
	ELSE
	IF(@errorCode=0 and @entityType=0)
	BEGIN
SET @errorString= (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId=(2497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @permissionString)
	END
	ELSE
	BEGIN
SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId=(2411 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@localeId)
	END
	IF(@isReturn<>0)
	 SELECT @errorString

IF EXISTS (select * from GxQscripts where name = 'sec_generateErrorMessage')
	delete from GxQscripts where name = 'sec_generateErrorMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_generateErrorMessage')
	delete from GXDBVersions where aliasname = 'sec_generateErrorMessage'
GO

insert into GXDBVersions values(2, 'sec_generateErrorMessage',  '00000000000000000000', 'sec_generateErrorMessage', '00000000000000000000')
GO

