

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_expandRoleWithPermissions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_expandRoleWithPermissions <<<'

IF EXISTS (select * from sysobjects where name='sec_expandRoleWithPermissions')
	drop procedure sec_expandRoleWithPermissions
IF EXISTS (select * from GxQscripts where name='sec_expandRoleWithPermissions')
	delete from GxQscripts where name = 'sec_expandRoleWithPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_expandRoleWithPermissions')
	delete from GXDBVersions where aliasname = 'sec_expandRoleWithPermissions'
GO
print '... Creating Procedure: sec_expandRoleWithPermissions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_expandRoleWithPermissions
  @roleId INT,
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(1024) OUTPUT,
  @populateTempTable INT =0
AS
--Outputs
SET @errorCode = 0
SET @errorString = 'Successful'
BEGIN TRY
	IF(@populateTempTable=0)
		DELETE UMRolesWithPermissionsExpanded
		WHERE roleId = @roleId
DECLARE @allCategories INT = 123
DECLARE @categoryEntityType INT = 121
DECLARE @permissionEntityType INT = 122
	DECLARE @includedPermissionsTbl TABLE
	(
		categoryId INT,
		permissionId INT
	)
	DECLARE @excludedPermissionsTbl TABLE
	(
		categoryId INT,
		permissionId INT
	)
	IF EXISTS (SELECT * FROM UMRolesPermissions WHERE roleId = @roleId AND hierarchyLevel = @allCategories)
		INSERT INTO @includedPermissionsTbl
			SELECT categoryId, id
			FROM UMPermissions
			WHERE id <> 0
	ELSE
		INSERT INTO @includedPermissionsTbl
			SELECT DISTINCT T.categoryid, T.permissionId
			FROM UMRolesPermissions RolePerm
			CROSS APPLY dbo.getAllPermissionsForCategory(RolePerm.categoryId,1) AS T
			WHERE roleId = @roleId AND hierarchyLevel = @categoryEntityType AND excludeCategory = 0
			UNION
			SELECT DISTINCT categoryId, permissionId
			FROM UMRolesPermissions
			WHERE roleId = @roleId AND hierarchyLevel = @permissionEntityType AND excludePermission = 0
	DELETE  Tbl
FROM @includedPermissionsTbl TBL JOIN UMPermissions P ON P.id=Tbl.permissionId WHERE flags&0x002<>0
	INSERT INTO @excludedPermissionsTbl
		SELECT DISTINCT T.categoryId, T.permissionId
		FROM UMRolesPermissions RolePerm
		CROSS APPLY dbo.getAllPermissionsForCategory(RolePerm.categoryId,1) AS T
		WHERE roleId = @roleId AND hierarchyLevel = @categoryEntityType AND excludeCategory = 1
		UNION
		SELECT categoryId, permissionId
		FROM UMRolesPermissions
		WHERE roleId = @roleId AND hierarchyLevel = @permissionEntityType AND excludePermission = 1
	IF(@populateTempTable=0)
	BEGIN
		INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)
			SELECT @roleId, categoryId, permissionId
			FROM @includedPermissionsTbl
			EXCEPT
			SELECT @roleId, categoryId, permissionId
			FROM @excludedPermissionsTbl
	END
	ELSE
	BEGIN
IF OBJECT_ID ('tempdb.dbo.#UMRolesPermissionExpandedTempTable') is not null
INSERT INTO #UMRolesPermissionExpandedTempTable
		SELECT @roleId, categoryId, permissionId
			FROM @includedPermissionsTbl
			EXCEPT
			SELECT @roleId, categoryId, permissionId
			FROM @excludedPermissionsTbl
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
END CATCH
END_PROCESSING:
--SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_expandRoleWithPermissions')
	delete from GxQscripts where name = 'sec_expandRoleWithPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_expandRoleWithPermissions')
	delete from GXDBVersions where aliasname = 'sec_expandRoleWithPermissions'
GO

insert into GXDBVersions values(2, 'sec_expandRoleWithPermissions',  '00000000000000000000', 'sec_expandRoleWithPermissions', '00000000000000000000')
GO

