

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_doesPwdMatchWithPreviousPwds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_doesPwdMatchWithPreviousPwds.sp,v $ $Id: sec_doesPwdMatchWithPreviousPwds.sp,v 1.1.2.2 2018/07/25 21:41:11 snandhini Exp $";
--verifies if the password given matches with the past n passwords that the user had used
--n can be set at usergroup level, organization level, commcell level
--key value when defined from more than one place - max of the value set from (usergroup,organization,commcell)
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_doesPwdMatchWithPreviousPwds <<<'

IF EXISTS (select * from sysobjects where name='sec_doesPwdMatchWithPreviousPwds')
	drop procedure sec_doesPwdMatchWithPreviousPwds
IF EXISTS (select * from GxQscripts where name='sec_doesPwdMatchWithPreviousPwds')
	delete from GxQscripts where name = 'sec_doesPwdMatchWithPreviousPwds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_doesPwdMatchWithPreviousPwds')
	delete from GXDBVersions where aliasname = 'sec_doesPwdMatchWithPreviousPwds'
GO
print '... Creating Procedure: sec_doesPwdMatchWithPreviousPwds'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_doesPwdMatchWithPreviousPwds
  @userId INT,
  @v3Pwd VARCHAR(255),
  @o_pswdCnt INT OUTPUT,
  @o_pswdMatched INT OUTPUT,
  @o_err NVARCHAR(255) OUTPUT,
  @returnCursor INT = 0
AS
  DECLARE @pswdCnt INT
  DECLARE @pswdMatched INT
  DECLARE @err NVARCHAR(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @n INT = 0
DECLARE @pswdTbl TABLE(hash NVARCHAR(255),salt VARCHAR(255),created INT)
DECLARE @pswdCursor CURSOR
DECLARE @hash NVARCHAR(255)
DECLARE @salt NVARCHAR(255)
SET @o_pswdMatched = 0
EXEC sec_getPasswordsToRememberForUser @userId, @o_pswdCnt OUTPUT
IF @o_pswdCnt <= 0
BEGIN
	IF @returnCursor = 1
		SELECT 0,0,''
	RETURN
END
INSERT INTO @pswdTbl(hash,salt,created)
SELECT top(@o_pswdCnt-1) [Old Password Hash],[Old Password Salt],created FROM
(
 SELECT attrName,attrVal,created
 FROM UMUsersProp
 WHERE componentNameId=@userId AND modified=0 AND
attrName in(N'Old Password Hash',N'Old Password Salt')
 ) AS temp
PIVOT
(
	MAX(attrVal)
	FOR attrName IN([Old Password Hash],[Old Password Salt])
)AS PivotTable ORDER BY created DESC
-- verify with current password too
INSERT INTO @pswdTbl(hash,salt,created)
SELECT password,salt,datePasswordSet FROM UMUsers WHERE id=@userId
SET @pswdCursor= CURSOR FOR SELECT hash,salt FROM @pswdTbl ORDER BY created desc
OPEN @pswdCursor
FETCH NEXT FROM @pswdCursor INTO @hash,@salt
WHILE @@FETCH_STATUS=0
BEGIN
	EXEC ValidateUserNew @hash, @v3Pwd, @salt, @o_pswdMatched OUT,@o_err OUT
	IF @o_pswdMatched=1
		BREAK;
	FETCH NEXT FROM @pswdCursor INTO @hash,@salt
END
CLOSE @pswdCursor
DEALLOCATE @pswdCursor
IF @returnCursor = 1
	SELECT @o_pswdCnt,@o_pswdMatched,@o_err
GO

IF EXISTS (select * from GxQscripts where name = 'sec_doesPwdMatchWithPreviousPwds')
	delete from GxQscripts where name = 'sec_doesPwdMatchWithPreviousPwds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_doesPwdMatchWithPreviousPwds')
	delete from GXDBVersions where aliasname = 'sec_doesPwdMatchWithPreviousPwds'
GO

insert into GXDBVersions values(2, 'sec_doesPwdMatchWithPreviousPwds',  '00010001000200020000', 'sec_doesPwdMatchWithPreviousPwds', '00010001000200020000')
GO

