

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_deleteUserAndGroupSecurityOnEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +=============================================================================================================================================+
--  |   Procedure:  sec_deleteUserAndGroupSecurityOnEntity
--  |
--  | Description:  Deleting specific user and group security associations for an entity - no security check will be done here. Application layer
--  |				code should do it and then call this SP. (same as sec_deleteSecurityAssociationForEntity)
--	|				This is called in places like from admin console when we disassociate plan from a company. In this case, Bhavyan wants to remove
--  |				all the user and group associations of that company on the plan and do not care about role / permission that the users have.
--	|				So they cannot call SetSecurityAssociations protocol since that requires role / permission to be specified.
--	|	Author: jswaminathan
--  +=============================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_deleteUserAndGroupSecurityOnEntity <<<'

IF EXISTS (select * from sysobjects where name='sec_deleteUserAndGroupSecurityOnEntity')
	drop procedure sec_deleteUserAndGroupSecurityOnEntity
IF EXISTS (select * from GxQscripts where name='sec_deleteUserAndGroupSecurityOnEntity')
	delete from GxQscripts where name = 'sec_deleteUserAndGroupSecurityOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_deleteUserAndGroupSecurityOnEntity')
	delete from GXDBVersions where aliasname = 'sec_deleteUserAndGroupSecurityOnEntity'
GO
print '... Creating Procedure: sec_deleteUserAndGroupSecurityOnEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_deleteUserAndGroupSecurityOnEntity
  @entityType1 INT,							
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0
AS
IF OBJECT_ID('tempdb.dbo.#deleteSecurity_UserGroupTbl')IS NULL
BEGIN
	RAISERROR ('Error. Output tables #deleteSecurity_UserGroupTblshould be passed to this SP.',
				16,
				1)
	RETURN
END
DELETE Sec
FROM UMSecurityAssociations Sec
	INNER JOIN #deleteSecurity_UserGroupTbl UG
		ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
WHERE
	(entityType1 = @entityType1 AND entityId1 = @entityId1
		AND (@entityType2 = 0 OR (entityType2 = @entityType2 AND entityId2 = @entityId2))
		AND (@entityType3 = 0 OR (entityType3 = @entityType3 AND entityId3 = @entityId3))
		AND (@entityTYpe4 = 0 OR (entityType4 = @entityType4 AND entityId4 = @entityId4))
		AND (@entityType5 = 0 OR (entityType5 = @entityType5 AND entityId5 = @entityId5)))
IF @entityTYpe2 = 0 AND @entityId2 = 0
BEGIN
	DELETE Sec
	FROM UMOwners Sec
		INNER JOIN #deleteSecurity_UserGroupTbl UG
			ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
	WHERE entityType = @entityType1 AND entityId = @entityId1
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_deleteUserAndGroupSecurityOnEntity')
	delete from GxQscripts where name = 'sec_deleteUserAndGroupSecurityOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_deleteUserAndGroupSecurityOnEntity')
	delete from GXDBVersions where aliasname = 'sec_deleteUserAndGroupSecurityOnEntity'
GO

insert into GXDBVersions values(2, 'sec_deleteUserAndGroupSecurityOnEntity',  '00000000000000000000', 'sec_deleteUserAndGroupSecurityOnEntity', '00000000000000000000')
GO

