

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_deleteSecurityAssociationsForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_deleteSecurityAssociationsForEntity
--  |
--  | Description:  deleting security associations for an entity - no security check will be done here. Application layer
--  |				code should do it and then call this SP
--  |
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_deleteSecurityAssociationsForEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_deleteSecurityAssociationsForEntity <<<'
	drop procedure sec_deleteSecurityAssociationsForEntity
END
IF EXISTS (select * from GxQscripts where name='sec_deleteSecurityAssociationsForEntity')
	delete from GxQscripts where name = 'sec_deleteSecurityAssociationsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_deleteSecurityAssociationsForEntity')
	delete from GXDBVersions where aliasname = 'sec_deleteSecurityAssociationsForEntity'
GO
print '... Creating Procedure: sec_deleteSecurityAssociationsForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_deleteSecurityAssociationsForEntity
  @entityType1 INT,							
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0
AS
DELETE FROM UMSecurityAssociations
WHERE (entityType1 = @entityType1 AND entityId1 = @entityId1
	  AND (@entityType2 = 0 OR (entityType2 = @entityType2 AND entityId2 = @entityId2))
	  AND (@entityType3 = 0 OR (entityType3 = @entityType3 AND entityId3 = @entityId3))
	  AND (@entityTYpe4 = 0 OR (entityType4 = @entityType4 AND entityId4 = @entityId4))
	  AND (@entityType5 = 0 OR (entityType5 = @entityType5 AND entityId5 = @entityId5)))
DECLARE @entityTypeToDelete INT = 0
DECLARE @entityIdToDelete INT = 0
--For backupsets, instance, subclients, entity type1 will still be client.
--but when we are deleting them we should not delete client owners associations.
--owner associations should be handled only if entitytype2 = 0
IF @entityTYpe2 = 0 AND @entityId2 = 0
BEGIN
	DELETE FROM UMOwners
	WHERE entityType = @entityType1 AND entityId = @entityId1
	DECLARE @roleID INT = ISNULL((SELECT TOP 1 roleId FROM UMOwnerRoles WHERE entityType = @entityType1 AND entityId = @entityId1), 0)
	DELETE FROM UMOwnerROles
	WHERE entityType = @entityType1 AND entityId = @entityId1
	IF @roleID <> 0
	BEGIN
		DECLARE @roleXML XML = (SELECT @roleId AS '@roleId'
								FOR XML PATH ('role'),
								ROOT ('Security_Role'))
EXEC sec_DeleteRole @roleXML, 1, 0, 1, 0
	END
	SET @entityTypeToDelete = @entityType1
	SET @entityIdToDelete = @entityId1
END
ELSE IF @entityType2 != 0 AND @entityId2 != 0 AND @entityType3 = 0
BEGIN
	SET @entityTypeToDelete = @entityType2
	SET @entityIdToDelete = @entityId2
END
ELSE IF @entityType3 != 0 AND @entityId3 != 0 AND @entityType4 = 0
BEGIN
	SET @entityTypeToDelete = @entityType3
	SET @entityIdToDelete = @entityId3
END
ELSE IF @entityType4 != 0 AND @entityId4 != 0 AND @entityType5 = 0
BEGIN
	SET @entityTypeToDelete = @entityType4
	SET @entityIdToDelete = @entityId4
END
ELSE IF @entityType5 != 0 AND @entityId5 != 0
BEGIN
	SET @entityTypeToDelete = @entityType5
	SET @entityIdToDelete = @entityId5
END
IF @entityTypeToDelete != 0 AND @entityIdToDelete != 0
BEGIN
	DELETE FROM App_CompanyEntities
	WHERE (entityType = @entityTypeToDelete AND entityId = @entityIdToDelete)
END
EXIT_PROC:
GO

IF EXISTS (select * from GxQscripts where name = 'sec_deleteSecurityAssociationsForEntity')
	delete from GxQscripts where name = 'sec_deleteSecurityAssociationsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_deleteSecurityAssociationsForEntity')
	delete from GXDBVersions where aliasname = 'sec_deleteSecurityAssociationsForEntity'
GO

insert into GXDBVersions values(2, 'sec_deleteSecurityAssociationsForEntity',  '00000000000000000000', 'sec_deleteSecurityAssociationsForEntity', '00000000000000000000')
GO

