

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_deleteQSDKSessionXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_DeleteQSDKSessionXML
--  |
--  | Description:  Deletes qsdk session with given session ID
--	|			    |
--  |       Input:  SessionId
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_DeleteQSDKSessionXML')
BEGIN
	print '>>> Drop Stored Procedure: sec_DeleteQSDKSessionXML <<<'
	drop procedure sec_DeleteQSDKSessionXML
END
IF EXISTS (select * from GxQscripts where name='sec_DeleteQSDKSessionXML')
	delete from GxQscripts where name = 'sec_DeleteQSDKSessionXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_DeleteQSDKSessionXML')
	delete from GXDBVersions where aliasname = 'sec_DeleteQSDKSessionXML'
GO
print '... Creating Procedure: sec_DeleteQSDKSessionXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_DeleteQSDKSessionXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @sessionId VARCHAR(64)    = (SELECT ref.value('@sessionID', 'VARCHAR(64)')    FROM @i_xmlText.nodes ('Api_QSDKDeleteSessionReq') R(ref))
DECLARE @location  NVARCHAR(4000) = (SELECT ref.value('@location',  'NVARCHAR(4000)') FROM @i_xmlText.nodes ('Api_QSDKDeleteSessionReq') R(ref))
DECLARE @auditFlag INT            = (SELECT ref.value('@auditFlag', 'VARCHAR(510)')   FROM @i_xmlText.nodes ('Api_QSDKDeleteSessionReq') R(ref))
IF (@location IS NULL) OR (@location = '')
    SELECT @location = location FROM UMQSDKSessions WHERE GUID = @sessionId
-- -- SP BODY BEGIN : sec_DeleteQSDKSession.spb ------------------------------------------------------------------------------------------------------------------------------------
BEGIN
	DECLARE @SPBodyNow_48036 INT = dbo.getUnixTime(GetUTCDATE())
	DELETE UMQSDKSessions WHERE GUID = @sessionID
	IF(@location IS NOT NULL AND @location != '')
        UPDATE	UMSESSIONAUDIT
        SET		logoutTime = @SPBodyNow_48036,
				flag       = @auditFlag,
				location   = @location
		WHERE	sessionId  = @sessionID
	ELSE
		UPDATE	UMSESSIONAUDIT
		SET		logoutTime = @SPBodyNow_48036,
				flag	   = @auditFlag
		WHERE sessionId = @sessionID
END
-- -- SP BODY END : sec_DeleteQSDKSession.spb --------------------------------------------------------------------------------------------------------------------------------------
SET @o_xmlText =
(
    SELECT 0  AS '@errorCode',
           '' AS '@errorMessage'
	FOR XML PATH('Api_GenericResp'), TYPE
)
SELECT @o_xmlText AS [o_xmlText]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_deleteQSDKSessionXML')
	delete from GxQscripts where name = 'sec_deleteQSDKSessionXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_deleteQSDKSessionXML')
	delete from GXDBVersions where aliasname = 'sec_deleteQSDKSessionXML'
GO

insert into GXDBVersions values(2, 'sec_deleteQSDKSessionXML',  '00000000000000000000', 'sec_deleteQSDKSessionXML', '00000000000000000000')
GO

