

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_deleteQSDKSession.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_DeleteQSDKSession
--  |
--  | Description:  Deletes qsdk session with given session ID
--	|			    |
--  |       Input:  SessionId
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_DeleteQSDKSession')
BEGIN
	print '>>> Drop Stored Procedure: sec_DeleteQSDKSession <<<'
	drop procedure sec_DeleteQSDKSession
END
IF EXISTS (select * from GxQscripts where name='sec_DeleteQSDKSession')
	delete from GxQscripts where name = 'sec_DeleteQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_DeleteQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_DeleteQSDKSession'
GO
print '... Creating Procedure: sec_DeleteQSDKSession'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_DeleteQSDKSession
  @sessionID nvarchar(255),
  @location nvarchar(2048) = '',
  @auditFlag int
AS
SET NOCOUNT ON
-- -- SP BODY BEGIN : sec_DeleteQSDKSession.spb ------------------------------------------------------------------------------------------------------------------------------------
BEGIN
	DECLARE @SPBodyNow_48036 INT = dbo.getUnixTime(GetUTCDATE())
	DELETE UMQSDKSessions WHERE GUID = @sessionID
	IF(@location IS NOT NULL AND @location != '')
        UPDATE	UMSESSIONAUDIT
        SET		logoutTime = @SPBodyNow_48036,
				flag       = @auditFlag,
				location   = @location
		WHERE	sessionId  = @sessionID
	ELSE
		UPDATE	UMSESSIONAUDIT
		SET		logoutTime = @SPBodyNow_48036,
				flag	   = @auditFlag
		WHERE sessionId = @sessionID
END
-- -- SP BODY END : sec_DeleteQSDKSession.spb --------------------------------------------------------------------------------------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'sec_deleteQSDKSession')
	delete from GxQscripts where name = 'sec_deleteQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_deleteQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_deleteQSDKSession'
GO

insert into GXDBVersions values(2, 'sec_deleteQSDKSession',  '00000000000000000000', 'sec_deleteQSDKSession', '00000000000000000000')
GO

