

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_createUserForRemoteCommcell.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_createUserForRemoteCommcell')
BEGIN
	print '>>> Drop Stored Procedure: sec_createUserForRemoteCommcell <<<'
	drop procedure sec_createUserForRemoteCommcell
END
IF EXISTS (select * from GxQscripts where name='sec_createUserForRemoteCommcell')
	delete from GxQscripts where name = 'sec_createUserForRemoteCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_createUserForRemoteCommcell')
	delete from GXDBVersions where aliasname = 'sec_createUserForRemoteCommcell'
GO
print '... Creating Procedure: sec_createUserForRemoteCommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_createUserForRemoteCommcell
  @inXML XML OUTPUT,
  @login NVARCHAR(MAX)
AS
BEGIN TRY
DECLARE @userId INT = 0
DECLARE @errorStr nvarchar(max)=''
DECLARE @errorCode INT = 0
SELECT @userId=id from UMUsers where login=@login
if (@userId <> 0)
GOTO PROC_EXIT
DECLARE @domainName nvarchar (MAX)=''
DECLARE @name nvarchar (MAX)= @login
DECLARE @userGuid nvarchar (MAX)=''
DECLARE @userGroups Table(userGroupName nvarchar(max),isADUserGroup int)
DECLARE @pos INT = 0
DECLARE @domainId INT = 0
DECLARE @email nvarchar(MAX) = (SELECT ref.value('@email','nvarchar(MAX)') FROM @inXML.nodes('/App_CreateUserRequest/users') R (ref))
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
INSERT INTO @userGroups   SELECT ref.value('@userGroupName','nvarchar(MAX)'),0 FROM @inXML.nodes('/App_CreateUserRequest/users/associatedUserGroups') R (ref)
INSERT INTO @userGroups   SELECT ref.value('@externalGroupName','nvarchar(MAX)'),1 FROM @inXML.nodes('/App_CreateUserRequest/users/associatedExternalUserGroups') R (ref)
SET @userGuid = ISNULL((SELECT ref.value('@GUID','nvarchar(MAX)') FROM @inXML.nodes('/App_CreateUserRequest/users/userEntity') R (ref)),NEWID())
-- find if the domain\login format OR only login name given
SET @pos=CHARINDEX('\',@login,1)
IF @pos <> 0
BEGIN
    SET @domainName =LTRIM(RTRIM(LEFT(@login,@pos-1)))
    SET @name= RIGHT(@login,LEN(@login)-@pos)
	UPDATE @userGroups
	 SET userGroupName =  substring(userGroupName,CHARINDEX('\',userGroupName)+1,len(userGroupName)), isADUserGroup = 1
	 WHERE CHARINDEX('\',userGroupName,1) <> 0
END
SET @domainId = (ISNULL((SELECT id from umdsproviders where domainName=@domainName),0))
IF (@domainId = 0 AND @pos <> 0)
BEGIN
	SET @errorCode = 1
	SET @errorStr = 'Domain not configured on Commcell'
	GOTO PROC_EXIT
END
IF EXISTS(SELECT 1 FROM UMUsers WHERE login like @login + '(Deleted,%' )
        BEGIN
            SET @userid = (SELECT TOP(1) id  FROM UMUsers WHERE login like @login + '(Deleted,%' ORDER BY id DESC)
            UPDATE UMUsers
            SET login = @login,
                flags = 1,
                enabled = 1,
				email = @email,
                umDSproviderId = @domainId
            WHERE id = @userid
			INSERT INTO UMUserGroup Select @userId, id,0 from UMGroups inner join @userGroups UG  on UG.userGroupName = UMGroups.name and UG.isADUserGroup = 0 and UMGroups.umdsProviderId = 0
			INSERT INTO UMUserGroup Select @userId, id,0 from UMGroups inner join @userGroups UG  on UG.userGroupName = UMGroups.name and UG.isADUserGroup = 1 and UMGroups.umdsProviderId = @domainId
        END
ELSE
        BEGIN
            INSERT INTO UMUsers([name]
            ,[description]
            ,[login]
            ,[password]
            ,[email]
            ,[datePasswordSet]
            ,[dateExpires]
            ,[policy]
            ,[enabled]
            ,[flags]
            ,[modified]
            ,[pVer]
            ,[Pager]
            ,[lastLogInTime]
            ,[credSetTime]
            ,[umDSproviderId]
            ,[userGuid]
            ,[origUserGuid])
            VALUES(@name, --name
            'Auto-Created user for Multicommcell via CRE',
            @login, -- login
            'Password Disabled',
            @email,--email
            0,--datePWDset
            0,--dateExpires
            0,--policy
            1,--enabled
            1,--flags
            0,--modified
            0,--pVer
            0,--Pager
            @nowTime,--lastLogInTime
            0,--credSetTime
            @domainId,--umDSproviderId
            @userGUID,--userGUID
            ''--origUserGuid
            )
            SET @userid = SCOPE_IDENTITY()
			INSERT INTO UMUserGroup Select @userId, id,0 from UMGroups inner join @userGroups UG  on UG.userGroupName = UMGroups.name and UG.isADUserGroup = 0 and UMGroups.umdsProviderId = 0
			INSERT INTO UMUserGroup Select @userId, id,0 from UMGroups inner join @userGroups UG  on UG.userGroupName = UMGroups.name and UG.isADUserGroup = 1 and UMGroups.umdsProviderId = @domainId
		END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @errorCode =  ERROR_NUMBER()
END CATCH
PROC_EXIT:
SET @inXML = ( SELECT @errorCode '@errorCode', @errorStr '@errorString',
(SELECT @userId as '@userId', @login as '@userName' FOR XML PATH ('entity'),TYPE)
FOR XML PATH('response'), ROOT('App_CreateUserResponse'),TYPE)
SELECT @inXML
GO

IF EXISTS (select * from GxQscripts where name = 'sec_createUserForRemoteCommcell')
	delete from GxQscripts where name = 'sec_createUserForRemoteCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_createUserForRemoteCommcell')
	delete from GXDBVersions where aliasname = 'sec_createUserForRemoteCommcell'
GO

insert into GXDBVersions values(2, 'sec_createUserForRemoteCommcell',  '00000000000000000000', 'sec_createUserForRemoteCommcell', '00000000000000000000')
GO

