

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_createProviderVCloudOrg.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_createProviderVCloudOrg')
BEGIN
	print '>>> Drop Stored Procedure: sec_createProviderVCloudOrg <<<'
	drop procedure sec_createProviderVCloudOrg
END
IF EXISTS (select * from GxQscripts where name='sec_createProviderVCloudOrg')
	delete from GxQscripts where name = 'sec_createProviderVCloudOrg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_createProviderVCloudOrg')
	delete from GXDBVersions where aliasname = 'sec_createProviderVCloudOrg'
GO
print '... Creating Procedure: sec_createProviderVCloudOrg'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_createProviderVCloudOrg
  @companyId int,
  @hostName varchar(MAX),
  @organisationUnitString varchar(MAX)
AS
  DECLARE @errorCode int
  DECLARE @errorString varchar(1000)
BEGIN
	DECLARE @createProvider XML
	DECLARE @umdsproviderId INT =0
	declare @login					nvarchar(128)
	declare @description			nvarchar(512)
	declare @password				nvarchar(512)
	declare @connectName			nvarchar(4000)
	declare @flags					integer
	declare @enabled				integer
	declare @serviceType			integer
	declare	@adminId				integer
	declare @domainName				nvarchar(512)
	declare @templateDomainName		nvarchar(512)
	declare @dnsRootStatus			integer
	declare @useSecureLdap			integer
	declare @port           		integer
	declare @resourceId				integer
	declare @creatorId				integer = 1
	DECLARE @providerIdOfInitiator INT=0
	declare @timeout				integer = 60
	declare @tries					integer = 3
	DECLARE @trustedhostUSer nvarchar(510)
	DECLARE @trusedHostPW nvarchar(800)
	DECLARE @ownerID int
	SET @errorCode=0
	SET @errorString=''
	IF NOT EXISTS(SELECT 1 from UMDSProviders where hostName=@hostName)
	BEGIN
		SELECT 1,'Ldap server doesnt exists'
		RETURN
	END
	SET @umdsproviderId = (SELECT TOP 1 id from UMDSProviders where hostName=@hostName order by id)
	IF EXISTS(SELECT 1 FROM UMProviderTypeAttributeMap WHERE attributeId =10 and attributeString=@organisationUnitString)
BEGIN
	SELECT 2,'Domain with same OU exists'
	RETURN
END
SELECT  @domainNAme =domainName,@description =description+ ' :Created for VCloud OU',@login =login,
@password =password,@trustedhostUSer=trustedHostUser,@trusedHostPW =trustedHostPW,@flags=flags,@enabled =enabled,@serviceType=14,@port=port,@ownerId=ownerId
FROM UMDSProviders where id = @umdsproviderId
DECLARE @inputString xml =(SELECT  1 as '@operation',
	(
	SELECT @login as '@login' ,@password as '@password',@hostName as '@connectName' ,@flags as '@flags',@enabled as '@enabled', @description as '@description',
			@serviceType as '@serviceType',@port as '@port',@companyId as '@ownerCompanyId'	,
			(SELECT  @domainName as '@domainName'  FOR XML PATH ('shortName'),TYPE),
(SELECT   (SELECT 10 as '@attrId',@organisationUnitString as '@customAttributeString'FOR XML PATH ('attributes'),TYPE)
				FOR XML PATH('customProvider'),TYPE)
	FOR XML PATH('provider'),TYPE
	)
FOR XML PATH('EVGui_UMDSProviderOpsReq'))
DECLARE @input nvarchar(MAX) =CAST (@inputString as  nvarchar(MAX))
DECLARE @outputtable TABLE (outputString xml)
INSERT INTO @outputtable
exec sec_UMDSProviderOpsReq 1,0,@input,0,0,0
DECLARE @ouptutString XML= (SELECT top 1 outputString from @outputTable)
SET @errorCode = ISNULL((SELECT ref.value('@errorCode','INT') AS errorCode
										FROM @ouptutString.nodes('App_GenericEntityResponse') R (ref)),0)
SET @errorString = ISNULL((SELECT ref.value('@errorString','varchar(1000)') AS errorCode
										FROM @ouptutString.nodes('App_GenericEntityResponse') R (ref)),'')
SELECT @errorCode,@errorString
END

IF EXISTS (select * from GxQscripts where name = 'sec_createProviderVCloudOrg')
	delete from GxQscripts where name = 'sec_createProviderVCloudOrg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_createProviderVCloudOrg')
	delete from GXDBVersions where aliasname = 'sec_createProviderVCloudOrg'
GO

insert into GXDBVersions values(2, 'sec_createProviderVCloudOrg',  '00000000000000000000', 'sec_createProviderVCloudOrg', '00000000000000000000')
GO

