

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_createDiscoveredUsersAndGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------------
--
--
--
--      This SP is used to add the newly discovered AD users and groups
--      To be done: Security check on provider
--
--
--
--
--
--		Authors: jswaminathan & saggarwal
-- -----------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_createDiscoveredUsersAndGroups')
BEGIN
	print '>>> Drop Stored Procedure: sec_createDiscoveredUsersAndGroups <<<'
	drop procedure sec_createDiscoveredUsersAndGroups
END
IF EXISTS (select * from GxQscripts where name='sec_createDiscoveredUsersAndGroups')
	delete from GxQscripts where name = 'sec_createDiscoveredUsersAndGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_createDiscoveredUsersAndGroups')
	delete from GXDBVersions where aliasname = 'sec_createDiscoveredUsersAndGroups'
GO
print '... Creating Procedure: sec_createDiscoveredUsersAndGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_createDiscoveredUsersAndGroups
  @xmlIn XML,
  @authorId INT,
  @localeId INT,
  @skipSecurityCheck INT = 0
AS
--Input variables
/*
DECLARE @xmlIn XML = '<App_DiscoverExternalUsersAndGroupsResp>
  <discoverResults domainName="commvault-nj" searchString="jswaminathan">
    <results description="" email="" fullName="Jagadeesh Kallidaikurichi Swaminathan">
      <associatedUserOrUserGroup _type_="13" clientSidePackage="1" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" userName="commvault-nj\jswaminathan" GUID="C5A86D98-0508-4D9A-8E25-1E617FD6870F"/>
    </results>
  </discoverResults>
  <discoverResults domainName="commvault-nj" searchString="mupadhyay">
    <results description="" email="" fullName="Mrityunjay Upadhyay">
      <associatedUserOrUserGroup _type_="13" clientSidePackage="1" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" userName="commvault-nj\mupadhyay" GUID="CDFF3615-8D17-4823-81F4-820E61317C49"/>
    </results>
  </discoverResults>
  <discoverResults domainName="commvault-nj" searchString="Dev-Server">
    <results description="" email="" fullName="Development server team">
      <associatedUserOrUserGroup _type_="62" clientSidePackage="1" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" externalGroupName="Dev-Server" providerId="2" GUID="B7CB61F6-EF21-4934-AB36-EB2697D99C84"/>
    </results>
  </discoverResults>
</App_DiscoverExternalUsersAndGroupsResp>'
DECLARE @authorId INT */
--Output variables
  DECLARE @errorCode INT 
  DECLARE @errorString NVARCHAR(MAX)
SET @errorCode = 0				--be optimistic
SET @errorstring = 'Successful'
--Read the inputs
DECLARE @nowTime INT = dbo.getUnixTime(GETUTCDATE())
DECLARE @usersTable TABLE
(
	userName NVARCHAR(MAX),
	domainName NVARCHAR(MAX),
	description NVARCHAR(MAX),
	email NVARCHAR(MAX),
	fullName NVARCHAR(MAX),
	GUID NVARCHAR(MAX),
	userId INT,
	providerId INT
)
DECLARE @userGroupsTable TABLE
(
	userGroupName NVARCHAR(MAX),
	domainName NVARCHAR(MAX),
	description NVARCHAR(MAX),
	email NVARCHAR(MAX),
	fullName NVARCHAR(MAX),
	GUID NVARCHAR(MAX),
	userGroupId INT,
	providerId INT
)
INSERT INTO @usersTable (domainName, userName, GUID, description, email, fullName, userId, providerId)
	SELECT U.value('(../@domainName)[1]', 'NVARCHAR(MAX)'),
		   U.value('(associatedUserOrUserGroup/@userName)[1]', 'NVARCHAR(MAX)'),
		   U.value('(associatedUserOrUserGroup/@GUID)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@description)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@email)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@fullName)[1]', 'NVARCHAR(MAX)'),
		   0,
		      ISNULL(U.value('(associatedUserOrUserGroup/@providerId)[1]', 'INT'),0)
	FROM @xmlIn.nodes('App_DiscoverExternalUsersAndGroupsResp/discoverResults/results') AS Input(U)
WHERE U.value('(associatedUserOrUserGroup/@_type_)[1]', 'NVARCHAR(MAX)') = 13
INSERT INTO @userGroupsTable (domainName, userGroupName, GUID, description, email, fullName, userGroupId, providerId)
	SELECT U.value('(../@domainName)[1]', 'NVARCHAR(MAX)'),
		   U.value('(associatedUserOrUserGroup/@externalGroupName)[1]', 'NVARCHAR(MAX)'),
		   U.value('(associatedUserOrUserGroup/@GUID)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@description)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@email)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@fullName)[1]', 'NVARCHAR(MAX)'),
		   0,
		    ISNULL(U.value('(associatedUserOrUserGroup/@providerId)[1]', 'INT'),0)
	FROM @xmlIn.nodes('App_DiscoverExternalUsersAndGroupsResp/discoverResults/results') AS Input(U)
WHERE U.value('(associatedUserOrUserGroup/@_type_)[1]', 'NVARCHAR(MAX)') = 62
	UNION
	SELECT U.value('(../@domainName)[1]', 'NVARCHAR(MAX)'),
		   U.value('(associatedUserOrUserGroup/@userGroupName)[1]', 'NVARCHAR(MAX)'),
		   U.value('(associatedUserOrUserGroup/@GUID)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@description)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@email)[1]', 'NVARCHAR(MAX)'),
		   U.value('(@fullName)[1]', 'NVARCHAR(MAX)'),
		   0,
		    ISNULL(U.value('(associatedUserOrUserGroup/@providerId)[1]', 'INT'),0)
	FROM @xmlIn.nodes('App_DiscoverExternalUsersAndGroupsResp/discoverResults/results') AS Input(U)
WHERE U.value('(associatedUserOrUserGroup/@_type_)[1]', 'NVARCHAR(MAX)') = 15
--when we receive user group names in USERGROUP_ENTITY, they are filled as commvault-nj\Dev-Server
UPDATE @userGroupsTable
SET userGroupName = SUBSTRING(userGroupName, CHARINDEX('\', userGroupName, 1)+1, LEN(userGroupName))
WHERE CHARINDEX('\', userGroupName, 1) >= 0
--Fill the provider Ids
UPDATE Tbl
SET providerId = P.id
FROM @usersTable Tbl INNER JOIN UMDSProviders P
ON Tbl.domainName = P.domainName
WHERE P.enabled <> 0 and TBL.providerId=0
UPDATE Tbl
SET providerId = P.id
FROM @userGroupsTable Tbl INNER JOIN UMDSProviders P
ON Tbl.domainName = P.domainName
WHERE P.enabled <> 0 and TBL.providerId=0
--there are many places where this stored procedure is called with existing users / groups
--these entries should be ignored
DELETE Tbl
FROM @usersTable Tbl INNER JOIN UMUsers U
ON Tbl.userName = U.login
DELETE Tbl
FROM @userGroupsTable Tbl INNER JOIN UMGroups G
ON Tbl.userGroupName = G.name AND G.umdsProviderID = Tbl.providerId AND (G.groupFlags & 1 <> 0)
--Security check alone needs to be done on the provider
IF @skipSecurityCheck = 0
BEGIN
	IF OBJECT_ID ('tempdb.dbo.#providersAddUser') IS NOT NULL
		DROP TABLE #providersAddUser
	IF OBJECT_ID ('tempdb.dbo.#providersAddUserGroup') IS NOT NULL
		DROP TABLE #providersAddUserGroup
	CREATE TABLE #providersAddUser (providerId INT)
	CREATE TABLE #providersAddUserGroup (providerId INT)
EXEC sec_getNonIdaObjectsForThisUser @authorId, 61, 101, '#providersAddUser'
EXEC sec_getNonIdaObjectsForThisUser @authorId, 61, 102, '#providersAddUserGroup'
	IF EXISTS (SELECT 1 FROM @usersTable WHERE providerId NOT IN (SELECT providerId FROM #providersAddUser))
	BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @authorId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (dbo.sec_getLocalizedPermission(101, @localeId)))
		SET @errorString = REPLACE(@errorString, '^3%s', (SELECT domainName FROM UMDSProviders WHERE id = (SELECT TOP 1 providerId FROM @usersTable WHERE providerId NOT IN (SELECT providerId FROM #providersAddUser))))
SET @errorString = REPLACE(@errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2377 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
		GOTO ERR_EXIT
	END
	IF EXISTS (SELECT 1 FROM @userGroupsTable WHERE providerId NOT IN (SELECT providerId FROM #providersAddUserGroup))
	BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WHERE id = @authorId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (dbo.sec_getLocalizedPermission(101, @localeId)))
		SET @errorString = REPLACE(@errorString, '^3%s', (SELECT domainName FROM UMDSProviders WHERE id = (SELECT TOP 1 providerId FROM @usersTable WHERE providerId NOT IN (SELECT providerId FROM #providersAddUserGroup))))
SET @errorString = REPLACE(@errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2377 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
		GOTO ERR_EXIT
	END
END
--Handle deleted users
UPDATE Users
SET login = Tbl.userName,
	flags = 1,
	enabled = 1,
	password = '2ALXqLLXNLLX0LLXcLLXxLL',
    umDSproviderId=Tbl.providerId,
	email=Tbl.email
FROM UMUsers Users INNER JOIN @usersTable Tbl
ON Users.login LIKE (Tbl.userName) + '(Deleted%'
--Handle deleted user groups
UPDATE G
SET G.groupFlags = (G.groupFlags | CAST(0x0001 AS INT)) & ~ CAST(0x0020 AS INT)			--Ideally we wont hit this with a GUI Hidden group.
FROM UMGroups G INNER JOIN @userGroupsTable GrpTbl
ON G.name = GrpTbl.userGroupName AND G.umdsproviderId = GrpTbl.providerId
UPDATE G
SET G.enabled = 1
FROM UMDSGroups G INNER JOIN @userGroupsTable GrpTbl
ON G.name = GrpTbl.userGroupName AND G.umdsProviderId = GrpTbl.providerId
-- If AD User login is updated in AD then update UMUsers table to avoid duplicate entry
UPDATE Users SET Users.login = Tbl.userName FROM UMUsers Users
INNER JOIN @usersTable tbl ON Tbl.GUID = Users.userGUID AND Tbl.providerId = Users.umDSproviderId AND Tbl.userName <> Users.login
-- If AD User Group login is updated in AD then update UMGroups and UMDSGroups tables to avoid duplicate entry
UPDATE UGroups SET UGroups.name = Tbl.userGroupName FROM UMDSGroups UGroups
INNER JOIN UMGroups Groups ON UGroups.id = Groups.id AND UGroups.umdsProviderId = Groups.umDSproviderId
INNER JOIN @userGroupsTable Tbl ON Tbl.GUID = Groups.GUID AND Tbl.providerId = Groups.umDSproviderId AND Tbl.userGroupName <> Groups.name
UPDATE Groups SET Groups.name = Tbl.userGroupName FROM UMGroups Groups
INNER JOIN @userGroupsTable Tbl ON Tbl.GUID = Groups.GUID AND Tbl.providerId = Groups.umDSproviderId AND Tbl.userGroupName <> Groups.name
--For already existing users and groups fill the Ids
UPDATE Tbl
SET Tbl.userId = Users.id
FROM @usersTable Tbl INNER JOIN UMUsers Users
ON Tbl.userName = Users.login AND Tbl.providerId = Users.umDSproviderId
UPDATE Tbl
SET Tbl.userGroupId = Groups.id
FROM @userGroupsTable Tbl INNER JOIN UMGroups Groups
ON Tbl.userGroupName = Groups.name AND Tbl.providerId = Groups.umdsproviderID
INSERT INTO UMUsers (name,description,login,password,email,datePasswordSet , dateExpires ,policy, enabled , flags,modified,pVer,Pager,lastLoginTime,credSetTime,umdsProviderId,userGUID,origUserGuid,origCCID)
	SELECT Tbl.fullName, Tbl.description, Tbl.userName, '2AZdUUxUUyUUz',Tbl.email, @nowtime, 0, 0, 1, 1, 0, 50, '', 0, 0, Tbl.providerid,
                ISNULL(GUID, NEWID()), '', 2
    FROM (SELECT DISTINCT * FROM @usersTable) Tbl
    WHERE userId <= 0
INSERT INTO UMGroups (groupFlags,allCapabilities,allAssociations,selfAssociation,name,description,origCCId,GUID,umdsProviderId,email,lastCredSetTime)
	SELECT DISTINCT 1, 0, 0, 1, Tbl.userGroupName, Tbl.description, 2, ISNULL(GUID, NEWID()), Tbl.providerId, Tbl.email, dbo.GetUnixTime(getutcdate())
    FROM (SELECT DISTINCT * FROM @userGroupsTable) Tbl
    WHERE userGroupId <= 0
INSERT INTO UMDSGroups
	SELECT DISTINCT UMGroups.id, Tbl.providerId, 1, Tbl.usergroupname, Tbl.description, Tbl.email, dbo.getunixtime(getutcdate()), 0
	FROM (SELECT DISTINCT * FROM @userGroupsTable) Tbl INNER JOIN UMGroups
	ON Tbl.userGroupName = UMGroups.name AND Tbl.providerId = UMGroups.umdsProviderId
	WHERE userGroupId <= 0
ERR_EXIT:
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_createDiscoveredUsersAndGroups')
	delete from GxQscripts where name = 'sec_createDiscoveredUsersAndGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_createDiscoveredUsersAndGroups')
	delete from GXDBVersions where aliasname = 'sec_createDiscoveredUsersAndGroups'
GO

insert into GXDBVersions values(2, 'sec_createDiscoveredUsersAndGroups',  '00000000000000000000', 'sec_createDiscoveredUsersAndGroups', '00000000000000000000')
GO

