

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_cloneSecurityAssociationsFromEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_cloneSecurityAssociationsFromEntity
--  |
--  | Description:  cloning security associations from a source entity to a destination entity
--  |
--	|	Input should be the source entity and destination entity
--  |   No security associations will be done here, it is up to the caller to do them and call this SP
--  |   Flags = 1 => Source associations will be retained, Destination associations will be appended with source associations
--	|	Flags = 2 => Source associations will be retained, Destination associations will be overwritten with source associations
--	|	Flags = 3 => Source associations will be deleted, Destination associations will be appended with source associations
--	|	Flags = 4 => Source associations will be deleted, Destination associations will be overwritten with source associations
--	|	OwnerSecurityAssociations = 0 => Clone only security associations (default so that backward compatiblity is retained)
--	|   OwnerSecurityAssociations = 1 => Clone only owner associations
--	|   OwnerSecurityAssociations = 2 => Clone both security associations + owner associations
--	|
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_cloneSecurityAssociationsFromEntity <<<'

IF EXISTS (select * from sysobjects where name='sec_cloneSecurityAssociationsFromEntity')
	drop procedure sec_cloneSecurityAssociationsFromEntity
IF EXISTS (select * from GxQscripts where name='sec_cloneSecurityAssociationsFromEntity')
	delete from GxQscripts where name = 'sec_cloneSecurityAssociationsFromEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_cloneSecurityAssociationsFromEntity')
	delete from GXDBVersions where aliasname = 'sec_cloneSecurityAssociationsFromEntity'
GO
print '... Creating Procedure: sec_cloneSecurityAssociationsFromEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_cloneSecurityAssociationsFromEntity
  @flags INT,														
  @callerId INT,
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT,
  @srcEntityType1 INT,
  @srcEntityId1 INT,
  @destEntityType1 INT,
  @destEntityId1 INT,
  @srcEntityType2 INT = 0,
  @srcEntityId2 INT = 0,
  @destEntityType2 INT = 0,
  @destEntityId2 INT = 0,
  @srcEntityType3 INT = 0,
  @srcEntityId3 INT = 0,
  @destEntityType3 INT = 0,
  @destEntityId3 INT = 0,
  @srcEntityType4 INT = 0,
  @srcEntityId4 INT = 0,
  @destEntityType4 INT = 0,
  @destEntityId4 INT = 0,
  @srcEntityType5 INT = 0,
  @srcEntityId5 INT = 0,
  @destEntityType5 INT = 0,
  @destEntityId5 INT = 0,
  @ownerSecurityAssociation INT = 0
AS
	BEGIN TRY
		SET @errorCode = 0
		SET @errorString = 'Successful'
		IF @ownerSecurityAssociation IN (0, 2)
		BEGIN
			IF @flags IN (2,4)			--overwrite the destination entity security associations with source entity security associations
			BEGIN
				DELETE UMSecurityAssociations
				WHERE entityType1 = @destEntityType1 AND entityId1 = @destEntityId1 AND
					  entityType2 = @destEntityType2 AND entityId2 = @destEntityId2 AND
					  entityType3 = @destEntityType3 AND entityId3 = @destEntityId3 AND
					  entityType4 = @destEntityType4 AND entityId4 = @destEntityId4 AND
					  entityType5 = @destEntityType5 AND entityId5 = @destEntityId5
			END
			DECLARE @destEntityOldAssociations TABLE (roleId INT, permissionId INT, userOrGroupId INT, isUser INT, isCreator INT)
			INSERT @destEntityOldAssociations
				SELECT roleId , permissionId , userOrGroupId , isUser , isCreator
				FROM UMSecurityAssociations
				WHERE entityType1 = @destEntityType1 AND entityId1 = @destEntityId1 AND
				  entityType2 = @destEntityType2 AND entityId2 = @destEntityId2 AND
				  entityType3 = @destEntityType3 AND entityId3 = @destEntityId3 AND
				  entityType4 = @destEntityType4 AND entityId4 = @destEntityId4 AND
				  entityType5 = @destEntityType5 AND entityId5 = @destEntityId5
			INSERT UMSecurityAssociations  (roleId, permissionId ,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects, roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId)
				SELECT Sec.roleId, Sec.permissionId, Sec.userOrGroupId, Sec.isUser, isRoleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude,
						@destEntityTYpe1, @destEntityId1,
						@destEntityTYpe2, @destEntityId2,
						@destEntityTYpe3, @destEntityId3,
						@destEntityTYpe4, @destEntityId4,
						@destEntityTYpe5, @destEntityId5,
						includeAll, Sec.isCreator, CASE WHEN @callerId <> 0 THEN @callerId ELSE authorId END
				FROM UMSecurityAssociations Sec LEFT OUTER JOIN @destEntityOldAssociations Tbl
				ON Sec.roleId = Tbl.roleId AND Sec.permissionId = Tbl.permissionId AND
				   Sec.userOrGroupId = Tbl.userOrGroupId AND Sec.isUser = Tbl.isUser AND
				   Sec.isCreator = Tbl.isCreator
				WHERE (entityType1 = @SrcEntityType1 AND entityId1 = @SrcEntityId1 AND
				  entityType2 = @SrcEntityType2 AND entityId2 = @SrcEntityId2 AND
				  entityType3 = @SrcEntityType3 AND entityId3 = @SrcEntityId3 AND
				  entityType4 = @SrcEntityType4 AND entityId4 = @SrcEntityId4 AND
				  entityType5 = @SrcEntityType5 AND entityId5 = @SrcEntityId5)
				  AND
				  (Tbl.roleId IS NULL AND Tbl.permissionId IS NULL AND Tbl.userOrGroupId IS NULL AND Tbl.isUser IS NULL AND Tbl.isCreator IS NULL)
			IF @flags IN (3,4)		--Delete the source security associations
			BEGIN
				DELETE UMSecurityAssociations
				WHERE entityType1 = @SrcEntityType1 AND entityId1 = @SrcEntityId1 AND
					  entityType2 = @SrcEntityType2 AND entityId2 = @SrcEntityId2 AND
					  entityType3 = @SrcEntityType3 AND entityId3 = @SrcEntityId3 AND
					  entityType4 = @SrcEntityType4 AND entityId4 = @SrcEntityId4 AND
					  entityType5 = @SrcEntityType5 AND entityId5 = @SrcEntityId5
			END
		END
		IF @ownerSecurityAssociation IN (1, 2)
		BEGIN
			IF @flags IN (2,4)			--overwrite the destination entity security associations with source entity security associations
			BEGIN
				DELETE UMOwners
				WHERE entityType = @destEntityType1 AND entityId = @destEntityId1
			END
			INSERT INTO UMOwners (entityTYpe, entityId, userOrGroupId, isUser, authorId, flags)
				SELECT @destEntityType1, @destEntityId1, userOrGroupId, isUser, authorId, flags
				FROM UMOwners
				WHERE entityType = @srcEntityType1 AND entityID = @srcEntityId1
				EXCEPT
				SELECT @destEntityType1, @destEntityId1, userOrGroupId, isUser, authorId, flags
				FROM UMOwners
				WHERE entityType = @destEntityType1 AND entityID = @destEntityId1
			IF @flags IN (3,4)		--Delete the source security associations
			BEGIN
				DELETE UMOwners
				WHERE entityType = @srcEntityType1 AND entityId = @srcEntityId1
			END
			DECLARE @sourceOwnerRoleXML XML
			DECLARE @destOwnerPermissionXML XML
			DECLARE @sourceOwnerRoleId INT = ISNULL((SELECT roleID FROM UMOwnerRoles WHERE entityType = @srcEntityType1 AND entityId = @srcEntityId1), 0)
			DECLARE @destRoleOperationType INT = 2				--Add
			IF @flags IN (2,4)
				SET @destRoleOperationType = 1					--Overwrite
			IF @sourceOwnerRoleId > 0
			BEGIN
				SET @sourceOwnerRoleXML = (SELECT 30 as '@listPropertyLevel',
													(SELECT @sourceOwnerRoleId AS '@roleId'
													FOR XML PATH ('roleEntity'), TYPE),
													(SELECT
														(SELECT 1 AS '@userId'			--US_ADMIN_USER_ID
														FOR XML PATH ('user'), TYPE)
													FOR XML PATH ('processinginstructioninfo'), TYPE)
												FOR XML PATH ('Security_GetRolesPropertiesRequest'))
				EXEC sec_getRoleDetailList @sourceOwnerRoleXML OUTPUT, 1					--Include hidden role
				SET @destOwnerPermissionXML = (SELECT
													(SELECT
														(SELECT @destRoleOperationType AS '@categoriesPermissionOperationType',
																@sourceOwnerRoleXML.query('Security_GetRolesPropertiesResponse/roleProperties/categoryPermission/categoriesPermissionList')
														FOR XML PATH ('categoryPermission'), TYPE)
													FOR XML PATH ('ownerAssociations'), TYPE)
												FOR XML PATH ('App_SecurityAssociationForEntityList'), TYPE)
				IF @destOwnerPermissionXML IS NOT NULL
					EXEC sec_populateOwnersTable @destOwnerPermissionXML, 1, 0, 0, @destEntityType1, @destEntityId1, 1, @errorCode OUTPUT, @errorString OUTPUT
				IF @flags IN (3,4)		--Delete the source security associations
				BEGIN
					SET @sourceOwnerRoleXML = (SELECT
														(SELECT
															(SELECT 1 AS '@categoriesPermissionOperationType'			--Overwrite
															FOR XML PATH ('categoryPermission'), TYPE)
														FOR XML PATH ('ownerAssociations'), TYPE)
													FOR XML PATH ('App_SecurityAssociationForEntityList'), TYPE)
					EXEC sec_populateOwnersTable @sourceOwnerRoleXML, 1, 0, 0, @srcEntityTYpe1, @srcEntityID1, 1, @errorCode OUTPUT, @errorString OUTPUT
				END
			END
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END CATCH
ERR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'sec_cloneSecurityAssociationsFromEntity')
	delete from GxQscripts where name = 'sec_cloneSecurityAssociationsFromEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_cloneSecurityAssociationsFromEntity')
	delete from GXDBVersions where aliasname = 'sec_cloneSecurityAssociationsFromEntity'
GO

insert into GXDBVersions values(2, 'sec_cloneSecurityAssociationsFromEntity',  '00000000000000000000', 'sec_cloneSecurityAssociationsFromEntity', '00000000000000000000')
GO

