

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_checkUserHasCapWithoutAssoc.sp] ---------- 

--		ALLOW COMMENTS BELOW HERE!
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_checkUserHasCapWithoutAssoc.sp,v $ $Id: sec_checkUserHasCapWithoutAssoc.sp,v 1.6.42.3 2017/05/08 11:42:47 jswaminathan Exp $";
-- =============================================
-- Author:		Bhavyan Mehta
-- Creation date: 05/03/2010
-- Description:	Return all capability for users without association check
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_checkUserHasCapWithoutAssoc <<<'

IF EXISTS (select * from sysobjects where name='sec_checkUserHasCapWithoutAssoc')
	drop procedure sec_checkUserHasCapWithoutAssoc
IF EXISTS (select * from GxQscripts where name='sec_checkUserHasCapWithoutAssoc')
	delete from GxQscripts where name = 'sec_checkUserHasCapWithoutAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkUserHasCapWithoutAssoc')
	delete from GXDBVersions where aliasname = 'sec_checkUserHasCapWithoutAssoc'
GO
print '... Creating Procedure: sec_checkUserHasCapWithoutAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_checkUserHasCapWithoutAssoc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId INTEGER
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @capability BIGINT
SET @capability = 0
IF dbo.isNewSecurity() = 0
BEGIN
	-- ad user
	IF EXISTS(SELECT umDSproviderId FROM UMUsers WHERE id = @userId AND umDSproviderId <> 0)
	BEGIN
		-- CHECK IF USERS BELONGS TO GROUP WITH ALL CAPABILITIES
		IF EXISTS (SELECT 1 FROM UMUsers UM
			INNER JOIN	UMDSgroups UG ON UM.umDSproviderId = UG.umdsProviderId AND UM.id = @userId AND UG.enabled > 0
			INNER JOIN UMDSUserGroup UUG ON UUG.userId = UM.id AND UUG.groupId=UG.id
			INNER JOIN UMDSGroupMaps GM ON UG.id = GM.umDSgroupId
INNER JOIN UMGroups GC ON GM.umgroupId = GC.id AND GC.allCapabilities = 1 AND GC.groupFlags&0x0001=0x0001)
		BEGIN
			SET @capability = (select SUM(POWER(2.0, id-1)) FROM UMCapability)
		END
		ELSE
		BEGIN
			SET @capability = (SELECT dbo.BitwiseOR(POWER(2.0,GC.capabilityId-1)) FROM UMUsers UM
				INNER JOIN	UMDSgroups UG ON UM.umDSproviderId = UG.umdsProviderId AND UM.id = @userId AND UG.enabled > 0
				INNER JOIN UMDSUserGroup UUG ON UUG.userId = UM.id AND UUG.groupId=UG.id
				INNER JOIN UMDSGroupMaps GM ON UG.id = GM.umDSgroupId
				INNER JOIN UMGroupCapability GC ON GM.umgroupId = GC.groupId
INNER JOIN UMGroups G ON GM.umgroupId = G.id AND G.groupFlags&0x0001=0x0001)
		END
	END
--
	-- Check in galaxy user tables for both users as they can directly be part of the galaxy user groups
	BEGIN
		-- CHECK IF USERS BELONGS TO GROUP WITH ALL CAPABILITIES
		IF EXISTS (SELECT 1 FROM UMUserGroup UG
			INNER JOIN UMGroups GC ON UG.groupId = GC.id AND GC.allCapabilities = 1 AND UG.userId = @userId AND GC.groupFlags & 1 = 1) -- CHECK IF ENABLED
		BEGIN
			SET @capability = (select SUM(POWER(2.0, id-1)) FROM UMCapability)
		END
		ELSE
		BEGIN
			SET @capability = @capability | (SELECT dbo.BitwiseOR(POWER(2.0,GC.capabilityId-1)) FROM UMUserGroup UG
				INNER JOIN	UMGroups G ON UG.groupId = G.id AND UG.userId = @userId AND G.groupFlags & 1 = 1 -- CHECK IF ENABLED
				INNER JOIN UMGroupCapability GC ON GC.groupId = G.id )
		END
	END
--
END
ELSE
BEGIN
	IF OBJECT_ID ('tempdb.dbo.#userAndGroupId') IS NOT NULL
		DROP TABLE #userAndGroupId
	CREATE TABLE #userAndGroupId (userOrGroupId INT, isUser INT)
	DECLARE @permissionList TABLE (permissionId INT)
	INSERT INTO #userAndGroupId
              SELECT DISTINCT id, 0
			  FROM UMGroups INNER JOIN (SELECT groupId, 0 AS isUser FROM UMUserGroup INNER JOIN UMGroups ON UMUserGroup.groupId = UMGroups.id WHERE userId = @userId
										UNION
										SELECT umGroupId, 0 FROM UMDSGroupMaps (NOLOCK) INNER JOIN UMUserGroup (NOLOCK) ON UMDSGroupMaps.umDSgroupId = UMUserGroup.groupId AND userId = @userId) AS UG
			  ON UMGroups.id = UG.groupId
			  WHERE groupFlags & 1 = 1
			  UNION
			  SELECT @userId, 1
	INSERT INTO @permissionList
		SELECT DISTINCT CASE WHEN permissionId < 64 THEN permissionId ELSE 31 END
		FROM UMSecurityAssociations Sec INNER JOIN #userAndGroupId UG
		ON Sec.isUser =  UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
		WHERE permissionId <> 0
		UNION ALL
		SELECT DISTINCT CASE WHEN Rpe.permissionId < 64 THEN Rpe.PermissionId ELSE 31 END
		FROM UMRolesWithPermissionsExpanded Rpe INNER JOIN UMROles Roles
		ON Rpe.roleId = Roles.id
		WHERE Roles.disabled = 0 AND Rpe.roleId IN (SELECT DISTINCT roleId
													FROM UMSecurityAssociations Sec INNER JOIN #userAndGroupId UG
													ON Sec.isUser =  UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId)
		IF OBJECT_ID ('tempdb.dbo.#tempOwnerRoles') IS NOT NULL
				DROP TABLE #tempOwnerRoles
		CREATE TABLE #tempOwnerRoles (roleId INT)
		--if the user is owner of commcell then he has all the entity owner's roles
		IF EXISTS (SELECT entitytype
				   FROM UMOwners owners INNER JOIN #userAndGroupId UG
				   ON owners.isUser = UG.isUser AND owners.userOrGroupId = UG.userOrGroupId
				   WHERE owners.entityType = 1 AND owners.entityId = 2)
		BEGIN
			INSERT INTO #tempOwnerRoles
				SELECT DISTINCT roleId
				FROM UMOwnerRoles
		END
		--else get list of owner roles that user has
		ELSE
		BEGIN
			--A user will have these roles -
			--1. All the owner roles on the children entities of the parent entities for whom the user is owner of
			--2. All the owner roles on the parent entities of the children entities for whom the user is owner of
			--3. All the owner roles on the entity for whom he is the owner of
			--if user is a owner of a entity get the list of roles of that entity
			INSERT INTO #tempOwnerRoles
				SELECT ownerroles.roleid
				FROM UMOwnerRoles ownerroles INNER JOIN UMOwners owners
				ON ownerroles.entityType = owners.entityType AND ownerroles.entityId = owners.entityId
				INNER JOIN #userAndGroupId ug
				ON owners.isuser = ug.isuser AND owners.userOrGroupId = ug.userorgroupid
			DECLARE @associationquery NVARCHAR(MAX) = N''
			DECLARE @localassociationquery NVARCHAR(MAX) = N''
			DECLARE @dynamicsql NVARCHAR(MAX) = N''
			--if user or group is owner of parent, then has to get all children roles
			--a single parent may be parent of many entity types
			--example, user group entity (15) is parent of user entity (13) and external group entity (62)
			--so get a union of those queries
			DECLARE entityParentTypeCursor CURSOR FOR
				SELECT DISTINCT associationQuery
				FROM (SELECT DISTINCT owners.entitytype
					  FROM UMOwners owners INNER JOIN #userAndGroupId ug
					  ON owners.isuser = ug.isuser AND owners.userOrGroupId = ug.userorgroupid) ownerEntities
				INNER JOIN app_entityparentassociation entityparentassoc
				ON entityparentassoc.parentEntityType = ownerEntities.entityType
			OPEN entityParentTypeCursor
			FETCH NEXT FROM entityParentTypeCursor INTO @localassociationquery
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @associationquery <> ''
					SET @associationquery = @associationquery + CHAR(10) + ' UNION ' + CHAR(10) + @localassociationquery
				ELSE
					SET @associationquery = @localassociationquery
				FETCH NEXT FROM entityParentTypeCursor INTO @localassociationquery
			END
			CLOSE entityParentTypeCursor
			DEALLOCATE entityParentTypeCursor
			IF(@associationquery <> '' and @associationquery IS NOT NULL)
			BEGIN
				SET @dynamicsql = 'INSERT INTO #tempOwnerRoles
								   SELECT DISTINCT ownerroles.roleid
								   FROM UMOwners owners
								   INNER JOIN (' +
								   CHAR(10) +
								   @associationquery +
								   CHAR(10) +
								   ') assoc
									ON assoc.parententitytype = owners.entitytype AND assoc.parentid = owners.entityid
									INNER JOIN umownerroles ownerroles
									ON ownerroles.entitytype = assoc.childentitytype AND ownerroles.entityid = assoc.childid
									INNER JOIN #userAndGroupId UG ON
									owners.isUser = UG.isUser AND owners.userOrGroupId = UG.userOrGroupId'
				EXEC (@dynamicsql)
			END
			SET @associationquery = ''
			SET @localassociationquery = ''
			SET @dynamicsql = ''
			--if user or group is owner of children has to get parent roles
			--a single child entity can be part of multiple parent entities
			--example, user entity is a child of user group entity, domain user group entity and nameserver entity
			--so get a union of those queries
			DECLARE childEntityTypeCursor CURSOR FOR
				SELECT DISTINCT associationQuery
				FROM (SELECT DISTINCT owners.entitytype
					  FROM UMOwners owners INNER JOIN #userAndGroupId ug
					  ON owners.isuser = ug.isuser AND owners.userOrGroupId = ug.userorgroupid) ownerEntities
				INNER JOIN app_entityparentassociation entityparentassoc
				ON entityparentassoc.childEntityType = ownerEntities.entityType
			OPEN childEntityTypeCursor
			FETCH NEXT FROM childEntityTypeCursor INTO @localassociationquery
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @associationquery <> ''
					SET @associationquery = @associationquery + CHAR(10) + ' UNION ' + CHAR(10) + @localassociationquery
				ELSE
					SET @associationquery = @localassociationquery
				FETCH NEXT FROM childEntityTypeCursor INTO @localassociationquery
			END
			CLOSE childEntityTypeCursor
			DEALLOCATE childEntityTypeCursor
			IF(@associationquery <> '' AND @associationquery IS NOT NULL)
			BEGIN
				SET @dynamicsql = 'INSERT INTO #tempOwnerRoles
								   SELECT DISTINCT ownerroles.roleid
								   FROM UMOwners owners
								   INNER JOIN (' +
								   CHAR(10) +
								   @associationquery +
								   CHAR(10) +
								   ') assoc
									ON assoc.childEntityType = owners.entitytype AND assoc.childId = owners.entityid
									INNER JOIN umownerroles ownerroles
									ON ownerroles.entitytype = assoc.parentEntityType AND ownerroles.entityid = assoc.parentId
									INNER JOIN #userAndGroupId UG ON
									owners.isUser = UG.isUser AND owners.userOrGroupId = UG.userOrGroupId'
				EXEC (@dynamicsql)
			END
		END
		INSERT INTO @permissionList
			SELECT DISTINCT Rpe.permissionId
			FROM UMROlesWithPermissionsExpanded Rpe INNER JOIN #tempOwnerRoles ORoles
			ON Rpe.roleId = ORoles.roleId
SET @capability = ( SELECT dbo.bitwiseOR(POWER(2.0,permissionId-1))
					FROM @permissionList
					WHERE permissionId < 64)
END
SELECT @capability
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_checkUserHasCapWithoutAssoc')
	delete from GxQscripts where name = 'sec_checkUserHasCapWithoutAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkUserHasCapWithoutAssoc')
	delete from GXDBVersions where aliasname = 'sec_checkUserHasCapWithoutAssoc'
GO

insert into GXDBVersions values(2, 'sec_checkUserHasCapWithoutAssoc',  '00010006004200030000', 'sec_checkUserHasCapWithoutAssoc', '00010006004200030000')
GO

