

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_checkUserHasAllPermissionsOnEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--           Stored procedure to check if an user has all permissions
--           on a given entity. It will check if he has all permissions
--           mapped to this entity type and entity type 0 in
--           UMPermissionEntityTypeMap table are present on this entity.
--
--
--           Authors: saggarwal and jswaminathan
-- ----------------------------------------------------------------------*/
--stored procedure to check if a given user has all applicable permissions on a given entity
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_checkUserHasAllPermissionsOnEntity <<<'

IF EXISTS (select * from sysobjects where name='sec_checkUserHasAllPermissionsOnEntity')
	drop procedure sec_checkUserHasAllPermissionsOnEntity
IF EXISTS (select * from GxQscripts where name='sec_checkUserHasAllPermissionsOnEntity')
	delete from GxQscripts where name = 'sec_checkUserHasAllPermissionsOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkUserHasAllPermissionsOnEntity')
	delete from GXDBVersions where aliasname = 'sec_checkUserHasAllPermissionsOnEntity'
GO
print '... Creating Procedure: sec_checkUserHasAllPermissionsOnEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_checkUserHasAllPermissionsOnEntity
  @userID int,
  @entityType int,
  @entityId int,
  @hasPermissions int output,
  @returnCursor int = 0
AS
SET NOCOUNT ON
  DECLARE @outputVariable INT
if object_id('tempdb.dbo.#allPermissions') is not null
	drop table #allPermissions
create table #allPermissions (permissionId int)
exec sec_getPermissionsOnEntity '#allPermissions', @userId, @entityType, @entityId
if exists (select 1
		   from UMPermissionEntityTypeMap
		   where entityType in (0, @entityType) and
		   permissionId not in (select permissionId from #allPermissions union select id from umpermissions where flags & 2 <> 0))			--ignore hidden permissions
	set @hasPermissions = 0
else
	set @hasPermissions = 1
if @returnCursor = 1
	select @hasPermissions
if object_id('tempdb.dbo.#allPermissions') is not null
	drop table #allPermissions
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_checkUserHasAllPermissionsOnEntity')
	delete from GxQscripts where name = 'sec_checkUserHasAllPermissionsOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkUserHasAllPermissionsOnEntity')
	delete from GXDBVersions where aliasname = 'sec_checkUserHasAllPermissionsOnEntity'
GO

insert into GXDBVersions values(2, 'sec_checkUserHasAllPermissionsOnEntity',  '00000000000000000000', 'sec_checkUserHasAllPermissionsOnEntity', '00000000000000000000')
GO

