

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_checkPermissionOnEntityType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------
--
--	SP: sec_checkPermissionOnEntityType
--
--	Description: Checks whether an user has right(s) on a entity Type (Any entity)
--				 Can be used for checking OR and AND of rights. (andOperation)
--				 When passing multiple permissions, pass external table #permissionIdTbl
--				 When passing single permission, pass in permissionId
--				 When only one permission Id 0 is passed will check for any association.
--
--	Author:	jswaminathan
-- ------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_checkPermissionOnEntityType <<<'

IF EXISTS (select * from sysobjects where name='sec_checkPermissionOnEntityType')
	drop procedure sec_checkPermissionOnEntityType
IF EXISTS (select * from GxQscripts where name='sec_checkPermissionOnEntityType')
	delete from GxQscripts where name = 'sec_checkPermissionOnEntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkPermissionOnEntityType')
	delete from GXDBVersions where aliasname = 'sec_checkPermissionOnEntityType'
GO
print '... Creating Procedure: sec_checkPermissionOnEntityType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_checkPermissionOnEntityType
  @userId INT,
  @entityType INT,
  @isAllowed INT OUTPUT,
  @permissionId INT = -1,
  @AndOperation INT = 0,
  @isReturned INT = 0
AS
  DECLARE @isAllowedR INTEGER
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @isAllowed=0
--DECLARE @startTime DATETIME2(7) = SYSDATETIME()
DECLARE @extTableProvided TINYINT = 1
IF @permissionId <> -1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#permissionIdTbl') IS NOT NULL
		DROP TABLE #permissionIdTbl
	CREATE TABLE #permissionIdTbl
	(
		i_permissionId INT
	)
	INSERT INTO #permissionIdTbl
		SELECT @permissionId
	SET @extTableProvided = 0
END
--ELSE				We would have got permissions in #permissionIdTbl itself.
DECLARE @checkOnlyAssociation INT = 0
DECLARE @countPermissionInput INT = 0
SELECT @countPermissionInput = COUNT(1)
FROM #permissionIdTbl
IF @countPermissionInput = 1
	SELECT @checkOnlyAssociation = 1
	FROM #permissionIdTbl
	WHERE i_permissionId = 0
IF @entityTYpe IN (4,5,6,7)					-- Ideally for IDA objects we should check only till that level. i.e, if queried on instance, we can query on Client, apptype or instance. But not on backupset, subclient.
	SET @entityType = 3						-- As of now, for all iDA objects I am querying on @entityType1 = client. So if someone queries for instance and if permission is present on subclient it will still return true. Will fix this later.
--Input permission validation whether they are mapped to correct entity type.
IF(@AndOperation = 1)
BEGIN
	--AND all passed input permission. IF any one of the permission is not mapped to entityType, than return false straight away
	IF @checkOnlyAssociation = 0 AND EXISTS (SELECT 1 from #permissionIdTbl WHERE i_permissionId  NOT IN (SELECT  permissionId FROM UMPermissionEntityTypeMap WHERE permissionId<>0 AND (entityType=@entityType OR entityType=0)
													UNION
													SELECT id FROM UMPermissions
													WHERE id <>0 AND id not in (SELECT  permissionId FROM UMPermissionEntityTypeMap) and flags& 0x001 = 0))				--UM_PERMISSIONS_NO_ASSOCIATION
BEGIN
	IF(@isReturned<>0)
		SELECT @isAllowed
	RETURN
END
END
ELSE
BEGIN
-- OR condition : IF all permission passed is not mapped to entityType than only passed false.
	IF(@checkOnlyAssociation = 0 and  NOT EXISTS(SELECT  1 FROM
														(SELECT  permissionId FROM UMPermissionEntityTypeMap WHERE permissionId<>0 AND (entityType=@entityType OR entityType=0)
														UNION
														SELECT id FROM UMPermissions
														WHERE id <>0 AND id not in (SELECT  permissionId FROM UMPermissionEntityTypeMap) and flags& 0x001 = 0)			--UM_PERMISSIONS_NO_ASSOCIATION
														Tbl
														JOIN #permissionIdTbl ON permissionId =i_permissionId))
	BEGIN
		IF(@isReturned<>0)
			SELECT @isAllowed
		RETURN
	END
END
--User groups this user belongs to.
DECLARE @userAndGroupId TABLE (userOrGroupId INT, isUser INT)
IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
	DROP TABLE #usergroupId
CREATE TABLE #userGroupId (userGroupId INT)
EXEC sec_getMemberUserGroups @userId
INSERT INTO @userAndGroupId
	SELECT userGroupId, 0
	FROM #userGroupId
	UNION
	SELECT @userId, 1
DROP TABLE #userGroupId
DECLARE @parentEntityType TABLE (entityType INT)				-- Using this as a table variable itself should be fine. Since it would have just a few parent entity types.
IF OBJECT_ID('tempdb.dbo.#ownerEntities') IS NOT NULL
		DROP TABLE #ownerEntities
CREATE TABLE #ownerEntities (entityType INT, entityId INT)
IF OBJECT_ID('tempdb.dbo.#checkPermissionOnEntityType_parentChildTable') IS NOT NULL
	DROP TABLE #checkPermissionOnEntityType_parentChildTable
CREATE TABLE #checkPermissionOnEntityType_parentChildTable
(
	parentEntityType INT,
	parentEntityId INT
)
CREATE CLUSTERED INDEX checkPermissionOnEntityType_parentChildTable ON #checkPermissionOnEntityType_parentChildTable (parentEntityType, parentEntityId)
IF (@AndOperation = 0 AND @checkOnlyAssociation = 0)		--Even if one permission is present we are good.
BEGIN
	--Commcell.
	SET @isAllowed = 0
	IF EXISTS (SELECT TOP 1 1
			   FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN #permissionIdTbl P
						ON Sec.permissionId = P.i_permissionId
			   WHERE entityType1 = 1 AND entityId1 = 2)				--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
	BEGIN
				SET @isAllowed = 1
				--PRINT 'Commcell Permission'
				GOTO PROC_EXIT
	END
	IF EXISTS (SELECT TOP 1 1
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN UMRolesWithPermissionsExpanded R
						ON Sec.roleID = R.roleID
					INNER JOIN #permissionIdTbl P
						ON R.permissionId = P.i_permissionId
				WHERE entityType1 = 1 AND entityId1 = 2)				--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
	BEGIN
				SET @isAllowed = 1
				--PRINT 'Commcell Role'
				GOTO PROC_EXIT
	END
	--Entity.
	IF EXISTS (SELECT TOP 1 1
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN #permissionIdTbl P
						ON Sec.permissionId = P.i_permissionId
				WHERE entityType1 = @entityType)
	BEGIN
			SET @isAllowed = 1
			--PRINT 'Entity Permission'
			GOTO PROC_EXIT
	END
	IF EXISTS (SELECT TOP 1 1
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN UMRolesWithPermissionsExpanded R
						ON Sec.roleID = R.roleID
					INNER JOIN #permissionIdTbl P
						ON R.permissionId = P.i_permissionId
				WHERE entityType1 = @entityType)
	BEGIN
			SET @isAllowed = 1
			--PRINT 'Entity Role'
			GOTO PROC_EXIT
	END
	--Parents.
	IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType)
	BEGIN
		-- TR 170802-596: User is able to see Analytics app which he is not supposed to see.
		-- This SP is called with client entity. User has rights on dummy client group with no client in it.
		-- Still the SP returned true. So they show Analytics App on web console.
		-- When it is clicked, no other option comes up since there are no clients to show.
		-- Fix: Instead of just checking association on parent entity type, see if association is on a
		-- parent who has some children of this entity type.
		DECLARE @dynamicSQLString VARCHAR(MAX) = ''
		SET @dynamicSQLString = 'INSERT INTO #checkPermissionOnEntityType_parentChildTable
										SELECT DISTINCT parentEntityType, parentId
										FROM ('
												+ CHAR(10)
												+ SUBSTRING
																	(
																		(
																			SELECT			'UNION'
																							+ CHAR(10)			-- New line character
																							+ CAST(associationQuery AS VARCHAR(MAX))
																							+ CHAR(10)
																			FROM App_EntityParentAssociation PE
																			WHERE
																				PE.childEntityType = @entityType
																			FOR XML PATH (''), TYPE
																		).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
																		6,				-- Exclude the first UNION
																		2147483647		-- MAX
																	)
												+ ')Tbl'
		EXEC (@dynamicSQLString)
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #permissionIdTbl P
							ON Sec.permissionId = P.i_permissionId
						INNER JOIN #checkPermissionOnEntityType_parentChildTable Parent
							ON Sec.entityType1 = Parent.parentEntityType AND Sec.entityId1 = Parent.parentEntityId)
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Parent Permission'
			GOTO PROC_EXIT
		END
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #permissionIdTbl P
							ON Sec.permissionId = P.i_permissionId
						INNER JOIN #checkPermissionOnEntityType_parentChildTable Parent
							ON Sec.entityType1 = Parent.parentEntityType AND Sec.includeAll = 1)
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Parent Permission'
			GOTO PROC_EXIT
		END
		IF EXISTS (
					SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleID = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN #checkPermissionOnEntityType_parentChildTable Parent
							ON Sec.entityType1 = Parent.parentEntityType AND Sec.entityId1 = Parent.parentEntityId)
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Parent Role'
			GOTO PROC_EXIT
		END
		IF EXISTS (
					SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleID = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN #checkPermissionOnEntityType_parentChildTable Parent
							ON Sec.entityType1 = Parent.parentEntityType AND Sec.includeAll = 1)
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Parent Role'
			GOTO PROC_EXIT
		END
	END		--SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType1
	--Owners.
	--Check if user / group is owner of this entity or parent entity or commcell.
	DECLARE @isOwner INT = 0
	INSERT INTO #ownerEntities				-- Including only owner of the entity as such. Today we support only client owners.
		SELECT Owners.entityType, entityId
		FROM UMOwners Owners
			INNER JOIN @userAndGroupId UG
				ON Owners.isUser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId
		WHERE Owners.entityTYpe = @entityType
	--Check if permission is configured at owner level for Commcell or this entity or parent entity. (Checking only role here since permission directly on owners is not supported yet).
	IF EXISTS (
				SELECT TOP 1 1
				FROM #ownerEntities
			  )
	BEGIN
			IF EXISTS (
					SELECT TOP 1 1
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN #ownerEntities OE
							ON OE.entityType = Sec.entityType AND OE.entityId = Sec.entityId
					  )
			BEGIN
						SET @isAllowed = 1
						--Print 'Owner Role Entity'
						GOTO PROC_EXIT
			END
			IF EXISTS (
					SELECT TOP 1 1
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType = 1 AND entityID = 2								--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
					)
			BEGIN
						SET @isAllowed = 1
						--Print 'Owner Role Commcell'
						GOTO PROC_EXIT
			END
			IF EXISTS (
					SELECT TOP 1 1
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN APP_ClientGroupAssoc CGA
							ON Sec.entityType = 28 AND Sec.entityId = CGA.clientGroupId						--CLIENT_GROUP_ENTITY
						INNER JOIN #ownerEntities OE
							ON OE.entityType = 3 AND OE.entityId = CGA.clientID								--CLIENT_ENTITY
						)
			BEGIN
						SET @isAllowed = 1
						--Print 'Owner Role Parent'
						GOTO PROC_EXIT
			END
	END		--@isOwner=1
END		--@AndOperation = 0
ELSE IF @AndOperation <> 0			--We need all permissions.
BEGIN
	SET @isAllowed = 0
	DECLARE @permissionIdsTablePresentAtEntities TABLE (permissionId INT)
	--Tried the same table variable approach and temp table approach for @andOperation = 0 case also. It was slower than the above written block for @andOperation = 0.
	--Tried it on Commserv_FC_SP6_20170106_DoNOTStage hosted on serverTeam1.testlab.commvault.com. Test data was a set of userIds who have
	--1. all association on commcell level itself. (88,10899,1,11049,108)
	--2. association on individual clients. (453,63,17543,28282,26643) on (698,7072,22877,73735,22877)
	--3. association on client owners. (29622,19516,199,7240,12243) on (9255,9231,10644,13182,15286)
	--4. association on client groups. (28121,5857,13849,10592,17565)
	--In all cases, this approach gave results ~=6 milliseconds faster than tried with @tableVariable and #tempTable. So using table variables only for @andOperation <> 0 case.
	--Commcell.
	INSERT INTO @permissionIdsTablePresentAtEntities
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
			 INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUSer AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN #permissionIdTbl P
				ON Sec.permissionId = P.i_permissionId
		WHERE entityType1 = 1 AND entityId1 = 2 AND permissionID > 0								--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
		UNION ALL
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded R
				ON Sec.roleID = R.roleID
			INNER JOIN #permissionIdTbl P
				ON R.permissionId = P.i_permissionId
		WHERE entityType1 = 1 AND entityID1 = 2 AND Sec.roleId > 0									--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
	--Delete all those permissions present at commcell level from input table.
	DELETE
	FROM #permissionIdTbl
	WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
	IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
	BEGIN
		SET @isAllowed = 1
		--PRINT 'Commcell'
		GOTO PROC_EXIT
	END
	--Entity.
	INSERT INTO @permissionIdsTablePresentAtEntities
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUSer AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN #permissionIdTbl P
				ON Sec.permissionId = P.i_permissionId
		WHERE entityType1 = @entityTYpe AND permissionID > 0
		UNION ALL
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded R
				ON Sec.roleID = R.roleID
			INNER JOIN #permissionIdTbl P
				ON R.permissionId = P.i_permissionId
		WHERE entityType1 = @entityTYpe AND Sec.roleId > 0
	DELETE
	FROM #permissionIdTbl
	WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
	IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
	BEGIN
		SET @isAllowed = 1
		--PRINT 'Entity'
		GOTO PROC_EXIT
	END
	--Parents.
	IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityTYpe)
	BEGIN
		INSERT INTO @parentEntityType
			SELECT parentEntityType
			FROM App_EntityParentAssociation
			WHERE childEntityType = @entityType
		INSERT INTO @permissionIdsTablePresentAtEntities
					SELECT P.i_permissionId
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #permissionIdTbl P
							ON Sec.permissionId = P.i_permissionId
						INNER JOIN @parentEntityType Parent
							ON Sec.entityType1 = Parent.EntityType
					UNION ALL
					SELECT P.i_permissionId
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleID = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN @parentEntityType Parent
							ON Sec.entityType1 = Parent.EntityType
		DELETE
		FROM #permissionIdTbl
		WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
		IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Parent'
			GOTO PROC_EXIT
		END
	END			--(SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType1)
	--Owners.
	SET @isOwner = 0
	INSERT INTO #ownerEntities				-- Including only owner of the entity as such. Today we support only client owners.
		SELECT Owners.entityType, entityId
		FROM UMOwners Owners
			INNER JOIN @userAndGroupId UG
				ON Owners.isUser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId
		WHERE Owners.entityTYpe = @entityType
	IF EXISTS (
				SELECT TOP 1 1
				FROM #ownerEntities
			  )
	BEGIN
			INSERT INTO @permissionIdsTablePresentAtEntities
					SELECT P.i_permissionId
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN #ownerEntities OE
							ON OE.entityType = Sec.entityType AND OE.entityId = Sec.entityId
					UNION ALL
					SELECT P.i_permissionId
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType = 1 AND entityID = 2											--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
					UNION ALL
					SELECT P.i_permissionId
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN APP_ClientGroupAssoc CGA
							ON Sec.entityType = 28 AND Sec.entityId = CGA.clientGroupId				--CLIENT_GROUP_ENTITY
						INNER JOIN #ownerEntities OE
							ON OE.entityType = 3 AND OE.entityId = CGA.clientID						--CLIENT_ENTITY
			DELETE
			FROM #permissionIdTbl
			WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
	END			--@isOwner = 1
	IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
	BEGIN
		SET @isAllowed = 1
		--PRINT 'Owner'
		GOTO PROC_EXIT
	END
END
ELSE IF @checkOnlyAssociation = 1			--Check if user has any association on given entity.
BEGIN
	SET @isAllowed = 0
	--Commcell.
	IF EXISTS (SELECT TOP 1 1
			   FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
			   WHERE entityType1 = 1 AND entityId1 = 2)									--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
	BEGIN
			   SET @isAllowed = 1
			   --PRINT 'Commcell'
			   GOTO PROC_EXIT
	END
	--Entity.
	IF EXISTS (SELECT TOP 1 1
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				WHERE entityType1 = @entityTYpe)
	BEGIN
			   SET @isAllowed = 1
			   --PRINT 'Entity'
			   GOTO PROC_EXIT
	END
	--Parents.
	IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType)
	BEGIN
		INSERT INTO @parentEntityType
			SELECT parentEntityType
			FROM App_EntityParentAssociation
			WHERE childEntityType = @entityType
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN @parentEntityType Parent
							ON Sec.entityType1 = Parent.EntityType)
		BEGIN
				SET @isAllowed = 1
				--PRINT 'Parent'
				GOTO PROC_EXIT
		END
	END			--SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType1
	--Owners.
	IF EXISTS (SELECT TOP 1 1
				FROM UMOwners Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				WHERE Sec.entityType = @entityType
				UNION						--Should we query on Commcell and CLient group since we do not support owners of them yet.
				SELECT TOP 1 1
				FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				WHERE Sec.entityType = 1 AND Sec.entityId = 2						--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
				UNION
				SELECT TOP 1 1
				FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN @parentEntityType P
						ON Sec.entityType = P.EntityType)
	BEGIN
		   SET @isAllowed = 1
		   --PRINT 'Owner'
		   GOTO PROC_EXIT
	END
END		--@checkOnlyAssociation.
PROC_EXIT:
IF(@isReturned<>0)
	SELECT @isAllowed
IF @extTableProvided = 0
	IF OBJECT_ID('tempdb.dbo.#permissionIdTbl') IS NOT NULL
		DROP TABLE #permissionIdTbl
GO

IF EXISTS (select * from GxQscripts where name = 'sec_checkPermissionOnEntityType')
	delete from GxQscripts where name = 'sec_checkPermissionOnEntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkPermissionOnEntityType')
	delete from GXDBVersions where aliasname = 'sec_checkPermissionOnEntityType'
GO

insert into GXDBVersions values(2, 'sec_checkPermissionOnEntityType',  '00000000000000000000', 'sec_checkPermissionOnEntityType', '00000000000000000000')
GO

