

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_checkPermissionOnEntityList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--   Description: This SP is used to check permission on the diff
--				  of newEntityList and oldEntityList.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_checkPermissionOnEntityList <<<'

IF EXISTS (select * from sysobjects where name='sec_checkPermissionOnEntityList')
	drop procedure sec_checkPermissionOnEntityList
IF EXISTS (select * from GxQscripts where name='sec_checkPermissionOnEntityList')
	delete from GxQscripts where name = 'sec_checkPermissionOnEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkPermissionOnEntityList')
	delete from GXDBVersions where aliasname = 'sec_checkPermissionOnEntityList'
GO
print '... Creating Procedure: sec_checkPermissionOnEntityList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_checkPermissionOnEntityList
  @userId INT,
  @localeId INT,
  @newEntityList XML,
  @oldEntityList XML,
  @permissionId INT,
  @isAllowedEntities INT = 0 OUTPUT,
  @invalidEntities NVARCHAR(MAX) = N'' OUTPUT
AS
DECLARE @entityListTableTemp TABLE
(
	_type_  INT,
	clientGroupId INT,
	clientId INT,
	applicationId  INT,
	instanceId  INT,
	backupsetId INT,
	subclientId INT,
	mediaAgentId INT ,
	schedulePolicyId INT ,
	libraryId INT ,
	storagePolicyId INT ,
	copyId  INT ,
	trackingPolicyId INT,
	workflowId INT,
	policyId INT,
	criteriaId INT,
	userGroupId INT,
	userId INT,
	shareId INT,
	includeAll INT,
	exclude INT
)
INSERT INTO @entityListTableTemp
(
    _type_ ,
	clientGroupId,
	clientId,
	applicationId ,
	instanceId ,
	backupsetId ,
	subclientId,
	mediaAgentId,
	schedulePolicyId ,
	libraryId,
	storagePolicyId ,
	copyId  ,
	trackingPolicyId ,
	workflowId,
	policyId,
	criteriaId,
	userGroupId,
	userId,
	shareId,
	includeAll,
	exclude
)
(SELECT
	ISNULL(Entity.value('@_type_','INT'),0),
	ISNULL(Entity.value('@clientGroupId','INT'),0),
	ISNULL(Entity.value('@clientId','INT'),0),
	ISNULL(Entity.value('@applicationId','INT'),0),
	ISNULL(Entity.value('@instanceId','INT'),0),
	ISNULL(Entity.value('@backupsetId','INT'),0),
	ISNULL(Entity.value('@subclientId','INT'),0),
	ISNULL(Entity.value('@mediaAgentId','INT'),0),
	ISNULL(Entity.value('@schedulePolicyId','INT'),0),
	ISNULL(Entity.value('@libraryId','INT'),0),
	ISNULL(Entity.value('@storagePolicyId','INT'),0),
	ISNULL(Entity.value('@copyId','INT'),0),
	ISNULL(Entity.value('@trackingPolicyId','INT'),0),
	ISNULL(Entity.value('@workflowId','INT'),0),
	ISNULL(Entity.value('@policyId','INT'),0),
	ISNULL(Entity.value('@criteriaId','INT'),0),
	ISNULL(Entity.value('@userGroupId','INT'),0),
	ISNULL(Entity.value('@userId','INT'),0),
	ISNULL(Entity.value('@shareId','INT'),0),
	ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0),
	ISNULL(Entity.value('(flags/@exclude)[1]', 'INT'), 0)
FROM @newEntityList.nodes ('/CVGui_CommCellTreeNode/associations') Ref(Entity)
EXCEPT
SELECT
	ISNULL(Entity.value('@_type_','INT'),0),
	ISNULL(Entity.value('@clientGroupId','INT'),0),
	ISNULL(Entity.value('@clientId','INT'),0),
	ISNULL(Entity.value('@applicationId','INT'),0),
	ISNULL(Entity.value('@instanceId','INT'),0),
	ISNULL(Entity.value('@backupsetId','INT'),0),
	ISNULL(Entity.value('@subclientId','INT'),0),
	ISNULL(Entity.value('@mediaAgentId','INT'),0),
	ISNULL(Entity.value('@schedulePolicyId','INT'),0),
	ISNULL(Entity.value('@libraryId','INT'),0),
	ISNULL(Entity.value('@storagePolicyId','INT'),0),
	ISNULL(Entity.value('@copyId','INT'),0),
	ISNULL(Entity.value('@trackingPolicyId','INT'),0),
	ISNULL(Entity.value('@workflowId','INT'),0),
	ISNULL(Entity.value('@policyId','INT'),0),
	ISNULL(Entity.value('@criteriaId','INT'),0),
	ISNULL(Entity.value('@userGroupId','INT'),0),
	ISNULL(Entity.value('@userId','INT'),0),
	ISNULL(Entity.value('@shareId','INT'),0),
	ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0),
	ISNULL(Entity.value('(flags/@exclude)[1]', 'INT'), 0)
FROM @oldEntityList.nodes ('/CVGui_CommCellTreeNode/associations') Ref(Entity))
UNION
(SELECT
	ISNULL(Entity.value('@_type_','INT'),0),
	ISNULL(Entity.value('@clientGroupId','INT'),0),
	ISNULL(Entity.value('@clientId','INT'),0),
	ISNULL(Entity.value('@applicationId','INT'),0),
	ISNULL(Entity.value('@instanceId','INT'),0),
	ISNULL(Entity.value('@backupsetId','INT'),0),
	ISNULL(Entity.value('@subclientId','INT'),0),
	ISNULL(Entity.value('@mediaAgentId','INT'),0),
	ISNULL(Entity.value('@schedulePolicyId','INT'),0),
	ISNULL(Entity.value('@libraryId','INT'),0),
	ISNULL(Entity.value('@storagePolicyId','INT'),0),
	ISNULL(Entity.value('@copyId','INT'),0),
	ISNULL(Entity.value('@trackingPolicyId','INT'),0),
	ISNULL(Entity.value('@workflowId','INT'),0),
	ISNULL(Entity.value('@policyId','INT'),0),
	ISNULL(Entity.value('@criteriaId','INT'),0),
	ISNULL(Entity.value('@userGroupId','INT'),0),
	ISNULL(Entity.value('@userId','INT'),0),
	ISNULL(Entity.value('@shareId','INT'),0),
	ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0),
	ISNULL(Entity.value('(flags/@exclude)[1]', 'INT'), 0)
FROM @oldEntityList.nodes ('/CVGui_CommCellTreeNode/associations') Ref(Entity)
EXCEPT
SELECT
	ISNULL(Entity.value('@_type_','INT'),0),
	ISNULL(Entity.value('@clientGroupId','INT'),0),
	ISNULL(Entity.value('@clientId','INT'),0),
	ISNULL(Entity.value('@applicationId','INT'),0),
	ISNULL(Entity.value('@instanceId','INT'),0),
	ISNULL(Entity.value('@backupsetId','INT'),0),
	ISNULL(Entity.value('@subclientId','INT'),0),
	ISNULL(Entity.value('@mediaAgentId','INT'),0),
	ISNULL(Entity.value('@schedulePolicyId','INT'),0),
	ISNULL(Entity.value('@libraryId','INT'),0),
	ISNULL(Entity.value('@storagePolicyId','INT'),0),
	ISNULL(Entity.value('@copyId','INT'),0),
	ISNULL(Entity.value('@trackingPolicyId','INT'),0),
	ISNULL(Entity.value('@workflowId','INT'),0),
	ISNULL(Entity.value('@policyId','INT'),0),
	ISNULL(Entity.value('@criteriaId','INT'),0),
	ISNULL(Entity.value('@userGroupId','INT'),0),
	ISNULL(Entity.value('@userId','INT'),0),
	ISNULL(Entity.value('@shareId','INT'),0),
	ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0),
	ISNULL(Entity.value('(flags/@exclude)[1]', 'INT'), 0)
FROM @newEntityList.nodes ('/CVGui_CommCellTreeNode/associations') Ref(Entity))
IF NOT EXISTS (SELECT 1 FROM @entityListTableTemp)
BEGIN
	SET @isAllowedEntities = 1
	GOTO EXIT_PRO
END
DECLARE @entityNotAllowed	NVARCHAR(MAX) = N''
DECLARE @sep				NVARCHAR(10) = N''
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 27)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 28, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2819 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 27 OR _type_ = 28
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 2)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 3, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2820 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 2 OR _type_ = 3
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 10)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 11, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2821 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 10 OR _type_ = 11
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 34)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 35, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2822 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 34 OR _type_ = 35
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 8)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 9, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2823 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 8 OR _type_ = 9
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 16)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 17, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2824 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 16 OR _type_ = 17
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 20)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 21, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2825 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 20 OR _type_ = 21
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 114)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 83, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2826 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 114 OR _type_ = 83
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 113)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 90, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2827 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 113 OR _type_ = 90
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 95)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 96, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2828 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 95 OR _type_ = 96
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 14)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 15, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (3122 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 14 OR _type_ = 15
	END
END
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 12)
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 13, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (3123 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 12 OR _type_ = 13
	END
END
-- Check for all shares entity
IF EXISTS(SELECT 1 FROM @entityListTableTemp WHERE _type_ = 7987 and shareId=0 )
BEGIN
EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, 7987, 0
	IF @isAllowedEntities = 0
	BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (3416 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @sep = ', '
	END
	ELSE
	BEGIN
DELETE FROM @entityListTableTemp WHERE _type_ = 7987
	END
END
IF NOT EXISTS (SELECT 1 FROM @entityListTableTemp)
BEGIN
	SET @isAllowedEntities = 1
	GOTO EXIT_PRO
END
SET @isAllowedEntities = 1  --will set to 0 later, if user do not have right on some entity
IF EXISTS(SELECT 1 FROM @entityListTableTemp tbl INNER JOIN APP_Entity entity
											ON tbl._type_ = entity.entityType
										WHERE tbl.includeAll = 1)
BEGIN
	DECLARE @type INT
	DECLARE acursor CURSOR FOR
		SELECT DISTINCT tbl._type_
		FROM @entityListTableTemp tbl INNER JOIN APP_Entity entity
											ON tbl._type_ = entity.entityType
										WHERE tbl.includeAll = 1
	OPEN acursor
	FETCH NEXT FROM acursor INTO @type
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC sec_checkPermissionOnEntity @userId, @permissionId, @isAllowedEntities OUTPUT, @type, 0
		IF @isAllowedEntities = 0
		BEGIN
SET @entityNotAllowed = @entityNotAllowed + @sep + (SELECT message FROM EvLocaleMsgs WHERE messageId = (2830 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			SET @entityNotAllowed = REPLACE(@entityNotAllowed, '^1%s', (SELECT message FROM EvLocaleMsgs
																				WHERE messageId = (SELECT entityTypeNameMessageId FROM APP_Entity WHERE entityType = @type)
																					AND localeid = @localeId))
			SET @sep = ', '
			DELETE FROM @entityListTableTemp WHERE _type_ = @type AND includeAll = 1
		END
		ELSE
		BEGIN
			DELETE FROM @entityListTableTemp WHERE _type_ = @type
		END
		FETCH NEXT FROM acursor INTO @type
	END
	CLOSE acursor
	DEALLOCATE acursor
END
IF NOT EXISTS (SELECT 1 FROM @entityListTableTemp)
BEGIN
	GOTO EXIT_PRO
END
DECLARE @genericEntityList xml = (SELECT * FROM @entityListTableTemp as associations
										FOR XML AUTO, ROOT('entityList'))
IF OBJECT_ID('tempdb.dbo.#entitiesTableTemp') IS NOT NULL
    DROP TABLE #entitiesTableTemp
CREATE TABLE #entitiesTableTemp
(
    entityType1 INT,
    entityId1 INT,
    entityType2 INT,
    entityId2 INT,
    entityType3 INT,
    entityId3 INT,
    entityType4 INT,
    entityId4 INT,
    entityType5 INT,
    entityId5 INT,
    entityAssociatedBlob XML,
    entityAssociatedModifiedBlob XML
)
INSERT INTO #entitiesTableTemp(entityAssociatedBlob)
        SELECT Entity.query('.')
        FROM @genericEntityList.nodes('entityList/associations') AS Ref(Entity)
UPDATE #entitiesTableTemp
    SET entityAssociatedModifiedBlob = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(entityAssociatedBlob)
UPDATE #entitiesTableTemp
SET entityType1 = (SELECT ref.value('@entityType1', 'INT') AS entityType1
					FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId1 = (SELECT ref.value('@entityId1', 'INT') AS entityId1
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType2 = (SELECT ref.value('@entityType2', 'INT') AS entityType2
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId2 = (SELECT ref.value('@entityId2', 'INT') AS entityId2
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType3 = (SELECT ref.value('@entityType3', 'INT') AS entityType3
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId3 = (SELECT ref.value('@entityId3', 'INT') AS entityId3
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType4 = (SELECT ref.value('@entityType4', 'INT') AS entityType4
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId4 = (SELECT ref.value('@entityId4', 'INT') AS entityId4
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType5 = (SELECT ref.value('@entityType5', 'INT') AS entityType5
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId5 = (SELECT ref.value('@entityId5', 'INT') AS entityId5
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
DECLARE @tempentitytype			INT = 0
DECLARE @SQLStatement			NVARCHAR(MAX)
DECLARE @ParmDefinition			NVARCHAR(500)
DECLARE @outputList				NVARCHAR(500)
DECLARE @entityNotAllowedNew	NVARCHAR(1000)
DECLARE @whereClause			NVARCHAR(1024)
DECLARE tempcursor CURSOR FOR
    SELECT DISTINCT dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityTYpe4, entityType5)
    FROM #entitiesTableTemp
OPEN tempcursor
FETCH NEXT FROM tempcursor INTO @tempentitytype
WHILE @@FETCH_STATUS = 0
BEGIN
	IF EXISTS (SELECT 1 FROM APP_Entity WHERE entityType = @tempentitytype)
	BEGIN
IF (@tempentitytype NOT IN (3, 4, 5, 6, 7))
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#entityAllowedNonIda') IS NOT NULL
				DROP TABLE #entityAllowedNonIda
			CREATE TABLE #entityAllowedNonIda (entityId INT)
			EXEC sec_getNonIdaObjectsForThisUser @userId, @tempentitytype, @permissionId, '#entityAllowedNonIda'
			IF EXISTS (SELECT 1	FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedNonIda sec
							ON tbl.entityType1 = @tempentitytype AND tbl.entityId1 = sec.entityId
						WHERE tbl.entityType1 = @tempentityType AND sec.entityId IS NULL)
			BEGIN
				SET @entityNotAllowedNew = (SELECT message FROM EvLocaleMsgs
													WHERE messageId = (SELECT entityTypeNameMessageId FROM APP_Entity WHERE entityType = @tempentitytype)
														AND localeid = @localeId) + ': {'
				SET @outputList = N''
				SET @SQLStatement = N'SELECT @output = @output + @sep + entity.'
										+ (SELECT entityNameColName FROM APP_Entity WHERE entityType = @tempentitytype)
										+ ' FROM (SELECT DISTINCT tbl.entityId1 FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedNonIda sec
														ON tbl.entityType1 = @entityType AND tbl.entityId1 = sec.entityId
													WHERE tbl.entityType1 = @entityType AND sec.entityId IS NULL) as tbl1 INNER JOIN '
										+ (SELECT tableName FROM APP_Entity WHERE entityType = @tempentitytype)
										+ ' entity ON tbl1.entityId1 = entity.'
										+ (SELECT idColName FROM APP_Entity WHERE entityType = @tempentitytype)
				SET @whereClause = ISNULL((SELECT whereClause FROM App_Entity WHERE entityType = @tempentitytype), '')
				IF @whereClause <> ''
				BEGIN
					SET @SQLStatement = @SQLStatement + ' AND ' + @whereClause
				END
				SET @ParmDefinition = N'@sep NVARCHAR(10), @entityType INT, @output NVARCHAR(MAX) OUTPUT';
				EXECUTE sp_executesql @SQLStatement, @ParmDefinition, @sep = ', ', @entityType = @tempentitytype, @output = @outputList OUTPUT
				SET @entityNotAllowedNew = @entityNotAllowedNew + STUFF(@outputList,1,2,'')
				SET @entityNotAllowedNew = @entityNotAllowedNew + '}'
				IF @entityNotAllowedNew IS NOT NULL	--If this value is NULL that means old xmlEntityList has older entity value which is not present in DB now. So ignoring it as it will be replaced by new entityList
				BEGIN
					SET @isAllowedEntities = 0
					SET @entityNotAllowed = @entityNotAllowed + @sep + @entityNotAllowedNew
					SET @sep = ', '
				END
			END
		END
		ELSE
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#entityAllowedIda') IS NOT NULL
				DROP TABLE #entityAllowedIda
			CREATE TABLE #entityAllowedIda (clientId INT, appTypeId INT, instanceID INT, backupsetId INT, subclientId INT)
			EXEC sec_getIdaObjectsForUser @userId, @tempentitytype, @permissionId, 0, '#entityAllowedIda'
			--Note that sec_getIdaObjectsForUser.sp will always "expand" the results and give. If you are asking for list of "backupset", then it will get you only backupset rows.
			--No client or appType or instance rows with backupsetId as 0 will be returned. So all we have to do is just do a ID mapping between entitiesTableTemp and entityAllowedIda
			IF EXISTS (SELECT 1 FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedIda sec
ON (tbl.entityType1 = 3 AND tbl.entityId1 = sec.clientID)
AND (@tempEntityType < 4 OR (tbl.entityType2 = 4 AND tbl.entityId2 = sec.appTypeId))
AND (@tempEntityType < 5 OR (tbl.entityType3 = 5 AND tbl.entityId3 = sec.instanceId))
AND (@tempEntityType < 6 OR (tbl.entityType4 = 6 AND tbl.entityId4 = sec.backupsetid))
AND (@tempEntityType < 7 OR (tbl.entityType5 = 7 AND tbl.entityId5 = sec.subclientId))
						WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = @tempentitytype AND sec.clientId IS NULL)
			BEGIN
				SET @entityNotAllowedNew = (SELECT message FROM EvLocaleMsgs
													WHERE messageId = (SELECT entityTypeNameMessageId FROM APP_Entity WHERE entityType = @tempentitytype)
														AND localeid = @localeId) + ': {'
				SET @outputList = N''
IF @tempentitytype = 3
				BEGIN
					SELECT @outputList = @outputList + ', ' + client.name
						FROM (SELECT DISTINCT tbl.entityId1 FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedIda sec
ON (tbl.entityType1 = 3 AND tbl.entityId1 = sec.clientID)
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 3
									AND sec.clientId IS NULL) as tbl1
							INNER JOIN APP_Client client
								ON tbl1.entityId1 = client.id
				END
ELSE IF @tempentitytype = 4
				BEGIN
					SELECT @outputList = @outputList + ', ' + client.name + '>' + ida.displayName
						FROM (SELECT DISTINCT tbl.entityId1, tbl.entityId2 FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedIda sec
ON (tbl.entityType1 = 3 AND tbl.entityId1 = sec.clientID)
AND (tbl.entityType2 = 4 AND tbl.entityId2 = sec.appTypeId)
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 4
									AND sec.clientId IS NULL) as tbl1
						INNER JOIN APP_Client client
							ON tbl1.entityId1 = client.id
						INNER JOIN APP_IDAType ida
							ON tbl1.entityId2 = ida.type
				END
ELSE IF @tempentitytype = 5
				BEGIN
					SELECT @outputList = @outputList + ', ' + client.name + '>' + ida.displayName + '>' + instance.name
						FROM (SELECT DISTINCT tbl.entityId1, tbl.entityId2, tbl.entityId3 FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedIda sec
ON (tbl.entityType1 = 3 AND tbl.entityId1 = sec.clientID)
AND (tbl.entityType2 = 4 AND tbl.entityId2 = sec.appTypeId)
AND (tbl.entityType3 = 5 AND tbl.entityId3 = sec.instanceId)
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 5
									AND sec.clientId IS NULL) as tbl1
						INNER JOIN APP_Client client
							ON tbl1.entityId1 = client.id
						INNER JOIN APP_IDAType ida
							ON tbl1.entityId2 = ida.type
						INNER JOIN APP_InstanceName instance
							ON tbl1.entityId3 = instance.id
				END
ELSE IF @tempentitytype = 6
				BEGIN
					SELECT @outputList = @outputList + ', ' + client.name + '>' + ida.displayName + '>' + backupset.name
						FROM (SELECT DISTINCT tbl.entityId1, tbl.entityId2, tbl.entityId3, tbl.entityId4 FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedIda sec
ON (tbl.entityType1 = 3 AND tbl.entityId1 = sec.clientID)
AND (tbl.entityType2 = 4 AND tbl.entityId2 = sec.appTypeId)
AND (tbl.entityType3 = 5 AND tbl.entityId3 = sec.instanceId)
AND (tbl.entityType4 = 6 AND tbl.entityId4 = sec.backupsetid)
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 6
									AND sec.clientId IS NULL) as tbl1
						INNER JOIN APP_Client client
							ON tbl1.entityId1 = client.id
						INNER JOIN APP_IDAType ida
							ON tbl1.entityId2 = ida.type
						INNER JOIN APP_InstanceName instance
							ON tbl1.entityId3 = instance.id
						INNER JOIN APP_BackupSetName backupset
							ON tbl1.entityId4 = backupset.id
				END
ELSE IF @tempentitytype = 7
				BEGIN
					SELECT @outputList = @outputList + ', ' + client.name + '>' + ida.displayName + '>' + backupset.name + '>' + subclient.subclientName
						FROM (SELECT DISTINCT tbl.entityId1, tbl.entityId2, tbl.entityId3, tbl.entityId4, tbl.entityId5 FROM #entitiesTableTemp tbl LEFT OUTER JOIN #entityAllowedIda sec
ON (tbl.entityType1 = 3 AND tbl.entityId1 = sec.clientID)
AND (tbl.entityType2 = 4 AND tbl.entityId2 = sec.appTypeId)
AND (tbl.entityType3 = 5 AND tbl.entityId3 = sec.instanceId)
AND (tbl.entityType4 = 6 AND tbl.entityId4 = sec.backupsetid)
AND (tbl.entityType5 = 7 AND tbl.entityId5 = sec.subclientId)
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 7
									AND sec.clientId IS NULL) as tbl1
						INNER JOIN APP_Client client
							ON tbl1.entityId1 = client.id
						INNER JOIN APP_IDAType ida
							ON tbl1.entityId2 = ida.type
						INNER JOIN APP_InstanceName instance
							ON tbl1.entityId3 = instance.id
						INNER JOIN APP_BackupSetName backupset
							ON tbl1.entityId4 = backupset.id
						INNER JOIN APP_Application subclient
							ON tbl1.entityId5 = subclient.id
				END
				SET @entityNotAllowedNew = @entityNotAllowedNew + STUFF(@outputList,1,2,'')
				SET @entityNotAllowedNew = @entityNotAllowedNew + '}'
				IF @entityNotAllowedNew IS NOT NULL	--If this value is NULL that means old xmlEntityList has older entity value which is not present in DB now. So ignoring it as it will be replaced by new entityList
				BEGIN
					SET @isAllowedEntities = 0
					SET @entityNotAllowed = @entityNotAllowed + @sep + @entityNotAllowedNew
					SET @sep = ', '
				END
			END
		END
	END
	ELSE
	BEGIN
		SET @isAllowedEntities = 0
	END
    FETCH NEXT FROM tempcursor INTO @tempentitytype
END
CLOSE tempcursor
DEALLOCATE tempcursor
EXIT_PRO:
IF @isAllowedEntities = 0
BEGIN
	SET @invalidEntities = @entityNotAllowed
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_checkPermissionOnEntityList')
	delete from GxQscripts where name = 'sec_checkPermissionOnEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkPermissionOnEntityList')
	delete from GXDBVersions where aliasname = 'sec_checkPermissionOnEntityList'
GO

insert into GXDBVersions values(2, 'sec_checkPermissionOnEntityList',  '00000000000000000000', 'sec_checkPermissionOnEntityList', '00000000000000000000')
GO

