

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_checkPermissionOnEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -----------------------------------------------------------------------------------------------
--
--	SP: sec_checkPermissionOnEntity
--
--	Description: Checks whether an user has right(s) on a entity
--				 Can be used for checking OR and AND of rights. (andOperation)
--				 You can pass one / multiple permissions in comma separated string
--				 to permissionIdList. Alternately can push into #permissionIdTbl(i_permissionId)
--				 When you pass only one permission (0) then will just check for any permission.
--
--				 Special note: When checking for permission '0' (any permission) on Commcell entity,
--				 this SP will return false if user has any Commcell mapped permission
--				 (like Create client group, create subclient policy) alone on Commcell. It shall return
--				 true if he has Generic permissions like Agent management, View, etc. (mapped to 0).
--				 This is because there are many application layer code where they call this SP with
--				 permissionId as 0 and Commcell entity to check for View All.
--				 If you want the SP to return true even if user has these Commcell mapped permissions too
--				 then pass honorCommcellMappedPermissionForAssociationCheck = 1
--
--	Author:	jswaminathan & saggarwal
-- ----------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_checkPermissionOnEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_checkPermissionOnEntity <<<'
	drop procedure sec_checkPermissionOnEntity
END
IF EXISTS (select * from GxQscripts where name='sec_checkPermissionOnEntity')
	delete from GxQscripts where name = 'sec_checkPermissionOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkPermissionOnEntity')
	delete from GXDBVersions where aliasname = 'sec_checkPermissionOnEntity'
GO
print '... Creating Procedure: sec_checkPermissionOnEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_checkPermissionOnEntity
  @userId integer,
  @permissionIdList varchar(4000),
  @isAllowed INTEGER OUTPUT,
  @entityType1 INTEGER,
  @entityId1 INTEGER,
  @entityType2 INTEGER=0,
  @entityId2 INTEGER=0,
  @entityType3 INTEGER=0,
  @entityId3 INTEGER=0,
  @entityType4 INTEGER=0,
  @entityId4 INTEGER=0,
  @entityType5 INTEGER=0,
  @entityId5 INTEGER=0,
  @isReturned INTEGER =0,
  @inheritFromChildren INTEGER = 0,
  @AndOperation INTEGER=0,
  @honorCommcellMappedPermissionForAssociationCheck INTEGER = 0
AS
  DECLARE @isAllowedR INTEGER
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @isAllowed=0
--Get Effective Entity Type
DECLARE @entityType INTEGER
SET @entityType = dbo.getEntityLevelFromEntityHierarchy(@entityType1, @entityType2, @entityType3, @entityTYpe4, @entityType5)
--DECLARE @startTime DATETIME2(7) = SYSDATETIME()
DECLARE @extTableProvided TINYINT = 1
IF @permissionIdList <> ''					--Old way. User has passed permission Ids as string. Frame #permissionIdTbl ourselves.
BEGIN
	IF OBJECT_ID('tempdb.dbo.#permissionIdTbl') IS NOT NULL
		DROP TABLE #permissionIdTbl
	CREATE TABLE #permissionIdTbl
	(
		i_permissionId INT
	)
	INSERT INTO #permissionIdTbl
		SELECT _ID
		FROM dbo.SplitIds(@permissionIdList)
	SET @extTableProvided = 0
END
--ELSE				We would have got permissions in #permissionIdTbl itself.
DECLARE @checkOnlyAssociation INT = 0
DECLARE @countPermissionInput INT = 0
SELECT @countPermissionInput = COUNT(1)
FROM #permissionIdTbl
IF @countPermissionInput = 1
	SELECT @checkOnlyAssociation = 1
	FROM #permissionIdTbl
	WHERE i_permissionId = 0
DECLARE @companyIdOfUser INT = 0
SET @companyIdOfUser = dbo.AppGetCompanyForUserOrUserGroup(@userId, 1)
IF OBJECT_ID('tempdb.dbo.#validCompaniesOfCompanyUser') IS NOT NULL
    DROP TABLE #validCompaniesOfCompanyUser
CREATE TABLE #validCompaniesOfCompanyUser
    (
        companyId INT NOT NULL
        primary key (companyId)
    )
DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
IF @doNotUseCompanyEntitiesTableForFiltering = 1
BEGIN
	SET @companyIdOfUser = 0
END
IF @companyIdOfUser <> 0
BEGIN
    declare @parentCompanyId int = @companyIdOfUser
        ;with parentCompany as
        (
            select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            union all
            select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select childCompanyId
        from parentCompany
    declare @childCompanyId int = @companyIdOfUser
        ;with childCompany as
        (
            select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
            union all
            select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select parentCompanyId
        from childCompany
    INSERT INTO #validCompaniesOfCompanyUser values (@companyIdOfUser) , (0)   -- Company Id 0 For MSP entities
END
IF @companyIdOfUser <> 0
BEGIN
	DECLARE @entityId INTEGER = 0
	IF @entityId5 <> 0
		SET @entityId = @entityId5
	ELSE IF @entityId4 <> 0
		SET @entityId = @entityId4
	ELSE IF @entityId3 <> 0
		SET @entityId = @entityId3
	ELSE IF @entityId1 <> 0
		SET @entityId = @entityId1
	IF (SELECT count(0)
		FROM App_CompanyEntities App
		LEFT JOIN #validCompaniesOfCompanyUser C
			ON C.companyId = App.companyId
		WHERE App.entityType = @entityType
			AND App.entityId = @entityId
			AND C.companyId IS NULL) > 0
	BEGIN
		SET @isAllowed = 0
		GOTO PROC_EXIT
	END
END
--User groups this user belongs to.
DECLARE @userAndGroupId TABLE (userOrGroupId INT, isUser INT)
IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
	DROP TABLE #usergroupId
CREATE TABLE #userGroupId (userGroupId INT)
EXEC sec_getMemberUserGroups @userId
INSERT INTO @userAndGroupId
	SELECT userGroupId, 0
	FROM #userGroupId
	UNION
	SELECT @userId, 1
DROP TABLE #userGroupId
IF OBJECT_ID('tempdb.dbo.#parentEntityTable') IS NOT NULL
      DROP TABLE #parentEntityTable
DECLARE @associationsQuery NVARCHAR(MAX) = ''
CREATE TABLE #parentEntityTable (parentEntityType INT, parentEntityId INT)
CREATE CLUSTERED INDEX parentEntityTable_parentEntityType_parentEntityId_Idx ON #parentEntityTable (parentEntityType, parentEntityId)
DECLARE @parentEntityType AS INT
-- VSA Subclients expansion.
-- If input entity is a VM client, then we need to inherit permissions from its hypervisor client and its parents as well.
-- This table to contain all the parent entities of this VM client.
IF OBJECT_ID('tempdb.dbo.#VSAEntities') IS NOT NULL
	DROP TABLE #vsaEntities
CREATE TABLE #VSAEntities
(
	entityType1 INT, entityId1 INT,
	entityType2 INT DEFAULT 0, entityID2 INT DEFAULT 0,
	entityType3 INT DEFAULT 0, entityId3 INT DEFAULT 0,
	entityType4 INT DEFAULT 0, entityId4 INT DEFAULT 0,
	entityType5 INT DEFAULT 0, entityId5 INT DEFAULT 0
)
CREATE CLUSTERED INDEX VSAEntities_Idx1 ON #VSAEntities (entityType1, entityId1);;
DECLARE @vsaClientId INT = 0, @vsaAppTypeId INT = 0, @vsaInstanceId INT = 0, @vsaBackupsetID INT = 0, @vsaSubclientId INT = 0
IF @entityType1 = 3
BEGIN
	SELECT @vsaClientId = clientId, @vsaAppTypeId = appTypeId, @vsaInstanceId = instance, @vsaBackupsetID = backupSet, @vsaSubclientId = a.id
	FROM App_ClientProp CP
		INNER JOIN APP_Application A
			ON CAST(CP.attrVal AS INT) = A.id
	WHERE
		componentNameId = @entityId1
AND attrName = 'Last Backup Subclient'
		AND CP.modified = 0
	IF @vsaClientId > 0			-- Push all the VSA related entities into this one table. since we do not have code to compute parent of parent in a hierarchical manner.
	BEGIN
		INSERT INTO #VSAEntities
VALUES (3, @vsaClientId, 4, @vsaAppTypeId, 5, @vsaInstanceId, 6, @vsaBackupsetId, 7, @vsaSubclientId)
		INSERT INTO #VSAEntities (entityType1, entityId1)
SELECT 61, companyId
			FROM UMOwners
			WHERE
entityTYpe = 3
				AND entityId = @vsaClientID
		INSERT INTO #VSAEntities (entityType1, entityId1)
SELECT 28, clientGroupId
			FROM APP_ClientGRoupAssoc
			WHERE
				clientId = @vsaClientId
	END
END
IF (@AndOperation = 0 AND @checkOnlyAssociation = 0)		--Even if one permission is present we are good.
BEGIN
	--Commcell.
	SET @isAllowed = 0
	IF EXISTS (SELECT TOP 1 1
			   FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN #permissionIdTbl P
						ON Sec.permissionId = P.i_permissionId
			   WHERE entityType1 = 1 AND entityId1 = 2)					--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
	BEGIN
				SET @isAllowed = 1
				--PRINT 'Commcell'
				GOTO PROC_EXIT
	END
	IF EXISTS (SELECT TOP 1 1
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN UMRolesWithPermissionsExpanded R
						ON Sec.roleID = R.roleID
					INNER JOIN #permissionIdTbl P
						ON R.permissionId = P.i_permissionId
				WHERE entityType1 = 1 AND entityId1 = 2)					--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
	BEGIN
				SET @isAllowed = 1
				--PRINT 'Commcell'
				GOTO PROC_EXIT
	END
	--Include All.
	IF EXISTS (SELECT TOP 1 1
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN #permissionIdTbl P
						ON Sec.permissionId = P.i_permissionId
				WHERE entityType1 = @entityType1 AND includeAll = 1)
	BEGIN
			SET @isAllowed = 1
			--PRINT 'Include All'
			GOTO PROC_EXIT
	END
	IF EXISTS (SELECT TOP 1 1
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN UMRolesWithPermissionsExpanded R
						ON Sec.roleID = R.roleID
					INNER JOIN #permissionIdTbl P
						ON R.permissionId = P.i_permissionId
				WHERE entityType1 = @entityType1 AND includeAll = 1)
	BEGIN
			SET @isAllowed = 1
			--PRINT 'Include All'
			GOTO PROC_EXIT
	END
	--Entity.
	IF @entityTYpe1 <> 3					--CLIENT_ENTITY
	BEGIN
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #permissionIdTbl P
							ON Sec.permissionId = P.i_permissionId
					WHERE entityType1 = @entityType1 AND entityID1 = @entityID1 )
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Entity'
			GOTO PROC_EXIT
		END
		IF EXISTS ( SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleID = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType1 = @entityType1 AND entityID1 = @entityID1)
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Entity'
			GOTO PROC_EXIT
		END
		-- There are some Create / Add permissions which needs to be checked on Company too, if user
		-- does not have it on Commcell. So even if application layer code passes Commcell entity, still
		-- check once on Company entity too.
		IF (@entityType1 = 1 AND @entityId1 = 2)
		BEGIN
			IF EXISTS ( SELECT 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN #permissionIdTbl P
								ON Sec.permissionId = P.i_permissionId
							INNER JOIN UMPermissions Perm
								ON Perm.id = P.i_permissionId
AND Perm.flags & 4 <> 0
WHERE entityType1 = 61)
			BEGIN
				SET @isAllowed = 1
				--PRINT 'Commcell->Company'
				GOTO PROC_EXIT
			END
			IF EXISTS ( SELECT 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMRolesWithPermissionsExpanded R
								ON Sec.roleID = R.roleID
							INNER JOIN #permissionIdTbl P
								ON R.permissionId = P.i_permissionId
							INNER JOIN UMPermissions Perm
								ON Perm.id = P.i_permissionId
AND Perm.flags & 4 <> 0
WHERE entityType1 = 61)
			BEGIN
				SET @isAllowed = 1
				--PRINT 'Commcell->Company'
				GOTO PROC_EXIT
			END
		END
	END			--@entityType1 <> 3
	ELSE		--@entityTYpe1 = 3
	BEGIN
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #permissionIdTbl P
							ON Sec.permissionId = P.i_permissionId
					WHERE entityType1 = @entityType1 AND entityID1 = @entityID1
							AND ((entityType2 = 0) OR (entityType2 = @entityType2 AND entityId2 = @entityId2))
							AND ((entityType3 = 0) OR (entityType3 = @entityType3 AND entityId3 = @entityId3))
							AND ((entityType4 = 0) OR (entityType4 = @entityType4 AND entityId4 = @entityId4))
							AND ((entityType5 = 0) OR (entityType5 = @entityType5 AND entityId5 = @entityId5)))
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Entity'
			GOTO PROC_EXIT
		END
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleID = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType1 = @entityType1 AND entityID1 = @entityID1
							AND ((entityType2 = 0) OR (entityType2 = @entityType2 AND entityId2 = @entityId2))
							AND ((entityType3 = 0) OR (entityType3 = @entityType3 AND entityId3 = @entityId3))
							AND ((entityType4 = 0) OR (entityType4 = @entityType4 AND entityId4 = @entityId4))
							AND ((entityType5 = 0) OR (entityType5 = @entityType5 AND entityId5 = @entityId5)))
		BEGIN
			SET @isAllowed = 1
			--PRINT 'Entity'
			GOTO PROC_EXIT
		END
		-- VSA Subclients expansion.
		-- Check if user got rights on the hypervisor entities as well.
		IF @vsaClientId <> 0
		BEGIN
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN #permissionIdTbl P
								ON Sec.permissionId = P.i_permissionId
							INNER JOIN #VSAEntities VSA
								ON Sec.entityType1 = VSA.entityType1 AND Sec.entityId1 = VSA.entityId1
								AND (Sec.entityType2 = 0 OR Sec.entityId2 = VSA.entityId2)
								AND (Sec.entityType3 = 0 OR Sec.entityId3 = VSA.entityId3)
								AND (Sec.entityType4 = 0 OR Sec.entityId4 = VSA.entityId4)
								AND (Sec.entityType5 = 0 OR Sec.entityId5 = VSA.entityId5))
			BEGIN
				SET @isAllowed = 1
				--PRINT 'Entity'
				GOTO PROC_EXIT
			END
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMRolesWithPermissionsExpanded R
								ON Sec.roleID = R.roleID
							INNER JOIN #permissionIdTbl P
								ON R.permissionId = P.i_permissionId
							INNER JOIN #VSAEntities VSA
								ON Sec.entityType1 = VSA.entityType1 AND Sec.entityId1 = VSA.entityId1
								AND (Sec.entityType2 = 0 OR Sec.entityId2 = VSA.entityId2)
								AND (Sec.entityType3 = 0 OR Sec.entityId3 = VSA.entityId3)
								AND (Sec.entityType4 = 0 OR Sec.entityId4 = VSA.entityId4)
								AND (Sec.entityType5 = 0 OR Sec.entityId5 = VSA.entityId5))
			BEGIN
				SET @isAllowed = 1
				--PRINT 'Entity'
				GOTO PROC_EXIT
			END
		END
	END			--@entityTYpe1 = 3
	--Parents.
	IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType)
	BEGIN
		--Get all parent entities and their entity types of this entity.
        SELECT @associationsQuery = 'INSERT INTO #parentEntityTable '+
									CHAR(10) +
								SUBSTRING
									(
										(
											SELECT DISTINCT 'UNION'
															+ CHAR(10)			-- New line character
															+ 'SELECT parentEntityType, parentId'
															+ CHAR(10)
															+ 'FROM ('
															+ CHAR(10)
															+ CAST(associationQuery AS VARCHAR(MAX))
															+ CHAR(10)
															+ ')Tbl'
															+ CHAR(10)
															+ CASE WHEN childEntityType NOT IN (4,5,6,7) THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10))
																   WHEN childEntityType = 4 THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10)) + ' AND Tbl.childId2 = ' + CAST(@entityId2 AS VARCHAR(10))
																   WHEN childEntityType = 5 THEN 'WHERE Tbl.childId3 = ' + CAST(@entityId3 AS VARCHAR(10))
																   WHEN childEntityType = 6 THEN 'WHERE Tbl.childId4 = ' + CAST(@entityId4 AS VARCHAR(10))
																   WHEN childEntityType = 7 THEN 'WHERE Tbl.childId5 = ' + CAST(@entityId5 AS VARCHAR(10))
															  END
															+ CHAR(10)
											FROM App_EntityParentAssociation
											WHERE
												(childEntityType = @entityType)
											FOR XML PATH (''), TYPE
										).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
										6,				-- Exclude the first UNION
										2147483647		-- MAX
									)
		EXEC (@associationsQuery)
		-- Till SP12, for iDA entity types, we consider only Client entity type's parents from Entity Parent Association table (like Client Group, Plan, Company, etc.).
		-- With parent child inheritance support for Subclient Policy, we needed to consider parent type for Backupset entity as well from the table. (Subclient Policy is Backupset in Security layer)
		-- So to make queries easier and optimized, we expanded Client Group, Plan, Company inheritance individually into AppType, Instance, Backupset and Subclient entities and saved in Entity Parent Association Table.
		-- Then in Security SPs, we just query for inputted entity's parents. So if input entity is a Subclient entity, then just query for Subclient's parents - which will give Client Group, Plan, etc. as well.
		-- But this logic broke in few places:
		--		1. When restore is launched from GUI, subclient ID comes as -1. We cannot get parents of Subclient Id -1, instead we need to get the parents for the Client Id.
		--		2. CloudApps, OneDrive, etc. do not store client - apptype information in App_IdaName. So the associations expansion query from Entity Parent Association table did not return Client group
		--		   as parent of these appTypes. So here too we need to get the parents from Client Id and not from appTypeId.
		-- So bringing back the same logic of SP12: Get Client parents also for iDA entities. This will fix the issue.
		-- We shall revisit this entire implementation of Parent child inheritance on SP14/15 and see if we can improvise it.
IF @entityType IN (4, 5, 6, 7)
			INSERT INTO #parentEntityTable (parentEntityType, parentEntityId)
SELECT 28,clientGroupId
				FROM APP_ClientGroupAssoc CGA
				WHERE
					clientId = @entityId1
				UNION
SELECT 61,companyId
				FROM UMOwners
				WHERE
					entityType = @entityTYpe1
					AND entityId = @entityId1
				UNION
SELECT 61, CAST(CP.attrVal AS INT)			-- Company - client relationship is saved in Client Properties table. Look for that one too.
				FROM APP_ClientProp CP
				WHERE
					componentNameId = @entityId1
AND attrName = 'Installation Company ID'
					AND attrVal <> '0'
					AND modified = 0
				EXCEPT
				SELECT parentEntityType, parentEntityId
				FROM #parentEntityTable
		IF EXISTS (SELECT TOP 1 1 FROM #parentEntityTable)
		BEGIN
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN #permissionIdTbl P
								ON Sec.permissionId = P.i_permissionId
							INNER JOIN #parentEntityTable Parent
								ON Sec.entityType1 = Parent.parentEntityType AND (Sec.entityID1 = Parent.parentEntityId OR Sec.includeAll = 1))
			BEGIN
				SET @isAllowed = 1
				--PRINT 'Parent'
				GOTO PROC_EXIT
			END
			IF EXISTS (
						SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMRolesWithPermissionsExpanded R
								ON Sec.roleID = R.roleID
							INNER JOIN #permissionIdTbl P
								ON R.permissionId = P.i_permissionId
							INNER JOIN #parentEntityTable Parent
								ON Sec.entityType1 = Parent.parentEntityType AND (Sec.entityID1 = Parent.parentEntityId OR Sec.includeAll = 1))
				BEGIN
					SET @isAllowed = 1
					--PRINT 'Parent'
					GOTO PROC_EXIT
				END
		END			--SELECT TOP 1 1 FROM #parentEntityTable
	END		--SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType1
	--Owners.
	--Check if user / group is owner of this entity or parent entity or commcell.
	DECLARE @isOwner INT = 0
	IF EXISTS (SELECT TOP 1 1
				FROM UMOwners Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				WHERE Sec.entityType = @entityType1 AND Sec.entityId = @entityId1
				UNION ALL						--Should we query on Commcell and CLient group since we do not support owners of them yet.
				SELECT TOP 1 1
				FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				WHERE Sec.entityType = 1 AND Sec.entityId = 2					--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
				UNION ALL
				SELECT TOP 1 1
				FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #parentEntityTable P
						ON Sec.entityType = P.parentEntityType AND Sec.entityId = P.parentEntityId
				UNION ALL
				SELECT TOP 1 1				-- Check if user is owner on the hypervisor client as well.
				FROM UMOwners Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userORGroupId = U.userOrGroupId
					INNER JOIN #VSAEntities VSA
						ON Sec.entityTYpe = VSA.entityTYpe1 AND Sec.entityId = VSA.entityID1)
						SET @isOwner = 1
	--Check if permission is configured at owner level for Commcell or this entity or parent entity. (Checking only role here since permission directly on owners is not supported yet).
	IF @isOwner = 1
	BEGIN
			IF EXISTS (
					SELECT TOP 1 1
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType = @entityType1 AND entityID = @entityId1)
			BEGIN
						SET @isAllowed = 1
						--PRINT 'Owner'
						GOTO PROC_EXIT
			END
			IF EXISTS (
					SELECT TOP 1 1
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType = 1 AND entityID = 2)							--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
			BEGIN
						SET @isAllowed = 1
						--PRINT 'Owner'
						GOTO PROC_EXIT
			END
			IF EXISTS (
					SELECT TOP 1 1
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN #parentEntityTable Parent
							ON Sec.entityType = Parent.parentEntityType AND Sec.entityId = Parent.parentEntityId)
			BEGIN
						SET @isAllowed = 1
						--PRINT 'Owner'
						GOTO PROC_EXIT
			END
			IF EXISTS (
					SELECT TOP 1 1
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN #VSAEntities VSA			-- This tabe already has parents. Get those owner roles defined either on hypervisor client or its client group, etc.
							ON Sec.entityType = VSA.entityType1 AND Sec.entityId = VSA.entityId1)
			BEGIN
						SET @isAllowed = 1
						--PRINT 'Owner'
						GOTO PROC_EXIT
			END
	END		--@isOwner=1
END		--@AndOperation = 0
ELSE IF @AndOperation <> 0			--We need all permissions.
BEGIN
	SET @isAllowed = 0
	DECLARE @permissionIdsTablePresentAtEntities TABLE (permissionId INT)
	--Tried the same table variable approach and temp table approach for @andOperation = 0 case also. It was slower than the above written block for @andOperation = 0.
	--Tried it on Commserv_FC_SP6_20170106_DoNOTStage hosted on serverTeam1.testlab.commvault.com. Test data was a set of userIds who have
	--1. all association on commcell level itself. (88,10899,1,11049,108)
	--2. association on individual clients. (453,63,17543,28282,26643) on (698,7072,22877,73735,22877)
	--3. association on client owners. (29622,19516,199,7240,12243) on (9255,9231,10644,13182,15286)
	--4. association on client groups. (28121,5857,13849,10592,17565)
	--In all cases, this approach gave results ~=6 milliseconds faster than tried with @tableVariable and #tempTable. So using table variables only for @andOperation <> 0 case.
	--Commcell.
	INSERT INTO @permissionIdsTablePresentAtEntities
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
			 INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUSer AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN #permissionIdTbl P
				ON Sec.permissionId = P.i_permissionId
		WHERE entityType1 = 1 AND entityId1 = 2 AND permissionID > 0						--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
		UNION ALL
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded R
				ON Sec.roleID = R.roleID
			INNER JOIN #permissionIdTbl P
				ON R.permissionId = P.i_permissionId
		WHERE entityType1 = 1 AND entityID1 = 2 AND Sec.roleId > 0							--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
	--Delete all those permissions present at commcell level from input table.
	DELETE
	FROM #permissionIdTbl
	WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
	IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
	BEGIN
		SET @isAllowed = 1
		--PRINT 'Commcell'
		GOTO PROC_EXIT
	END
	--Include All.
	INSERT INTO @permissionIdsTablePresentAtEntities
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUSer AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN #permissionIdTbl P
				ON Sec.permissionId = P.i_permissionId
		WHERE entityType1 = @entityTYpe1 AND includeAll = 1 AND permissionID > 0
		UNION ALL
		SELECT P.i_permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN @userAndGroupId U
				ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded R
				ON Sec.roleID = R.roleID
			INNER JOIN #permissionIdTbl P
				ON R.permissionId = P.i_permissionId
		WHERE entityType1 = @entityTYpe1  AND includeAll = 1 AND Sec.roleId > 0
	DELETE
	FROM #permissionIdTbl
	WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
	IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
	BEGIN
		SET @isAllowed = 1
		--PRINT 'Include All'
		GOTO PROC_EXIT
	END
	--Entity.
	IF @entityTYpe1 <> 3						--CLIENT_ENTITY
	BEGIN
		INSERT INTO @permissionIdsTablePresentAtEntities
			SELECT P.i_permissionId
			FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId U
					ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				INNER JOIN #permissionIdTbl P
					ON Sec.permissionId = P.i_permissionId
			WHERE entityType1 = @entityType1 AND entityID1 = @entityID1
			UNION ALL
			SELECT P.i_permissionId
			FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId U
					ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				INNER JOIN UMRolesWithPermissionsExpanded R
					ON Sec.roleID = R.roleID
				INNER JOIN #permissionIdTbl P
					ON R.permissionId = P.i_permissionId
			WHERE entityType1 = @entityType1 AND entityID1 = @entityID1
		-- There are some Create / Add permissions which needs to be checked on Company too, if user
		-- does not have it on Commcell. So even if application layer code passes Commcell entity, still
		-- check once on Company entity too.
		IF (@entityType1 = 1 AND @entityId1 = 2)
		BEGIN
			INSERT INTO @permissionIdsTablePresentAtEntities
				SELECT P.i_permissionId
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN #permissionIdTbl P
						ON Sec.permissionId = P.i_permissionId
					INNER JOIN UMPermissions Perm
						ON Perm.id = P.i_permissionId
AND Perm.flags & 4 <> 0
WHERE entityType1 = 61
				UNION ALL
				SELECT P.i_permissionId
				FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN UMRolesWithPermissionsExpanded R
						ON Sec.roleID = R.roleID
					INNER JOIN #permissionIdTbl P
						ON R.permissionId = P.i_permissionId
					INNER JOIN UMPermissions Perm
						ON Perm.id = P.i_permissionId
AND Perm.flags & 4 <> 0
WHERE entityType1 = 61
		END
	END
	ELSE		--@entityTYpe1 = 3
	BEGIN
		INSERT INTO @permissionIdsTablePresentAtEntities
			SELECT P.i_permissionId
			FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId U
					ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				INNER JOIN #permissionIdTbl P
					ON Sec.permissionId = P.i_permissionId
			WHERE entityType1 = @entityType1 AND entityID1 = @entityID1
					AND ((entityType2 = 0) OR (entityType2 = @entityType2 AND entityId2 = @entityId2))
					AND ((entityType3 = 0) OR (entityType3 = @entityType3 AND entityId3 = @entityId3))
					AND ((entityType4 = 0) OR (entityType4 = @entityType4 AND entityId4 = @entityId4))
					AND ((entityType5 = 0) OR (entityType5 = @entityType5 AND entityId5 = @entityId5))
			UNION ALL
			SELECT P.i_permissionId
			FROM UMSecurityAssociations Sec
				INNER JOIN @userAndGroupId U
					ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				INNER JOIN UMRolesWithPermissionsExpanded R
					ON Sec.roleID = R.roleID
				INNER JOIN #permissionIdTbl P
					ON R.permissionId = P.i_permissionId
			WHERE entityType1 = @entityType1 AND entityID1 = @entityID1
					AND ((entityType2 = 0) OR (entityType2 = @entityType2 AND entityId2 = @entityId2))
					AND ((entityType3 = 0) OR (entityType3 = @entityType3 AND entityId3 = @entityId3))
					AND ((entityType4 = 0) OR (entityType4 = @entityType4 AND entityId4 = @entityId4))
					AND ((entityType5 = 0) OR (entityType5 = @entityType5 AND entityId5 = @entityId5))
	END			--@entityTYpe1 <> 3
	DELETE
	FROM #permissionIdTbl
	WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
	IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
	BEGIN
		SET @isAllowed = 1
		--PRINT 'Entity'
		GOTO PROC_EXIT
	END
	--Parents.
	IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType)
	BEGIN
		--Get all parent entities and their entity types of this entity.
        SELECT @associationsQuery = 'INSERT INTO #parentEntityTable '+
									CHAR(10) +
								SUBSTRING
									(
										(
											SELECT DISTINCT 'UNION'
															+ CHAR(10)			-- New line character
															+ 'SELECT parentEntityType, parentId'
															+ CHAR(10)
															+ 'FROM ('
															+ CHAR(10)
															+ CAST(associationQuery AS VARCHAR(MAX))
															+ CHAR(10)
															+ ')Tbl'
															+ CHAR(10)
															+ CASE WHEN childEntityType NOT IN (4,5,6,7) THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10))
																   WHEN childEntityType = 4 THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10)) + ' AND Tbl.childId2 = ' + CAST(@entityId2 AS VARCHAR(10))
																   WHEN childEntityType = 5 THEN 'WHERE Tbl.childId3 = ' + CAST(@entityId3 AS VARCHAR(10))
																   WHEN childEntityType = 6 THEN 'WHERE Tbl.childId4 = ' + CAST(@entityId4 AS VARCHAR(10))
																   WHEN childEntityType = 7 THEN 'WHERE Tbl.childId5 = ' + CAST(@entityId5 AS VARCHAR(10))
															  END
															+ CHAR(10)
											FROM App_EntityParentAssociation
											WHERE
												(childEntityType = @entityType)
											FOR XML PATH (''), TYPE
										).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
										6,				-- Exclude the first UNION
										2147483647		-- MAX
									)
		--print (@associationsQuery)
		EXEC (@associationsQuery)
IF @entityType IN (4, 5, 6, 7)
			INSERT INTO #parentEntityTable (parentEntityType, parentEntityId)
SELECT 28,clientGroupId
				FROM APP_ClientGroupAssoc CGA
				WHERE
					clientId = @entityId1
				UNION
SELECT 61,companyId
				FROM UMOwners
				WHERE
					entityType = @entityTYpe1
					AND entityId = @entityId1
				UNION
SELECT 61, CAST(CP.attrVal AS INT)			-- Company - client relationship is saved in Client Properties table. Look for that one too.
				FROM APP_ClientProp CP
				WHERE
					componentNameId = @entityId1
AND attrName = 'Installation Company ID'
					AND attrVal <> '0'
					AND modified = 0
				EXCEPT
				SELECT parentEntityType, parentEntityId
				FROM #parentEntityTable
		IF EXISTS (SELECT 1 FROM #parentEntityTable)
		BEGIN
			INSERT INTO @permissionIdsTablePresentAtEntities
						SELECT P.i_permissionId
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN #permissionIdTbl P
								ON Sec.permissionId = P.i_permissionId
							INNER JOIN #parentEntityTable Parent
								ON Sec.entityType1 = Parent.parentEntityType AND (Sec.entityID1 = Parent.parentEntityId OR Sec.includeAll = 1)
						UNION ALL
						SELECT P.i_permissionId
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMRolesWithPermissionsExpanded R
								ON Sec.roleID = R.roleID
							INNER JOIN #permissionIdTbl P
								ON R.permissionId = P.i_permissionId
							INNER JOIN #parentEntityTable Parent
								ON Sec.entityType1 = Parent.parentEntityType AND (Sec.entityID1 = Parent.parentEntityId OR Sec.includeAll = 1)
			DELETE
			FROM #permissionIdTbl
			WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
			IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
			BEGIN
				SET @isAllowed = 1
				--PRINT 'Parent'
				GOTO PROC_EXIT
			END
		END				--(SELECT TOP 1 1 FROM #parentEntityTable)
	END			--(SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType1)
	--Owners.
	SET @isOwner = 0
	IF EXISTS (SELECT TOP 1 1
				FROM UMOwners Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				WHERE Sec.entityType = @entityType1 AND Sec.entityId = @entityId1
				UNION	ALL					--Should we query on Commcell and CLient group since we do not support owners of them yet.
				SELECT TOP 1 1
				FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
				WHERE Sec.entityType = 1 AND Sec.entityId = 2					--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
				UNION ALL
				SELECT TOP 1 1
				FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #parentEntityTable P
						ON Sec.entityType = P.parentEntityType AND Sec.entityId = P.parentEntityId)
						SET @isOwner = 1
	IF @isOwner = 1
	BEGIN
			INSERT INTO @permissionIdsTablePresentAtEntities
					SELECT P.i_permissionId
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType = @entityType1 AND entityID = @entityId1
					UNION ALL
					SELECT P.i_permissionId
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
					WHERE entityType = 1 AND entityID = 2						--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
					UNION ALL
					SELECT P.i_permissionId
					FROM UMOwnerRoles Sec
						INNER JOIN UMRolesWithPermissionsExpanded R
							ON Sec.roleId = R.roleID
						INNER JOIN #permissionIdTbl P
							ON R.permissionId = P.i_permissionId
						INNER JOIN #parentEntityTable Parent
							ON Sec.entityType = Parent.parentEntityType AND Sec.entityId = Parent.parentEntityId
			DELETE
			FROM #permissionIdTbl
			WHERE EXISTS (SELECT 1 FROM @permissionIdsTablePresentAtEntities P WHERE P.permissionId = i_permissionId)
	END			--@isOwner = 1
	IF NOT EXISTS (SELECT TOP 1 1 FROM #permissionIdTbl)
	BEGIN
		SET @isAllowed = 1
		--PRINT 'Owner'
		GOTO PROC_EXIT
	END
END
ELSE IF @checkOnlyAssociation = 1			--Check if user has any association on given entity.
BEGIN
	SET @isAllowed = 0
	IF (@entityType = 1 AND @honorCommcellMappedPermissionForAssociationCheck = 0)
	BEGIN
		IF EXISTS (SELECT TOP 1 1
			   FROM UMSecurityAssociations Sec
					INNER JOIN @userAndGroupId U
						ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					INNER JOIN UMPermissionEntityTypeMap UPE
						ON Sec.permissionId = UPE.permissionId
			   WHERE Sec.entityType1 = 1 AND Sec.entityId1 = 2						--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
					 AND UPE.entityType = 0)				-- Check only for Generic permission on Commcell.
		BEGIN
			   SET @isAllowed = 1
			   --PRINT 'Commcell'
			   GOTO PROC_EXIT
		END
		IF EXISTS (SELECT TOP 1 1
				   FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded RPE
							ON Sec.roleID = RPE.roleID
						INNER JOIN UMPermissionEntityTypeMap UPE
							ON RPE.permissionId = UPE.permissionId
				   WHERE Sec.entityType1 = 1 AND Sec.entityId1 = 2						--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
						 AND UPE.entityType = 0)			-- Check only for Generic permission on Commcell.
		BEGIN
				   SET @isAllowed = 1
				   --PRINT 'Commcell'
				   GOTO PROC_EXIT
		END
	END
	ELSE
	BEGIN
		--Commcell.
		IF EXISTS (SELECT TOP 1 1
				   FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMPermissionEntityTypeMap UPE
							ON Sec.permissionId = UPE.permissionId
				   WHERE Sec.entityType1 = 1 AND Sec.entityId1 = 2						--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
						 AND UPE.entityType IN (@entityType,0))
		BEGIN
				   SET @isAllowed = 1
				   --PRINT 'Commcell'
				   GOTO PROC_EXIT
		END
		IF EXISTS (SELECT TOP 1 1
				   FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded RPE
							ON Sec.roleID = RPE.roleID
						INNER JOIN UMPermissionEntityTypeMap UPE
							ON RPE.permissionId = UPE.permissionId
				   WHERE Sec.entityType1 = 1 AND Sec.entityId1 = 2						--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
						 AND UPE.entityType IN (@entityType,0))
		BEGIN
				   SET @isAllowed = 1
				   --PRINT 'Commcell'
				   GOTO PROC_EXIT
		END
		--Include All.
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMPermissionEntityTypeMap UPE
							ON Sec.permissionId = UPE.permissionId
					WHERE Sec.entityType1 = @entityTYpe AND Sec.includeAll = 1
						 AND UPE.entityType IN (@entityType,0))
		BEGIN
				   SET @isAllowed = 1
				   --PRINT 'Include All'
				   GOTO PROC_EXIT
		END
		IF EXISTS (SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN UMRolesWithPermissionsExpanded RPE
							ON Sec.roleID = RPE.roleID
						INNER JOIN UMPermissionEntityTypeMap UPE
							ON RPE.permissionId = UPE.permissionId
					WHERE Sec.entityType1 = @entityTYpe AND Sec.includeAll = 1
						 AND UPE.entityType IN (@entityType,0))
		BEGIN
				   SET @isAllowed = 1
				   --PRINT 'Include All'
				   GOTO PROC_EXIT
		END
		--Entity.
		IF @entityType1 <> 3					--CLIENT_ENTITY
		BEGIN
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMPermissionEntityTypeMap UPE
								ON Sec.permissionId = UPE.permissionId
						WHERE Sec.entityTYpe1 = @entityTYpe1 AND Sec.entityId1 = @entityID1
							  AND UPE.entityType IN (@entityType,0))
			BEGIN
					SET @isAllowed = 1
					--PRINT 'Entity'
					GOTO PROC_EXIT
			END
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMRolesWithPermissionsExpanded RPE
								ON Sec.roleID = RPE.roleID
							INNER JOIN UMPermissionEntityTypeMap UPE
								ON RPE.permissionId = UPE.permissionId
						WHERE Sec.entityTYpe1 = @entityTYpe1 AND Sec.entityId1 = @entityID1
							  AND UPE.entityType IN (@entityType,0))
			BEGIN
					SET @isAllowed = 1
					--PRINT 'Entity'
					GOTO PROC_EXIT
			END
		END				--@entityType1 <> 3
		ELSE			--@entityTYpe1 = 3
		BEGIN
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMPermissionEntityTypeMap UPE
								ON Sec.permissionId = UPE.permissionId
						WHERE entityTYpe1 = @entityTYpe1 AND entityId1 = @entityID1
								AND ((entityType2 = 0) OR (entityTYpe2 = @entityType2 AND entityId2 = @entityID2))
								AND ((entityType3 = 0) OR (entityTYpe3 = @entityType3 AND entityId3 = @entityID3))
								AND ((entityType4 = 0) OR (entityTYpe4 = @entityType4 AND entityId4 = @entityID4))
								AND ((entityType5 = 0) OR (entityTYpe5 = @entityType5 AND entityId5 = @entityID5))
								AND UPE.entityType IN (@entityTYpe,0))
			BEGIN
					SET @isAllowed = 1
					--PRINT 'Entity'
					GOTO PROC_EXIT
			END
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN UMRolesWithPermissionsExpanded RPE
								ON Sec.roleID = RPE.roleID
							INNER JOIN UMPermissionEntityTypeMap UPE
								ON RPE.permissionId = UPE.permissionId
						WHERE entityTYpe1 = @entityTYpe1 AND entityId1 = @entityID1
								AND ((entityType2 = 0) OR (entityTYpe2 = @entityType2 AND entityId2 = @entityID2))
								AND ((entityType3 = 0) OR (entityTYpe3 = @entityType3 AND entityId3 = @entityID3))
								AND ((entityType4 = 0) OR (entityTYpe4 = @entityType4 AND entityId4 = @entityID4))
								AND ((entityType5 = 0) OR (entityTYpe5 = @entityType5 AND entityId5 = @entityID5))
								AND UPE.entityType IN (@entityTYpe,0))
			BEGIN
					SET @isAllowed = 1
					--PRINT 'Entity'
					GOTO PROC_EXIT
			END
			-- VSA Subclient expansion
			IF @vsaClientID > 0
			BEGIN
				IF EXISTS (SELECT TOP 1 1
							FROM UMSecurityAssociations Sec
								INNER JOIN @userAndGroupId U
									ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
								INNER JOIN UMPermissionEntityTypeMap UPE
									ON Sec.permissionId = UPE.permissionId
								INNER JOIN #VSAEntities VSA
									ON Sec.entityType1 = VSA.entityType1 AND Sec.entityId1 = VSA.entityId1
									AND (Sec.entityType2 = 0 OR Sec.entityId2 = VSA.entityId2)
									AND (Sec.entityType3 = 0 OR Sec.entityId3 = VSA.entityId3)
									AND (Sec.entityType4 = 0 OR Sec.entityId4 = VSA.entityId4)
									AND (Sec.entityType5 = 0 OR Sec.entityId5 = VSA.entityId5)
							WHERE UPE.entityType IN (@entityTYpe,0))
				BEGIN
						SET @isAllowed = 1
						--PRINT 'Entity'
						GOTO PROC_EXIT
				END
				IF EXISTS (SELECT TOP 1 1
							FROM UMSecurityAssociations Sec
								INNER JOIN @userAndGroupId U
									ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
								INNER JOIN UMRolesWithPermissionsExpanded RPE
									ON Sec.roleID = RPE.roleID
								INNER JOIN UMPermissionEntityTypeMap UPE
									ON RPE.permissionId = UPE.permissionId
								INNER JOIN #VSAEntities VSA
									ON Sec.entityType1 = VSA.entityType1 AND Sec.entityId1 = VSA.entityId1
									AND (Sec.entityType2 = 0 OR Sec.entityId2 = VSA.entityId2)
									AND (Sec.entityType3 = 0 OR Sec.entityId3 = VSA.entityId3)
									AND (Sec.entityType4 = 0 OR Sec.entityId4 = VSA.entityId4)
									AND (Sec.entityType5 = 0 OR Sec.entityId5 = VSA.entityId5)
							WHERE UPE.entityType IN (@entityTYpe,0))
				BEGIN
						SET @isAllowed = 1
						--PRINT 'Entity'
						GOTO PROC_EXIT
				END
			END
		END				--@entityTYpe1 = 3
		--Parents.
		IF EXISTS (SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType)
		BEGIN
			--Get all parent entities and their entity types of this entity.
			SELECT @associationsQuery = 'INSERT INTO #parentEntityTable '+
										CHAR(10) +
									SUBSTRING
										(
											(
												SELECT DISTINCT 'UNION'
																+ CHAR(10)			-- New line character
																+ 'SELECT parentEntityType, parentId'
																+ CHAR(10)
																+ 'FROM ('
																+ CHAR(10)
																+ CAST(associationQuery AS VARCHAR(MAX))
																+ CHAR(10)
																+ ')Tbl'
																+ CHAR(10)
																+ CASE WHEN childEntityType NOT IN (4,5,6,7) THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10))
																	   WHEN childEntityType = 4 THEN 'WHERE Tbl.childId = ' + CAST(@entityId1 AS VARCHAR(10)) + ' AND Tbl.childId2 = ' + CAST(@entityId2 AS VARCHAR(10))
																	   WHEN childEntityType = 5 THEN 'WHERE Tbl.childId3 = ' + CAST(@entityId3 AS VARCHAR(10))
																	   WHEN childEntityType = 6 THEN 'WHERE Tbl.childId4 = ' + CAST(@entityId4 AS VARCHAR(10))
																	   WHEN childEntityType = 7 THEN 'WHERE Tbl.childId5 = ' + CAST(@entityId5 AS VARCHAR(10))
																  END
																+ CHAR(10)
												FROM App_EntityParentAssociation
												WHERE
													(childEntityType = @entityType)
												FOR XML PATH (''), TYPE
											).value('.','NVARCHAR(MAX)'),				-- There may be < or > symbols that are XML encoded into &lt; and &gt; Doing a .value removes that encoding.
											6,				-- Exclude the first UNION
											2147483647		-- MAX
										)
			--print (@associationsQuery)
			EXEC (@associationsQuery)
IF @entityType IN (4, 5, 6, 7)
				INSERT INTO #parentEntityTable (parentEntityType, parentEntityId)
SELECT 28,clientGroupId
					FROM APP_ClientGroupAssoc CGA
					WHERE
						clientId = @entityId1
					UNION
SELECT 61,companyId
					FROM UMOwners
					WHERE
						entityType = @entityTYpe1
						AND entityId = @entityId1
					UNION
SELECT 61, CAST(CP.attrVal AS INT)			-- Company - client relationship is saved in Client Properties table. Look for that one too.
					FROM APP_ClientProp CP
					WHERE
						componentNameId = @entityId1
AND attrName = 'Installation Company ID'
						AND attrVal <> '0'
						AND modified = 0
					EXCEPT
					SELECT parentEntityType, parentEntityId
					FROM #parentEntityTable
			IF EXISTS (SELECT TOP 1 1 FROM #parentEntityTable)
			BEGIN
				IF EXISTS (SELECT TOP 1 1
							FROM UMSecurityAssociations Sec
								INNER JOIN @userAndGroupId U
									ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
								INNER JOIN UMPermissionEntityTypeMap UPE
									ON Sec.permissionId = UPE.permissionId
								INNER JOIN #parentEntityTable Parent
									ON Sec.entityType1 = Parent.parentEntityType AND (Sec.entityID1 = Parent.parentEntityId OR Sec.includeAll = 1)
							WHERE
								UPE.entityType IN (@entityTYpe,0))
				BEGIN
					   SET @isAllowed = 1
					   --PRINT 'Parent'
					   GOTO PROC_EXIT
				END
				IF EXISTS (SELECT TOP 1 1
							FROM UMSecurityAssociations Sec
								INNER JOIN @userAndGroupId U
									ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
								INNER JOIN UMRolesWithPermissionsExpanded RPE
									ON Sec.roleID = RPE.roleID
								INNER JOIN UMPermissionEntityTypeMap UPE
									ON RPE.permissionId = UPE.permissionId
								INNER JOIN #parentEntityTable Parent
									ON Sec.entityType1 = Parent.parentEntityType AND (Sec.entityID1 = Parent.parentEntityId OR Sec.includeAll = 1)
							WHERE
								UPE.entityType IN (@entityTYpe,0))
				BEGIN
					   SET @isAllowed = 1
					   --PRINT 'Parent'
					   GOTO PROC_EXIT
				END
			END				--SELECT TOP 1 1 FROM #parentEntityTable
		END			--SELECT TOP 1 1 FROM App_EntityParentAssociation WHERE childEntityType = @entityType1
		-- Requirement (MR 233017): When any user gets associated with any rights on a plan, he should be able to View the alerts associated to it.
		-- If we handle this in with Parent Child Association approach, all permissions from plan (Edit, Delete) also will inherit to alerts -> this should not happen.
		-- If we add an entry into Security Associations table for each association done on the plan, it is too much bookmarking and maintanence issues.
		-- So manually handling this in all the necessary stored procs. Specifically this code is written only under "check Only Associations" block(just for Viewing).
IF @entityType = 64
		BEGIN
			IF EXISTS (SELECT TOP 1 1
					  FROM UMSecurityAssociations Sec (NOLOCK)
							INNER JOIN @userAndGroupId U
								ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN App_PlanProp PP(NOLOCK)
ON Sec.entityType1 = 158 AND Sec.entityId1 = PP.componentNameId
AND PP.attrName = 'Alert' AND PP.modified = 0
							CROSS APPLY dbo.splitIds(PP.attrVal) SIDS						-- Alerts are stored as comma separated list in plan properties table.
					  WHERE
							SIDS._ID = @entityId1)
			BEGIN
				SET @isAllowed = 1
				GOTO PROC_EXIT
			END
		END
		--Owners.
		IF EXISTS (SELECT TOP 1 1
					FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					WHERE Sec.entityType = @entityType1 AND Sec.entityId = @entityId1
					UNION						--Should we query on Commcell and CLient group since we do not support owners of them yet.
					SELECT TOP 1 1
					FROM UMOwners Sec
							INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
					WHERE Sec.entityType = 1 AND Sec.entityId = 2				--COMMCELL_ENTITY, DEFAULT_COMMCELL_ID
					UNION
					SELECT TOP 1 1
					FROM UMOwners Sec
							INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
							INNER JOIN #parentEntityTable P
							ON Sec.entityType = P.parentEntityType AND Sec.entityId = P.parentEntityId
					UNION
					SELECT TOP 1 1
					FROM UMOwners Sec
						INNER JOIN @userAndGroupId U
							ON Sec.isUser = U.isUser AND Sec.userOrGroupId = U.userOrGroupId
						INNER JOIN #VSAEntities VSA
							ON Sec.entityType = VSA.entityType1 AND Sec.entityId = VSA.entityId1)
		BEGIN
			   SET @isAllowed = 1
			   --PRINT 'Owner'
			   GOTO PROC_EXIT
		END
	END
END		--@checkOnlyAssociation.
PROC_EXIT:
IF(@isReturned<>0)
	SELECT @isAllowed
IF OBJECT_ID('tempdb.dbo.#parentEntityTable') IS NOT NULL
      DROP TABLE #parentEntityTable
IF @extTableProvided = 0
	IF OBJECT_ID('tempdb.dbo.#permissionIdTbl') IS NOT NULL
		DROP TABLE #permissionIdTbl
GO

IF EXISTS (select * from GxQscripts where name = 'sec_checkPermissionOnEntity')
	delete from GxQscripts where name = 'sec_checkPermissionOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_checkPermissionOnEntity')
	delete from GXDBVersions where aliasname = 'sec_checkPermissionOnEntity'
GO

insert into GXDBVersions values(2, 'sec_checkPermissionOnEntity',  '00000000000000000000', 'sec_checkPermissionOnEntity', '00000000000000000000')
GO

