

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canUploadFileForWorkFlow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_canUploadFileForWorkFlow <<<'

IF EXISTS (select * from sysobjects where name='sec_canUploadFileForWorkFlow')
	drop procedure sec_canUploadFileForWorkFlow
IF EXISTS (select * from GxQscripts where name='sec_canUploadFileForWorkFlow')
	delete from GxQscripts where name = 'sec_canUploadFileForWorkFlow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canUploadFileForWorkFlow')
	delete from GXDBVersions where aliasname = 'sec_canUploadFileForWorkFlow'
GO
print '... Creating Procedure: sec_canUploadFileForWorkFlow'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_canUploadFileForWorkFlow
  @userId integer,
  @workflowId integer,
  @clientId integer,   
  @jobId integer   
AS
  DECLARE @userHasCapability int = 0
  DECLARE @validClientId int = 0
  DECLARE @validJob int = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @jobId > 0
	IF EXISTS(SELECT * FROM JMAdminJobInfoTable Where opType = 90 AND jobId = @jobId AND cloudId = @clientId)
		SET @validJob = 1
EXECUTE sec_isWorkflowAdmin @userId, @userHasCapability OUTPUT
IF @userHasCapability = 0
BEGIN
	EXECUTE sec_checkPermissionOnEntity @userId, '113', @userHasCapability OUTPUT, 83, @workflowId
	IF (@userHasCapability = 0 AND @validJob = 1)
	BEGIN
		IF EXISTS(Select * From WF_Interaction Where jobId = @jobId AND InteractionId in (Select InteractionId from dbo.GetUserInteractions(@userId, 0)))
		BEGIN
			SET @userHasCapability = 1
        END
    END
END
IF @jobId = 0
BEGIN
	IF EXISTS(SELECT * FROM WF_Deploy Where WorkflowId = @workflowId AND clientId = @clientId)
	BEGIN
		SET @validClientId = 1
    END
END
ELSE
BEGIN
	IF @validJob = 1
	BEGIN
		SET @validClientId = 1
    END
END
SELECT @userHasCapability , @validClientId , @validJob
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canUploadFileForWorkFlow')
	delete from GxQscripts where name = 'sec_canUploadFileForWorkFlow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canUploadFileForWorkFlow')
	delete from GXDBVersions where aliasname = 'sec_canUploadFileForWorkFlow'
GO

insert into GXDBVersions values(2, 'sec_canUploadFileForWorkFlow',  '00000000000000000000', 'sec_canUploadFileForWorkFlow', '00000000000000000000')
GO

